/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpCustomExitPointRegistry;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCatchConditionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpEntryPointInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInterruptScriptInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpReturnInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpStatementInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpThrowInstruction;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpInconsistentReturnPointsInspection
extends PhpInspection {
    public static final PhpType GENERATOR_TYPE = new PhpType().add("\\Generator");
    public static final PhpType PROBABLY_GENERATOR_TYPE = new PhpType().add("\\Iterator").add("\\Traversable").add("\\iterable");
    public boolean ALLOW_RETURN_NULL_IN_VOID = true;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                PhpInconsistentReturnPointsInspection.this.analyzeScope(function, holder);
            }

            public void visitPhpMethod(Method method) {
                PhpInconsistentReturnPointsInspection.this.analyzeScope((Function)method, holder);
            }
        };
    }

    private void analyzeScope(@NotNull Function function, @NotNull ProblemsHolder holder) {
        PsiElement rBrace;
        GroupStatement groupStatement;
        PhpType declaredType;
        boolean isGenerator;
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(2);
        }
        final boolean isProbablyGenerator = !(isGenerator = PhpType.intersects((PhpType)GENERATOR_TYPE, (PhpType)(declaredType = FunctionImpl.getDeclaredType(function)))) && PhpInconsistentReturnPointsInspection.isProbablyGenerator(declaredType);
        final boolean isVoid = !isGenerator && !isProbablyGenerator && PhpType.intersects((PhpType)PhpType.VOID, (PhpType)declaredType);
        final Ref yieldIsPresent = new Ref((Object)false);
        final Ref canExitWithoutReturnRef = new Ref((Object)false);
        SmartList returnWithoutArgument = new SmartList();
        SmartList returnWithArgument = new SmartList();
        PhpControlFlow flow = PhpCustomExitPointRegistry.getControlFlow((PhpScopeHolder)function);
        PhpControlFlowUtil.processPredecessors((PhpInstruction)flow.getExitPoint(), false, new PhpInstructionProcessor((List)returnWithArgument, (List)returnWithoutArgument){
            final /* synthetic */ List val$returnWithArgument;
            final /* synthetic */ List val$returnWithoutArgument;
            {
                this.val$returnWithArgument = list;
                this.val$returnWithoutArgument = list2;
            }

            public boolean processEntryPointInstruction(PhpEntryPointInstruction instruction) {
                if (!isVoid) {
                    canExitWithoutReturnRef.set((Object)true);
                }
                return false;
            }

            public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                if (!isVoid && instruction.getPredecessors().size() > 0) {
                    if (this.isSkippedStatement(instruction.getStatement())) {
                        return true;
                    }
                    if ((isGenerator || isProbablyGenerator) && this.containsYield(instruction.getStatement())) {
                        yieldIsPresent.set((Object)true);
                        return false;
                    }
                    canExitWithoutReturnRef.set((Object)true);
                }
                return (isGenerator || isProbablyGenerator) && (Boolean)yieldIsPresent.get() == false;
            }

            private boolean isSkippedStatement(@NotNull Statement statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(0);
                }
                return statement instanceof PhpBreak;
            }

            private boolean containsYield(@NotNull Statement statement) {
                if (statement == null) {
                    2.$$$reportNull$$$0(1);
                }
                final Ref result = Ref.create((Object)false);
                statement.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

                    public void visitElement(@NotNull PsiElement element) {
                        if (element == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (element instanceof PhpYield) {
                            result.set((Object)true);
                            this.stopWalking();
                        } else if (!(element instanceof GroupStatement)) {
                            super.visitElement(element);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection$2$1", "visitElement"));
                    }
                });
                return (Boolean)result.get();
            }

            public boolean processThrowInstruction(PhpThrowInstruction instruction) {
                return false;
            }

            public boolean processCatchConditionInstruction(PhpCatchConditionInstruction instruction) {
                return instruction.getResult();
            }

            public boolean processInterruptScriptInstruction(PhpInterruptScriptInstruction instruction) {
                return false;
            }

            public boolean processReturnInstruction(PhpReturnInstruction instruction) {
                PhpReturn phpReturn;
                PsiElement argument = instruction.getArgument();
                if (argument != null) {
                    if (!PhpInconsistentReturnPointsInspection.this.ALLOW_RETURN_NULL_IN_VOID || !PhpCodeInsightUtil.isNull(argument)) {
                        this.val$returnWithArgument.add(argument);
                    }
                } else if (!isVoid && (phpReturn = this.getPredecessorReturnStatement(instruction)) != null) {
                    this.val$returnWithoutArgument.add(phpReturn);
                }
                return isGenerator;
            }

            @Nullable
            public PhpReturn getPredecessorReturnStatement(PhpReturnInstruction instruction) {
                final Ref phpReturn = new Ref(null);
                PhpControlFlowUtil.processPredecessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                    public boolean processStatementInstruction(PhpStatementInstruction instruction) {
                        Statement statement = instruction.getStatement();
                        if (statement instanceof PhpReturn) {
                            phpReturn.set((Object)((PhpReturn)statement));
                            return false;
                        }
                        return true;
                    }
                });
                return (PhpReturn)phpReturn.get();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "statement";
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSkippedStatement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "containsYield";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (returnWithArgument.size() > 0) {
            for (PhpReturn phpReturn : returnWithoutArgument) {
                holder.registerProblem((PsiElement)phpReturn, PhpInconsistentReturnPointsInspection.getPROBLEM_2(), new LocalQuickFix[0]);
            }
        }
        if ((returnWithArgument.size() > 0 || function.getTypeDeclaration() != null || PhpInconsistentReturnPointsInspection.getReturnTag(function) != null) && ((Boolean)canExitWithoutReturnRef.get() != false && (!isGenerator && !isProbablyGenerator || isProbablyGenerator && (Boolean)yieldIsPresent.get() == false) || isGenerator && !((Boolean)yieldIsPresent.get()).booleanValue() && !PhpInconsistentReturnPointsInspection.returnsGeneratorOrProbablyReturnsGenerator((List<PsiElement>)returnWithArgument)) && (groupStatement = (GroupStatement)PsiTreeUtil.getChildOfType((PsiElement)function, GroupStatement.class)) != null && (rBrace = PhpPsiUtil.getChildOfType((PsiElement)groupStatement, PhpTokenTypes.chRBRACE)) != null) {
            holder.registerProblem(rBrace, !isGenerator ? PhpInconsistentReturnPointsInspection.getPROBLEM_1() : PhpInconsistentReturnPointsInspection.getPROBLEM_1_YIELD(), new LocalQuickFix[0]);
        }
    }

    public static boolean isProbablyGenerator(PhpType declaredType) {
        return PhpType.intersects((PhpType)PROBABLY_GENERATOR_TYPE, (PhpType)declaredType) || PhpType.MIXED.equals((Object)declaredType);
    }

    @Nullable
    private static PhpDocReturnTag getReturnTag(@NotNull Function function) {
        PhpDocComment docComment;
        if (function == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(3);
        }
        return (docComment = function.getDocComment()) != null ? docComment.getReturnTag() : null;
    }

    private static boolean returnsGeneratorOrProbablyReturnsGenerator(@NotNull List<PsiElement> returnWithArgument) {
        if (returnWithArgument == null) {
            PhpInconsistentReturnPointsInspection.$$$reportNull$$$0(4);
        }
        if (returnWithArgument.isEmpty()) {
            return false;
        }
        Project project = returnWithArgument.get(0).getProject();
        return returnWithArgument.stream().filter(PhpTypedElement.class::isInstance).map(PhpTypedElement.class::cast).map(PhpTypedElement::getType).anyMatch(type -> PhpType.intersectsGlobal((Project)project, (PhpType)GENERATOR_TYPE, (PhpType)type) || PhpInconsistentReturnPointsInspection.isProbablyGenerator(type.global(project)));
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @InspectionMessage
    private static String getPROBLEM_1() {
        return PhpBundle.message("inspection.inconsistent.return.points.problem1", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_1_YIELD() {
        return PhpBundle.message("inspection.inconsistent.return.points.problem1.yield", new Object[0]);
    }

    @InspectionMessage
    private static String getPROBLEM_2() {
        return PhpBundle.message("inspection.inconsistent.return.points.problem2", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnWithArgument";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpInconsistentReturnPointsInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "analyzeScope";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getReturnTag";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "returnsGeneratorOrProbablyReturnsGenerator";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class OptionsPanel {
        private JPanel myMainPanel;
        private JBCheckBox myAllowReturnNullInVoidCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myAllowReturnNullInVoidCheckBox.setSelected(PhpInconsistentReturnPointsInspection.this.ALLOW_RETURN_NULL_IN_VOID);
            this.myAllowReturnNullInVoidCheckBox.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpInconsistentReturnPointsInspection.this.ALLOW_RETURN_NULL_IN_VOID = OptionsPanel.this.myAllowReturnNullInVoidCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myAllowReturnNullInVoidCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.inconsistent.return.points.option.treat.return"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

