/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.daemon.quickFix.CreateFileFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Include;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpIncludeInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpIncludeInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpInclude(Include include) {
                if (include.getStaticElement() == null || include.getError() != null) {
                    holder.registerProblem((PsiElement)include, this.getMessage(include), new LocalQuickFix[0]);
                    return;
                }
                PsiReference[] refs = include.getReferences();
                int refsLength = refs.length;
                for (int i = 0; i < refsLength; ++i) {
                    PsiReference ref = refs[i];
                    if (!(ref instanceof FileReference) || ref.resolve() != null) continue;
                    if (isOnTheFly) {
                        LocalQuickFix[] localQuickFixArray;
                        PsiDirectory dir;
                        try {
                            PsiElement target;
                            dir = i > 0 ? ((target = refs[i - 1].resolve()) instanceof PsiDirectory ? (PsiDirectory)target : null) : include.getContainingFile().getParent();
                        }
                        catch (PsiInvalidElementAccessException e) {
                            throw new RuntimeException("Error while inspecting include reference: '" + include.getText() + "' at " + include.getContainingFile().getParent().getText(), e);
                        }
                        PsiElement psiElement = ref.getElement();
                        TextRange textRange = ref.getRangeInElement();
                        String string = PhpBundle.message("inspection.php.include.description2", include.getFileName());
                        if (dir != null) {
                            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
                            localQuickFixArray = localQuickFixArray2;
                            localQuickFixArray2[0] = new CreateFileFix(i < refs.length - 1, ref.getCanonicalText(), dir);
                        } else {
                            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
                        }
                        holder.registerProblem(psiElement, textRange, string, localQuickFixArray);
                    } else {
                        holder.registerProblem(include.getFirstChild(), PhpBundle.message("inspection.php.include.description", include.getFileName()), new LocalQuickFix[0]);
                    }
                    return;
                }
            }

            @NotNull
            @InspectionMessage
            private String getMessage(@NotNull Include include) {
                if (include == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (isOnTheFly && include.getError() != null) {
                    String string = PhpBundle.message("dynamic.include.expression.ref.is.not.analysed.error", include.getError());
                    if (string == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return string;
                }
                String string = PhpBundle.message("dynamic.include.expression.ref.is.not.analysed", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(2);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "include";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpIncludeInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpIncludeInspection$1";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMessage";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getMessage";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpIncludeInspection", "buildVisitor"));
    }
}

