/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.codeInspection.HTMLComposer;
import com.intellij.codeInspection.ex.HTMLComposerImpl;
import com.intellij.codeInspection.lang.HTMLComposerExtension;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.xml.util.XmlStringUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClass;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefClassMember;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElement;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefElementImpl;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefField;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefFunction;
import com.jetbrains.php.lang.inspections.reference.elements.PhpRefMethod;
import com.jetbrains.php.lang.inspections.reference.visitors.PhpRefVisitor;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHTMLComposer
implements HTMLComposerExtension<PhpHTMLComposer> {
    @NotNull
    public static final Key<PhpHTMLComposer> COMPOSER = Key.create((String)"PhpHTMLComposer");
    @NotNull
    private final HTMLComposerImpl myComposer;

    public PhpHTMLComposer(@NotNull HTMLComposerImpl composer) {
        if (composer == null) {
            PhpHTMLComposer.$$$reportNull$$$0(0);
        }
        this.myComposer = composer;
    }

    public void appendClassOrInterface(@NotNull StringBuilder buf, PhpRefClass refClass, boolean capitalizeFirstLetter) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(1);
        }
        if (refClass.isInterface()) {
            buf.append(capitalizeFirstLetter ? AnalysisBundle.message((String)"inspection.export.results.capitalized.interface", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspection.export.results.interface", (Object[])new Object[0]));
        } else if (refClass.isAbstract()) {
            buf.append(capitalizeFirstLetter ? AnalysisBundle.message((String)"inspection.export.results.capitalized.abstract.class", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspection.export.results.abstract.class", (Object[])new Object[0]));
        } else if (refClass.isAnonymous()) {
            buf.append(PhpBundle.message("inspection.unused.symbol.check.anonymous_classes", new Object[0]));
        } else {
            buf.append(capitalizeFirstLetter ? AnalysisBundle.message((String)"inspection.export.results.capitalized.class", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspection.export.results.class", (Object[])new Object[0]));
        }
    }

    public void appendClassExtendsImplements(@NotNull StringBuilder buf, PhpRefClassImpl refClass) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(2);
        }
        if (refClass.getSuperClasses().size() > 0) {
            HTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.extends.implements", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (PhpRefClass refBase : refClass.getSuperClasses()) {
                this.myComposer.appendListItem(buf, (RefElement)refBase);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendDerivedClasses(@NotNull StringBuilder buf, PhpRefClassImpl refClass) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(3);
        }
        if (refClass.getSubClasses().size() > 0) {
            if (refClass.isInterface() || refClass.isAbstract()) {
                HTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.extended.implemented", (Object[])new Object[0]));
            } else {
                HTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.extended", (Object[])new Object[0]));
            }
            this.myComposer.startList(buf);
            for (PhpRefClass refDerived : refClass.getSubClasses()) {
                this.myComposer.appendListItem(buf, (RefElement)refDerived);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendSuperMethods(@NotNull StringBuilder buf, PhpRefMethod refMethod) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(4);
        }
        if (refMethod.getSuperMethods().size() > 0) {
            HTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.overrides.implements", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (PhpRefMethod refSuper : refMethod.getSuperMethods()) {
                this.myComposer.appendListItem(buf, (RefElement)refSuper);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendDerivedMethods(@NotNull StringBuilder buf, PhpRefMethod refMethod) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(5);
        }
        if (refMethod.getDerivedMethods().size() > 0) {
            HTMLComposer.appendHeading((StringBuilder)buf, (String)AnalysisBundle.message((String)"inspection.export.results.derived.methods", (Object[])new Object[0]));
            this.myComposer.startList(buf);
            for (PhpRefMethod refDerived : refMethod.getDerivedMethods()) {
                this.myComposer.appendListItem(buf, (RefElement)refDerived);
            }
            this.myComposer.doneList(buf);
        }
    }

    public void appendShortName(RefEntity refElement, final @NotNull StringBuilder buf) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(6);
        }
        if (refElement instanceof PhpRefClassMember) {
            String modifier = ((PhpRefClassMember)refElement).getAccessModifierString();
            buf.append(modifier);
            buf.append("&nbsp;");
        }
        refElement.accept((RefVisitor)new PhpRefVisitor(){

            @Override
            public void visitRefClass(PhpRefClass refClass) {
                if (refClass.isTrait()) {
                    buf.append(AnalysisBundle.message((String)"inspection.export.results.static", (Object[])new Object[0]));
                    buf.append("&nbsp;");
                }
                PhpHTMLComposer.this.appendClassOrInterface(buf, refClass, false);
                buf.append("&nbsp;").append("<b>").append("<code>");
                buf.append(refClass.getName());
                buf.append("</code>").append("</b>");
            }

            @Override
            public void visitRefField(PhpRefField refField) {
                Field psiField = refField.getPhpElement();
                if (psiField != null) {
                    if (refField.isStatic()) {
                        buf.append(AnalysisBundle.message((String)"inspection.export.results.static", (Object[])new Object[0]));
                        buf.append("&nbsp;");
                    } else if (refField.isConstant()) {
                        buf.append(PhpBundle.message("inspection.export.results.const", new Object[0]));
                        buf.append("&nbsp;");
                    }
                    buf.append(AnalysisBundle.message((String)"inspection.export.results.field", (Object[])new Object[0])).append("&nbsp;");
                    buf.append("<code>").append("&nbsp;");
                    buf.append("<b>");
                    buf.append(psiField.getName());
                    buf.append("</b>").append("</code>");
                }
            }

            @Override
            public void visitRefMethod(PhpRefMethod refMethod) {
                Method method = refMethod.getPhpElement();
                if (method != null) {
                    if (method.isStatic()) {
                        buf.append(AnalysisBundle.message((String)"inspection.export.results.static", (Object[])new Object[0]));
                        buf.append("&nbsp;");
                    } else if (method.isAbstract()) {
                        buf.append(AnalysisBundle.message((String)"inspection.export.results.abstract", (Object[])new Object[0]));
                        buf.append("&nbsp;");
                    }
                    buf.append(refMethod.isConstructor() ? AnalysisBundle.message((String)"inspection.export.results.constructor", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspection.export.results.method", (Object[])new Object[0]));
                    buf.append("&nbsp;").append("<code>");
                    buf.append("<b>");
                    buf.append(method.getName());
                    buf.append("</b>");
                    PhpHTMLComposer.appendFunctionParameters(buf, (Function)method, true);
                    buf.append("</code>");
                }
            }

            public void visitFile(@NotNull RefFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                PsiFile psiFile = file.getPsiElement();
                buf.append("<b>");
                buf.append(psiFile.getName());
                buf.append("</b>");
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/jetbrains/php/lang/inspections/PhpHTMLComposer$1", "visitFile"));
            }
        });
    }

    public void appendLocation(RefEntity entity, @NotNull StringBuilder buf) {
        RefEntity owner;
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(7);
        }
        if ((owner = entity.getOwner()) instanceof PhpRefMethod) {
            buf.append(AnalysisBundle.message((String)"inspection.export.results.method", (Object[])new Object[0]));
            buf.append("&nbsp;");
            this.myComposer.appendElementReference(buf, (RefElement)owner);
        } else if (owner instanceof PhpRefField) {
            buf.append(AnalysisBundle.message((String)"inspection.export.results.field", (Object[])new Object[0]));
            buf.append("&nbsp;");
            this.myComposer.appendElementReference(buf, (RefElement)owner);
            buf.append("&nbsp;");
            buf.append(AnalysisBundle.message((String)"inspection.export.results.initializer", (Object[])new Object[0]));
        } else if (owner instanceof PhpRefClass) {
            this.appendClassOrInterface(buf, (PhpRefClass)owner, false);
            buf.append("&nbsp;");
            this.myComposer.appendElementReference(buf, (RefElement)owner);
        }
    }

    @Nullable
    public String getQualifiedName(RefEntity refEntity) {
        if (refEntity instanceof PhpRefMethod) {
            return refEntity.getQualifiedName();
        }
        return null;
    }

    public void appendReferencePresentation(RefEntity refElement, @NotNull StringBuilder buf, boolean isPackageIncluded) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(8);
        }
        buf.append("<code>");
        if (refElement instanceof PhpRefElementImpl) {
            PhpPsiElement element = ((PhpRefElement)refElement).getPhpElement();
            this.appendReferenceHeader(element, buf);
            this.appendReferenceLink(refElement, buf, isPackageIncluded);
            if (element instanceof Function) {
                PhpHTMLComposer.appendFunctionParameters(buf, (Function)element, false);
            }
        }
        buf.append("</code>");
        RefElement owner = (RefElement)ObjectUtils.tryCast((Object)refElement.getOwner(), RefElement.class);
        if (owner != null && refElement instanceof PhpRefClass && ((PhpRefClass)refElement).isAnonymous()) {
            buf.append(" ");
            buf.append(AnalysisBundle.message((String)"inspection.export.results.anonymous.ref.in.owner", (Object[])new Object[0]));
            buf.append(" ");
            this.myComposer.appendElementReference(buf, owner, isPackageIncluded);
        }
    }

    protected void appendReferenceLink(RefEntity refElement, @NotNull StringBuilder buf, boolean isNamespaceIncluded) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(9);
        }
        buf.append("<a HREF=\"");
        buf.append(((RefElementImpl)refElement).getURL());
        buf.append("\"");
        if (isNamespaceIncluded) {
            buf.append(" qualifiedname=\"");
            buf.append(refElement.getQualifiedName());
            buf.append("\"");
        }
        buf.append(">");
        if (refElement instanceof PhpRefClass && ((PhpRefClass)refElement).isAnonymous()) {
            buf.append(AnalysisBundle.message((String)"inspection.reference.anonymous", (Object[])new Object[0]));
        } else if (refElement instanceof PhpRefFunction) {
            if (((PhpRefFunction)refElement).isClosure()) {
                buf.append(refElement.getQualifiedName());
            } else {
                Function function = ((PhpRefFunction)refElement).getPhpElement();
                if (function != null) {
                    buf.append(function.getName());
                }
            }
        } else {
            buf.append(refElement.getName());
        }
        buf.append("</a>");
    }

    protected void appendReferenceHeader(@Nullable PhpPsiElement element, @NotNull StringBuilder buf) {
        String namespaceName;
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(10);
        }
        if (element instanceof PhpClass || element instanceof PhpClassMember) {
            PhpClass phpClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)element, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (phpClass != null) {
                buf.append(XmlStringUtil.escapeString((String)phpClass.getNamespaceName()));
                if (element instanceof PhpClassMember && !phpClass.isAnonymous()) {
                    buf.append(XmlStringUtil.escapeString((String)phpClass.getName()));
                    buf.append("::");
                }
            }
        } else if (element instanceof Function) {
            Function function = (Function)element;
            if (!function.isClosure()) {
                String namespaceName2 = function.getNamespaceName();
                if (!PhpLangUtil.isGlobalNamespaceFQN(namespaceName2)) {
                    buf.append(XmlStringUtil.escapeString((String)namespaceName2));
                    buf.append("&nbsp;");
                }
            } else {
                PhpNamedElement namedElement = (PhpNamedElement)PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition<? super PsiElement>)((Condition)owner -> owner instanceof PhpClass && !((PhpClass)owner).isAnonymous() || owner instanceof Function && !((Function)owner).isClosure()));
                String closureQualifiedName = namedElement != null ? StringUtil.replace((String)namedElement.getFQN(), (String)".", (String)"::") : function.getNamespaceName();
                buf.append(XmlStringUtil.escapeString((String)closureQualifiedName));
                buf.append("&nbsp;");
            }
        } else if (element instanceof Constant && !PhpLangUtil.isGlobalNamespaceFQN(namespaceName = ((Constant)element).getNamespaceName())) {
            buf.append(namespaceName);
        }
    }

    private static void appendFunctionParameters(@NotNull StringBuilder buf, @NotNull Function function, boolean showNames) {
        if (buf == null) {
            PhpHTMLComposer.$$$reportNull$$$0(11);
        }
        if (function == null) {
            PhpHTMLComposer.$$$reportNull$$$0(12);
        }
        Parameter[] params = function.getParameters();
        buf.append('(');
        if (showNames) {
            for (int i = 0; i < params.length; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                Parameter param = params[i];
                buf.append(' ');
                buf.append(param.getName());
            }
        }
        buf.append(')');
    }

    @NotNull
    public static String getClassOrInterface(@NotNull PhpRefClass refClass, boolean capitalizeFirstLetter) {
        if (refClass == null) {
            PhpHTMLComposer.$$$reportNull$$$0(13);
        }
        if (refClass.isInterface()) {
            String string = capitalizeFirstLetter ? AnalysisBundle.message((String)"inspection.export.results.capitalized.interface", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspection.export.results.interface", (Object[])new Object[0]);
            if (string == null) {
                PhpHTMLComposer.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (refClass.isAbstract()) {
            String string = capitalizeFirstLetter ? AnalysisBundle.message((String)"inspection.export.results.capitalized.abstract.class", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspection.export.results.abstract.class", (Object[])new Object[0]);
            if (string == null) {
                PhpHTMLComposer.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = capitalizeFirstLetter ? AnalysisBundle.message((String)"inspection.export.results.capitalized.class", (Object[])new Object[0]) : AnalysisBundle.message((String)"inspection.export.results.class", (Object[])new Object[0]);
        if (string == null) {
            PhpHTMLComposer.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    public Key<PhpHTMLComposer> getID() {
        Key<PhpHTMLComposer> key = COMPOSER;
        if (key == null) {
            PhpHTMLComposer.$$$reportNull$$$0(17);
        }
        return key;
    }

    @NotNull
    public Language getLanguage() {
        PhpLanguage phpLanguage = PhpLanguage.INSTANCE;
        if (phpLanguage == null) {
            PhpHTMLComposer.$$$reportNull$$$0(18);
        }
        return phpLanguage;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composer";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refClass";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpHTMLComposer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpHTMLComposer";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassOrInterface";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getID";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "appendClassOrInterface";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "appendClassExtendsImplements";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendDerivedClasses";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendSuperMethods";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendDerivedMethods";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendShortName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendLocation";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "appendReferencePresentation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendReferenceLink";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "appendReferenceHeader";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "appendFunctionParameters";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getClassOrInterface";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

