/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.inspections.PhpFqnInspectionBase;
import com.jetbrains.php.lang.inspections.PhpUnnecessaryFullyQualifiedNameInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpBaseImportQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.lang.intentions.PhpImportClassIntention;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpGroupUseElement;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpFullyQualifiedNameUsageInspection
extends PhpFqnInspectionBase
implements CleanupLocalInspectionTool {
    private static final PhpImportQualifierQuickFix FIX_ON_NAMESPACE = new PhpImportQualifierQuickFix(PhpBundle.message("replace.qualifier.with.an.import", new Object[0]));
    private static final PhpImportQualifierQuickFix FIX_ON_CLASSNAME = new PhpImportQualifierQuickFix(PhpBundle.message("quickfix.remove.unnecessary.qualifier.on.class.name", new Object[0]));
    private static final Key<PhpFullyQualifiedNameUsageInspection> SHORT_NAME_KEY = Key.create((String)"PhpFullyQualifiedNameUsageInspection");

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpClassReference(ClassReference classReference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)classReference), PhpGroupUseElement.PhpUseKeyword.CLASS);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.CONSTANT);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.check(PhpPsiUtil.getClassReferenceAt((PsiElement)reference), PhpGroupUseElement.PhpUseKeyword.FUNCTION);
            }

            public void visitPhpDocType(PhpDocType type) {
                if (!PhpUnnecessaryFullyQualifiedNameInspection.phpdocUseFqcn(type) && this.fqnShouldBeImported((PhpReference)type, PhpGroupUseElement.PhpUseKeyword.CLASS)) {
                    PhpFullyQualifiedNameUsageInspection.this.registerWarning((PhpReference)type, holder, isOnTheFly);
                }
            }

            private void check(PhpReference reference, PhpGroupUseElement.PhpUseKeyword keyword) {
                if (this.fqnShouldBeImported(reference, keyword)) {
                    PhpFullyQualifiedNameUsageInspection.this.registerWarning(reference, holder, isOnTheFly);
                }
            }

            private boolean fqnShouldBeImported(PhpReference reference, PhpGroupUseElement.PhpUseKeyword keyword) {
                if (reference == null || !PhpImportClassIntention.canBeImported(reference)) {
                    return false;
                }
                String fqn = reference.getFQN();
                if (fqn == null || !PhpLangUtil.isFqn(fqn)) {
                    return false;
                }
                if (PhpFqnInspectionBase.isGlobalNamespaceFqn(fqn) && PhpFullyQualifiedNameUsageInspection.this.IGNORE_GLOBAL_NAMESPACE) {
                    return false;
                }
                if (PhpUnnecessaryFullyQualifiedNameInspection.inCoversDefaultClassTag(reference)) {
                    return false;
                }
                PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)reference);
                if (scope == null) {
                    return false;
                }
                if (!(scope instanceof PhpNamespace || PhpFullyQualifiedNameUsageInspection.this.ENABLE_IN_FILE_SCOPE && scope instanceof PhpFile)) {
                    return false;
                }
                String immediateFQN = PhpCodeInsightUtil.getImmediateFQN(reference);
                if (immediateFQN == null || !PhpLangUtil.isFqn(immediateFQN)) {
                    return false;
                }
                if (PhpCodeInsightUtil.hasNameConflicts(scope, immediateFQN, this.getElementType(keyword))) {
                    return false;
                }
                String simplifiedFqn = PhpCodeInsightUtil.createQualifiedName(scope, immediateFQN);
                if (PhpFullyQualifiedNameUsageInspection.isShortName(simplifiedFqn)) {
                    return false;
                }
                return !PhpUnnecessaryFullyQualifiedNameInspection.collectAliasesExceptFqn(scope, fqn, keyword).containsKey(StringUtil.toLowerCase((String)PhpLangUtil.toShortName(immediateFQN)));
            }

            private PhpCodeInsightUtil.ImportElementType getElementType(PhpGroupUseElement.PhpUseKeyword keyword) {
                switch (keyword) {
                    case CONSTANT: {
                        return PhpCodeInsightUtil.ImportElementType.CONSTANT;
                    }
                    case FUNCTION: {
                        return PhpCodeInsightUtil.ImportElementType.FUNCTION;
                    }
                    case CLASS: {
                        return PhpCodeInsightUtil.ImportElementType.CLASS;
                    }
                }
                throw new IllegalStateException();
            }
        };
    }

    @Override
    @NotNull
    protected Key<? extends PhpFqnInspectionBase> getShortNameKey() {
        Key<PhpFullyQualifiedNameUsageInspection> key = SHORT_NAME_KEY;
        if (key == null) {
            PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(1);
        }
        return key;
    }

    private void registerWarning(PhpReference reference, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Object namespaceReference;
        if (holder == null) {
            PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(2);
        }
        if ((namespaceReference = PhpPsiUtil.getChildByCondition((PsiElement)reference, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF)) != null) {
            ProblemHighlightType type = PhpFullyQualifiedNameUsageInspection.getHighlightType(reference);
            if (type == ProblemHighlightType.INFORMATION && !isOnTheFly) {
                return;
            }
            holder.registerProblem(namespaceReference, PhpFullyQualifiedNameUsageInspection.getProblem(), type, this.getQuickFixes(reference, FIX_ON_NAMESPACE));
            ASTNode nameNode = reference.getNameNode();
            if (nameNode != null && isOnTheFly) {
                TextRange range = new TextRange(1, nameNode.getTextLength());
                holder.registerProblem(nameNode.getPsi(), PhpFullyQualifiedNameUsageInspection.getProblem(), ProblemHighlightType.INFORMATION, range, this.getQuickFixes(reference, FIX_ON_CLASSNAME));
            }
        }
    }

    public static boolean isShortName(String name) {
        return StringUtil.equals((CharSequence)name, (CharSequence)PhpLangUtil.toShortName(name));
    }

    @NotNull
    static ProblemHighlightType getHighlightType(@NotNull PhpReference reference) {
        if (reference == null) {
            PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(3);
        }
        if (!PhpCodeInsightUtil.isFullyQualified(reference)) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.INFORMATION;
            if (problemHighlightType == null) {
                PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(4);
            }
            return problemHighlightType;
        }
        if (PhpPsiUtil.getParentByCondition((PsiElement)reference, false, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF) != null) {
            ProblemHighlightType problemHighlightType = ProblemHighlightType.WEAK_WARNING;
            if (problemHighlightType == null) {
                PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(5);
            }
            return problemHighlightType;
        }
        ProblemHighlightType problemHighlightType = ProblemHighlightType.LIKE_UNUSED_SYMBOL;
        if (problemHighlightType == null) {
            PhpFullyQualifiedNameUsageInspection.$$$reportNull$$$0(6);
        }
        return problemHighlightType;
    }

    @Override
    public JComponent createOptionsPanel() {
        return new OptionsPanel().getComponent();
    }

    @InspectionMessage
    private static String getProblem() {
        return PhpBundle.message("inspection.fully.qualified.name.usage", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFullyQualifiedNameUsageInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFullyQualifiedNameUsageInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameKey";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "registerWarning";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class OptionsPanel {
        private JPanel myMainPanel;
        private JBCheckBox myEnableFileScopeCheckBox;
        private JBCheckBox myIgnoreGlobalNamespaceCheckBox;

        public OptionsPanel() {
            this.$$$setupUI$$$();
            this.myEnableFileScopeCheckBox.setSelected(PhpFullyQualifiedNameUsageInspection.this.ENABLE_IN_FILE_SCOPE);
            this.myEnableFileScopeCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpFullyQualifiedNameUsageInspection.this.ENABLE_IN_FILE_SCOPE = OptionsPanel.this.myEnableFileScopeCheckBox.isSelected();
                }
            });
            this.myIgnoreGlobalNamespaceCheckBox.setSelected(PhpFullyQualifiedNameUsageInspection.this.IGNORE_GLOBAL_NAMESPACE);
            this.myIgnoreGlobalNamespaceCheckBox.getModel().addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    PhpFullyQualifiedNameUsageInspection.this.IGNORE_GLOBAL_NAMESPACE = OptionsPanel.this.myIgnoreGlobalNamespaceCheckBox.isSelected();
                }
            });
        }

        public JPanel getComponent() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JBCheckBox jBCheckBox;
            JBCheckBox jBCheckBox2;
            JPanel jPanel;
            this.myMainPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.myEnableFileScopeCheckBox = jBCheckBox2 = new JBCheckBox();
            jBCheckBox2.setSelected(false);
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.fully.qualified.name.usage.option.enable.file.scope"));
            jPanel.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
            this.myIgnoreGlobalNamespaceCheckBox = jBCheckBox = new JBCheckBox();
            this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/PhpBundle", OptionsPanel.class).getString("inspection.fully.qualified.name.usage.name.option.ignore.global.namespace"));
            jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myMainPanel;
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }

    private static final class PhpImportQualifierQuickFix
    extends PhpQuickFixBase {
        @Nls
        private final String myName;

        private PhpImportQualifierQuickFix(@Nls String name) {
            this.myName = name;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                PhpImportQualifierQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PhpReference classReference;
            if (project == null) {
                PhpImportQualifierQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpImportQualifierQuickFix.$$$reportNull$$$0(2);
            }
            if ((classReference = PhpPsiUtil.getClassReferenceAt(descriptor.getPsiElement())) == null) {
                return;
            }
            String fqn = PhpCodeInsightUtil.getImmediateFQN(classReference);
            if (fqn == null) {
                return;
            }
            PhpPsiElement scopeForUseOperator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)classReference);
            if (scopeForUseOperator == null) {
                return;
            }
            PhpImportClassIntention.apply(project, scopeForUseOperator, fqn, null, this.getFamilyName(), PhpBaseImportQuickFix.getKeyword(classReference));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFullyQualifiedNameUsageInspection$PhpImportQualifierQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFullyQualifiedNameUsageInspection$PhpImportQualifierQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

