/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpFqnInspectionBase
extends PhpInspection {
    public boolean ENABLE_IN_FILE_SCOPE = true;
    public boolean IGNORE_GLOBAL_NAMESPACE = false;

    protected static boolean isGlobalNamespaceFqn(@Nullable String fqn) {
        return fqn != null && PhpLangUtil.isFqn(fqn) && PhpLangUtil.isGlobalNamespaceFQN(PhpLangUtil.getParentNamespaceFQN(fqn));
    }

    protected LocalQuickFix[] getQuickFixes(@NotNull PhpReference reference, LocalQuickFix fix) {
        if (reference == null) {
            PhpFqnInspectionBase.$$$reportNull$$$0(0);
        }
        ArrayList<LocalQuickFix> fixes = new ArrayList<LocalQuickFix>();
        fixes.add(fix);
        if (PhpFqnInspectionBase.isGlobalNamespaceFqn(reference.getFQN())) {
            fixes.add(new PhpEnableIgnoreGlobalNamespaceSettingQuickFix(this.getShortNameKey()));
        }
        if (PhpPsiUtil.getParentByCondition((PsiElement)reference, false, (Condition<? super PsiElement>)PhpDocType.INSTANCEOF) != null) {
            fixes.add(PhpEnableFqcnInPhpDocQuickFix.INSTANCE);
        }
        return fixes.toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    @NotNull
    protected abstract Key<? extends PhpFqnInspectionBase> getShortNameKey();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase", "getQuickFixes"));
    }

    private static class PhpEnableFqcnInPhpDocQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpEnableFqcnInPhpDocQuickFix();

        private PhpEnableFqcnInPhpDocQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.force.fqcn.for.references.in.phpdoc", new Object[0]);
            if (string == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpEnableFqcnInPhpDocQuickFix.$$$reportNull$$$0(2);
            }
            final PsiElement element = descriptor.getPsiElement();
            PhpEnableFqcnInPhpDocQuickFix.setPhpDocFQCN(element, true);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{element.getContainingFile().getVirtualFile()}){

                public void undo() {
                    PhpEnableFqcnInPhpDocQuickFix.setPhpDocFQCN(element, false);
                }

                public void redo() {
                    PhpEnableFqcnInPhpDocQuickFix.setPhpDocFQCN(element, true);
                }

                public boolean isGlobal() {
                    return true;
                }
            });
        }

        private static void setPhpDocFQCN(PsiElement element, boolean value) {
            ((PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)element.getContainingFile(), PhpCodeStyleSettings.class)).PHPDOC_USE_FQCN = value;
            DaemonCodeAnalyzer.getInstance((Project)element.getProject()).restart();
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase$PhpEnableFqcnInPhpDocQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase$PhpEnableFqcnInPhpDocQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class PhpEnableIgnoreGlobalNamespaceSettingQuickFix
    implements LocalQuickFix,
    LowPriorityAction {
        private final Key<? extends PhpFqnInspectionBase> myFqnInspectionKey;

        private PhpEnableIgnoreGlobalNamespaceSettingQuickFix(Key<? extends PhpFqnInspectionBase> fqnInspectionKey) {
            this.myFqnInspectionKey = fqnInspectionKey;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("quickfix.disable.inspection.for.global.namespace", new Object[0]);
            if (string == null) {
                PhpEnableIgnoreGlobalNamespaceSettingQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpEnableIgnoreGlobalNamespaceSettingQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpEnableIgnoreGlobalNamespaceSettingQuickFix.$$$reportNull$$$0(2);
            }
            final PsiElement element = descriptor.getPsiElement();
            this.setIgnoreGlobalNamespaceSetting(project, element, true);
            UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)new BasicUndoableAction(new VirtualFile[]{element.getContainingFile().getVirtualFile()}){

                public void undo() {
                    this.setIgnoreGlobalNamespaceSetting(project, element, false);
                }

                public void redo() {
                    this.setIgnoreGlobalNamespaceSetting(project, element, true);
                }
            });
        }

        private void setIgnoreGlobalNamespaceSetting(@NotNull Project project, @NotNull PsiElement element, boolean value) {
            if (project == null) {
                PhpEnableIgnoreGlobalNamespaceSettingQuickFix.$$$reportNull$$$0(3);
            }
            if (element == null) {
                PhpEnableIgnoreGlobalNamespaceSettingQuickFix.$$$reportNull$$$0(4);
            }
            InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
            profile.modifyToolSettings(this.myFqnInspectionKey, element, inspection -> {
                inspection.IGNORE_GLOBAL_NAMESPACE = value;
            });
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase$PhpEnableIgnoreGlobalNamespaceSettingQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFqnInspectionBase$PhpEnableIgnoreGlobalNamespaceSettingQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setIgnoreGlobalNamespaceSetting";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

