/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.highlighting.PhpConversionSpecificationParser;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersHandlerFactory;
import com.jetbrains.php.codeInsight.highlighting.PhpHighlightFormatStringParametersUsagesHandler;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.intentions.stringDoc.PhpHeredocToStringIntention;
import com.jetbrains.php.lang.intentions.strings.converters.PhpConcatenationStringRepresentationConverter;
import com.jetbrains.php.lang.intentions.strings.converters.PhpInterpolationStringRepresentationConverter;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFormatFunctionParametersMismatchInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpFormatFunctionParametersMismatchInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                this.checkReference(reference);
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.checkReference((FunctionReference)reference);
            }

            private void checkReference(FunctionReference reference) {
                int formatStringIndex = PhpHighlightFormatStringParametersHandlerFactory.getFormatStringIndex(holder.getProject(), reference);
                PsiElement[] parameters = reference.getParameters();
                if (formatStringIndex < 0 || formatStringIndex >= parameters.length) {
                    return;
                }
                List<StringLiteralExpression> expressions = PhpFormatFunctionParametersMismatchInspection.getLiteralExpressions(parameters[formatStringIndex]);
                MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications = PhpFormatFunctionParametersMismatchInspection.getConversionSpecifications(expressions);
                if (specifications == null) {
                    return;
                }
                this.checkFormatStringSpecifications(formatStringIndex, parameters, specifications, expressions);
                this.checkParameters(formatStringIndex, parameters, specifications);
            }

            private void checkParameters(int formatStringIndex, PsiElement[] parameters, MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications) {
                for (int i = formatStringIndex + 1; i < parameters.length; ++i) {
                    if (specifications.containsKey((Object)(i - formatStringIndex))) continue;
                    holder.registerProblem(parameters[i], PhpFormatFunctionParametersMismatchInspection.getParameterMessage(), new LocalQuickFix[0]);
                }
            }

            private void checkFormatStringSpecifications(int formatStringIndex, PsiElement[] parameters, MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> specifications, List<StringLiteralExpression> expressions) {
                if (IntStream.range(0, parameters.length).filter(i -> i > formatStringIndex).anyMatch(i -> PhpPsiUtil.isArgumentUnpacking(parameters[i]))) {
                    return;
                }
                MultiMap<Integer, PhpHighlightFormatStringParametersUsagesHandler.RelativeRange> relativeSpecificationRanges = PhpHighlightFormatStringParametersUsagesHandler.getRelativeSpecificationRanges(specifications, expressions);
                relativeSpecificationRanges.entrySet().stream().filter(e -> (Integer)e.getKey() + formatStringIndex >= parameters.length).flatMap(e -> ((Collection)e.getValue()).stream()).forEach(e -> holder.registerProblem((PsiElement)e.getContainingExpression(), e.getRangeInsideExpression().shiftRight(e.getContainingExpression().getValueRange().getStartOffset()), PhpFormatFunctionParametersMismatchInspection.getStringMessage(), new LocalQuickFix[0]));
            }
        };
    }

    @Nullable
    public static MultiMap<Integer, PhpConversionSpecificationParser.ConversionSpecification> getConversionSpecifications(List<StringLiteralExpression> expressions) {
        StringLiteralExpression expression = (StringLiteralExpression)ContainerUtil.getFirstItem(expressions);
        if (expression == null) {
            return null;
        }
        String content = PhpInterpolationStringRepresentationConverter.createExpressionContent(expressions);
        return PhpConversionSpecificationParser.parseConversionSpecifications(content, expression.isSingleQuote() || PhpHeredocToStringIntention.isNowdoc((PsiElement)expression));
    }

    @NotNull
    public static List<StringLiteralExpression> getLiteralExpressions(PsiElement argument) {
        if (argument instanceof StringLiteralExpression) {
            List<StringLiteralExpression> list = Collections.singletonList((StringLiteralExpression)argument);
            if (list == null) {
                PhpFormatFunctionParametersMismatchInspection.$$$reportNull$$$0(1);
            }
            return list;
        }
        if (PhpConcatenationStringRepresentationConverter.isConcatenation(argument)) {
            List<StringLiteralExpression> list = PhpHighlightFormatStringParametersUsagesHandler.getLiteralExpressions((BinaryExpression)argument);
            if (list == null) {
                PhpFormatFunctionParametersMismatchInspection.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<StringLiteralExpression> list = Collections.emptyList();
        if (list == null) {
            PhpFormatFunctionParametersMismatchInspection.$$$reportNull$$$0(3);
        }
        return list;
    }

    @InspectionMessage
    private static String getParameterMessage() {
        return PhpBundle.message("inspection.format.function.parameters.mismatch.parameter", new Object[0]);
    }

    @InspectionMessage
    private static String getStringMessage() {
        return PhpBundle.message("inspection.format.function.parameters.mismatch.conversion.specification", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpFormatFunctionParametersMismatchInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpFormatFunctionParametersMismatchInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralExpressions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

