/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpRedundantAssignmentToPromotedFieldInspection;
import com.jetbrains.php.lang.inspections.controlFlow.PhpSideEffectDetector;
import com.jetbrains.php.lang.inspections.quickfix.PhpAddThrowBeforeExceptionQuickFix;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class PhpExpressionResultUnusedInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpElement(PhpPsiElement element) {
                if (element instanceof PhpExpression) {
                    if (element instanceof AssignmentExpression || element instanceof PhpGoto) {
                        return;
                    }
                    if (!(element.getParent() instanceof PhpUse)) {
                        PhpExpressionResultUnusedInspection.analyzeExpression((PhpExpression)element, holder);
                    }
                }
            }

            public void visitPhpMethodReference(MethodReference reference) {
                if (PhpLangUtil.equalsMethodNames(reference.getName(), "__construct") && !(reference.getClassReference() instanceof Variable)) {
                    return;
                }
                this.visitPhpElement((PhpPsiElement)reference);
            }
        };
    }

    private static void analyzeExpression(@NotNull PhpExpression psiElement, @NotNull ProblemsHolder holder) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(2);
        }
        if (!PhpCodeInsightUtil.isResultUsed((PsiElement)psiElement) && !PhpSideEffectDetector.canContainSideEffect((PsiElement)psiElement, true, true)) {
            boolean isInsideSingleStatement = PhpExpressionResultUnusedInspection.isInsideSingleStatement((PsiElement)psiElement);
            if (PhpExpressionResultUnusedInspection.hasOnlyThrowableTypes(psiElement)) {
                PhpExpressionResultUnusedInspection.registerUnusedThrowable(psiElement, holder, isInsideSingleStatement);
            } else {
                PhpExpressionResultUnusedInspection.registerUnusedExpression(psiElement, holder, isInsideSingleStatement);
            }
        }
    }

    public static boolean isInsideSingleStatement(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(3);
        }
        PsiElement parent = psiElement.getParent();
        return PhpRedundantAssignmentToPromotedFieldInspection.isSingleStatement(parent);
    }

    private static void registerUnusedExpression(@NotNull PhpExpression psiElement, @NotNull ProblemsHolder holder, boolean isInsideSingleStatement) {
        LocalQuickFix[] localQuickFixArray;
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(5);
        }
        PsiElement parent = psiElement.getParent();
        if (isInsideSingleStatement) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = new PhpDeleteElementQuickFix(parent);
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] fixes = localQuickFixArray;
        holder.registerProblem(PhpExpressionResultUnusedInspection.getElementToHighlight(psiElement), PhpBundle.message("inspection.expression.result.unused.problem", new Object[0]), fixes);
    }

    private static void registerUnusedThrowable(@NotNull PhpExpression expression, @NotNull ProblemsHolder holder, boolean insideSingleStatement) {
        LocalQuickFix[] localQuickFixArray;
        if (expression == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(7);
        }
        if (insideSingleStatement) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = PhpAddThrowBeforeExceptionQuickFix.INSTANCE;
        } else {
            localQuickFixArray = LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] fixes = localQuickFixArray;
        holder.registerProblem(PhpExpressionResultUnusedInspection.getElementToHighlight(expression), PhpBundle.message("inspection.php.throwable.not.thrown.inspection.display.name", new Object[0]), fixes);
    }

    @NotNull
    private static PsiElement getElementToHighlight(@NotNull PhpExpression psiElement) {
        if (psiElement == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(8);
        }
        Object object = psiElement instanceof PhpMatchExpression ? psiElement.getFirstChild() : psiElement;
        if (object == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(9);
        }
        return object;
    }

    private static boolean hasOnlyThrowableTypes(@NotNull PhpExpression expression) {
        if (expression == null) {
            PhpExpressionResultUnusedInspection.$$$reportNull$$$0(10);
        }
        PhpIndex phpIndex = PhpIndex.getInstance((Project)expression.getProject());
        PhpType type = expression.getGlobalType();
        return !type.isEmpty() && ContainerUtil.all((Collection)type.getTypes(), t -> PhpType.findSuper((String)"\\Throwable", (String)t, (PhpIndex)phpIndex));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpExpressionResultUnusedInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpExpressionResultUnusedInspection";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "analyzeExpression";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isInsideSingleStatement";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerUnusedExpression";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "registerUnusedThrowable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getElementToHighlight";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyThrowableTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

