/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.inspections.PhpDeprecationInspection;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.PhpLanguageLevelInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassConstantInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedClassInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedConstantInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFieldInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedFunctionInspection;
import com.jetbrains.php.lang.inspections.PhpUndefinedMethodInspection;
import com.jetbrains.php.lang.psi.PhpDeprecationProvider;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClassAlias;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpElementIsNotAvailableInCurrentPhpVersionInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){
            private final boolean syncWithComposer;
            {
                this.syncWithComposer = ComposerDataService.getInstance(holder.getProject()).syncLanguageLevel();
            }

            public void visitPhpMethodReference(MethodReference reference) {
                this.check((PhpReference)reference, () -> PhpUndefinedMethodInspection.findDfaReachability(reference) == PhpUndefinedMethodInspection.Reachability.DEFINED);
            }

            public void visitPhpFunctionCall(FunctionReference reference) {
                Supplier<Boolean> dfaReachableSupplier = this.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> PhpUndefinedFunctionInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined));
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            public void visitPhpClassReference(ClassReference reference) {
                Supplier<Boolean> dfaReachableSupplier = this.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> PhpUndefinedClassInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined));
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            public void visitPhpClassConstantReference(ClassConstantReference reference) {
                Supplier<Boolean> dfaReachableSupplier = this.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> {
                    PhpExpression classReference = reference.getClassReference();
                    if (classReference instanceof ClassReference) {
                        PhpUndefinedClassConstantInspection.performDfaReachability((MemberReference)reference, (PhpReference)classReference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined);
                    }
                });
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            public void visitPhpFieldReference(FieldReference reference) {
                Supplier<Boolean> dfaReachableSupplier = this.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> PhpUndefinedFieldInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined));
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            public void visitPhpConstantReference(ConstantReference reference) {
                Supplier<Boolean> dfaReachableSupplier = this.createDfaReachableSupplier((canBeDefined, canBeUndefined) -> PhpUndefinedConstantInspection.processDfaReachability(reference, (Ref<Boolean>)canBeDefined, (Ref<Boolean>)canBeUndefined));
                this.check((PhpReference)reference, dfaReachableSupplier);
            }

            private Supplier<Boolean> createDfaReachableSupplier(BiConsumer<Ref<Boolean>, Ref<Boolean>> consumer) {
                return () -> {
                    Ref canBeUndefined = new Ref((Object)Boolean.FALSE);
                    Ref canBeDefined = new Ref((Object)Boolean.FALSE);
                    consumer.accept(canBeDefined, canBeUndefined);
                    return (Boolean)canBeDefined.get() != false && (Boolean)canBeUndefined.get() == false;
                };
            }

            private void check(PhpReference reference, Supplier<Boolean> dfaReachableSupplier) {
                Collection<? extends PsiElement> elements = PhpDeprecationInspection.multiResolve(reference);
                if (elements.isEmpty()) {
                    return;
                }
                if (ContainerUtil.all(elements, PhpElementIsNotAvailableInCurrentPhpVersionInspection::notAvailableBySinceTag)) {
                    if (dfaReachableSupplier.get().booleanValue()) {
                        return;
                    }
                    PhpLanguageLevel version = PhpElementIsNotAvailableInCurrentPhpVersionInspection.versions(elements, "@since").max(Comparator.naturalOrder()).orElse(PhpLanguageLevel.DEFAULT);
                    LocalQuickFix fix = PhpLanguageLevelInspection.getSwitchLanguageLevelQuickFix(holder.getProject(), version, this.syncWithComposer, isOnTheFly);
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("php.element.is.available.starting.with.php.version", reference.getName(), version.getPresentableName()), new LocalQuickFix[]{fix});
                    return;
                }
                if (ContainerUtil.all(elements, PhpElementIsNotAvailableInCurrentPhpVersionInspection::notAvailableByRemovedTag)) {
                    if (dfaReachableSupplier.get().booleanValue()) {
                        return;
                    }
                    PhpLanguageLevel removedVersion = PhpElementIsNotAvailableInCurrentPhpVersionInspection.versions(elements, "@removed").min(Comparator.naturalOrder()).orElse(PhpLanguageLevel.DEFAULT);
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("php.element.was.removed.in.php.version", reference.getName(), removedVersion.getPresentableName()), new LocalQuickFix[0]);
                }
            }
        };
    }

    public static boolean notAvailableByRemovedTag(PsiElement element) {
        if (element instanceof PhpNamedElement) {
            String removedVersion = PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion((PhpNamedElement)element, "@removed");
            return removedVersion != null & PhpElementIsNotAvailableInCurrentPhpVersionInspection.isRemovedInCurrentPhpVersion((PhpNamedElement)element, removedVersion);
        }
        return false;
    }

    public static boolean notAvailableBySinceTag(PsiElement element) {
        if (element instanceof PhpNamedElement) {
            String version = PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion((PhpNamedElement)element, "@since");
            return version != null && !PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion((PhpNamedElement)element, version);
        }
        return true;
    }

    private static @NotNull Stream<@Nullable PhpLanguageLevel> versions(Collection<? extends PsiElement> elements, String tag) {
        Stream<PhpLanguageLevel> stream = elements.stream().map(e -> PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion((PhpNamedElement)e, tag)).filter(Objects::nonNull).map(versionString -> (PhpLanguageLevel)((Object)((Object)ObjectUtils.notNull((Object)((Object)PhpLanguageLevel.parse(versionString)), (Object)((Object)PhpLanguageLevel.DEFAULT)))));
        if (stream == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(1);
        }
        return stream;
    }

    public static boolean isAvailableInCurrentPhpVersion(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(2);
        }
        return PhpElementIsNotAvailableInCurrentPhpVersionInspection.isAvailableInCurrentPhpVersion(element, PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion(element, "@since")) && !PhpElementIsNotAvailableInCurrentPhpVersionInspection.isRemovedInCurrentPhpVersion(element);
    }

    private static boolean isRemovedInCurrentPhpVersion(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(3);
        }
        return PhpElementIsNotAvailableInCurrentPhpVersionInspection.isRemovedInCurrentPhpVersion(element, PhpElementIsNotAvailableInCurrentPhpVersionInspection.getVersion(element, "@removed"));
    }

    public static boolean isRemovedInCurrentPhpVersion(@NotNull PhpNamedElement element, String removedVersion) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(4);
        }
        if (removedVersion == null) {
            return false;
        }
        List providers = PhpDeprecationProvider.getProvidersForElement((PhpNamedElement)element);
        return !providers.isEmpty() && providers.stream().allMatch(provider -> provider.isDeprecated(element, removedVersion));
    }

    private static boolean isAvailableInCurrentPhpVersion(@NotNull PhpNamedElement element, @Nullable String version) {
        if (element == null) {
            PhpElementIsNotAvailableInCurrentPhpVersionInspection.$$$reportNull$$$0(5);
        }
        if (version == null) {
            return true;
        }
        return PhpDeprecationProvider.getProvidersForElement((PhpNamedElement)element).stream().noneMatch(provider -> provider.isNotAvailable(element, version));
    }

    private static String getVersion(PhpNamedElement element, String tagName) {
        PhpDocTag sinceTag;
        if (element instanceof PhpClassAlias) {
            return null;
        }
        PhpDocComment comment = element.getDocComment();
        PhpDocTag phpDocTag = sinceTag = comment != null ? (PhpDocTag)ArrayUtil.getFirstElement((Object[])comment.getTagElementsByName(tagName)) : null;
        if (sinceTag == null) {
            return null;
        }
        return PhpNamedElementImpl.getVersionString(sinceTag);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpElementIsNotAvailableInCurrentPhpVersionInspection";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpElementIsNotAvailableInCurrentPhpVersionInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "versions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailableInCurrentPhpVersion";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isRemovedInCurrentPhpVersion";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

