/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpNavigateToDuplicateElementQuickFix;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldsDefaultValueMatcherIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFileConstantsDefaultValueMatcherIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpParametersDefaultValueMatchersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDuplicateArrayKeysInspection
extends PhpInspection {
    private static final int MAX_RESOLVE_JUMPS = 5;

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
                for (Map.Entry<Pair<String, String>, List<PsiElement>> entry : PhpDuplicateArrayKeysInspection.getKeyValueToKeyElementMap(expression).entrySet()) {
                    List<PsiElement> duplicates = entry.getValue();
                    if (duplicates.size() < 2) continue;
                    Pair<String, String> valueWithSignature = entry.getKey();
                    if (valueWithSignature.first == null && valueWithSignature.second == null) continue;
                    PhpDuplicateArrayKeysInspection.highlightDuplicates((String)valueWithSignature.first, duplicates, holder, isOnTheFly);
                }
            }
        };
    }

    private static void highlightDuplicates(@Nullable String keyValue, @NotNull List<PsiElement> duplicateKeys, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (duplicateKeys == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(2);
        }
        for (int i = 0; i < duplicateKeys.size(); ++i) {
            PsiElement key = duplicateKeys.get(i);
            if (isOnTheFly) {
                PsiElement nextKey = duplicateKeys.get((i + 1) % duplicateKeys.size());
                holder.registerProblem(key, PhpDuplicateArrayKeysInspection.getProblem(key, keyValue), new LocalQuickFix[]{new PhpNavigateToDuplicateElementQuickFix(nextKey, PhpBundle.message("quickfix.navigate.to.duplicate.array.key", new Object[0]))});
                continue;
            }
            holder.registerProblem(key, PhpDuplicateArrayKeysInspection.getProblem(key, keyValue), new LocalQuickFix[0]);
        }
    }

    @NotNull
    private static Map<Pair<String, String>, List<PsiElement>> getKeyValueToKeyElementMap(ArrayCreationExpression expression) {
        HashMap<Pair<String, String>, List<PsiElement>> keyValueToKeyElement = new HashMap<Pair<String, String>, List<PsiElement>>();
        for (ArrayHashElement hashElement : expression.getHashElements()) {
            Pair<String, String> keyValueWithSignature;
            PhpPsiElement keyElement = hashElement.getKey();
            if (keyElement == null || (keyValueWithSignature = PhpDuplicateArrayKeysInspection.getKeyValueWithSignature(keyElement)) == null) continue;
            keyValueToKeyElement.computeIfAbsent(keyValueWithSignature, s -> new SmartList()).add(keyElement);
        }
        HashMap<Pair<String, String>, List<PsiElement>> hashMap = keyValueToKeyElement;
        if (hashMap == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(3);
        }
        return hashMap;
    }

    @Nullable
    private static Pair<String, String> getKeyValueWithSignature(@NotNull PhpPsiElement firstChild) {
        if (firstChild == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(4);
        }
        if (firstChild instanceof ConstantReference || firstChild instanceof ClassConstantReference) {
            PsiElement resolve = ((PhpReference)firstChild).resolve();
            if (resolve == null && firstChild instanceof ClassConstantReference) {
                PhpExpression classReference = ((ClassConstantReference)firstChild).getClassReference();
                if (classReference instanceof ClassReference) {
                    return Pair.create((Object)(((ClassReference)classReference).getFQN() + "::" + firstChild.getName()), null);
                }
            } else if (resolve instanceof Constant || PhpDuplicateArrayKeysInspection.isClassConstant(resolve)) {
                return PhpDuplicateArrayKeysInspection.resolveToFinalValue((PhpNamedElement)resolve, 5);
            }
        }
        return Pair.create((Object)PhpCodeInsightUtil.toString((PsiElement)firstChild), null);
    }

    @Nullable
    private static Pair<String, String> resolveToFinalValue(@NotNull PhpNamedElement element, int resolveJumpsLeft) {
        PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher matcher;
        if (element == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(5);
        }
        if ((matcher = PhpDuplicateArrayKeysInspection.getValueMatcher(element)) == null) {
            return null;
        }
        String value = matcher.getValue();
        if (matcher instanceof PhpParametersDefaultValueMatchersIndex.PhpParameterConstantDefaultValueMatcher) {
            Pair<String, String> valueWithSignature;
            List constants;
            PhpNamedElement constant;
            if (resolveJumpsLeft > 0 && (constant = (PhpNamedElement)ContainerUtil.getOnlyItem((Collection)(constants = ContainerUtil.filter((Collection)PhpIndex.getInstance((Project)element.getProject()).getBySignature(value), e -> e instanceof Constant || PhpDuplicateArrayKeysInspection.isClassConstant((PsiElement)e))))) != null && (valueWithSignature = PhpDuplicateArrayKeysInspection.resolveToFinalValue(constant, resolveJumpsLeft - 1)) != null) {
                return valueWithSignature;
            }
            return Pair.create(null, (Object)value);
        }
        return Pair.create((Object)value, null);
    }

    @Nullable
    private static PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher getValueMatcher(@NotNull PhpNamedElement element) {
        if (element == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(6);
        }
        if (element instanceof Constant) {
            return PhpFileConstantsDefaultValueMatcherIndex.getDefaultValueMatcher((Constant)element);
        }
        if (PhpDuplicateArrayKeysInspection.isClassConstant((PsiElement)element)) {
            return PhpFieldsDefaultValueMatcherIndex.getDefaultValueMatcher((Field)element);
        }
        return null;
    }

    private static boolean isClassConstant(PsiElement element) {
        return element instanceof Field && ((Field)element).isConstant();
    }

    @Nls
    private static String getProblem(@NotNull PsiElement key, @Nullable String keyValue) {
        if (key == null) {
            PhpDuplicateArrayKeysInspection.$$$reportNull$$$0(7);
        }
        if (keyValue != null && key instanceof PhpReference && !PhpLangUtil.isBuiltInConstant(((PhpReference)key).getName())) {
            return PhpBundle.message("inspection.duplicate.array.keys.problem.0", keyValue);
        }
        return PhpBundle.message("inspection.duplicate.array.keys.problem", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicateKeys";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDuplicateArrayKeysInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstChild";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDuplicateArrayKeysInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyValueToKeyElementMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "highlightDuplicates";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getKeyValueWithSignature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveToFinalValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getValueMatcher";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

