/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.EditInspectionToolsSettingsAction;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.json.JsonDialectUtil;
import com.intellij.json.psi.JsonElementVisitor;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.composer.ComposerDataService;
import com.jetbrains.php.composer.configData.ComposerConfigClient;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.inspections.quickfix.PhpQuickFixBase;
import com.jetbrains.php.tools.quality.QualityToolsComposerConfig;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDisabledQualityToolComposerInspection
extends LocalInspectionTool {
    private static final EnableInspectionFix[] ENABLE_INSPECTION_FIX = new EnableInspectionFix[]{EnableInspectionFix.INSTANCE};
    private static final OpenInspectionSettingsFix[] OPEN_INSPECTION_SETTINGS_FIXES = new OpenInspectionSettingsFix[]{OpenInspectionSettingsFix.INSTANCE};

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        PsiFile file;
        if (holder == null) {
            PhpDisabledQualityToolComposerInspection.$$$reportNull$$$0(0);
        }
        if (!JsonDialectUtil.isStandardJson((PsiElement)(file = holder.getFile()))) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpDisabledQualityToolComposerInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        final Project project = holder.getProject();
        ComposerDataService dataService = ComposerDataService.getInstance(project);
        if (dataService == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpDisabledQualityToolComposerInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        String path = dataService.getConfigPath();
        if (path == null || !FileUtil.pathsEqual((String)path, (String)file.getVirtualFile().getPath())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpDisabledQualityToolComposerInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new JsonElementVisitor(){

            public void visitObject(@NotNull JsonObject o) {
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (ComposerConfigClient client : (ComposerConfigClient[])ComposerConfigClient.EP_NAME.getExtensions()) {
                    ObjectUtils.consumeIfCast((Object)client, QualityToolsComposerConfig.class, qualityConfig -> {
                        PhpInterpreter interpreter = PhpProjectConfigurationFacade.getInstance(project).getInterpreter();
                        Object settings = qualityConfig.getSettings(project, interpreter);
                        if (settings != null && !StringUtil.isEmpty((String)settings.getToolPath())) {
                            JsonProperty property = o.findProperty(qualityConfig.getFrameworkPackage());
                            InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
                            if (property != null && !profile.isToolEnabled(HighlightDisplayKey.find((String)qualityConfig.getQualityInspectionShortName()), (PsiElement)o)) {
                                holder.registerProblem((PsiElement)property.getNameElement(), PhpBundle.message("inspection.disabled.quality.tool.inspection", qualityConfig.getConfigurationManager(project).getQualityToolName()), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])(isOnTheFly ? (qualityConfig.canBeEnabled(project) ? ENABLE_INSPECTION_FIX : OPEN_INSPECTION_SETTINGS_FIXES) : LocalQuickFix.EMPTY_ARRAY));
                            }
                        }
                    });
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/jetbrains/php/lang/inspections/PhpDisabledQualityToolComposerInspection$1", "visitObject"));
            }
        };
    }

    @Nullable
    private static QualityToolsComposerConfig getComposerConfig(@NotNull PsiElement element, @NotNull Project project) {
        if (element == null) {
            PhpDisabledQualityToolComposerInspection.$$$reportNull$$$0(4);
        }
        if (project == null) {
            PhpDisabledQualityToolComposerInspection.$$$reportNull$$$0(5);
        }
        return ComposerConfigClient.EP_NAME.extensions().filter(QualityToolsComposerConfig.class::isInstance).map(QualityToolsComposerConfig.class::cast).filter(i -> i.getFrameworkPackage().equals(((JsonStringLiteral)element).getValue())).findFirst().orElse(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDisabledQualityToolComposerInspection";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDisabledQualityToolComposerInspection";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getComposerConfig";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class OpenInspectionSettingsFix
    extends PhpQuickFixBase {
        static OpenInspectionSettingsFix INSTANCE = new OpenInspectionSettingsFix();

        private OpenInspectionSettingsFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.disabled.quality.tool.inspection.open.fix", new Object[0]);
            if (string == null) {
                OpenInspectionSettingsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                OpenInspectionSettingsFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                OpenInspectionSettingsFix.$$$reportNull$$$0(2);
            }
            QualityToolsComposerConfig composerConfig = PhpDisabledQualityToolComposerInspection.getComposerConfig(descriptor.getPsiElement(), project);
            ObjectUtils.consumeIfNotNull((Object)composerConfig, config -> EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile(), (String)config.getQualityInspectionShortName()));
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDisabledQualityToolComposerInspection$OpenInspectionSettingsFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDisabledQualityToolComposerInspection$OpenInspectionSettingsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class EnableInspectionFix
    extends PhpQuickFixBase {
        static EnableInspectionFix INSTANCE = new EnableInspectionFix();

        private EnableInspectionFix() {
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("inspection.disabled.quality.tool.inspection.fix", new Object[0]);
            if (string == null) {
                EnableInspectionFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                EnableInspectionFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                EnableInspectionFix.$$$reportNull$$$0(2);
            }
            QualityToolsComposerConfig composerConfig = PhpDisabledQualityToolComposerInspection.getComposerConfig(descriptor.getPsiElement(), project);
            ObjectUtils.consumeIfNotNull((Object)composerConfig, config -> {
                InspectionProfileManager.getInstance((Project)project).getCurrentProfile().enableTool(config.getQualityInspectionShortName(), project);
                EditInspectionToolsSettingsAction.editToolSettings((Project)project, (InspectionProfileImpl)ProjectInspectionProfileManager.getInstance((Project)project).getCurrentProfile(), (String)config.getQualityInspectionShortName());
            });
        }

        public boolean startInWriteAction() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDisabledQualityToolComposerInspection$EnableInspectionFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDisabledQualityToolComposerInspection$EnableInspectionFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

