/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.PhpDeprecationQuickFixesProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpDeprecationAttributeOwner;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDeprecationInfoBasedQuickFixProvider
implements PhpDeprecationQuickFixesProvider {
    private static final PhpDeprecationTemplateVariable PARAMETER_LIST_TEMPLATE_VARIABLE = new PhpDeprecationTemplateVariable("%parametersList%", r -> {
        ParameterList list = r.getParameterList();
        return list != null ? list.getText() : null;
    });
    private static final PhpDeprecationTemplateVariable NAME_DEPRECATION_TEMPLATE = new PhpDeprecationTemplateVariable("%name%", reference -> {
        if (reference instanceof MethodReference) {
            return reference.getName();
        }
        PsiElement lParen = PhpPsiUtil.getChildOfType(reference.getElement(), PhpTokenTypes.chLPAREN);
        TextRange range = lParen != null ? TextRange.create((int)0, (int)lParen.getStartOffsetInParent()) : TextRange.create((int)0, (int)reference.getTextRange().getLength());
        return range.substring(reference.getText());
    });
    private static final PhpDeprecationTemplateVariable CLASS_REFERENCE_DEPRECATION_TEMPLATE = new PhpDeprecationTemplateVariable("%class%", reference -> {
        if (reference instanceof MethodReference) {
            PhpExpression classReference = ((MethodReference)reference).getClassReference();
            return classReference != null ? classReference.getText() : null;
        }
        return null;
    });

    @Override
    @NotNull
    public Collection<? extends LocalQuickFix> createFixes(@NotNull PsiElement deprecatedReference, @NotNull PhpNamedElement deprecatedElement) {
        if (deprecatedReference == null) {
            PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(0);
        }
        if (deprecatedElement == null) {
            PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(1);
        }
        if (deprecatedElement instanceof PhpDeprecationAttributeOwner && deprecatedReference instanceof FunctionReference) {
            String replaceWith;
            PhpDeprecationAttributeOwner.PhpDeprecationInfo info = ((PhpDeprecationAttributeOwner)deprecatedElement).getDeprecationInfo();
            String string = replaceWith = info != null ? info.getReplaceWith() : null;
            if (replaceWith != null) {
                List<PhpReplaceWithDeprecationInfoBasedQuickFix> list = Collections.singletonList(new PhpReplaceWithDeprecationInfoBasedQuickFix(deprecatedReference, deprecatedElement, replaceWith));
                if (list == null) {
                    PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(2);
                }
                return list;
            }
        }
        List list = Collections.emptyList();
        if (list == null) {
            PhpDeprecationInfoBasedQuickFixProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    public static Collection<PhpDeprecationTemplateVariable> getDeprecationTemplateVariables(@Nullable PhpNamedElement element) {
        if (element == null) {
            return Collections.emptyList();
        }
        ArrayList<PhpDeprecationTemplateVariable> res = new ArrayList<PhpDeprecationTemplateVariable>();
        if (element instanceof Function) {
            Parameter[] parameters = ((Function)element).getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                res.add(PhpDeprecationInfoBasedQuickFixProvider.createParameterDeprecationTemplate(i));
            }
            res.add(PARAMETER_LIST_TEMPLATE_VARIABLE);
            res.add(NAME_DEPRECATION_TEMPLATE);
            if (element instanceof Method) {
                res.add(CLASS_REFERENCE_DEPRECATION_TEMPLATE);
            }
        }
        return res;
    }

    @NotNull
    private static PhpDeprecationTemplateVariable createParameterDeprecationTemplate(int i) {
        return new PhpDeprecationTemplateVariable(String.format("%%parameter%d%%", i), reference -> {
            ParameterListOwner owner = (ParameterListOwner)ObjectUtils.tryCast((Object)reference, ParameterListOwner.class);
            PsiElement argument = owner != null ? owner.getParameter(i) : null;
            return argument != null ? argument.getText() : null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deprecatedElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createFixes";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpReplaceWithDeprecationInfoBasedQuickFix
    implements LocalQuickFix {
        private final String myText;

        private PhpReplaceWithDeprecationInfoBasedQuickFix(@NotNull PsiElement reference, @NotNull PhpNamedElement deprecatedElement, String replaceWith) {
            if (reference == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(0);
            }
            if (deprecatedElement == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(1);
            }
            this.myText = PhpReplaceWithDeprecationInfoBasedQuickFix.composeText(reference, deprecatedElement, replaceWith);
        }

        private static String composeText(PsiElement reference, @NotNull PhpNamedElement deprecatedElement, String replaceWith) {
            if (deprecatedElement == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(2);
            }
            if (reference instanceof FunctionReference) {
                Collection<PhpDeprecationTemplateVariable> deprecationTemplateVariables = PhpDeprecationInfoBasedQuickFixProvider.getDeprecationTemplateVariables(deprecatedElement);
                for (PhpDeprecationTemplateVariable variable : deprecationTemplateVariables) {
                    String replacement = variable.myReplaceFunction.apply((FunctionReference)((FunctionReference)reference));
                    if (replacement == null) continue;
                    replaceWith = replaceWith.replace(variable.getTemplate(), replacement);
                }
            }
            return replaceWith;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.replace.with", this.myText);
            if (string == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(4);
            }
            if (descriptor == null) {
                PhpReplaceWithDeprecationInfoBasedQuickFix.$$$reportNull$$$0(5);
            }
            descriptor.getStartElement().replace((PsiElement)PhpPsiElementFactory.createFunctionReference(project, this.myText));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "reference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deprecatedElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpReplaceWithDeprecationInfoBasedQuickFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpReplaceWithDeprecationInfoBasedQuickFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "composeText";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PhpDeprecationTemplateVariable {
        @NotNull
        private final String myTemplate;
        private final java.util.function.Function<? super @NotNull FunctionReference, @Nullable String> myReplaceFunction;

        public PhpDeprecationTemplateVariable(@NotNull String template, java.util.function.Function<? super @NotNull FunctionReference, @Nullable String> replaceFunction) {
            if (template == null) {
                PhpDeprecationTemplateVariable.$$$reportNull$$$0(0);
            }
            this.myTemplate = template;
            this.myReplaceFunction = replaceFunction;
        }

        @NotNull
        public String getTemplate() {
            String string = this.myTemplate;
            if (string == null) {
                PhpDeprecationTemplateVariable.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "template";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpDeprecationTemplateVariable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecationInfoBasedQuickFixProvider$PhpDeprecationTemplateVariable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTemplate";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

