/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDeprecatedImplodeUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDeprecatedImplodeUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunctionCall(FunctionReference reference) {
                PsiElement[] parameters = reference.getParameters();
                if (parameters.length < 2) {
                    return;
                }
                String functionFqn = PhpDeprecatedImplodeUsageInspection.getFunctionFqn(reference);
                if (functionFqn == null) {
                    return;
                }
                if (("\\implode".equalsIgnoreCase(functionFqn) || "\\join".equalsIgnoreCase(functionFqn)) && PhpDeprecatedImplodeUsageInspection.isObsoleteParametersOrder(parameters)) {
                    holder.registerProblem((PsiElement)reference, PhpBundle.message("inspection.deprecated.implode.usage", PhpLangUtil.toShortName(functionFqn)), ProblemHighlightType.LIKE_DEPRECATED, new LocalQuickFix[]{new PhpFlipArgumentsQuickFix(reference)});
                }
            }
        };
    }

    private static boolean isObsoleteParametersOrder(PsiElement[] parameters) {
        ArrayList<PsiElement> resolvedArguments = new ArrayList<PsiElement>(Arrays.asList(null, null));
        for (PsiElement parameter : parameters) {
            int index = PhpWorkaroundUtil.resolveMappedParameterIndex(parameter);
            if (index < 0 || index >= resolvedArguments.size()) continue;
            resolvedArguments.set(index, parameter);
        }
        return PhpType.isArray((PhpType)PhpDeprecatedImplodeUsageInspection.getParameterType((PsiElement)resolvedArguments.get(0))) && PhpType.STRING.equals((Object)PhpDeprecatedImplodeUsageInspection.getParameterType((PsiElement)resolvedArguments.get(1)));
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static PhpType getParameterType(@Nullable PsiElement parameter) {
        if (parameter == null) {
            return PhpType.EMPTY;
        }
        return new PhpType().add(parameter).global(parameter.getProject()).filterUnknown();
    }

    private static String getFunctionFqn(FunctionReference reference) {
        Set fqns = (Set)StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).map(PhpNamedElement::getFQN).collect(Collectors.toSet());
        return (String)ContainerUtil.getOnlyItem((Collection)fqns);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDeprecatedImplodeUsageInspection", "buildVisitor"));
    }

    private static final class PhpFlipArgumentsQuickFix
    extends LocalQuickFixOnPsiElement {
        private PhpFlipArgumentsQuickFix(FunctionReference functionReference) {
            super((PsiElement)functionReference);
        }

        @NotNull
        public String getText() {
            Pair<PsiElement, PsiElement> argumentsToFlip = this.getArgumentsToFlip();
            if (argumentsToFlip == null) {
                String string = this.getFamilyName();
                if (string == null) {
                    PhpFlipArgumentsQuickFix.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = PhpBundle.message("intention.name.flip", ((PsiElement)argumentsToFlip.first).getText(), ((PsiElement)argumentsToFlip.second).getText());
            if (string == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        private Pair<PsiElement, PsiElement> getArgumentsToFlip() {
            FunctionReference reference = (FunctionReference)ObjectUtils.tryCast((Object)this.myStartElement.getElement(), FunctionReference.class);
            if (reference == null) {
                return null;
            }
            PsiElement[] parameters = reference.getParameters();
            if (parameters.length < 2) {
                return null;
            }
            return Pair.create((Object)parameters[0], (Object)parameters[1]);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Pair<PsiElement, PsiElement> argumentsToFlip;
            if (project == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(5);
            }
            if ((argumentsToFlip = this.getArgumentsToFlip()) == null) {
                return;
            }
            PsiElement tmp = ((PsiElement)argumentsToFlip.first).copy();
            ((PsiElement)argumentsToFlip.first).replace((PsiElement)argumentsToFlip.second);
            ((PsiElement)argumentsToFlip.second).replace(tmp);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("php.flip.arguments.quick.fix.family.name", new Object[0]);
            if (string == null) {
                PhpFlipArgumentsQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDeprecatedImplodeUsageInspection$PhpFlipArgumentsQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDeprecatedImplodeUsageInspection$PhpFlipArgumentsQuickFix";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

