/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.impl.PhpDefineImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpNamedElementImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpDefineCanBeReplacedWithConstInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpDefineCanBeReplacedWithConstInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpConstant(Constant constant) {
                if (constant instanceof PhpDefineImpl) {
                    PsiElement[] parameters = ((PhpDefineImpl)constant).getParameters();
                    if (parameters.length != 2) {
                        return;
                    }
                    if (!PhpCodeValidationUtil.isAllowedAsConstantValue(parameters[1])) {
                        return;
                    }
                    PsiElement parent = constant.getParent();
                    if (!(parent instanceof Statement) || parent.getChildren().length != 1 || PhpAnnotatorVisitor.notAllowedConstantDeclarationPlace(constant)) {
                        return;
                    }
                    if (PhpLangUtil.equalsNamespaceNames(PhpNamedElementImpl.getNamespace((PsiElement)constant), constant.getNamespaceName())) {
                        holder.registerProblem((PsiElement)constant, PhpBundle.message("inspection.message.can.be.replaced.with.const.syntax", new Object[0]), new LocalQuickFix[]{PhpReplaceDefineWithConstSyntaxQuickFix.INSTANCE});
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpDefineCanBeReplacedWithConstInspection", "buildVisitor"));
    }

    private static class PhpReplaceDefineWithConstSyntaxQuickFix
    implements LocalQuickFix {
        private static final LocalQuickFix INSTANCE = new PhpReplaceDefineWithConstSyntaxQuickFix();

        private PhpReplaceDefineWithConstSyntaxQuickFix() {
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.const.syntax", new Object[0]);
            if (string == null) {
                PhpReplaceDefineWithConstSyntaxQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceDefineWithConstSyntaxQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceDefineWithConstSyntaxQuickFix.$$$reportNull$$$0(2);
            }
            PhpDefineImpl define = (PhpDefineImpl)descriptor.getStartElement();
            PsiElement value = define.getParameters()[1];
            PhpPsiElement constants = PhpPsiElementFactory.createPhpPsiFromText(project, PhpElementTypes.CONSTANTS, String.format("const %s = %s;", define.getName(), value.getText()));
            define.getParent().replace((PsiElement)constants);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpDefineCanBeReplacedWithConstInspection$PhpReplaceDefineWithConstSyntaxQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpDefineCanBeReplacedWithConstInspection$PhpReplaceDefineWithConstSyntaxQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

