/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpCurlyBraceAccessSyntaxUsageInspection
extends PhpInspection {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, final boolean isOnTheFly) {
        if (holder == null) {
            PhpCurlyBraceAccessSyntaxUsageInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpArrayIndex(ArrayIndex arrayIndex) {
                PsiElement leftBrace = PhpCurlyBraceAccessSyntaxUsageInspection.getLeftBrace(arrayIndex);
                PsiElement rightBrace = PhpCurlyBraceAccessSyntaxUsageInspection.getRightBrace(arrayIndex);
                if (PhpPsiUtil.isOfType(leftBrace, PhpTokenTypes.chLBRACE) && PhpPsiUtil.isOfType(rightBrace, PhpTokenTypes.chRBRACE)) {
                    ProblemDescriptor descriptor = InspectionManager.getInstance((Project)arrayIndex.getProject()).createProblemDescriptor(leftBrace, rightBrace, PhpCurlyBraceAccessSyntaxUsageInspection.getMessage(), ProblemHighlightType.LIKE_DEPRECATED, isOnTheFly, new LocalQuickFix[]{PhpReplaceCurlyBracesWithBracketsQuickFix.INSTANCE});
                    holder.registerProblem(descriptor);
                }
            }
        };
    }

    @Override
    @Nullable
    protected PhpLanguageLevel getMinimumSupportedLanguageLevel() {
        return PhpLanguageLevel.PHP740;
    }

    private static PsiElement getRightBrace(ArrayIndex arrayIndex) {
        return PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)arrayIndex, true);
    }

    private static PsiElement getLeftBrace(ArrayIndex arrayIndex) {
        return PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)arrayIndex, true);
    }

    @Nls
    private static String getMessage() {
        return PhpBundle.message("inspection.curly.braces.access.syntax.usage", new Object[0]);
    }

    @Nls
    public static String getFixName() {
        return PhpBundle.message("quickfix.replace.curly.braces.with.brackets", new Object[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpCurlyBraceAccessSyntaxUsageInspection", "buildVisitor"));
    }

    private static class PhpReplaceCurlyBracesWithBracketsQuickFix
    implements LocalQuickFix {
        static final LocalQuickFix INSTANCE = new PhpReplaceCurlyBracesWithBracketsQuickFix();

        private PhpReplaceCurlyBracesWithBracketsQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpCurlyBraceAccessSyntaxUsageInspection.getFixName();
            if (string == null) {
                PhpReplaceCurlyBracesWithBracketsQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                PhpReplaceCurlyBracesWithBracketsQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpReplaceCurlyBracesWithBracketsQuickFix.$$$reportNull$$$0(2);
            }
            ArrayIndex arrayIndexWithBrackets = PhpPsiElementFactory.createPhpPsiFromText(project, ArrayIndex.class, "$a[1];");
            descriptor.getStartElement().replace(arrayIndexWithBrackets.getPrevSibling());
            descriptor.getEndElement().replace(arrayIndexWithBrackets.getNextSibling());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpCurlyBraceAccessSyntaxUsageInspection$PhpReplaceCurlyBracesWithBracketsQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpCurlyBraceAccessSyntaxUsageInspection$PhpReplaceCurlyBracesWithBracketsQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

