/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PhpConcatenationWithArithmeticInspection
extends PhpInspection {
    @NotNull
    private static final TokenSet RIGHT_DEPRECATED = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opPLUS, PhpTokenTypes.opMINUS, PhpTokenTypes.opSHIFT_LEFT, PhpTokenTypes.opSHIFT_RIGHT});
    @NotNull
    private static final TokenSet LEFT_DEPRECATED = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opSHIFT_LEFT, PhpTokenTypes.opSHIFT_RIGHT});

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpConcatenationWithArithmeticInspection.$$$reportNull$$$0(0);
        }
        if (PhpLanguageLevel.current(holder.getProject()).isAtLeast(PhpLanguageLevel.PHP800)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                PhpConcatenationWithArithmeticInspection.$$$reportNull$$$0(1);
            }
            return psiElementVisitor;
        }
        return new PhpElementVisitor(){

            public void visitPhpBinaryExpression(BinaryExpression expression) {
                if (expression.getOperationType() == PhpTokenTypes.opCONCAT) {
                    PsiElement left = expression.getLeftOperand();
                    PsiElement right = expression.getRightOperand();
                    if (left instanceof BinaryExpression && LEFT_DEPRECATED.contains(((BinaryExpression)left).getOperationType())) {
                        this.registerProblem(expression, (BinaryExpression)left);
                    } else if (right instanceof BinaryExpression && RIGHT_DEPRECATED.contains(((BinaryExpression)right).getOperationType())) {
                        this.registerProblem(expression, (BinaryExpression)right);
                    }
                }
            }

            private void registerProblem(BinaryExpression expression, BinaryExpression operand) {
                PsiElement operandOperation = operand.getOperation();
                if (operandOperation != null) {
                    LocalQuickFix[] fixes = new LocalQuickFix[]{new PhpWrapWithParenthesesQuickFix((PsiElement)expression, true), new PhpWrapWithParenthesesQuickFix((PsiElement)expression, false)};
                    holder.registerProblem((PsiElement)expression, PhpBundle.message("inspection.message.behavior.unparenthesized.expressions.containing.both.will.change.in.php", operandOperation.getText()), fixes);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpWrapWithParenthesesQuickFix
    extends LocalQuickFixOnPsiElement {
        private final boolean myWrapCorrectlyParsedOperand;

        protected PhpWrapWithParenthesesQuickFix(@NotNull PsiElement element, boolean wrapCorrectlyParsedOperand) {
            if (element == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(0);
            }
            super(element);
            this.myWrapCorrectlyParsedOperand = wrapCorrectlyParsedOperand;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String textToReplace = this.getTextToReplace();
            String string = textToReplace != null ? PhpBundle.message("intention.family.name.replace.with", textToReplace) : this.getFamilyName();
            if (string == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        private String getTextToReplace() {
            BinaryExpression expr = (BinaryExpression)ObjectUtils.tryCast((Object)this.getStartElement(), BinaryExpression.class);
            if (expr == null) {
                return null;
            }
            PsiElement left = expr.getLeftOperand();
            PsiElement right = expr.getRightOperand();
            PsiElement operation = expr.getOperation();
            if (left == null || right == null || operation == null) {
                return null;
            }
            if (this.myWrapCorrectlyParsedOperand) {
                if (left instanceof BinaryExpression) {
                    return String.format("(%s) %s %s", left.getText(), operation.getText(), right.getText());
                }
                return String.format("%s %s (%s)", left.getText(), operation.getText(), right.getText());
            }
            if (left instanceof BinaryExpression) {
                PsiElement leftLeft = ((BinaryExpression)left).getLeftOperand();
                PsiElement leftRight = ((BinaryExpression)left).getRightOperand();
                PsiElement leftOperation = ((BinaryExpression)left).getOperation();
                if (leftOperation != null && leftLeft != null && leftRight != null) {
                    return String.format("%s %s (%s %s %s)", leftLeft.getText(), leftOperation.getText(), leftRight.getText(), operation.getText(), right.getText());
                }
            } else if (right instanceof BinaryExpression) {
                PsiElement rightLeft = ((BinaryExpression)right).getLeftOperand();
                PsiElement rightRight = ((BinaryExpression)right).getRightOperand();
                PsiElement rightOperation = ((BinaryExpression)right).getOperation();
                if (rightOperation != null && rightLeft != null && rightRight != null) {
                    return String.format("(%s %s %s) %s %s", left.getText(), operation.getText(), rightLeft.getText(), rightOperation.getText(), rightRight.getText());
                }
            }
            return null;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            String textToReplace;
            if (project == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(5);
            }
            if ((textToReplace = this.getTextToReplace()) == null) {
                return;
            }
            startElement.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, textToReplace));
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = this.myWrapCorrectlyParsedOperand ? PhpBundle.message("intention.name.wrap.left.operand.in.parentheses", new Object[0]) : PhpBundle.message("intention.name.wrap.right.operand.in.parentheses", new Object[0]);
            if (string == null) {
                PhpWrapWithParenthesesQuickFix.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection$PhpWrapWithParenthesesQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpConcatenationWithArithmeticInspection$PhpWrapWithParenthesesQuickFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 6: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

