/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpClosureCanBeConvertedToShortArrowFunctionInspection
extends PhpInspection {
    @Nls
    public static final String FIX_NAME = PhpBundle.message("convert.closure.to.arrow.function", new Object[0]);

    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PhpClosureCanBeConvertedToShortArrowFunctionInspection.$$$reportNull$$$0(0);
        }
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function closure) {
                if (!PhpLanguageFeature.ARROW_FUNCTION_SYNTAX.isSupported(closure.getProject())) {
                    return;
                }
                if (!closure.isClosure() || FunctionImpl.isShortArrowFunction(closure)) {
                    return;
                }
                GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)closure, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
                if (body == null) {
                    return;
                }
                if (!(body.getOnlyStatement() instanceof PhpReturn)) {
                    return;
                }
                if (PhpClosureCanBeConvertedToShortArrowFunctionInspection.useByReferenceExists(closure)) {
                    return;
                }
                holder.registerProblem((PsiElement)closure, PhpBundle.message("inspection.closure.can.be.converted.to.arrow.function", new Object[0]), new LocalQuickFix[]{PhpConvertClosureToArrowFunctionQuickFix.INSTANCE});
            }
        };
    }

    private static boolean useByReferenceExists(Function closure) {
        PhpUseList useList = (PhpUseList)PhpPsiUtil.getChildByCondition((PsiElement)closure, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
        if (useList == null) {
            return false;
        }
        return Arrays.stream(useList.getChildren()).anyMatch(r -> PhpPsiUtil.isOfType(r.getPrevSibling(), PhpTokenTypes.opBIT_AND));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection", "buildVisitor"));
    }

    private static class PhpConvertClosureToArrowFunctionQuickFix
    implements LocalQuickFix {
        private static final PhpConvertClosureToArrowFunctionQuickFix INSTANCE = new PhpConvertClosureToArrowFunctionQuickFix();

        private PhpConvertClosureToArrowFunctionQuickFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = FIX_NAME;
            if (string == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            Function function;
            if (project == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(2);
            }
            if ((function = (Function)ObjectUtils.tryCast((Object)descriptor.getStartElement(), Function.class)) == null) {
                return;
            }
            GroupStatement body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
            if (body == null) {
                return;
            }
            PsiElement returnArgument = PhpConvertClosureToArrowFunctionQuickFix.copyReturnArgumentWithoutSemicolon(body);
            if (returnArgument == null) {
                return;
            }
            PhpConvertClosureToArrowFunctionQuickFix.doReplace(project, function, body, returnArgument);
        }

        private static void doReplace(@NotNull Project project, Function function, GroupStatement body, PsiElement returnArgument) {
            ASTNode functionKeyword;
            if (project == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(3);
            }
            if ((functionKeyword = function.getNode().findChildByType(PhpTokenTypes.kwFUNCTION)) == null) {
                return;
            }
            PhpConvertClosureToArrowFunctionQuickFix.restoreComments(function, body);
            functionKeyword.getPsi().replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.kwFN, "fn()"));
            PsiElement arrow = body.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opHASH_ARRAY, "fn() => 1"));
            arrow.getParent().addAfter(returnArgument, arrow);
            Object useList = PhpPsiUtil.getChildByCondition((PsiElement)function, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
            if (useList != null) {
                useList.delete();
            }
        }

        @Nullable
        private static PsiElement copyReturnArgumentWithoutSemicolon(@NotNull GroupStatement body) {
            PhpReturn onlyReturn;
            if (body == null) {
                PhpConvertClosureToArrowFunctionQuickFix.$$$reportNull$$$0(4);
            }
            if ((onlyReturn = (PhpReturn)ObjectUtils.tryCast((Object)ArrayUtil.getFirstElement((Object[])body.getStatements()), PhpReturn.class)) == null) {
                return null;
            }
            PsiElement returnArgument = onlyReturn.getArgument();
            return returnArgument != null ? returnArgument.copy() : null;
        }

        private static void restoreComments(Function function, GroupStatement body) {
            PsiElement parent = function.getParent();
            PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class).forEach(comment -> parent.addBefore(comment.copy(), (PsiElement)function));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection$PhpConvertClosureToArrowFunctionQuickFix";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/inspections/PhpClosureCanBeConvertedToShortArrowFunctionInspection$PhpConvertClosureToArrowFunctionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "doReplace";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "copyReturnArgumentWithoutSemicolon";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

