/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter.ui.predefinedStyle;

import com.intellij.lang.Language;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.ui.PhpLanguageCodeStyleSettingsProvider;
import com.jetbrains.php.refactoring.PhpNameStyle;

public class SymfonyCodeStyle
extends PhpLanguageCodeStyleSettingsProvider.PSR1PSR2CodeStyle {
    @NlsSafe
    private static final String SYMFONY_2 = "Symfony2";

    public SymfonyCodeStyle() {
        super(SYMFONY_2);
    }

    @Override
    public void apply(CodeStyleSettings settings) {
        super.apply(settings);
        CommonCodeStyleSettings commonSettings = settings.getCommonSettings((Language)PhpLanguage.INSTANCE);
        commonSettings.SPACE_AFTER_COMMA = true;
        commonSettings.SPACE_AROUND_ADDITIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_ASSIGNMENT_OPERATORS = true;
        commonSettings.SPACE_AROUND_BITWISE_OPERATORS = true;
        commonSettings.SPACE_AROUND_EQUALITY_OPERATORS = true;
        commonSettings.SPACE_AROUND_LOGICAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS = true;
        commonSettings.SPACE_AROUND_RELATIONAL_OPERATORS = true;
        commonSettings.SPACE_AROUND_SHIFT_OPERATORS = true;
        commonSettings.SPACE_AROUND_UNARY_OPERATOR = false;
        commonSettings.CALL_PARAMETERS_WRAP = 5;
        commonSettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE = true;
        commonSettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE = true;
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)settings.getCustomSettings(PhpCodeStyleSettings.class);
        phpSettings.CONCAT_SPACES = false;
        phpSettings.BLANK_LINES_BEFORE_RETURN_STATEMENT = 1;
        phpSettings.COMMA_AFTER_LAST_ARRAY_ELEMENT = true;
        phpSettings.VARIABLE_NAMING_STYLE = PhpNameStyle.Style.CAMEL_CASE;
    }
}

