/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraversal;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.PhpLanguageConstruct;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.impl.PhpYieldImpl;
import java.util.Comparator;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

final class PhpKeywordToLowerCaseFormatPreprocessor
implements PreFormatProcessor {
    private static final Map<String, PhpLanguageLevel> TYPES = CollectionFactory.createCaseInsensitiveStringMap((Map)ContainerUtil.newHashMap((Pair)Pair.create((Object)"array", (Object)((Object)PhpLanguageLevel.PHP530)), (Pair[])new Pair[]{Pair.create((Object)"callable", (Object)((Object)PhpLanguageLevel.PHP540)), Pair.create((Object)"int", (Object)((Object)PhpLanguageLevel.PHP700)), Pair.create((Object)"string", (Object)((Object)PhpLanguageLevel.PHP700)), Pair.create((Object)"float", (Object)((Object)PhpLanguageLevel.PHP700)), Pair.create((Object)"bool", (Object)((Object)PhpLanguageLevel.PHP700)), Pair.create((Object)"void", (Object)((Object)PhpLanguageLevel.PHP700)), Pair.create((Object)"iterable", (Object)((Object)PhpLanguageLevel.PHP710)), Pair.create((Object)"object", (Object)((Object)PhpLanguageLevel.PHP720)), Pair.create((Object)"false", (Object)((Object)PhpLanguageLevel.PHP800)), Pair.create((Object)"null", (Object)((Object)PhpLanguageLevel.PHP800))}));

    PhpKeywordToLowerCaseFormatPreprocessor() {
    }

    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        Document document;
        PsiElement psiElement;
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(0);
        }
        if (range == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(1);
        }
        if ((psiElement = element.getPsi()) == null || !psiElement.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(2);
            }
            return textRange;
        }
        PsiFile file = psiElement.getContainingFile();
        if (!(file instanceof PhpFile) || file.getViewProvider().getBaseLanguage() != PhpLanguage.INSTANCE || file.getContext() != null) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
        if (!phpCodeStyleSettings.LOWER_CASE_KEYWORDS) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(4);
            }
            return textRange;
        }
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)psiElement.getProject());
        Document document2 = document = file.isPhysical() ? documentManager.getDocument(file) : file.getViewProvider().getDocument();
        if (document == null) {
            TextRange textRange = range;
            if (textRange == null) {
                PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        documentManager.doPostponedOperationsAndUnblockDocument(document);
        SmartList rangesToProcess = new SmartList();
        for (PsiElement token : SyntaxTraverser.psiTraverser((PsiElement)psiElement).traverse(TreeTraversal.LEAVES_BFS)) {
            String text;
            TextRange textRange;
            if (!PhpKeywordToLowerCaseFormatPreprocessor.isApplicableKeyword(token) && !PhpKeywordToLowerCaseFormatPreprocessor.isApplicableType(token) || PhpKeywordToLowerCaseFormatPreprocessor.isInComment(token) || !range.contains(textRange = PhpKeywordToLowerCaseFormatPreprocessor.getTextRangeForToken(token)) || !StringUtil.hasUpperCaseChar((String)(text = token.getText()))) continue;
            rangesToProcess.add(textRange);
        }
        if (!rangesToProcess.isEmpty()) {
            rangesToProcess.sort(Comparator.comparingInt(TextRange::getStartOffset));
            rangesToProcess.forEach(i -> document.replaceString(i.getStartOffset(), i.getEndOffset(), (CharSequence)StringUtil.toLowerCase((String)document.getText(i))));
            documentManager.commitDocument(document);
        }
        TextRange textRange = range;
        if (textRange == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    @NotNull
    private static TextRange getTextRangeForToken(@NotNull PsiElement token) {
        LeafPsiElement from;
        if (token == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(7);
        }
        TextRange result = token.getTextRange();
        if (PhpPsiUtil.isOfType(token, PhpTokenTypes.kwYIELD) && token.getParent() instanceof PhpYield && (from = PhpYieldImpl.getFrom((PhpYield)token.getParent())) != null && token.equals(token.getParent().getFirstChild())) {
            result = TextRange.create((int)token.getTextRange().getStartOffset(), (int)from.getTextRange().getEndOffset());
        }
        TextRange textRange = result;
        if (textRange == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(8);
        }
        return textRange;
    }

    private static boolean isApplicableKeyword(@NotNull PsiElement element) {
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(9);
        }
        if (!PhpPsiUtil.isOfType(element, PhpTokenTypes.tsKEYWORDS)) {
            return false;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof PhpReference && !(parent instanceof PhpLanguageConstruct)) {
            return !element.getNode().equals(((PhpReference)parent).getNameNode());
        }
        if (parent instanceof PhpNamedElement) {
            return !element.getNode().equals(((PhpNamedElement)parent).getNameNode());
        }
        return true;
    }

    private static boolean isApplicableType(@NotNull PsiElement element) {
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(10);
        }
        if (PhpPsiUtil.isOfType(element, PhpTokenTypes.tsCAST_OPS)) {
            return true;
        }
        if (PhpPsiUtil.isOfType(element, TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.IDENTIFIER, PhpTokenTypes.kwARRAY, PhpTokenTypes.kwCALLABLE}))) {
            ClassReference parent = (ClassReference)ObjectUtils.tryCast((Object)element.getParent(), ClassReference.class);
            if (parent == null) {
                return false;
            }
            PhpLanguageLevel currentLanguageLevel = PhpProjectConfigurationFacade.getInstance(element.getProject()).getLanguageLevel();
            PhpLanguageLevel requiredLanguageLevel = TYPES.get(element.getText());
            if (requiredLanguageLevel == null || !currentLanguageLevel.isAtLeast(requiredLanguageLevel)) {
                return false;
            }
            return parent.getParent() instanceof PhpTypeDeclaration;
        }
        return false;
    }

    private static boolean isInComment(@NotNull PsiElement element) {
        if (element == null) {
            PhpKeywordToLowerCaseFormatPreprocessor.$$$reportNull$$$0(11);
        }
        return PhpPsiUtil.getParentByCondition(element, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpKeywordToLowerCaseFormatPreprocessor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "token";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpKeywordToLowerCaseFormatPreprocessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "process";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRangeForToken";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getTextRangeForToken";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableKeyword";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isApplicableType";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isInComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

