/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.formatter.PhpFormatterUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.stubs.PhpFileElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class PhpIndentProcessor
extends PhpFormatterUtil {
    private final ASTNode myNode;
    private final CommonCodeStyleSettings mySettings;
    private final PhpCodeStyleSettings myPhpSettings;
    private final int myIndentSize;
    private final FormattingMode myFormattingMode;

    PhpIndentProcessor(ASTNode node, CommonCodeStyleSettings settings, PhpCodeStyleSettings phpSettings, int indentSize) {
        this.myNode = node;
        this.mySettings = settings;
        this.myPhpSettings = phpSettings;
        this.myIndentSize = indentSize;
        this.myFormattingMode = PhpIndentProcessor.getFormattingMode(node);
    }

    private static FormattingMode getFormattingMode(@NotNull ASTNode node) {
        Project project;
        PsiElement psi;
        if (node == null) {
            PhpIndentProcessor.$$$reportNull$$$0(0);
        }
        if ((psi = node.getPsi()).isValid() && !(project = psi.getProject()).isDisposed()) {
            return CodeStyleManager.getCurrentFormattingMode((Project)project);
        }
        return FormattingMode.REFORMAT;
    }

    @NotNull
    Indent getChildIndent(@NotNull ASTNode child) {
        ASTNode firstChild;
        ASTNode prevNode;
        Indent openTagIndent;
        IElementType parentType;
        if (child == null) {
            PhpIndentProcessor.$$$reportNull$$$0(1);
        }
        IElementType myType = child.getElementType();
        ASTNode parent = child.getTreeParent();
        IElementType iElementType = parentType = parent != null ? parent.getElementType() : null;
        if (parentType == PhpFileElementType.FILE) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(2);
            }
            return indent;
        }
        if (child.getPsi().getLanguage() != this.myNode.getPsi().getLanguage()) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(3);
            }
            return indent;
        }
        if (myType == PhpTokenTypes.PHP_OPENING_TAG && parentType != PhpElementTypes.NON_LAZY_GROUP_STATEMENT && (openTagIndent = this.getOpenTagIndentFromAttachedNode(child)) != null) {
            Indent indent = openTagIndent;
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(4);
            }
            return indent;
        }
        if (myType == PhpTokenTypes.LINE_COMMENT && (prevNode = child.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace && prevNode.getText().endsWith("\n") && this.mySettings.KEEP_FIRST_COLUMN_COMMENT) {
            Indent indent = Indent.getAbsoluteNoneIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(5);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.NON_LAZY_GROUP_STATEMENT && myType != PhpTokenTypes.PHP_OPENING_TAG && myType != PhpTokenTypes.PHP_ECHO_OPENING_TAG && myType != PhpTokenTypes.PHP_CLOSING_TAG && this.myPhpSettings.INDENT_CODE_IN_PHP_TAGS && (parent.getTreeParent().getElementType() != PhpStubElementTypes.NAMESPACE || PhpIndentProcessor.isBracedNamespace(parent.getTreeParent()))) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(6);
            }
            return indent;
        }
        if (myType == PhpTokenTypes.PHP_OPENING_TAG) {
            if (parentType == PhpElementTypes.NON_LAZY_GROUP_STATEMENT) {
                ASTNode parentTreeParent = parent.getTreeParent();
                Indent indent = parentTreeParent instanceof FileElement || child.getTreeNext() == null ? Indent.getNoneIndent() : Indent.getNormalIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(7);
                }
                return indent;
            }
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(8);
            }
            return indent;
        }
        if (parentType == PhpStubElementTypes.NAMESPACE) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(9);
            }
            return indent;
        }
        if (parentType == PhpStubElementTypes.CLASS_FIELD || parentType == PhpStubElementTypes.CLASS_CONST) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(10);
            }
            return indent;
        }
        if (myType == PhpElementTypes.ELSE || myType == PhpElementTypes.ELSE_IF || parentType == PhpElementTypes.DO_WHILE && myType == PhpTokenTypes.kwWHILE) {
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(11);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.DO_WHILE && !ANY_GROUP_STATEMENT.contains(myType)) {
            if (myType == PhpTokenTypes.kwWHILE || myType == PhpTokenTypes.kwDO || myType == PhpTokenTypes.chLPAREN || myType == PhpTokenTypes.chRPAREN || myType == PhpTokenTypes.opSEMICOLON) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(12);
                }
                return indent;
            }
            if (PhpIndentProcessor.isAfter(child, PhpTokenTypes.kwWHILE)) {
                Indent indent = Indent.getContinuationIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(13);
                }
                return indent;
            }
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(14);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.SWITCH || parentType == PhpElementTypes.MATCH_EXPRESSION) {
            if (myType == PhpElementTypes.CASE || myType == PhpElementTypes.CASE_DEFAULT || myType == MATCH_ARM || myType == DEFAULT_MATCH_ARM) {
                if (myType == MATCH_ARM || myType == DEFAULT_MATCH_ARM || this.mySettings.INDENT_CASE_FROM_SWITCH) {
                    Indent indent = Indent.getNormalIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(15);
                    }
                    return indent;
                }
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(16);
                }
                return indent;
            }
            if (myType == PhpTokenTypes.chLBRACE || myType == PhpTokenTypes.chRBRACE) {
                Indent indent = this.mySettings.BRACE_STYLE == 3 || this.mySettings.BRACE_STYLE == 4 ? Indent.getNormalIndent() : Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(17);
                }
                return indent;
            }
        }
        if (myType == PhpElementTypes.PARAMETER_LIST) {
            Indent indent = this.myFormattingMode.equals((Object)FormattingMode.ADJUST_INDENT_ON_ENTER) && PhpIndentProcessor.onNewLine(child) ? Indent.getContinuationIndent() : Indent.getNoneIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(18);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.PARAMETER_LIST) {
            boolean shouldEnforceIndent = false;
            if (PhpElementTypes.BINARY_EXPRESSIONS.contains(myType) || (PhpElementTypes.FUNCTION_CALL == myType || PhpElementTypes.NEW_EXPRESSION == myType || PhpElementTypes.ARRAY_CREATION_EXPRESSION == myType) && !PhpIndentProcessor.isInlineParameter(parent, child)) {
                shouldEnforceIndent = true;
            }
            Indent indent = this.myFormattingMode.equals((Object)FormattingMode.ADJUST_INDENT_ON_ENTER) && PhpIndentProcessor.onNewLine(parent) ? Indent.getNoneIndent() : Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)shouldEnforceIndent);
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(19);
            }
            return indent;
        }
        if (PhpFormatterUtil.belongsToBody(child)) {
            ASTNode grandParent;
            IElementType statementType = parentType;
            ASTNode statementNode = parent;
            if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentType)) {
                ASTNode aSTNode = grandParent = parent != null ? parent.getTreeParent() : null;
                if (grandParent != null) {
                    statementType = grandParent.getElementType();
                    statementNode = grandParent;
                }
                if (myType == PhpElementTypes.GROUP_STATEMENT && (statementType != PhpStubElementTypes.NAMESPACE || ((PhpNamespace)statementNode.getPsi()).isBraced()) && !PhpIndentProcessor.isCaseBlock(statementType)) {
                    Indent indent = PhpPsiUtil.isOfType(statementNode, (IElementType)PhpFileElementType.FILE) ? Indent.getNoneIndent() : Indent.getNormalIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(20);
                    }
                    return indent;
                }
            }
            if (statementType == PhpStubElementTypes.NAMESPACE) {
                if (PhpIndentProcessor.isBracedNamespace(parent)) {
                    return this.getInternalIndent(child, parent, this.myPhpSettings.NAMESPACE_BRACE_STYLE);
                }
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(21);
                }
                return indent;
            }
            if (statementType == PhpStubElementTypes.CLASS) {
                if (!((PhpClass)statementNode.getPsi()).isAnonymous()) {
                    if (this.mySettings.CLASS_BRACE_STYLE == 3) {
                        Indent indent = Indent.getNormalIndent();
                        if (indent == null) {
                            PhpIndentProcessor.$$$reportNull$$$0(22);
                        }
                        return indent;
                    }
                    if (this.mySettings.CLASS_BRACE_STYLE == 4) {
                        if (myType == PhpTokenTypes.chLBRACE || myType == PhpTokenTypes.chRBRACE) {
                            Indent indent = Indent.getNormalIndent();
                            if (indent == null) {
                                PhpIndentProcessor.$$$reportNull$$$0(23);
                            }
                            return indent;
                        }
                        Indent indent = Indent.getSpaceIndent((int)(this.myIndentSize * 2));
                        if (indent == null) {
                            PhpIndentProcessor.$$$reportNull$$$0(24);
                        }
                        return indent;
                    }
                } else {
                    if (this.myPhpSettings.ANONYMOUS_BRACE_STYLE == 3) {
                        Indent indent = Indent.getNormalIndent();
                        if (indent == null) {
                            PhpIndentProcessor.$$$reportNull$$$0(25);
                        }
                        return indent;
                    }
                    if (this.myPhpSettings.ANONYMOUS_BRACE_STYLE == 4) {
                        if (myType == PhpTokenTypes.chLBRACE || myType == PhpTokenTypes.chRBRACE) {
                            Indent indent = Indent.getNormalIndent();
                            if (indent == null) {
                                PhpIndentProcessor.$$$reportNull$$$0(26);
                            }
                            return indent;
                        }
                        Indent indent = Indent.getSpaceIndent((int)(this.myIndentSize * 2));
                        if (indent == null) {
                            PhpIndentProcessor.$$$reportNull$$$0(27);
                        }
                        return indent;
                    }
                }
                return this.getInternalIndent(child, parent, this.mySettings.CLASS_BRACE_STYLE);
            }
            if (statementType == PhpStubElementTypes.FUNCTION || statementType == PhpStubElementTypes.CLASS_METHOD) {
                if (myType == PhpElementTypes.USE_LIST) {
                    Indent indent = Indent.getNoneIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(28);
                    }
                    return indent;
                }
                ASTNode aSTNode = grandParent = statementNode != null ? statementNode.getTreeParent() : null;
                if (grandParent != null && grandParent.getElementType() == PhpElementTypes.CLOSURE) {
                    return this.getInternalIndent(child, parent, this.mySettings.LAMBDA_BRACE_STYLE);
                }
                return this.getInternalIndent(child, parent, this.mySettings.METHOD_BRACE_STYLE);
            }
            if (PhpFormatterUtil.isControlStatement(statementType) || PhpElementTypes.ANY_GROUP_STATEMENT.contains(statementType)) {
                if (PhpFormatterUtil.isAltSyntaxEndKeyword(myType)) {
                    Indent indent = Indent.getNoneIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(29);
                    }
                    return indent;
                }
                if (PhpIndentProcessor.isCaseBlock(statementType) && child.getElementType() == GROUP_STATEMENT) {
                    if (parent.getChildren(TokenSet.andNot((TokenSet)TokenSet.ANY, (TokenSet)TokenSet.EMPTY)).length == 1) {
                        Indent indent = Indent.getNoneIndent();
                        if (indent == null) {
                            PhpIndentProcessor.$$$reportNull$$$0(30);
                        }
                        return indent;
                    }
                    Indent indent = Indent.getNormalIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(31);
                    }
                    return indent;
                }
                return this.getInternalIndent(child, parent, this.mySettings.BRACE_STYLE);
            }
            if (statementType == PhpElementTypes.DECLARE) {
                return this.getInternalIndent(child, parent, this.mySettings.BRACE_STYLE);
            }
        }
        if (parentType == PhpElementTypes.ISSET_EXPRESSION || parentType == PhpElementTypes.UNSET) {
            if (myType == PhpTokenTypes.chLPAREN || myType == PhpTokenTypes.chRPAREN || myType == PhpTokenTypes.kwISSET || myType == PhpTokenTypes.kwUNSET) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(32);
                }
                return indent;
            }
            Indent indent = Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(33);
            }
            return indent;
        }
        if (myType == PhpDocTokenTypes.DOC_LEADING_ASTERISK || myType == PhpDocTokenTypes.DOC_COMMENT_END) {
            Indent indent = Indent.getSpaceIndent((int)1);
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(34);
            }
            return indent;
        }
        if (child.getTreePrev() != null) {
            if (parentType == PhpElementTypes.FUNCTION_CALL || parentType == PhpElementTypes.NEW_EXPRESSION) {
                if (myType == PhpTokenTypes.IDENTIFIER) {
                    Indent indent = Indent.getContinuationIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(35);
                    }
                    return indent;
                }
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(36);
                }
                return indent;
            }
            if (parentType == PhpElementTypes.METHOD_REFERENCE || parentType == PhpElementTypes.FIELD_REFERENCE) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(37);
                }
                return indent;
            }
            if (parentType == PhpElementTypes.RETURN) {
                boolean shouldEnforceIndent = PhpElementTypes.BINARY_EXPRESSIONS.contains(myType);
                Indent indent = Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)shouldEnforceIndent);
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(38);
                }
                return indent;
            }
            if (parentType == PhpElementTypes.EXPRESSION) {
                Indent indent = Indent.getContinuationIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(39);
                }
                return indent;
            }
            if (PhpElementTypes.BINARY_EXPRESSIONS.contains(parentType)) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(40);
                }
                return indent;
            }
            if (PhpElementTypes.BINARY_EXPRESSIONS.contains(myType) && parentType != PhpElementTypes.FOR && parentType != PhpElementTypes.FOREACH) {
                Indent indent = Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(41);
                }
                return indent;
            }
            if (parentType == PhpElementTypes.PRINT_EXPRESSION) {
                Indent indent = Indent.getContinuationIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(42);
                }
                return indent;
            }
            if (PhpFormatterUtil.isAssignment(parentType)) {
                if (PhpFormatterUtil.isAssignment(myType)) {
                    Indent indent = Indent.getNoneIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(43);
                    }
                    return indent;
                }
                Indent indent = Indent.getContinuationWithoutFirstIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(44);
                }
                return indent;
            }
            if (parentType == PhpElementTypes.HASH_ARRAY_ELEMENT) {
                Indent indent = PhpIndentProcessor.getHashArrayElementIndentation(child);
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(45);
                }
                return indent;
            }
        }
        if (PhpElementTypes.tsARRAY_EXPRESSIONS.contains(parentType) && (myType == PhpElementTypes.ARRAY_KEY || myType == PhpElementTypes.HASH_ARRAY_ELEMENT || myType == PhpElementTypes.ARRAY_VALUE)) {
            firstChild = child.getFirstChildNode();
            if (firstChild != null && PhpElementTypes.BINARY_EXPRESSIONS.contains(firstChild.getElementType())) {
                Indent indent = Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(46);
                }
                return indent;
            }
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(47);
            }
            return indent;
        }
        if (PhpElementTypes.ATTRIBUTES_LIST == parentType && myType == PhpStubElementTypes.ATTRIBUTE) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(48);
            }
            return indent;
        }
        if ((parentType == PhpElementTypes.FOR || parentType == PhpElementTypes.FOREACH) && PhpFormatterUtil.isAlignable(myType)) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(49);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.IMPLEMENTS_LIST || parentType == PhpElementTypes.EXTENDS_LIST) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(50);
            }
            return indent;
        }
        if (PhpIndentProcessor.isComment(myType) && !PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentType) && !PhpFormatterUtil.isPrecededBy(child, PhpElementTypes.ATTRIBUTES_LIST)) {
            IElementType nextType;
            ASTNode nextNonComment = PhpIndentProcessor.findNextNonCommentSibling(child);
            if (nextNonComment != null && ((nextType = nextNonComment.getElementType()) == PhpElementTypes.ELSE || nextType == PhpElementTypes.ELSE_IF)) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(51);
                }
                return indent;
            }
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(52);
            }
            return indent;
        }
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(myType)) {
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(53);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.TERNARY_EXPRESSION && PhpFormatterUtil.isNodeAtOrAfter(child, PhpTokenTypes.opQUEST)) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(54);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.GLOBAL) {
            Indent indent = Indent.getIndent((Indent.Type)Indent.Type.NONE, (int)0, (boolean)true, (boolean)false);
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(55);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.USE_LIST) {
            ASTNode superParent;
            ASTNode aSTNode = superParent = parent != null ? parent.getTreeParent() : null;
            if (superParent != null && superParent.getElementType() == PhpStubElementTypes.FUNCTION) {
                if (myType != PhpTokenTypes.chLPAREN && myType != PhpTokenTypes.chRPAREN && myType != PhpTokenTypes.kwUSE) {
                    Indent indent = Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(56);
                    }
                    return indent;
                }
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(57);
                }
                return indent;
            }
            if (myType == PhpTokenTypes.kwUSE || myType == PhpStubElementTypes.USE) {
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(58);
                }
                return indent;
            }
            if (myType == PhpTokenTypes.chRBRACE || myType == PhpTokenTypes.chLBRACE) {
                if (this.mySettings.BRACE_STYLE == 3 || this.mySettings.BRACE_STYLE == 4) {
                    Indent indent = Indent.getNormalIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(59);
                    }
                    return indent;
                }
                Indent indent = Indent.getNoneIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(60);
                }
                return indent;
            }
            if (this.mySettings.BRACE_STYLE == 4) {
                Indent indent = Indent.getSpaceIndent((int)(this.mySettings.getIndentOptions().INDENT_SIZE * 2));
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(61);
                }
                return indent;
            }
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(62);
            }
            return indent;
        }
        if (parentType == PhpStubElementTypes.USE) {
            Indent indent = Indent.getContinuationIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(63);
            }
            return indent;
        }
        if (parentType == PhpElementTypes.ARRAY_CREATION_EXPRESSION) {
            ASTNode aSTNode = firstChild = parent != null ? parent.getFirstChildNode() : null;
            if (firstChild != null && firstChild.getElementType() == PhpTokenTypes.chLBRACKET && child != firstChild && child.getElementType() != PhpTokenTypes.chRBRACKET) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(64);
                }
                return indent;
            }
            if (this.myFormattingMode.equals((Object)FormattingMode.ADJUST_INDENT_ON_ENTER) && (myType == PhpTokenTypes.chRPAREN || myType == PhpTokenTypes.chRBRACKET)) {
                ASTNode prev = child.getTreePrev();
                if (prev instanceof PsiWhiteSpace) {
                    prev = prev.getTreePrev();
                }
                if (prev != null && prev.getElementType() == PhpTokenTypes.opCOMMA) {
                    Indent indent = Indent.getContinuationIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(65);
                    }
                    return indent;
                }
            }
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            PhpIndentProcessor.$$$reportNull$$$0(66);
        }
        return indent;
    }

    private static boolean onNewLine(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        ASTNode prev = node.getTreePrev();
        if (!(prev instanceof PsiWhiteSpace)) {
            return false;
        }
        return prev.textContains('\n');
    }

    @NotNull
    private Indent getInternalIndent(@NotNull ASTNode child, @Nullable ASTNode parent, int braceStyle) {
        IElementType childType;
        if (child == null) {
            PhpIndentProcessor.$$$reportNull$$$0(67);
        }
        if (ANY_GROUP_STATEMENT.contains(childType = child.getElementType())) {
            if (braceStyle == 3 || braceStyle == 4) {
                Indent indent = Indent.getNormalIndent();
                if (indent == null) {
                    PhpIndentProcessor.$$$reportNull$$$0(68);
                }
                return indent;
            }
            Indent indent = Indent.getNoneIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(69);
            }
            return indent;
        }
        if (childType != PhpTokenTypes.chRBRACE && childType != PhpTokenTypes.chLBRACE && childType != PhpTokenTypes.kwDO && childType != PhpTokenTypes.kwELSE) {
            if (parent != null) {
                IElementType parentType = parent.getElementType();
                if (braceStyle == 3 && PhpElementTypes.ANY_GROUP_STATEMENT.contains(parentType)) {
                    Indent indent = Indent.getNoneIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(70);
                    }
                    return indent;
                }
                ASTNode blockParent = parent.getTreeParent();
                if (!(blockParent == null || blockParent.getElementType() != PhpElementTypes.CASE && blockParent.getElementType() != PhpElementTypes.CASE_DEFAULT || childType != PhpElementTypes.BREAK || this.mySettings.INDENT_BREAK_FROM_CASE)) {
                    Indent indent = Indent.getNoneIndent();
                    if (indent == null) {
                        PhpIndentProcessor.$$$reportNull$$$0(71);
                    }
                    return indent;
                }
            }
            Indent indent = Indent.getNormalIndent();
            if (indent == null) {
                PhpIndentProcessor.$$$reportNull$$$0(72);
            }
            return indent;
        }
        Indent indent = Indent.getNoneIndent();
        if (indent == null) {
            PhpIndentProcessor.$$$reportNull$$$0(73);
        }
        return indent;
    }

    private static boolean isBracedNamespace(ASTNode node) {
        ASTNode nsChild = node.getFirstChildNode();
        if (nsChild.getElementType() == PhpTokenTypes.kwNAMESPACE && PhpElementTypes.ANY_GROUP_STATEMENT.contains((nsChild = node.getLastChildNode()).getElementType())) {
            nsChild = nsChild.getFirstChildNode();
        }
        return nsChild != null && nsChild.getElementType() == PhpTokenTypes.chLBRACE;
    }

    @Nullable
    private static ASTNode findNextNonCommentSibling(ASTNode node) {
        for (ASTNode next = node.getTreeNext(); next != null; next = next.getTreeNext()) {
            if (next.getPsi() instanceof PsiWhiteSpace || PhpIndentProcessor.isComment(next.getElementType())) continue;
            return next;
        }
        return null;
    }

    private static Indent getHashArrayElementIndentation(@NotNull ASTNode child) {
        if (child == null) {
            PhpIndentProcessor.$$$reportNull$$$0(74);
        }
        if (child.getElementType() == PhpElementTypes.ARRAY_VALUE) {
            boolean enforceIndent = false;
            ASTNode firstSubChild = child.getFirstChildNode();
            if (firstSubChild != null && PhpElementTypes.BINARY_EXPRESSIONS.contains(firstSubChild.getElementType())) {
                enforceIndent = true;
            }
            return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)enforceIndent);
        }
        return Indent.getNoneIndent();
    }

    private static boolean isInlineParameter(@Nullable ASTNode paramListNode, @NotNull ASTNode paramNode) {
        ASTNode nextToParamList;
        if (paramNode == null) {
            PhpIndentProcessor.$$$reportNull$$$0(75);
        }
        if (paramListNode == null) {
            return false;
        }
        ASTNode prev = paramNode.getTreePrev();
        if (prev instanceof PsiWhiteSpace && prev.textContains('\n')) {
            return false;
        }
        ASTNode next = paramNode.getTreeNext();
        if (next instanceof PsiWhiteSpace && next.textContains('\n')) {
            return false;
        }
        return paramListNode.getLastChildNode() != paramNode || !((nextToParamList = paramListNode.getTreeNext()) instanceof PsiWhiteSpace) || !nextToParamList.textContains('\n');
    }

    @Nullable
    private Indent getOpenTagIndentFromAttachedNode(@NotNull ASTNode openTagNode) {
        ASTNode next;
        if (openTagNode == null) {
            PhpIndentProcessor.$$$reportNull$$$0(76);
        }
        if ((next = openTagNode.getTreeNext()) != null) {
            if (next.getPsi() instanceof PsiWhiteSpace) {
                if (next.textContains('\n')) {
                    return null;
                }
                next = next.getTreeNext();
            }
            if (next != null) {
                if (PhpIndentProcessor.isFirstCaseInSwitch(next)) {
                    return Indent.getAbsoluteNoneIndent();
                }
                return this.getChildIndent(next);
            }
        } else {
            ASTNode outerNext = PhpFormatterUtil.findOuterNextSiblingNoLineFeedsBetween(openTagNode);
            if (outerNext != null) {
                return Indent.getNoneIndent();
            }
        }
        return null;
    }

    private static boolean isFirstCaseInSwitch(@NotNull ASTNode node) {
        if (node == null) {
            PhpIndentProcessor.$$$reportNull$$$0(77);
        }
        if (node.getElementType() == PhpElementTypes.CASE || node.getElementType() == PhpElementTypes.CASE_DEFAULT) {
            for (ASTNode prev = node.getTreePrev(); prev != null; prev = prev.getTreePrev()) {
                if (prev.getElementType() != PhpElementTypes.CASE) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isRParenAfterUnfinishedParamList(@NotNull ASTNode node) {
        if (node == null) {
            PhpIndentProcessor.$$$reportNull$$$0(78);
        }
        if (node.getElementType() == PhpTokenTypes.chRPAREN) {
            ASTNode prev = node.getTreePrev();
            if (prev instanceof PsiWhiteSpace) {
                prev = prev.getTreePrev();
            }
            if (prev != null && prev.getElementType() == PhpElementTypes.PARAMETER_LIST) {
                ASTNode last = prev.getLastChildNode();
                return last != null && last.getElementType() == PhpTokenTypes.opCOMMA;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 67: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/formatter/PhpIndentProcessor";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramNode";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openTagNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpIndentProcessor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildIndent";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getInternalIndent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFormattingMode";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getChildIndent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getInternalIndent";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getHashArrayElementIndentation";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isInlineParameter";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "getOpenTagIndentFromAttachedNode";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "isFirstCaseInSwitch";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isRParenAfterUnfinishedParamList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

