/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.Statement;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFormatterUtil
implements PhpElementTypes {
    static final DependentSpacingRule LINE_BREAK_IF_NO_OTHER_LINE_BREAK = new DependentSpacingRule(DependentSpacingRule.Trigger.DOES_NOT_HAVE_LINE_FEEDS).registerData(DependentSpacingRule.Anchor.MIN_LINE_FEEDS, 1);
    private static final TokenSet CONTROL_STATEMENTS = TokenSet.create((IElementType[])new IElementType[]{IF, ELSE, ELSE_IF, DO_WHILE, SWITCH, WHILE, FOR, FOREACH, TRY, CATCH, FINALLY, CASE, CASE_DEFAULT});
    public static final TokenSet CONTROL_STATEMENTS_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwIF, PhpTokenTypes.kwELSE, PhpTokenTypes.kwELSEIF, PhpTokenTypes.kwWHILE, PhpTokenTypes.kwDO, PhpTokenTypes.kwSWITCH, PhpTokenTypes.kwCASE, PhpTokenTypes.kwDEFAULT, PhpTokenTypes.kwFOR, PhpTokenTypes.kwFOREACH, PhpTokenTypes.kwTRY, PhpTokenTypes.kwCATCH, PhpTokenTypes.kwFINALLY, CATCH, FINALLY});
    private static final TokenSet ALIGNABLE_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{SELF_ASSIGNMENT_EXPRESSION, ASSIGNMENT_EXPRESSION, POSTFIX_EXPRESSION, VARIABLE, ARRAY_CREATION_EXPRESSION, ARRAY_ACCESS_EXPRESSION, HASH_ARRAY_ELEMENT, ARRAY_VALUE, PhpTokenTypes.kwAS, NOT_PROMOTED_PARAMETER, PROMOTED_FIELD_PARAMETER, NUMBER, STRING, FUNCTION_CALL, METHOD_REFERENCE, CLASS_REFERENCE, FIELD_REFERENCE, CONSTANT_REF, CLASS_CONSTANT_REFERENCE, NEW_EXPRESSION, PhpTokenTypes.kwNEW});
    private static final TokenSet ALTSYNTAX_END_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwENDFOREACH, PhpTokenTypes.kwENDIF, PhpTokenTypes.kwENDDECLARE, PhpTokenTypes.kwENDFOR, PhpTokenTypes.kwENDSWITCH, PhpTokenTypes.kwENDWHILE});
    public static final TokenSet BINARY_OPERATORS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opAND, PhpTokenTypes.opBIT_AND, PhpTokenTypes.opBIT_OR, PhpTokenTypes.opBIT_XOR, PhpTokenTypes.opCONCAT, PhpTokenTypes.opDIV, PhpTokenTypes.opEQUAL, PhpTokenTypes.opGREATER, PhpTokenTypes.opGREATER_OR_EQUAL, PhpTokenTypes.opIDENTICAL, PhpTokenTypes.opLESS, PhpTokenTypes.opLESS_OR_EQUAL, PhpTokenTypes.opLIT_AND, PhpTokenTypes.opLIT_OR, PhpTokenTypes.opLIT_XOR, PhpTokenTypes.opMINUS, PhpTokenTypes.opMUL, PhpTokenTypes.opEXP, PhpTokenTypes.opNOT_EQUAL, PhpTokenTypes.opNOT_IDENTICAL, PhpTokenTypes.opOR, PhpTokenTypes.opPLUS, PhpTokenTypes.opREM, PhpTokenTypes.opSHIFT_LEFT, PhpTokenTypes.opSHIFT_RIGHT});
    public static final TokenSet MODIFIERS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwPRIVATE, PhpTokenTypes.kwPUBLIC, PhpTokenTypes.kwPROTECTED, PhpTokenTypes.kwSTATIC, PhpTokenTypes.kwABSTRACT});
    public static final TokenSet ARRAY_SURROUNDING_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwARRAY, PhpTokenTypes.chLPAREN, PhpTokenTypes.chLBRACKET, PhpTokenTypes.chRPAREN, PhpTokenTypes.chRBRACKET});
    public static final TokenSet BUILT_IN_FUNCTIONS = TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.EXIT_EXPRESSION, PhpElementTypes.EMPTY_EXPRESSION, PhpElementTypes.MULTIASSIGNMENT_EXPRESSION, PhpElementTypes.UNSET, PhpElementTypes.EVAL_EXPRESSION, PhpElementTypes.ISSET_EXPRESSION});

    public static boolean isAssignment(IElementType elType) {
        return ASSIGNMENTS.contains(elType);
    }

    public static boolean isControlStatement(IElementType myType) {
        return CONTROL_STATEMENTS.contains(myType);
    }

    public static boolean isAssignmentOperator(IElementType childType) {
        return PhpTokenTypes.tsASGN_OPS.contains(childType);
    }

    public static boolean isAlignable(IElementType childType) {
        return UNARY_EXPRESSIONS.contains(childType) || BINARY_EXPRESSIONS.contains(childType) || ALIGNABLE_ELEMENTS.contains(childType) || childType == TERNARY_EXPRESSION;
    }

    public static boolean isClassField(IElementType childType) {
        return childType == CLASS_FIELDS;
    }

    public static boolean isCastOperator(IElementType childType) {
        return PhpTokenTypes.CAST_OPERATORS.contains(childType);
    }

    public static boolean isLogicalOperator(IElementType childType) {
        return childType == PhpTokenTypes.opAND || childType == PhpTokenTypes.opOR;
    }

    public static boolean isEqualityOperator(IElementType childType) {
        return childType == PhpTokenTypes.opEQUAL || childType == PhpTokenTypes.opNOT_EQUAL || childType == PhpTokenTypes.opIDENTICAL || childType == PhpTokenTypes.opNOT_IDENTICAL;
    }

    public static boolean isComparisonOperator(IElementType childType) {
        return childType == PhpTokenTypes.opGREATER || childType == PhpTokenTypes.opGREATER_OR_EQUAL || childType == PhpTokenTypes.opLESS || childType == PhpTokenTypes.opLESS_OR_EQUAL;
    }

    public static boolean isBitwiseOperator(IElementType childType) {
        return childType == PhpTokenTypes.opBIT_AND || childType == PhpTokenTypes.opBIT_NOT || childType == PhpTokenTypes.opBIT_OR || childType == PhpTokenTypes.opBIT_XOR;
    }

    public static boolean isAdditiveOperator(IElementType childType) {
        return childType == PhpTokenTypes.opPLUS || childType == PhpTokenTypes.opMINUS;
    }

    public static boolean isMultiplicativeOperator(IElementType childType) {
        return childType == PhpTokenTypes.opDIV || childType == PhpTokenTypes.opMUL || childType == PhpTokenTypes.opEXP || childType == PhpTokenTypes.opREM;
    }

    public static boolean isShiftOperator(IElementType childType) {
        return childType == PhpTokenTypes.opSHIFT_LEFT || childType == PhpTokenTypes.opSHIFT_RIGHT;
    }

    public static boolean someStatementLevel(IElementType child1Type) {
        return STATEMENTS.contains(child1Type) || child1Type == FUNCTION;
    }

    public static boolean isClassMemberMember(IElementType child1Type) {
        return child1Type == CLASS_METHOD || child1Type == CLASS_FIELDS || child1Type == CLASS_CONSTANTS || child1Type == FUNCTION || child1Type == VARIABLE || child1Type == USE_LIST;
    }

    public static boolean isGlobalDeclaration(IElementType child1Type) {
        return child1Type == CLASS || child1Type == FUNCTION || child1Type == VARIABLE;
    }

    static boolean isCaseBlock(IElementType elType) {
        return elType == CASE || elType == CASE_DEFAULT;
    }

    static boolean isAltSyntaxEndKeyword(IElementType elType) {
        return ALTSYNTAX_END_KEYWORDS.contains(elType);
    }

    static boolean isNodeAtOrAfter(ASTNode node, IElementType elType) {
        for (ASTNode currNode = node; currNode != null; currNode = currNode.getTreePrev()) {
            if (currNode.getElementType() != elType) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ASTNode getBoundStatement(ASTNode node) {
        for (ASTNode parent = node.getTreeParent(); parent != null; parent = parent.getTreeParent()) {
            if (!PhpElementTypes.STATEMENTS.contains(parent.getElementType()) && parent.getElementType() != CLASS_FIELDS) continue;
            return parent;
        }
        return null;
    }

    static boolean isBinaryOperator(IElementType eType) {
        return BINARY_OPERATORS.contains(eType);
    }

    static boolean isPrecededBy(ASTNode node, IElementType eType) {
        ASTNode prevNode;
        for (prevNode = node.getTreePrev(); prevNode != null && prevNode.getPsi() instanceof PsiWhiteSpace; prevNode = prevNode.getTreePrev()) {
        }
        if (prevNode == null) {
            return false;
        }
        return prevNode.getElementType() == eType;
    }

    static boolean isAfter(ASTNode node, IElementType eType) {
        ASTNode prevNode = node;
        do {
            if ((prevNode = prevNode.getTreePrev()) == null || prevNode.getElementType() != eType) continue;
            return true;
        } while (prevNode != null);
        return false;
    }

    static boolean isPrecededBy(ASTNode node, TokenSet tokens) {
        ASTNode prevNode;
        for (prevNode = node.getTreePrev(); prevNode != null && prevNode.getPsi() instanceof PsiWhiteSpace; prevNode = prevNode.getTreePrev()) {
        }
        if (prevNode == null) {
            return false;
        }
        return tokens.contains(prevNode.getElementType());
    }

    static boolean isAfterLeftBrace(ASTNode node) {
        if (PhpFormatterUtil.isPrecededBy(node, PhpTokenTypes.chLPAREN)) {
            return true;
        }
        ASTNode parent = node.getTreeParent();
        if (parent != null && !ANY_GROUP_STATEMENT.contains(node.getElementType()) && parent.getFirstChildNode() == node) {
            return PhpFormatterUtil.isAfterLeftBrace(parent);
        }
        return false;
    }

    static boolean isSimpleGroup(ASTNode groupNode) {
        if (groupNode != null && !groupNode.textContains('\n')) {
            ASTNode childNode;
            int statementCount = 0;
            ASTNode aSTNode = childNode = groupNode.getElementType() == PhpStubElementTypes.CLASS ? groupNode.findChildByType(PhpTokenTypes.chLBRACE) : groupNode.getFirstChildNode();
            while (childNode != null) {
                IElementType childType = childNode.getElementType();
                if (childType != PhpTokenTypes.chLBRACE && childType != PhpTokenTypes.chRBRACE && !(childNode.getPsi() instanceof PsiWhiteSpace) && ++statementCount > 1) {
                    return false;
                }
                childNode = childNode.getTreeNext();
            }
            return true;
        }
        return false;
    }

    public static boolean isModifier(IElementType elType) {
        return MODIFIERS.contains(elType);
    }

    static boolean isAtChainedCall(ASTNode arrowNode) {
        if (arrowNode == null) {
            return false;
        }
        ASTNode parentNode = arrowNode.getTreeParent();
        ASTNode methodRef = arrowNode.getTreePrev();
        if (methodRef != null && methodRef.getPsi() instanceof PsiWhiteSpace) {
            methodRef = methodRef.getTreePrev();
        }
        if (methodRef != null && methodRef.getElementType() == METHOD_REFERENCE) {
            return true;
        }
        if (parentNode == null) {
            return false;
        }
        methodRef = parentNode.getTreeParent();
        return methodRef != null && methodRef.getElementType() == METHOD_REFERENCE;
    }

    static boolean belongsToBody(ASTNode child) {
        IElementType childType = child.getElementType();
        if (childType == PhpTokenTypes.chRBRACE || childType == PhpTokenTypes.chLBRACE) {
            return true;
        }
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(childType)) {
            return true;
        }
        if (CONTROL_STATEMENTS_KEYWORDS.contains(childType)) {
            return false;
        }
        if (childType == PhpTokenTypes.chLPAREN || childType == PhpTokenTypes.chRPAREN) {
            return false;
        }
        ASTNode treeParent = child.getTreeParent();
        if (treeParent == null) {
            return false;
        }
        IElementType type = treeParent.getElementType();
        if (type == PhpStubElementTypes.CLASS && PhpFormatterUtil.isClassMemberMember(childType)) {
            return true;
        }
        if (PhpFormatterUtil.isControlStatement(type)) {
            return PhpFormatterUtil.isImmediatelyAfter(child, PhpTokenTypes.chRPAREN, PhpTokenTypes.kwELSE);
        }
        if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(type)) {
            return true;
        }
        if (type == PhpElementTypes.IF && childType != PhpTokenTypes.chRPAREN) {
            ASTNode treePrev;
            for (treePrev = child.getTreePrev(); treePrev != null && treePrev.getElementType() == TokenType.WHITE_SPACE; treePrev = treePrev.getTreePrev()) {
            }
            if (treePrev != null && treePrev.getElementType() == PhpTokenTypes.chRPAREN) {
                return true;
            }
        }
        if (tsCOMMENTS.contains(childType)) {
            ASTNode treeNext;
            for (treeNext = child.getTreeNext(); treeNext != null && treeNext.getElementType() == TokenType.WHITE_SPACE; treeNext = treeNext.getTreeNext()) {
            }
            if (treeNext != null && PhpElementTypes.ANY_GROUP_STATEMENT.contains(treeNext.getElementType())) {
                return true;
            }
        }
        return false;
    }

    static boolean isComment(IElementType myType) {
        return myType == PhpTokenTypes.C_STYLE_COMMENT || myType == PhpTokenTypes.LINE_COMMENT || myType == PhpDocElementTypes.DOC_COMMENT;
    }

    static boolean isUnixScriptDefinition(@Nullable ASTNode node) {
        if (node == null) {
            return false;
        }
        String text = node.getText();
        return !text.trim().contains("\n") && node.getText().startsWith("#!/");
    }

    static boolean isPlusMinusUnaryOperator(IElementType elementType) {
        return elementType == PhpTokenTypes.opMINUS || elementType == PhpTokenTypes.opPLUS || elementType == PhpTokenTypes.opINCREMENT || elementType == PhpTokenTypes.opDECREMENT;
    }

    static boolean isAssignmentStatement(ASTNode statement) {
        ASTNode assignmentNode = statement.getFirstChildNode();
        if (assignmentNode == null || !PhpPsiUtil.isOfType(assignmentNode, ASSIGNMENT_EXPRESSION, SELF_ASSIGNMENT_EXPRESSION)) {
            return false;
        }
        for (ASTNode child = assignmentNode.getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (!PhpTokenTypes.tsASGN_OPS.contains(child.getElementType())) continue;
            return true;
        }
        return false;
    }

    static boolean isBlockGroupStatement(ASTNode node) {
        if (!PhpPsiUtil.isOfType(node, PhpElementTypes.ANY_GROUP_STATEMENT)) {
            return false;
        }
        ASTNode firstChild = node.getFirstChildNode();
        return firstChild != null && firstChild.getElementType() == PhpTokenTypes.chLBRACE;
    }

    static Block getLastInternalBlock(Block block) {
        List childBlocks = block.getSubBlocks();
        if (childBlocks.size() > 0) {
            Block lastBlock = (Block)childBlocks.get(childBlocks.size() - 1);
            return PhpFormatterUtil.getLastInternalBlock(lastBlock);
        }
        return block;
    }

    static boolean isImmediatelyAfter(ASTNode node, IElementType ... types) {
        ASTNode prevNode;
        for (prevNode = node.getTreePrev(); prevNode != null && (prevNode.getPsi() instanceof PsiWhiteSpace || prevNode.getPsi() instanceof PsiComment); prevNode = prevNode.getTreePrev()) {
        }
        if (prevNode != null) {
            IElementType prevType = prevNode.getElementType();
            for (IElementType type : types) {
                if (type != prevType) continue;
                return true;
            }
        }
        return false;
    }

    static boolean startsWith(@Nullable ASTNode node, @NotNull IElementType type) {
        if (type == null) {
            PhpFormatterUtil.$$$reportNull$$$0(0);
        }
        if (node == null) {
            return false;
        }
        if (node.getElementType() == type) {
            return true;
        }
        return PhpFormatterUtil.startsWith(node.getFirstChildNode(), type);
    }

    static boolean endsWith(@Nullable ASTNode node, IElementType ... types) {
        if (types == null) {
            PhpFormatterUtil.$$$reportNull$$$0(1);
        }
        return PhpFormatterUtil.getEndingNodeOfType(node, types) != null;
    }

    @Nullable
    static ASTNode getEndingNodeOfType(@Nullable ASTNode node, IElementType ... types) {
        if (types == null) {
            PhpFormatterUtil.$$$reportNull$$$0(2);
        }
        if (node == null) {
            return null;
        }
        IElementType nodeType = node.getElementType();
        for (IElementType expectedType : types) {
            if (nodeType != expectedType) continue;
            return node;
        }
        return PhpFormatterUtil.getEndingNodeOfType(node.getLastChildNode(), types);
    }

    static boolean isAtFirstMethodReference(ASTNode node) {
        PsiElement refParent = PsiTreeUtil.findFirstParent((PsiElement)node.getPsi(), (boolean)false, element -> element instanceof MethodReference);
        if (refParent instanceof MethodReference) {
            for (PsiElement child = refParent.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (!(child instanceof FunctionReference)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static boolean isTopMethodReference(@NotNull ASTNode node) {
        ASTNode parent;
        if (node == null) {
            PhpFormatterUtil.$$$reportNull$$$0(3);
        }
        return (parent = node.getTreeParent()) != null && parent.getElementType() != PhpElementTypes.METHOD_REFERENCE;
    }

    static boolean isUnderParentOfType(@NotNull ASTNode node, @NotNull IElementType stopAt, IElementType ... types) {
        if (node == null) {
            PhpFormatterUtil.$$$reportNull$$$0(4);
        }
        if (stopAt == null) {
            PhpFormatterUtil.$$$reportNull$$$0(5);
        }
        for (ASTNode parent = node.getTreeParent(); parent != null && parent.getElementType() != stopAt; parent = parent.getTreeParent()) {
            for (IElementType expectedType : types) {
                if (parent.getElementType() != expectedType) continue;
                return true;
            }
        }
        return false;
    }

    static boolean isBracedGroup(@NotNull ASTNode groupNode) {
        ASTNode firstChild;
        if (groupNode == null) {
            PhpFormatterUtil.$$$reportNull$$$0(6);
        }
        return (firstChild = groupNode.getFirstChildNode()) != null && firstChild.getElementType() == PhpTokenTypes.chLBRACE;
    }

    @Nullable
    public static ASTNode findOuterNextSiblingNoLineFeedsBetween(@NotNull ASTNode node) {
        ASTNode next;
        if (node == null) {
            PhpFormatterUtil.$$$reportNull$$$0(7);
        }
        if ((next = node.getTreeNext()) != null && next.getPsi() instanceof PsiWhiteSpace) {
            if (next.textContains('\n')) {
                return null;
            }
            next = next.getTreeNext();
        }
        if (next == null) {
            ASTNode parent = node.getTreeParent();
            if (parent == null || parent.getPsi() instanceof PsiFile) {
                return null;
            }
            return PhpFormatterUtil.findOuterNextSiblingNoLineFeedsBetween(parent);
        }
        return next;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isFileHeader(@Nullable PsiElement comment) {
        PsiElement next;
        PsiElement parent;
        PsiElement prev;
        if (comment instanceof PsiComment && PhpPsiUtil.isOfType(prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(comment, true), PhpTokenTypes.PHP_OPENING_TAG) && PhpPsiUtil.isOfType(parent = comment.getParent(), PhpElementTypes.ANY_GROUP_STATEMENT.getTypes()) && parent.getPrevSibling() == null && (next = comment.getNextSibling()) instanceof PsiWhiteSpace) {
            return StringUtil.getLineBreakCount((CharSequence)next.getText()) != 1 || !((next = next.getNextSibling()) instanceof PhpClass) && !(next instanceof Function) && !(next instanceof Constant) && !(next instanceof Statement);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopAt";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/formatter/PhpFormatterUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "startsWith";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "endsWith";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getEndingNodeOfType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isTopMethodReference";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isUnderParentOfType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isBracedGroup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findOuterNextSiblingNoLineFeedsBetween";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

