/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.formatter;

import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.refactoring.PhpNameStyle;
import org.jetbrains.annotations.NotNull;

public class PhpCodeStyleSettings
extends CustomCodeStyleSettings {
    public boolean INDENT_CODE_IN_PHP_TAGS = false;
    public boolean ALIGN_KEY_VALUE_PAIRS = false;
    public boolean ALIGN_PHPDOC_PARAM_NAMES = false;
    public boolean ALIGN_PHPDOC_COMMENTS = false;
    public boolean ALIGN_ASSIGNMENTS = false;
    public boolean ALIGN_INLINE_COMMENTS = false;
    public boolean CONCAT_SPACES = true;
    public boolean COMMA_AFTER_LAST_ARRAY_ELEMENT = false;
    public boolean PHPDOC_BLANK_LINE_BEFORE_TAGS = false;
    public boolean PHPDOC_KEEP_BLANK_LINES = true;
    public boolean PHPDOC_BLANK_LINES_AROUND_PARAMETERS = false;
    public boolean PHPDOC_WRAP_LONG_LINES = false;
    public int BLANK_LINES_BETWEEN_IMPORTS = 0;
    public int PHPDOC_PARAM_SPACES_BETWEEN_TAG_AND_TYPE = 1;
    public int PHPDOC_PARAM_SPACES_BETWEEN_TYPE_AND_NAME = 1;
    public int PHPDOC_PARAM_SPACES_BETWEEN_NAME_AND_DESCRIPTION = 1;
    @CommonCodeStyleSettings.BraceStyleConstant
    public int ANONYMOUS_BRACE_STYLE = 1;
    public boolean SORT_PHPDOC_ELEMENTS = true;
    public int LINK_WEIGHT = 28;
    public int THROWS_WEIGHT = 2;
    public int PARAM_WEIGHT = 0;
    public int RETURN_WEIGHT = 1;
    public int AUTHOR_WEIGHT = 28;
    public int INTERNAL_WEIGHT = 28;
    public int USES_WEIGHT = 28;
    public int VERSION_WEIGHT = 28;
    public int API_WEIGHT = 28;
    public int CATEGORY_WEIGHT = 28;
    public int COPYRIGHT_WEIGHT = 28;
    public int DEPRECATED_WEIGHT = 28;
    public int EXAMPLE_WEIGHT = 28;
    public int FILESOURCE_WEIGHT = 28;
    public int GLOBAL_WEIGHT = 28;
    public int IGNORE_WEIGHT = 28;
    public int LICENSE_WEIGHT = 28;
    public int METHOD_WEIGHT = 28;
    public int PACKAGE_WEIGHT = 28;
    public int PROPERTY_WEIGHT = 28;
    public int PROPERTY_READ_WEIGHT = 28;
    public int PROPERTY_WRITE_WEIGHT = 28;
    public int SEE_WEIGHT = 28;
    public int SINCE_WEIGHT = 28;
    public int SUBPACKAGE_WEIGHT = 28;
    public int TODO_WEIGHT = 28;
    public int VAR_WEIGHT = 28;
    public int UNKNOWN_TAG_WEIGHT = 28;
    public ImportSorting IMPORT_SORTING = ImportSorting.ALPHABETIC;
    @CommonCodeStyleSettings.WrapConstant
    public int GROUP_USE_WRAP = 5;
    public boolean UPPER_CASE_BOOLEAN_CONST = false;
    public boolean UPPER_CASE_NULL_CONST = false;
    public boolean LOWER_CASE_BOOLEAN_CONST = false;
    public boolean LOWER_CASE_NULL_CONST = false;
    public ElseIfStyle ELSE_IF_STYLE = ElseIfStyle.AS_IS;
    public PhpModifier.Access FIELDS_DEFAULT_VISIBILITY = PhpModifier.Access.PRIVATE;
    public GettersSettersOrderStyle GETTERS_SETTERS_ORDER_STYLE = GettersSettersOrderStyle.GETTERS_FIRST;
    public PhpNameStyle.Style GETTERS_SETTERS_NAMING_STYLE = PhpNameStyle.Style.CAMEL_CASE;
    public PhpNameStyle.Style VARIABLE_NAMING_STYLE = PhpNameStyle.Style.MIXED;
    public boolean LOWER_CASE_KEYWORDS = true;
    @Deprecated
    public boolean BLANK_LINE_BEFORE_RETURN_STATEMENT = false;
    public int BLANK_LINES_BEFORE_RETURN_STATEMENT = 0;
    public boolean KEEP_RPAREN_AND_LBRACE_ON_ONE_LINE = false;
    public boolean SPACES_AROUND_VAR_WITHIN_BRACKETS = false;
    public boolean ALIGN_CLASS_CONSTANTS = false;
    public int BLANK_LINES_AROUND_CONSTANTS = 0;
    public int BLANK_LINES_AFTER_OPENING_TAG = 0;
    public int BLANK_LINES_AFTER_FUNCTION = 1;
    public int KEEP_BLANK_LINES_AFTER_LBRACE = 2;
    public boolean SPACE_BEFORE_UNARY_NOT = false;
    public boolean SPACE_AFTER_UNARY_NOT = false;
    public boolean SPACE_BETWEEN_TERNARY_QUEST_AND_COLON = false;
    public boolean SPACES_WITHIN_SHORT_ECHO_TAGS = true;
    public boolean SPACE_BEFORE_CLOSURE_LEFT_PARENTHESIS = true;
    public boolean SPACE_BEFORE_SHORT_CLOSURE_LEFT_PARENTHESIS = false;
    public boolean FORCE_SHORT_DECLARATION_ARRAY_STYLE = false;
    public boolean NEW_LINE_AFTER_PHP_OPENING_TAG = false;
    public boolean SPACES_AROUND_ARROW = false;
    public boolean SPACES_AROUND_NULL_COALESCE_OPERATOR = true;
    public boolean SPACE_AROUND_ASSIGNMENT_IN_DECLARE = false;
    public boolean SPACE_BEFORE_COLON_IN_RETURN_TYPE = false;
    public boolean SPACE_AFTER_COLON_IN_RETURN_TYPE = true;
    public boolean SPACE_BEFORE_COLON_IN_NAMED_ARGUMENT = false;
    public boolean SPACE_AFTER_COLON_IN_NAMED_ARGUMENT = true;
    public boolean RETURN_TYPE_ON_NEW_LINE = false;
    public boolean PHPDOC_USE_FQCN = false;
    public PhpDocNullPosition NULL_TYPE_POSITION = PhpDocNullPosition.IN_THE_END;
    public boolean MULTILINE_CHAINED_CALLS_SEMICOLON_ON_NEW_LINE = false;
    @Deprecated
    public boolean PREFER_TEMPLATE_INDENTS = false;
    public int NAMESPACE_BRACE_STYLE = 1;
    public int PLACE_PARENS_FOR_CONSTRUCTOR = 0;
    public boolean IF_LPAREN_ON_NEXT_LINE = false;
    public boolean IF_RPAREN_ON_NEXT_LINE = false;
    @CommonCodeStyleSettings.WrapConstant
    public int ATTRIBUTES_WRAP = 0;
    @CommonCodeStyleSettings.WrapConstant
    public int PARAMETERS_ATTRIBUTES_WRAP = 0;

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            PhpCodeStyleSettings.$$$reportNull$$$0(0);
        }
        PhpCodeStyleSettings phpSettings = (PhpCodeStyleSettings)rootSettings.getCustomSettings(PhpCodeStyleSettings.class);
        if (phpSettings.BLANK_LINE_BEFORE_RETURN_STATEMENT) {
            this.BLANK_LINE_BEFORE_RETURN_STATEMENT = false;
            this.BLANK_LINES_BEFORE_RETURN_STATEMENT = 1;
        }
    }

    public PhpCodeStyleSettings(CodeStyleSettings container) {
        super("PHPCodeStyleSettings", container);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSettings", "com/jetbrains/php/lang/formatter/PhpCodeStyleSettings", "importLegacySettings"));
    }

    public static final class OmitParensForConstructor {
        public static final int AS_IS = 0;
        public static final int ALWAYS = 1;
        public static final int NEVER = 2;
    }

    public static enum PhpDocNullPosition {
        IN_THE_BEGINNING,
        IN_THE_END,
        DONT_FORCE;

    }

    public static enum ElseIfStyle {
        AS_IS,
        SEPARATE,
        COMBINE;

    }

    public static enum GettersSettersOrderStyle {
        GETTERS_FIRST,
        SETTERS_FIRST;

    }

    public static enum ImportSorting {
        ALPHABETIC,
        BY_LENGTH,
        DONT_SORT;

    }
}

