/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.ID;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.findUsages.PhpMethodReferenceAtOffsetSearcher;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpSerializeFunctionCallsOffsetsIndex;
import gnu.trove.TIntArrayList;
import org.jetbrains.annotations.NotNull;

public class PhpSerializationMethodsReferenceSearcher
extends PhpMethodReferenceAtOffsetSearcher {
    @Override
    @NotNull
    protected ID<Boolean, TIntArrayList> getReferenceOffsetIndexKey() {
        ID<Boolean, TIntArrayList> iD = PhpSerializeFunctionCallsOffsetsIndex.KEY;
        if (iD == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @Override
    protected boolean isMethodToSearch(@NotNull Method method) {
        String name;
        if (method == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(1);
        }
        if ((name = method.getName()).equalsIgnoreCase("__serialize") || name.equalsIgnoreCase("__unserialize")) {
            return true;
        }
        return (name.equalsIgnoreCase("serialize") || name.equalsIgnoreCase("unserialize")) && PhpSerializationMethodsReferenceSearcher.methodFromSerializableInterface(method);
    }

    private static boolean methodFromSerializableInterface(@NotNull Method method) {
        if (method == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(2);
        }
        Ref res = new Ref((Object)Boolean.FALSE);
        PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)method, (classMember, subClass, baseClass) -> {
            if (baseClass.isInterface() && PhpLangUtil.equalsClassNames(baseClass.getFQN(), "\\Serializable")) {
                res.set((Object)Boolean.TRUE);
                return false;
            }
            return true;
        });
        return res.get() == Boolean.TRUE;
    }

    @Override
    @NotNull
    protected Condition<? super PsiElement> getReferenceCondition() {
        Condition condition = FunctionReference.INSTANCEOF;
        if (condition == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(3);
        }
        return condition;
    }

    @Override
    protected boolean isReferenceTo(@NotNull PsiReference reference, @NotNull Method method) {
        if (reference == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(4);
        }
        if (method == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(5);
        }
        return PhpSerializationMethodsReferenceSearcher.functionReferenceArgumentReferenceToContainingClass(reference, method) && PhpSerializationMethodsReferenceSearcher.referenceNameMatchesCorrespondingMethodName(reference, method);
    }

    private static boolean referenceNameMatchesCorrespondingMethodName(@NotNull PsiReference reference, @NotNull Method method) {
        Function referenceFunction;
        if (reference == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(6);
        }
        if (method == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(7);
        }
        if ((referenceFunction = (Function)ObjectUtils.tryCast((Object)reference.resolve(), Function.class)) == null) {
            return false;
        }
        String referenceFunctionFqn = referenceFunction.getFQN();
        String name = method.getName();
        if (PhpLangUtil.equalsClassNames(referenceFunctionFqn, "\\serialize")) {
            return name.equalsIgnoreCase("serialize") || name.equalsIgnoreCase("__serialize");
        }
        if (PhpLangUtil.equalsClassNames(referenceFunctionFqn, "\\unserialize")) {
            return name.equalsIgnoreCase("unserialize") || name.equalsIgnoreCase("__unserialize");
        }
        return false;
    }

    private static boolean functionReferenceArgumentReferenceToContainingClass(@NotNull PsiReference reference, @NotNull Method method) {
        if (reference == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(8);
        }
        if (method == null) {
            PhpSerializationMethodsReferenceSearcher.$$$reportNull$$$0(9);
        }
        if (!(reference instanceof FunctionReference)) {
            return false;
        }
        PhpTypedElement referenceArgument = (PhpTypedElement)ObjectUtils.tryCast((Object)((FunctionReference)reference).getParameter(0), PhpTypedElement.class);
        if (referenceArgument == null) {
            return false;
        }
        PhpClass methodContainingClass = method.getContainingClass();
        if (methodContainingClass == null) {
            return false;
        }
        return PhpSerializationMethodsReferenceSearcher.hasClassFqnInType(referenceArgument, methodContainingClass.getFQN());
    }

    private static boolean hasClassFqnInType(PhpTypedElement referenceArgument, String classFqn) {
        return referenceArgument.getGlobalType().getTypes().contains(classFqn);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/findUsages/PhpSerializationMethodsReferenceSearcher";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceOffsetIndexKey";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpSerializationMethodsReferenceSearcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceCondition";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isMethodToSearch";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "methodFromSerializableInterface";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "referenceNameMatchesCorrespondingMethodName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "functionReferenceArgumentReferenceToContainingClass";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

