/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.indexing.ID;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFlatCollectionIndexBase;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public abstract class PhpMethodReferenceAtOffsetSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public void processQuery(@NotNull ReferencesSearch.SearchParameters parameters, @NotNull Processor<? super PsiReference> consumer) {
        Method methodToSearch;
        if (parameters == null) {
            PhpMethodReferenceAtOffsetSearcher.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PhpMethodReferenceAtOffsetSearcher.$$$reportNull$$$0(1);
        }
        if ((methodToSearch = (Method)ObjectUtils.tryCast((Object)parameters.getElementToSearch(), Method.class)) == null) {
            return;
        }
        if (((Boolean)ReadAction.compute(() -> this.isMethodToSearch(methodToSearch))).booleanValue()) {
            Project project = (Project)ReadAction.compute(() -> methodToSearch.getProject());
            THashMap fileOffsets = new THashMap();
            DumbService dumbService = DumbService.getInstance((Project)project);
            dumbService.runReadActionInSmartMode(() -> this.lambda$processQuery$3(parameters, project, (Map)fileOffsets));
            PsiManager psiManager = PsiManager.getInstance((Project)project);
            for (Map.Entry entry : fileOffsets.entrySet()) {
                PsiFile file = (PsiFile)ReadAction.compute(() -> psiManager.findFile((VirtualFile)entry.getKey()));
                if (file == null) continue;
                TIntArrayList offsets = (TIntArrayList)entry.getValue();
                for (int i = 0; i < offsets.size(); ++i) {
                    ProgressManager.checkCanceled();
                    int offset = offsets.get(i);
                    if (((Boolean)dumbService.runReadActionInSmartMode(() -> this.processFunctionReferenceAtOffset(offset, methodToSearch, consumer, file))).booleanValue()) continue;
                    return;
                }
            }
        }
    }

    private boolean processFunctionReferenceAtOffset(Integer offset, Method elementToSearch, Processor<? super PsiReference> consumer, @NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PhpMethodReferenceAtOffsetSearcher.$$$reportNull$$$0(2);
        }
        LeafPsiElement referenceIdentifier = (LeafPsiElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)psiFile, (int)offset, LeafPsiElement.class, (boolean)false);
        Object referenceHolder = PhpPsiUtil.getParentByCondition((PsiElement)referenceIdentifier, false, this.getReferenceCondition(), (Condition<? super PsiElement>)Statement.INSTANCEOF);
        while (referenceHolder != null) {
            PsiReference reference;
            PsiReference psiReference = reference = referenceHolder instanceof PsiReference ? (PsiReference)referenceHolder : (PsiReference)ArrayUtil.getFirstElement((Object[])referenceHolder.getReferences());
            if (reference != null && this.isReferenceTo(reference, elementToSearch) && !consumer.process((Object)reference)) {
                return false;
            }
            referenceHolder = PhpPsiUtil.getParentByCondition(referenceHolder, true, this.getReferenceCondition(), (Condition<? super PsiElement>)Statement.INSTANCEOF);
        }
        return true;
    }

    protected boolean isReferenceTo(@NotNull PsiReference reference, @NotNull Method elementToSearch) {
        if (reference == null) {
            PhpMethodReferenceAtOffsetSearcher.$$$reportNull$$$0(3);
        }
        if (elementToSearch == null) {
            PhpMethodReferenceAtOffsetSearcher.$$$reportNull$$$0(4);
        }
        return reference.isReferenceTo((PsiElement)elementToSearch);
    }

    @NotNull
    protected abstract ID<Boolean, TIntArrayList> getReferenceOffsetIndexKey();

    protected abstract boolean isMethodToSearch(@NotNull Method var1);

    @NotNull
    protected abstract Condition<? super PsiElement> getReferenceCondition();

    private /* synthetic */ void lambda$processQuery$3(ReferencesSearch.SearchParameters parameters, Project project, Map fileOffsets) {
        GlobalSearchScope filter = GlobalSearchScopeUtil.toGlobalSearchScope((SearchScope)parameters.getEffectiveSearchScope(), (Project)project);
        PhpFlatCollectionIndexBase.processValues(this.getReferenceOffsetIndexKey(), (file, value) -> {
            ProgressManager.checkCanceled();
            fileOffsets.put(file, value);
            return true;
        }, filter);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpMethodReferenceAtOffsetSearcher";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processQuery";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processFunctionReferenceAtOffset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isReferenceTo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

