/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.findUsages;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesHandler;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesOptions;
import com.jetbrains.php.lang.findUsages.PhpFindUsagesProvider;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorsGenerator;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    private final PhpFindUsagesOptions myFindMethodOptions;

    public PhpFindUsagesHandlerFactory(Project project) {
        this.myFindMethodOptions = new PhpFindUsagesOptions(project);
    }

    public boolean canFindUsages(@NotNull PsiElement element) {
        if (element == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        return element.isValid() && new PhpFindUsagesProvider().canFindUsagesFor(element);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, @NotNull FindUsagesHandlerFactory.OperationMode operationMode) {
        PsiElement[] accessors;
        if (element == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        if (operationMode == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(2);
        }
        if (element instanceof Method && operationMode != FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES) {
            Method[] methods = this.checkSuperMethods((Method)element, FindBundle.message((String)"find.usages.dialog.title", (Object[])new Object[0]));
            if (methods.length > 1) {
                return new PhpFindUsagesHandler(element, (PsiElement[])methods, this);
            }
            if (methods.length == 1) {
                return new PhpFindUsagesHandler((PsiElement)methods[0], this);
            }
            return FindUsagesHandler.NULL_HANDLER;
        }
        if (element instanceof Field && operationMode != FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES && (accessors = PhpFindUsagesHandlerFactory.findAccessors((Field)element)).length > 0 && this.shouldSearchAccessors(((Field)element).getName())) {
            return new PhpFindUsagesHandler(element, PsiElement.EMPTY_ARRAY, accessors, this);
        }
        return new PhpFindUsagesHandler(element, this);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(3);
        }
        return this.createFindUsagesHandler(element, forHighlightUsages ? FindUsagesHandlerFactory.OperationMode.HIGHLIGHT_USAGES : FindUsagesHandlerFactory.OperationMode.DEFAULT);
    }

    private static PsiElement[] findAccessors(@NotNull Field field) {
        if (field == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(4);
        }
        PhpAccessorsGenerator generator = new PhpAccessorsGenerator(field);
        List getters = ContainerUtil.filter((Object[])generator.findGetters(), method -> PhpFindUsagesHandlerFactory.onlyReturnsField(method, field));
        List setters = ContainerUtil.filter((Object[])generator.findSetters(), method -> PhpFindUsagesHandlerFactory.onlyAssignsFieldOptionallyFluent(method, field));
        return PsiUtilCore.toPsiElementArray((Collection)ContainerUtil.concat((List)getters, (List)setters));
    }

    private static boolean onlyAssignsFieldOptionallyFluent(@NotNull Method method, @NotNull Field field) {
        Parameter[] parameters;
        if (method == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(5);
        }
        if (field == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(6);
        }
        if ((parameters = method.getParameters()).length != 1) {
            return false;
        }
        PsiElement[] statements = PhpFindUsagesHandlerFactory.getStatements(method);
        if (statements.length == 0 || statements.length > 2) {
            return false;
        }
        if (!PhpFindUsagesHandlerFactory.fieldToParameterAssignment(statements[0], field, parameters[0])) {
            return false;
        }
        if (statements.length < 2) {
            return true;
        }
        PhpReturn fluentReturn = (PhpReturn)ObjectUtils.tryCast((Object)statements[1], PhpReturn.class);
        return fluentReturn != null && PhpLangUtil.isThisReference(fluentReturn.getArgument());
    }

    private static boolean fieldToParameterAssignment(@NotNull PsiElement statement, @NotNull Field field, @NotNull Parameter parameter) {
        AssignmentExpression assignment;
        if (statement == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(7);
        }
        if (field == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(8);
        }
        if (parameter == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(9);
        }
        return (assignment = (AssignmentExpression)PhpPsiUtil.getChildByCondition((PsiElement)ObjectUtils.tryCast((Object)statement, Statement.class), (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF)) != null && PhpFindUsagesHandlerFactory.resolveParameter(assignment.getValue()) == parameter && PhpFindUsagesHandlerFactory.resolveField((PsiElement)assignment.getVariable()) == field;
    }

    @Nullable
    private static PsiElement resolveParameter(@Nullable PhpPsiElement value) {
        return value instanceof Variable ? ((Variable)value).resolve() : null;
    }

    private static boolean onlyReturnsField(@NotNull Method method, Field field) {
        Parameter[] parameters;
        if (method == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(10);
        }
        if ((parameters = method.getParameters()).length > 0) {
            return false;
        }
        PsiElement[] statements = PhpFindUsagesHandlerFactory.getStatements(method);
        PhpReturn fieldReturn = statements.length == 1 ? (PhpReturn)ObjectUtils.tryCast((Object)statements[0], PhpReturn.class) : null;
        return fieldReturn != null && PhpFindUsagesHandlerFactory.resolveField(fieldReturn.getArgument()) == field;
    }

    private static PsiElement @NotNull [] getStatements(@NotNull Method method) {
        GroupStatement body;
        if (method == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(11);
        }
        PsiElement[] psiElementArray = (body = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF)) != null ? body.getStatements() : PsiElement.EMPTY_ARRAY;
        if (psiElementArray == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(12);
        }
        return psiElementArray;
    }

    @Nullable
    private static Field resolveField(@Nullable PsiElement argument) {
        FieldReference reference = (FieldReference)ObjectUtils.tryCast((Object)argument, FieldReference.class);
        return reference != null ? (Field)ObjectUtils.tryCast((Object)reference.resolve(), Field.class) : null;
    }

    protected boolean shouldSearchAccessors(@NotNull String fieldName) {
        if (fieldName == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        return MessageDialogBuilder.yesNo((String)PhpBundle.message("find.field.accessors.title", new Object[0]), (String)PhpBundle.message("find.field.accessors.text", fieldName)).show() == 0;
    }

    private Method @NotNull [] checkSuperMethods(Method method, @Nls String actionString) {
        PhpClass containingClass = method.getContainingClass();
        if (containingClass == null) {
            Method[] methodArray = new Method[]{method};
            if (methodArray == null) {
                PhpFindUsagesHandlerFactory.$$$reportNull$$$0(14);
            }
            return methodArray;
        }
        ArrayList<Method> superMethods = new ArrayList<Method>();
        PhpClassHierarchyUtils.processSuperMethods((Method)method, (method1, subClass, baseClass) -> {
            if (subClass != null && PhpLangUtil.isObject(subClass)) {
                return false;
            }
            superMethods.add((Method)method1);
            return true;
        });
        ArrayList allMethods = new ArrayList(superMethods);
        if (allMethods.isEmpty()) {
            Method[] methodArray = new Method[]{method};
            if (methodArray == null) {
                PhpFindUsagesHandlerFactory.$$$reportNull$$$0(15);
            }
            return methodArray;
        }
        String messageBuilder = PhpFindUsagesHandlerFactory.createWindowMessage(method, containingClass, superMethods);
        if (this.isFindUsagesOfBaseMethod(method.getProject(), messageBuilder, actionString)) {
            Method[] methodArray = allMethods.toArray(Method.EMPTY);
            if (methodArray == null) {
                PhpFindUsagesHandlerFactory.$$$reportNull$$$0(16);
            }
            return methodArray;
        }
        Method[] methodArray = new Method[]{method};
        if (methodArray == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(17);
        }
        return methodArray;
    }

    protected boolean isFindUsagesOfBaseMethod(final @NotNull Project project, @NotNull @Nls String message, @NotNull @Nls String title) {
        PhpSmartKeysConfiguration configuration;
        if (project == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(18);
        }
        if (message == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(19);
        }
        if (title == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(20);
        }
        if (!(configuration = PhpSmartKeysConfiguration.getInstance()).isPromptFindUsagesOfBaseMethod()) {
            return configuration.isFindUsagesOfBaseMethod();
        }
        int result = Messages.showYesNoCancelDialog((String)message, (String)title, (String)PhpBundle.message("find.usages.button.base.method", new Object[0]), (String)PhpBundle.message("find.usages.button.current.method", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)new DialogWrapper.DoNotAskOption.Adapter(){

            public void rememberChoice(boolean isSelected, int exitCode) {
                if (isSelected && exitCode != 2) {
                    boolean baseMethod = exitCode == 0;
                    PhpFindUsagesHandlerFactory.logEventIntoStatistic(project, baseMethod);
                    configuration.setPromptFindUsagesOfBaseMethod(false);
                    configuration.setFindUsagesOfBaseMethod(baseMethod);
                }
            }
        });
        return result == 0;
    }

    private static void logEventIntoStatistic(@NotNull Project project, boolean baseMethod) {
        if (project == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(21);
        }
        FUCounterUsageLogger.getInstance().logEvent(project, "php.find.usages", "select.default.method.target", new FeatureUsageData().addData("base_method", baseMethod));
    }

    public PhpFindUsagesOptions getFindMethodOptions() {
        return this.myFindMethodOptions;
    }

    @Nls
    private static String createWindowMessage(@NotNull Method method, @NotNull PhpClass containingClass, Collection<Method> superMethods) {
        if (method == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(22);
        }
        if (containingClass == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(23);
        }
        Set<String> superClasses = PhpFindUsagesHandlerFactory.getSuperClassesNames(superMethods);
        boolean allInterfaces = StreamEx.of(superMethods).map(PhpClassMember::getContainingClass).nonNull().allMatch(PhpClass::isInterface);
        String superClassesString = StringUtil.join(superClasses, (String)",");
        String key = allInterfaces ? "find.usages.prompt.dialog.implements" : "find.usages.prompt.dialog.overrides";
        return PhpBundle.message(key, method.getName(), containingClass.getName(), superClassesString, superClasses.size() > 1 ? 1 : 0);
    }

    @NotNull
    private static Set<String> getSuperClassesNames(@NotNull Collection<Method> superMethods) {
        if (superMethods == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(24);
        }
        THashSet superClasses = new THashSet();
        for (Method superMethod : superMethods) {
            PhpClass containingSuperClass = superMethod.getContainingClass();
            assert (containingSuperClass != null);
            superClasses.add(containingSuperClass.getName());
        }
        THashSet tHashSet = superClasses;
        if (tHashSet == null) {
            PhpFindUsagesHandlerFactory.$$$reportNull$$$0(25);
        }
        return tHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationMode";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 5: 
            case 10: 
            case 11: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/findUsages/PhpFindUsagesHandlerFactory";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldName";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containingClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/findUsages/PhpFindUsagesHandlerFactory";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "checkSuperMethods";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuperClassesNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canFindUsages";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFindUsagesHandler";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findAccessors";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onlyAssignsFieldOptionallyFluent";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fieldToParameterAssignment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onlyReturnsField";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStatements";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "shouldSearchAccessors";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFindUsagesOfBaseMethod";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "logEventIntoStatistic";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createWindowMessage";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getSuperClassesNames";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

