/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.editor.enterHandlers;

import com.intellij.CommonBundle;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.editor.enterHandlers.PhpEnterHandlerBase;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.inspections.phpdoc.PhpDocCommentGenerator;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocEnterHandler
extends PhpEnterHandlerBase {
    @Override
    public boolean beforeEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull DataContext dataContext, @NotNull Project project, @NotNull Document document, int lineNumber, int caret, @NotNull PsiElement elementAt) {
        if (file == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(1);
        }
        if (dataContext == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(3);
        }
        if (document == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(4);
        }
        if (elementAt == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(5);
        }
        PhpDocComment docComment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(caret - 1), PhpDocComment.class, (boolean)false);
        PhpEnterHandlerBase.CommentInserter commentInserter = new PhpEnterHandlerBase.CommentInserter(project, document, editor, lineNumber);
        if (docComment != null) {
            ASTNode nodeAt = elementAt.getNode();
            if (PhpDocTokenTypes.DOC_COMMENT_END.equals(nodeAt.getElementType()) && elementAt.getTextRange().getEndOffset() == caret) {
                return false;
            }
            PsiElement elementAtParent = elementAt.getParent();
            if (docComment == elementAtParent) {
                PsiElement prev;
                boolean atStartOfComment = DOC_COMMENT_START == nodeAt.getElementType() ? true : (prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(elementAt, true)) != null && DOC_COMMENT_START == prev.getNode().getElementType();
                boolean autoCompleted = false;
                if (atStartOfComment) {
                    PsiElement next = PhpPsiUtil.getNextSiblingIgnoreWhitespace(elementAt, true);
                    IElementType nextType = PsiUtilCore.getElementType((PsiElement)next);
                    if (next == null || nextType == PhpDocTokenTypes.DOC_IGNORED || next instanceof PsiErrorElement) {
                        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"\n */");
                        PhpDocEnterHandler.indentLine(project, document, lineNumber + 1);
                        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                        docComment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(caret - 1), PhpDocComment.class, (boolean)false);
                        editor.getCaretModel().moveToOffset(caret);
                        autoCompleted = true;
                    }
                }
                if (atStartOfComment && autoCompleted && docComment != null) {
                    PhpPsiElement child;
                    PhpPsiElement target = docComment.getNextPsiSibling();
                    PsiElement parent = docComment.getParent();
                    if (PhpPsiUtil.isOfType(parent, PhpStubElementTypes.NAMESPACE) && PhpPsiUtil.isOfType((PsiElement)target, PhpElementTypes.ANY_GROUP_STATEMENT)) {
                        target = target.getFirstPsiChild();
                    }
                    if (target instanceof Statement && (child = target.getFirstPsiChild()) instanceof AssignmentExpression && PhpPsiUtil.isOfType((PsiElement)(child = child.getLastChild()), PhpElementTypes.CLOSURE) && (child = child.getFirstChild()) instanceof Function) {
                        target = (Function)child;
                    }
                    PhpDocEnterHandler.insertDocComment(file, docComment, (PsiElement)target, commentInserter);
                    return true;
                }
            }
            if (elementAtParent != null && elementAtParent.getNode().getElementType() == PhpDocElementTypes.phpDocAttributeList && nodeAt.getElementType() != PhpDocTokenTypes.DOC_RPAREN) {
                PhpDocEnterHandler.adjustWithinAttributeList(file, editor, project, document, lineNumber, caret, elementAt);
                return true;
            }
            int lineStart = document.getLineStartOffset(lineNumber);
            int lineEnd = document.getLineEndOffset(lineNumber);
            String restString = editor.getDocument().getCharsSequence().subSequence(caret, lineEnd).toString();
            if (!restString.startsWith("*") && !restString.startsWith("/")) {
                commentInserter.insertLine("", restString.startsWith(" ") ? "*" : "* ");
                if (restString.trim().endsWith("*/")) {
                    CaretModel model = editor.getCaretModel();
                    int caretOffset = model.getOffset();
                    int newLineEnd = document.getLineEndOffset(commentInserter.getCurrentLine());
                    model.moveToOffset(newLineEnd - (restString.length() - restString.lastIndexOf("*/")));
                    commentInserter.insertLine("", "");
                    model.moveToOffset(caretOffset);
                }
                commentInserter.commitChanges();
                PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
                if (phpCodeStyleSettings.ALIGN_PHPDOC_COMMENTS) {
                    if (caret < lineEnd) {
                        commentInserter.commitChanges();
                        int newLineEnd = document.getLineEndOffset(commentInserter.getCurrentLine());
                        CodeStyleManager.getInstance((Project)project).reformatText(file, lineStart, newLineEnd);
                    } else {
                        PhpDocEnterHandler.alignCaretWithComment(file, editor, caret);
                    }
                }
                if (caret < lineEnd) {
                    PhpDocEnterHandler.moveCaretToNonWhitespace(editor);
                }
                return true;
            }
        }
        return false;
    }

    private static void adjustWithinAttributeList(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Project project, @NotNull Document document, int lineNumber, int offset, @NotNull PsiElement elementAt) {
        PsiElement next;
        if (file == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(7);
        }
        if (project == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(8);
        }
        if (document == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(9);
        }
        if (elementAt == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(10);
        }
        boolean isParenthesisLine = false;
        boolean isNewLineBeforeParenthesis = false;
        if (elementAt instanceof PsiWhiteSpace && (next = elementAt.getNextSibling()) != null && (next.getNode().getElementType() == PhpDocTokenTypes.DOC_IGNORED && next.textMatches((CharSequence)")") || next.getNode().getElementType() == PhpDocTokenTypes.DOC_RPAREN)) {
            isParenthesisLine = true;
            isNewLineBeforeParenthesis = elementAt.textContains('\n');
        }
        CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE).getIndentOptions();
        assert (indentOptions != null);
        String indentString = "* " + (!isParenthesisLine || isNewLineBeforeParenthesis ? StringUtil.repeatSymbol((char)' ', (int)indentOptions.INDENT_SIZE) : "");
        int lineStart = document.getLineStartOffset(lineNumber);
        if (!isNewLineBeforeParenthesis) {
            indentString = "\n" + indentString;
            lineStart = document.getLineStartOffset(lineNumber + 1);
        }
        document.insertString(offset, (CharSequence)indentString);
        if (isNewLineBeforeParenthesis) {
            document.insertString(offset + indentString.length(), (CharSequence)"\n* ");
        }
        editor.getCaretModel().moveToOffset(offset + indentString.length());
        int nextLineOffset = document.getLineStartOffset(lineNumber + 1);
        PsiDocumentManager.getInstance((Project)project).commitDocument(document);
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, lineStart);
        CodeStyleManager.getInstance((Project)project).adjustLineIndent(document, nextLineOffset);
    }

    @Override
    public EnterHandlerDelegate.Result getNextAction() {
        return EnterHandlerDelegate.Result.Stop;
    }

    private static void insertDocComment(@NotNull PsiFile file, @NotNull PhpDocComment docComment, PsiElement target, PhpEnterHandlerBase.CommentInserter commentInserter) {
        if (file == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(11);
        }
        if (docComment == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(12);
        }
        Project project = commentInserter.getProject();
        Editor editor = commentInserter.getEditor();
        if (target == null || !PhpDocEnterHandler.isDocCommentGenerationAvailable(project, editor)) {
            commentInserter.insertLine("", " ", false, true, "*");
            commentInserter.commitChanges();
            return;
        }
        RangeMarker originalRange = editor.getDocument().createRangeMarker(docComment.getTextRange());
        PhpDocComment newDocComment = PhpDocCommentGenerator.constructDocComment(project, target, true);
        assert (newDocComment != null);
        String docText = PhpDocEnterHandler.getDocCommentContent(newDocComment);
        String[] lines = docText.split("\n");
        boolean isLastLineEmpty = false;
        for (String line : lines) {
            isLastLineEmpty = "*".equals(line.trim());
            commentInserter.insertLine("", line, false, false, "");
        }
        commentInserter.commitChanges();
        PhpDocEnterHandler.formatAddedComment(project, file, originalRange.getStartOffset(), originalRange.getEndOffset());
        if (!PhpDocCommentGenerator.tryMoveCaretOnMarker(editor, new TextRange(originalRange.getStartOffset(), originalRange.getEndOffset())) && (isLastLineEmpty || PhpPsiUtil.isOfType(target, PhpElementTypes.CLASS_FIELDS))) {
            int currOffset = editor.getCaretModel().getOffset();
            editor.getDocument().insertString(currOffset, (CharSequence)" ");
            editor.getCaretModel().moveToOffset(currOffset + 1);
        }
        originalRange.dispose();
    }

    private static boolean isDocCommentGenerationAvailable(@NotNull Project project, @NotNull Editor editor) {
        if (project == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(13);
        }
        if (editor == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(14);
        }
        if (DumbService.getInstance((Project)project).isDumb()) {
            String message = PhpBundle.message("actions.generate.php.doc.is.not.available", new Object[0]);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (editor.getComponent().getRootPane() == null) {
                    Messages.showMessageDialog((Project)project, (String)message, (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
                } else {
                    HintManager.getInstance().showErrorHint(editor, message);
                }
            });
            return false;
        }
        return true;
    }

    @NotNull
    private static String getDocCommentContent(@NotNull PhpDocComment docComment) {
        if (docComment == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(15);
        }
        StringBuilder docText = new StringBuilder();
        for (PsiElement child = docComment.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType childType = child.getNode().getElementType();
            if (childType == PhpDocTokenTypes.DOC_COMMENT_START || childType == PhpDocTokenTypes.DOC_COMMENT_END) continue;
            docText.append(child.getText());
        }
        String string = docText.toString().trim();
        if (string == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static void formatAddedComment(Project project, PsiFile file, int startOffset, int endOffset) {
        PhpCodeStyleSettings phpCodeStyleSettings = (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)file, PhpCodeStyleSettings.class);
        boolean keepBlankLines = phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES;
        phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES = true;
        CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, startOffset, endOffset, true);
        phpCodeStyleSettings.PHPDOC_KEEP_BLANK_LINES = keepBlankLines;
    }

    private static void alignCaretWithComment(PsiFile file, Editor editor, int caret) {
        PsiElement element = file.findElementAt(caret);
        assert (element != null) : "Can't find an element at " + caret;
        ASTNode valueNode = PhpDocEnterHandler.getPhpDocValueNode(element.getNode());
        if (valueNode != null) {
            int caretAdvance = 0;
            for (ASTNode prev = valueNode.getTreePrev(); !(prev == null || prev.getElementType() == PhpDocTokenTypes.DOC_LEADING_ASTERISK || prev.getPsi() instanceof PsiWhiteSpace && prev.textContains('\n')); prev = prev.getTreePrev()) {
                caretAdvance += prev.getTextLength();
            }
            if (caretAdvance > 0) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)StringUtil.repeat((String)" ", (int)caretAdvance));
            }
        }
    }

    @Nullable
    private static ASTNode getPhpDocValueNode(@NotNull ASTNode docNode) {
        ASTNode nextParent;
        if (docNode == null) {
            PhpDocEnterHandler.$$$reportNull$$$0(17);
        }
        ASTNode currNode = docNode;
        while (!(currNode == null || (nextParent = currNode.getTreeParent()) != null && nextParent.getPsi() instanceof PhpDocComment)) {
            currNode = nextParent;
        }
        assert (currNode != null) : "The specified node " + docNode.getTextRange() + " is not within PhpDoc";
        while (currNode != null) {
            if (PhpDocUtil.isSimpleTag(currNode.getPsi())) {
                if ((currNode = currNode.getLastChildNode()) == null || currNode.getElementType() != PhpDocElementTypes.phpDocTagValue) {
                    return null;
                }
                return currNode;
            }
            currNode = currNode.getTreePrev();
        }
        return null;
    }

    private static void moveCaretToNonWhitespace(Editor editor) {
        Document document = editor.getDocument();
        int caretOffset = editor.getCaretModel().getOffset();
        int lineEnd = editor.getDocument().getLineEndOffset(document.getLineNumber(caretOffset));
        CharSequence stringAfter = document.getCharsSequence().subSequence(caretOffset, lineEnd);
        for (int pos = 0; pos < stringAfter.length(); ++pos) {
            char c = stringAfter.charAt(pos);
            if (c == ' ' || c == '\t') continue;
            editor.getCaretModel().moveCaretRelatively(pos, 0, false, false, false);
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementAt";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/editor/enterHandlers/PhpDocEnterHandler";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/editor/enterHandlers/PhpDocEnterHandler";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocCommentContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeEnter";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "adjustWithinAttributeList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "insertDocComment";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isDocCommentGenerationAvailable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDocCommentContent";
                break;
            }
            case 16: {
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getPhpDocValueNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

