/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.jetbrains.php.PhpIcons;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocPsiElementImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Collection;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocVarImpl
extends PhpDocPsiElementImpl
implements PhpDocVariable {
    private static final TokenSet NN = TokenSet.create((IElementType[])new IElementType[]{PhpDocTokenTypes.DOC_VARIABLE, PhpDocTokenTypes.DOC_IDENTIFIER});

    @Nullable
    public Icon getIcon() {
        return PhpIcons.VARIABLE;
    }

    public PhpDocVarImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public String getName() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            String name = nameNode.getText();
            String string = name.charAt(0) == '$' ? name.substring(1) : name;
            if (string == null) {
                PhpDocVarImpl.$$$reportNull$$$0(0);
            }
            return string;
        }
        return "";
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpDocVarImpl.$$$reportNull$$$0(1);
        }
        phpElementVisitor.visitPhpDocVariable((PhpDocVariable)this);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        ASTNode astNode;
        if (name == null) {
            PhpDocVarImpl.$$$reportNull$$$0(2);
        }
        if ((astNode = this.getNameNode()) != null && !name.equals(this.getName())) {
            PhpDocVariable variable = PhpPsiElementFactory.createFromText(this.getProject(), PhpDocVariable.class, "/** @var $" + name);
            assert (variable != null) : name;
            astNode.getTreeParent().replaceChild(astNode, variable.getNameNode());
        }
        return this;
    }

    public PsiElement handleElementRename(@NotNull String name) throws IncorrectOperationException {
        ASTNode astNode;
        if (name == null) {
            PhpDocVarImpl.$$$reportNull$$$0(3);
        }
        if ((astNode = this.getNameNode()) != null) {
            PhpDocVariable variable = PhpPsiElementFactory.createFromText(this.getProject(), PhpDocVariable.class, "/** @var $" + name);
            assert (variable != null) : name;
            astNode.getTreeParent().replaceChild(astNode, variable.getNameNode());
        }
        return this;
    }

    public PhpDocComment getDocComment() {
        return null;
    }

    public void processDocs(Processor<PhpDocComment> processor) {
    }

    @NotNull
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            PhpDocVarImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getNamespaceName() {
        return "\\";
    }

    public boolean isDeprecated() {
        return false;
    }

    public boolean isInternal() {
        return false;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public PhpType getType() {
        PhpType type = new PhpType();
        Object docTag = PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF);
        type.add(docTag);
        PhpType phpType = type.createImmutableType();
        if (phpType == null) {
            PhpDocVarImpl.$$$reportNull$$$0(5);
        }
        return phpType;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        Collection<? extends PhpNamedElement> vars;
        PhpDocComment docComment = (PhpDocComment)PsiTreeUtil.getParentOfType((PsiElement)this, PhpDocComment.class, (boolean)false);
        PhpPsiElement next = docComment.getNextPsiSibling();
        if (next instanceof Function) {
            for (Parameter parameter : ((Function)next).getParameters()) {
                String name = parameter.getName();
                if (!name.equals(this.getName())) continue;
                ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)parameter)};
                if (resolveResultArray == null) {
                    PhpDocVarImpl.$$$reportNull$$$0(6);
                }
                return resolveResultArray;
            }
        }
        if (!(vars = VariableImpl.collectDeclarationsWithExternalRef((PsiElement)this, false, this.getName())).isEmpty()) {
            ResolveResult[] resolveResultArray = new ResolveResult[]{new PsiElementResolveResult((PsiElement)vars.iterator().next())};
            if (resolveResultArray == null) {
                PhpDocVarImpl.$$$reportNull$$$0(7);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            PhpDocVarImpl.$$$reportNull$$$0(8);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    @NotNull
    public PsiElement getElement() {
        PhpDocVarImpl phpDocVarImpl = this;
        if (phpDocVarImpl == null) {
            PhpDocVarImpl.$$$reportNull$$$0(9);
        }
        return phpDocVarImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return new TextRange(0, this.getTextLength());
    }

    @Nullable
    public ASTNode getNameNode() {
        return this.getNode().findChildByType(NN);
    }

    public boolean isWriteAccess() {
        return true;
    }

    public PsiElement getNameIdentifier() {
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PhpDocVarImpl.$$$reportNull$$$0(10);
        }
        throw new IncorrectOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocVarImpl.$$$reportNull$$$0(11);
        }
        return (element instanceof Parameter || element instanceof Variable) && this.resolve() == element;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            PhpDocVarImpl.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public SearchScope getUseScope() {
        Function f = (Function)PhpPsiUtil.getParentByCondition((PsiElement)this, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (f != null) {
            return new LocalSearchScope((PsiElement)f);
        }
        SearchScope searchScope = super.getUseScope();
        if (searchScope == null) {
            PhpDocVarImpl.$$$reportNull$$$0(13);
        }
        return searchScope;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocVarImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocVarImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getUseScope";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

