/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocPsiElementImpl;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpDocCallbackTP;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeAnalyserVisitor;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeInfo;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocTypeImpl
extends PhpDocPsiElementImpl
implements PhpDocType {
    private static final ResolveCache.PolyVariantResolver<PhpDocType> MY_RESOLVER = (expression, incompleteCode) -> PsiElementResolveResult.createResults((Collection)expression.resolveGlobal(incompleteCode));

    public PhpDocTypeImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected void accept(@NotNull PhpElementVisitor phpElementVisitor) {
        if (phpElementVisitor == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(0);
        }
        phpElementVisitor.visitPhpDocType((PhpDocType)this);
    }

    @NotNull
    public PsiElement getElement() {
        PhpDocTypeImpl phpDocTypeImpl = this;
        if (phpDocTypeImpl == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(1);
        }
        return phpDocTypeImpl;
    }

    @NotNull
    public TextRange getRangeInElement() {
        ASTNode nameNode = this.getNameNode();
        if (nameNode != null) {
            PsiElement psi = nameNode.getPsi();
            int startOffset = psi != null ? psi.getStartOffsetInParent() : 0;
            return new TextRange(startOffset, startOffset + nameNode.getTextLength());
        }
        return new TextRange(0, this.getTextLength());
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        if (!incompleteCode) {
            ResolveResult[] resolveResultArray = ResolveCache.getInstance((Project)this.getProject()).resolveWithCaching((PsiPolyVariantReference)this, MY_RESOLVER, true, false);
            if (resolveResultArray == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(2);
            }
            return resolveResultArray;
        }
        ResolveResult[] resolveResultArray = MY_RESOLVER.resolve((PsiPolyVariantReference)this, true);
        if (resolveResultArray == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(3);
        }
        return resolveResultArray;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] results = this.multiResolve(false);
        if (results.length == 1) {
            return results[0].getElement();
        }
        return null;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.getText();
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        ASTNode nameNode;
        if (newElementName == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(5);
        }
        if ((nameNode = this.getNameNode()) != null && !newElementName.equals(nameNode.getText())) {
            String text = "/** " + newElementName + " */";
            PsiElement renamed = PhpPsiElementFactory.createFromText(this.getProject(), nameNode.getElementType(), text);
            nameNode.getTreeParent().replaceChild(nameNode, renamed.getNode());
        }
        return this;
    }

    @Nullable
    public ASTNode getNameNode() {
        PsiElement child = this.findChildByType(PhpDocTokenTypes.DOC_IDENTIFIER);
        if (child == null) {
            child = this.findChildByType(PhpDocTokenTypes.DOC_VARIABLE);
        }
        if (child != null) {
            return child.getNode();
        }
        return null;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveLocal() {
        return PhpDocTypeImpl.resolveLocal((PhpReference)this);
    }

    @NotNull
    public PhpType resolveLocalType() {
        PhpType phpType = PhpCodeInsightUtil.getLocalType((PhpReference)this);
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(6);
        }
        return phpType;
    }

    @NotNull
    private static Collection<? extends PhpNamedElement> resolveLocal(@NotNull PhpReference docType) {
        String text;
        if (docType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(7);
        }
        if ((text = docType.getText()) == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(8);
            }
            return set;
        }
        String name = docType.getName();
        if (name != null && (PhpType.isPrimitiveType((String)name) || "\\callback".equalsIgnoreCase(PhpLangUtil.toFQN(name))) && !PhpLangUtil.mayBeReferenceToUserDefinedClass(name, docType.getProject())) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(9);
            }
            return set;
        }
        Set<? extends PhpNamedElement> set = ClassReferenceImpl.resolveLocal(docType, name, PhpDocTypeImpl.getNamespaceName(docType, false));
        if (set == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public Collection<? extends PhpNamedElement> resolveGlobal(boolean incompleteCode) {
        String text = this.getText();
        if (text == null) {
            Set set = Collections.emptySet();
            if (set == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(11);
            }
            return set;
        }
        String name = this.getName();
        String namespaceName = PhpLangUtil.toFQN(name).equals("\\Closure") && this.getImmediateNamespaceName().isEmpty() ? "\\" : PhpDocTypeImpl.getNamespaceName((PhpReference)this, false);
        Collection<? extends PhpNamedElement> collection = ClassReferenceImpl.resolveGlobal((PhpReference)this, name, namespaceName, false);
        if (collection == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(12);
        }
        return collection;
    }

    @NotNull
    public String getSignature() {
        return "";
    }

    @NotNull
    public String getName() {
        ASTNode node = this.getNameNode();
        return node != null ? node.getText() : "";
    }

    @NotNull
    public String getNamespaceName() {
        return PhpDocTypeImpl.getNamespaceName((PhpReference)this, true);
    }

    @NotNull
    private static String getNamespaceName(@NotNull PhpReference type, boolean checkPrimitives) {
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(13);
        }
        String string = PhpReferenceImpl.findNamespaceName(PhpDocTypeImpl.getImmediateNamespaceName(type, checkPrimitives), (PsiElement)type);
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    public String getImmediateNamespaceName() {
        String string = PhpDocTypeImpl.getImmediateNamespaceName((PhpReference)this, true);
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static String getImmediateNamespaceName(@NotNull PhpReference type, boolean checkPrimitives) {
        PhpNamespaceReference reference;
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(16);
        }
        return (reference = (PhpNamespaceReference)PhpPsiUtil.getChildByCondition((PsiElement)type, (Condition<? super PsiElement>)PhpNamespaceReference.INSTANCEOF)) != null ? reference.getFullName() : (checkPrimitives && PhpType.isPrimitiveType((String)type.getName()) ? "\\" : "");
    }

    public boolean isAbsolute() {
        String local = this.getImmediateNamespaceName();
        return StringUtil.startsWithChar((CharSequence)local, (char)'\\');
    }

    @NotNull
    public String getFQN() {
        String string = this.getNamespaceName() + this.getName();
        if (string == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(17);
        }
        return string;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(18);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(19);
        }
        if (element instanceof PhpClass) {
            if (PhpLangUtil.equalsClassNames(this.getFQN(), ((PhpClass)element).getFQN())) {
                return true;
            }
            return Arrays.stream(this.multiResolve(false)).anyMatch(result -> result.isValidResult() && result.getElement() == element);
        }
        return false;
    }

    public Object @NotNull [] getVariants() {
        Object[] objectArray = this.multiResolve(true);
        if (objectArray == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(20);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return true;
    }

    public PsiReference getReference() {
        return this;
    }

    @NotNull
    public PhpType getType() {
        PhpType type = PhpTypeInfo.getType((PsiElement)this);
        if (type.size() > 1 && this.inferNativeType().size() < type.size()) {
            PhpType typeFromProviders = PhpTypeInfo.getTypeFromAST((PsiElement)this, new PhpTypeAnalyserVisitor(){

                @Override
                @NotNull
                public PhpType getType() {
                    return new PhpType();
                }
            });
            PhpType phpType = typeFromProviders.pluralise(PhpType.getPluralDimension((String)this.getText()));
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(21);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(22);
        }
        return phpType;
    }

    @NotNull
    private PhpType inferNativeType() {
        PhpTypeAnalyserVisitor visitor = new PhpTypeAnalyserVisitor();
        this.accept(visitor);
        PhpType phpType = visitor.getType();
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(23);
        }
        return phpType;
    }

    @NotNull
    public static PhpType getType(@NotNull PhpReference classReference, @NotNull String fullReferenceText) {
        String pluralisedType;
        String aClass;
        String name;
        if (classReference == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(24);
        }
        if (fullReferenceText == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(25);
        }
        if ("parent".equals(name = classReference.getName())) {
            aClass = "parent";
        } else {
            Collection<? extends PhpNamedElement> elements = PhpDocTypeImpl.resolveLocal(classReference);
            if (elements.size() > 0) {
                PhpNamedElement element = elements.iterator().next();
                String typeString = element.getType().toString();
                aClass = element instanceof PhpClass && PhpDocTypeImpl.isPolymorphicClassReference(name, (PhpClass)element) ? PhpTypeSignatureKey.POLYMORPHIC_CLASS.sign((CharSequence)typeString) : typeString;
            } else {
                aClass = PhpDocUtil.getTypeString((PhpLangUtil.isClassNameSpecial(name) ? "" : PhpDocTypeImpl.getNamespaceName(classReference, true)) + name, (PhpPsiElement)classReference);
            }
        }
        PhpType type = new PhpType();
        int plural = fullReferenceText.indexOf("[");
        String string = pluralisedType = plural >= 0 ? aClass + fullReferenceText.substring(plural) : aClass;
        if (pluralisedType.length() > 1) {
            type.add(pluralisedType);
        }
        if ("callback".equalsIgnoreCase(PhpLangUtil.toShortName(aClass)) && !PhpLangUtil.isFqn(fullReferenceText)) {
            PhpType phpType = type.map(PhpDocCallbackTP::sign);
            if (phpType == null) {
                PhpDocTypeImpl.$$$reportNull$$$0(26);
            }
            return phpType;
        }
        PhpType phpType = type;
        if (phpType == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(27);
        }
        return phpType;
    }

    public static boolean isPolymorphicClassReference(@NotNull String name, @Nullable PhpClass containingClass) {
        if (name == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(28);
        }
        return PhpLangUtil.isClassNameSpecial(name) && (!"self".equals(name) || containingClass != null && containingClass.isTrait());
    }

    @NotNull
    public static PhpType getLocalType(@NotNull PhpDocType type) {
        if (type == null) {
            PhpDocTypeImpl.$$$reportNull$$$0(29);
        }
        return PhpDocTypeImpl.getType((PhpReference)type, type.getText());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpElementVisitor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocTypeImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docType";
                break;
            }
            case 13: 
            case 16: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullReferenceText";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocTypeImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocalType";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveLocal";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGlobal";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceName";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateNamespaceName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFQN";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 21: 
            case 22: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "inferNativeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolveLocal";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateNamespaceName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isPolymorphicClassReference";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getLocalType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

