/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocCommentStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocTagStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocLinkTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocPropertyTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpPsiElementImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpDocCommentImpl
extends PhpPsiElementImpl<PhpDocCommentStub>
implements PhpDocComment {
    public PhpDocCommentImpl(PhpDocCommentStub stub) {
        super(stub, PhpDocElementTypes.DOC_COMMENT);
    }

    public PhpDocCommentImpl(ASTNode node) {
        super(node);
    }

    @NotNull
    public IElementType getTokenType() {
        IStubElementType iStubElementType = this.getElementType();
        if (iStubElementType == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(0);
        }
        return iStubElementType;
    }

    @Nullable
    public PhpDocReturnTag getReturnTag() {
        return (PhpDocReturnTag)ArrayUtil.getFirstElement((Object[])this.getTagElementsByName("@return"));
    }

    public PhpDocLinkTag @Nullable [] getLinkTags() {
        return this.getDocTagByClass(PhpDocLinkTag.class).toArray(new PhpDocLinkTag[0]);
    }

    @NotNull
    public List<PhpDocParamTag> getParamTags() {
        List list = ContainerUtil.filter(this.getDocTagByClass(PhpDocParamTag.class), tag -> {
            String name = tag.getName();
            return "@param".equalsIgnoreCase(name) || "@var".equalsIgnoreCase(name);
        });
        if (list == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(1);
        }
        return list;
    }

    public <T extends PhpDocTag> List<T> getDocTagByClass(Class<T> aClass) {
        ArrayList<PhpDocTag> tags2 = new ArrayList<PhpDocTag>();
        PhpDocCommentStub stub = (PhpDocCommentStub)this.getGreenStub();
        if (stub != null) {
            for (StubElement child : stub.getChildrenStubs()) {
                PhpDocTag psi;
                PhpDocTagStub tagStub;
                if (!(child instanceof PhpDocTagStub) || !StringUtil.isNotEmpty((String)(tagStub = (PhpDocTagStub)child).getName()) || !aClass.isInstance(psi = (PhpDocTag)tagStub.getPsi())) continue;
                tags2.add(psi);
            }
        } else {
            PhpDocTag tag = (PhpDocTag)PsiTreeUtil.getChildOfType((PsiElement)this, aClass);
            while (tag != null) {
                if (StringUtil.isNotEmpty((String)tag.getName())) {
                    tags2.add(tag);
                }
                tag = (PhpDocTag)PsiTreeUtil.getNextSiblingOfType((PsiElement)tag, aClass);
            }
        }
        return tags2;
    }

    @NotNull
    public List<PhpDocPropertyTag> getPropertyTags() {
        List<PhpDocPropertyTag> list = this.getDocTagByClass(PhpDocPropertyTag.class);
        if (list == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public PhpDocParamTag getVarTag() {
        List<PhpDocParamTag> tags2 = this.getDocTagByClass(PhpDocParamTag.class);
        if (tags2.size() != 1) {
            return null;
        }
        PhpDocParamTag paramTag = tags2.get(0);
        String name = paramTag.getName();
        return "@var".equals(name) || "@type".equals(name) ? paramTag : null;
    }

    public PhpDocMethod @NotNull [] getMethods() {
        SmartList result = new SmartList();
        List<PhpDocMethodTag> tags2 = this.getDocTagByClass(PhpDocMethodTag.class);
        for (PhpDocMethodTag tag : tags2) {
            ContainerUtil.addIfNotNull((Collection)result, (Object)((PhpDocMethod)PsiTreeUtil.getStubChildOfType((PsiElement)tag, PhpDocMethod.class)));
        }
        PhpDocMethod[] phpDocMethodArray = result.isEmpty() ? PhpDocMethod.EMPTY_ARRAY : result.toArray(PhpDocMethod.EMPTY_ARRAY);
        if (phpDocMethodArray == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(3);
        }
        return phpDocMethodArray;
    }

    public PhpDocTag @NotNull [] getTagElementsByName(String tagName) {
        if (tagName == null) {
            if (PhpDocTag.EMPTY_ARRAY == null) {
                PhpDocCommentImpl.$$$reportNull$$$0(4);
            }
            return PhpDocTag.EMPTY_ARRAY;
        }
        ArrayList tags2 = new ArrayList();
        PhpDocUtil.processTagElementsByName(this, tagName, (Processor<? super PhpDocTag>)((Processor)tags2::add));
        PhpDocTag[] phpDocTagArray = tags2.toArray(PhpDocTag.EMPTY_ARRAY);
        if (phpDocTagArray == null) {
            PhpDocCommentImpl.$$$reportNull$$$0(5);
        }
        return phpDocTagArray;
    }

    public PhpType[] getExceptionClasses() {
        ArrayList<PhpType> exceptionClasses = new ArrayList<PhpType>();
        for (PhpDocTag exceptionTag : this.getTagElementsByName("@throws")) {
            exceptionClasses.add(exceptionTag.getType());
        }
        return exceptionClasses.toArray(new PhpType[0]);
    }

    public PsiElement getOwner() {
        PsiElement owner = (PsiElement)this.getUserData(OWNER_KEY);
        if (owner != null && owner.isValid()) {
            return owner;
        }
        PhpPsiElement next = this.getNextPsiSibling();
        if (next == null) {
            return null;
        }
        owner = PhpPsiElementImpl.findNextPhpPsiElement((PsiElement)next);
        if (owner == null) {
            return null;
        }
        IElementType elementType = owner.getNode().getElementType();
        if (elementType == PhpElementTypes.CLASS_FIELDS) {
            owner = PhpPsiUtil.getChildOfType(owner, PhpStubElementTypes.CLASS_FIELD);
        } else if (elementType == PhpElementTypes.CLASS_CONSTANTS) {
            owner = PhpPsiUtil.getChildOfType(owner, PhpStubElementTypes.CLASS_CONST);
        } else if (elementType == PhpElementTypes.CONSTANTS) {
            owner = PhpPsiUtil.getChildOfType(owner, PhpStubElementTypes.CONST);
        } else if (owner instanceof ParameterList) {
            PsiElement parameter = ((ParameterList)owner).getParameter(0);
            if (parameter instanceof PhpPsiElement && PhpPsiUtil.isOfType(parameter, PhpElementTypes.CLOSURE)) {
                owner = ((PhpPsiElement)parameter).getFirstPsiChild();
            }
        } else if (PhpElementTypes.ANY_GROUP_STATEMENT.contains(elementType)) {
            PsiElement parent = owner.getParent();
            if (PhpPsiUtil.isOfType(parent, PhpStubElementTypes.NAMESPACE)) {
                owner = owner.getFirstChild();
            }
        } else if (!(owner instanceof PhpNamedElement)) {
            Object prevAttribute = PhpPsiUtil.getPrevSiblingByCondition((PsiElement)this, (Condition<? super PsiElement>)((Condition)PhpAttributesList.class::isInstance));
            if (prevAttribute != null) {
                owner = this.getParent();
            }
        }
        this.putUserData(OWNER_KEY, owner);
        return owner;
    }

    @Nullable
    public PhpDocParamTag getParamTagByName(String name) {
        for (PhpDocParamTag tag : this.getParamTags()) {
            String tn = tag.getVarName();
            if (tn == null || !tn.equals(name)) continue;
            return tag;
        }
        return null;
    }

    public boolean hasInheritDocTag() {
        return PhpDocUtil.hasDocTagWithName(this, "@inheritDoc") || PhpDocUtil.hasDocTagWithName(this, "@inheritdoc");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/lang/documentation/phpdoc/psi/impl/PhpDocCommentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyTags";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMethods";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTagElementsByName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

