/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc.parser.tags;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.openapi.project.Project;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpDocTagParser;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpPsiBuilder;
import com.jetbrains.php.lang.parser.parsing.classes.ClassReference;
import com.jetbrains.php.lang.parser.parsing.functions.ParameterList;
import org.jetbrains.annotations.NotNull;

public class PhpDocMethodSignatureTagParser
extends PhpDocTagParser
implements PsiParser,
PhpTokenTypes {
    private final Project myProject;

    public PhpDocMethodSignatureTagParser(Project project) {
        this.myProject = project;
    }

    @NotNull
    public ASTNode parse(IElementType root, PsiBuilder builder) {
        PhpPsiBuilder phpBuilder = new PhpPsiBuilder(this.myProject, builder);
        PsiBuilder.Marker rootMarker = phpBuilder.mark();
        phpBuilder.match(opSILENCE, PhpBundle.message("parsing.error,at.expected", new Object[0]));
        phpBuilder.match(IDENTIFIER, PhpBundle.message("parsing.error.method.label.expected", new Object[0]));
        phpBuilder.compareAndEat(PhpTokenTypes.kwSTATIC);
        PsiBuilder.Marker i1 = builder.mark();
        do {
            PsiBuilder.Marker typeMarker = phpBuilder.mark();
            if (ClassReference.parse(phpBuilder) == PhpElementTypes.EMPTY_INPUT) {
                phpBuilder.compareAndEat(kwARRAY);
                phpBuilder.compareAndEat(kwCALLABLE);
                if (phpBuilder.compare(VARIABLE) && "$this".equals(phpBuilder.getTokenText())) {
                    builder.advanceLexer();
                    PsiBuilder.Marker precede = typeMarker.precede();
                    typeMarker.done(PhpElementTypes.CLASS_REFERENCE);
                    typeMarker = precede;
                }
            }
            PsiBuilder.Marker array = phpBuilder.mark();
            if (phpBuilder.compareAndEat(chLBRACKET)) {
                if (phpBuilder.compareAndEat(chRBRACKET)) {
                    array.drop();
                } else {
                    array.rollbackTo();
                }
            } else {
                array.rollbackTo();
            }
            typeMarker.done((IElementType)phpDocMethodType);
        } while (phpBuilder.compareAndEat(opBIT_OR));
        if (!phpBuilder.compare(IDENTIFIER) && !phpBuilder.compare(tsKEYWORDS)) {
            i1.rollbackTo();
        } else {
            i1.drop();
        }
        PsiBuilder.Marker firstSignature = builder.mark();
        PsiBuilder.Marker i2 = builder.mark();
        boolean firstSignatureIsEmpty = false;
        if (phpBuilder.compareAndEat(IDENTIFIER) || phpBuilder.compareAndEat(tsKEYWORDS)) {
            if (phpBuilder.compare(chLPAREN)) {
                phpBuilder.match(chLPAREN);
                firstSignatureIsEmpty = phpBuilder.compare(chRPAREN);
                ParameterList.parse(phpBuilder, true);
                phpBuilder.match(chRPAREN);
                if (firstSignatureIsEmpty) {
                    i2.drop();
                } else {
                    i2.done((IElementType)phpDocMethod);
                }
            } else {
                i2.done((IElementType)phpDocMethod);
            }
        } else {
            i2.rollbackTo();
        }
        if (firstSignatureIsEmpty) {
            PsiBuilder.Marker i3 = builder.mark();
            if (phpBuilder.compareAndEat(IDENTIFIER) || phpBuilder.compareAndEat(tsKEYWORDS)) {
                if (phpBuilder.compare(chLPAREN)) {
                    phpBuilder.match(chLPAREN);
                    ParameterList.parse(phpBuilder, true);
                    phpBuilder.match(chRPAREN);
                    i3.done((IElementType)phpDocMethod);
                    firstSignature.drop();
                } else {
                    i3.rollbackTo();
                    firstSignature.done((IElementType)phpDocMethod);
                }
            } else {
                i3.rollbackTo();
                firstSignature.done((IElementType)phpDocMethod);
            }
        } else {
            firstSignature.drop();
        }
        PsiBuilder.Marker methodDescription = builder.mark();
        while (!builder.eof()) {
            builder.advanceLexer();
        }
        methodDescription.done(DOC_METHOD_DESCRIPTION);
        rootMarker.done(root);
        ASTNode aSTNode = phpBuilder.getTreeBuilt();
        if (aSTNode == null) {
            PhpDocMethodSignatureTagParser.$$$reportNull$$$0(0);
        }
        return aSTNode;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/documentation/phpdoc/parser/tags/PhpDocMethodSignatureTagParser", "parse"));
    }
}

