/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation.phpdoc;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.documentation.PhpClassMemberDocSource;
import com.jetbrains.php.lang.documentation.PhpFunctionDocSource;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocMarkdownUtil;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.PhpDocCommentImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.impl.tags.PhpDocTagImpl;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocCommentStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.stubs.PhpDocTagStub;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.formatter.PhpCodeStyleSettings;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpAttributesOwner;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpDocUtil {
    @NlsSafe
    public static final String API_TAG = "@api";
    @NlsSafe
    public static final String AUTHOR_TAG = "@author";
    @NlsSafe
    public static final String CATEGORY_TAG = "@category";
    @NlsSafe
    public static final String COPYRIGHT_TAG = "@copyright";
    @NlsSafe
    public static final String DEPRECATED_TAG = "@deprecated";
    @NlsSafe
    public static final String EXAMPLE_TAG = "@example";
    @NlsSafe
    public static final String FILESOURCE_TAG = "@filesource";
    @NlsSafe
    public static final String GLOBAL_TAG = "@global";
    @NlsSafe
    public static final String IGNORE_TAG = "@ignore";
    @NlsSafe
    public static final String INTERNAL_TAG = "@internal";
    @NlsSafe
    public static final String LICENSE_TAG = "@license";
    @NlsSafe
    public static final String LINK_TAG = "@link";
    @NlsSafe
    public static final String METHOD_TAG = "@method";
    @NlsSafe
    public static final String PACKAGE_TAG = "@package";
    @NlsSafe
    public static final String PARAM_TAG = "@param";
    @NlsSafe
    public static final String PROPERTY_TAG = "@property";
    @NlsSafe
    public static final String PROPERTY_READ_TAG = "@property-read";
    @NlsSafe
    public static final String PROPERTY_WRITE_TAG = "@property-write";
    @NlsSafe
    public static final String RETURN_TAG = "@return";
    @NlsSafe
    public static final String SEE_TAG = "@see";
    @NlsSafe
    public static final String SINCE_TAG = "@since";
    @NlsSafe
    public static final String REMOVED_TAG = "@removed";
    @NlsSafe
    public static final String SUBPACKAGE_TAG = "@subpackage";
    @NlsSafe
    public static final String THROWS_TAG = "@throws";
    @NlsSafe
    public static final String TODO_TAG = "@todo";
    @NlsSafe
    public static final String USES_TAG = "@uses";
    @NlsSafe
    public static final String USED_BY_TAG = "used-by";
    @NlsSafe
    public static final String VAR_TAG = "@var";
    @NlsSafe
    public static final String VERSION_TAG = "@version";
    @NlsSafe
    public static final String INHERITDOC_TAG = "@inheritDoc";
    @NlsSafe
    public static final String MIXIN_TAG = "@mixin";
    @NlsSafe
    public static final String NOINSPECTION = "@noinspection";
    @NlsSafe
    public static final String TYPE_TAG = "@type";
    public static final String[] ALL_TAGS = new String[]{"@api", "@author", "@category", "@copyright", "@deprecated", "@example", "@filesource", "@global", "@ignore", "@internal", "@license", "@link", "@method", "@package", "@param", "@property", "@property-read", "@property-write", "@return", "@see", "@since", "@subpackage", "@throws", "@todo", "@uses", "used-by", "@var", "@version", "@inheritDoc", "@mixin"};
    private static final Set<String> ALL_TAGS_MAP = new HashSet<String>();
    public static final TokenSet ALLOWED_PHP_DOC_TOKENS;

    private PhpDocUtil() {
    }

    public static String getTagValue(PhpDocTag tagElement) {
        StringBuilder valueBuf = new StringBuilder();
        PsiElement lastChild = tagElement.getLastChild();
        if (lastChild != null && PhpPsiUtil.isOfType(lastChild, (IElementType)PhpDocElementTypes.phpDocTagValue)) {
            PhpDocUtil.appendDescription(valueBuf, lastChild);
        }
        PsiElement nextElement = tagElement.getNextSibling();
        while (nextElement != null && PhpDocUtil.appendDescription(valueBuf, nextElement)) {
            nextElement = PhpDocUtil.getNextSiblingIgnoringInlineDocTagRBrace(nextElement);
        }
        return valueBuf.toString().trim();
    }

    private static PsiElement getNextSiblingIgnoringInlineDocTagRBrace(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        PsiElement nextSibling = element.getNextSibling();
        if (!(element instanceof PhpDocTag)) {
            return nextSibling;
        }
        return PhpDocTagImpl.isInline((PhpDocTag)element) ? nextSibling.getNextSibling() : nextSibling;
    }

    @NotNull
    public static String getDescription(@Nullable PhpDocComment docComment) {
        if (docComment == null) {
            return "";
        }
        StringBuilder descBuf = new StringBuilder();
        PsiElement child = docComment.getFirstChild();
        while (child != null && PhpDocUtil.appendDescription(descBuf, child)) {
            child = PhpDocUtil.getNextSiblingIgnoringInlineDocTagRBrace(child);
        }
        String string = PhpDocMarkdownUtil.markdown2Html(descBuf.toString().trim());
        if (string == null) {
            PhpDocUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static boolean appendDescription(StringBuilder buf, PsiElement element) {
        ASTNode childNode = element.getNode();
        if (childNode == null) {
            return false;
        }
        IElementType currType = childNode.getElementType();
        if (currType == PhpDocTokenTypes.DOC_COMMENT_END || currType == PhpDocElementTypes.phpDocSpecialTag) {
            return false;
        }
        if (element instanceof PhpDocTag) {
            ASTNode prevNode;
            PsiElement prevChild = element.getPrevSibling();
            if (prevChild != null && (prevNode = prevChild.getNode()) != null) {
                if (prevNode.getElementType() != PhpDocTokenTypes.DOC_LBRACE) {
                    return false;
                }
                buf.deleteCharAt(buf.length() - 1);
                buf.append(PhpDocUtil.processInlineTag((PhpDocTag)element));
                return true;
            }
        } else if (currType == PhpDocElementTypes.phpDocTagValue) {
            PsiElement valueChild = element.getFirstChild();
            while (valueChild != null) {
                PsiElement next = valueChild.getNextSibling();
                if (PhpPsiUtil.isOfType(valueChild, PhpDocTokenTypes.DOC_LBRACE) && next instanceof PhpDocTag && PhpDocTagImpl.isInline((PhpDocTag)next)) {
                    buf.append(PhpDocUtil.processInlineTag((PhpDocTag)next));
                    valueChild = PhpDocUtil.getNextSiblingIgnoringInlineDocTagRBrace(next);
                    continue;
                }
                buf.append(valueChild.getNode().getChars());
                valueChild = valueChild.getNextSibling();
            }
            return true;
        }
        if (currType != PhpDocTokenTypes.DOC_LEADING_ASTERISK && currType != PhpDocTokenTypes.DOC_COMMENT_START) {
            int lastEolPos;
            String elementText = element.getText();
            if (childNode.getPsi() instanceof PsiWhiteSpace && childNode.textContains('\n') && (lastEolPos = elementText.lastIndexOf(10)) >= 0) {
                elementText = elementText.substring(0, lastEolPos + 1);
            }
            buf.append(elementText);
        }
        return true;
    }

    private static String processInlineTag(PhpDocTag tagElement) {
        ASTNode node = tagElement.getNode();
        StringBuilder outBuf = new StringBuilder();
        if (node != null) {
            String tagName = null;
            StringBuilder textBuf = new StringBuilder();
            for (ASTNode child = node.getFirstChildNode(); child != null; child = child.getTreeNext()) {
                if (child.getElementType() == PhpDocTokenTypes.DOC_TAG_NAME) {
                    tagName = child.getText();
                    continue;
                }
                if (child.getElementType() == PhpDocElementTypes.phpDocRef) {
                    textBuf.append(child.getText());
                    textBuf.append(" ");
                    continue;
                }
                if (child.getElementType() != PhpDocElementTypes.phpDocTagValue) continue;
                for (ASTNode valueChild = child.getFirstChildNode(); valueChild != null; valueChild = valueChild.getTreeNext()) {
                    textBuf.append(valueChild.getText());
                }
            }
            if (tagName != null) {
                PhpDocUtil.appendInlineTag(outBuf, tagName, textBuf.toString());
                return outBuf.toString();
            }
        }
        return PhpDocUtil.markAsError(tagElement.getText());
    }

    private static void appendInlineTag(@NotNull StringBuilder outBuf, @NotNull String tagName, @NotNull @NlsSafe String tagValue) {
        if (outBuf == null) {
            PhpDocUtil.$$$reportNull$$$0(1);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(2);
        }
        if (tagValue == null) {
            PhpDocUtil.$$$reportNull$$$0(3);
        }
        if (LINK_TAG.equals(tagName) || SEE_TAG.equals(tagName)) {
            String[] chunks = tagValue.split(" ");
            if (chunks.length > 0) {
                String linkValue = chunks[0].trim();
                String linkDesc = tagValue.replace(linkValue, "").trim();
                Object target = !linkValue.startsWith("http://") && !linkValue.startsWith("https://") ? "psi_element://" + linkValue : linkValue;
                outBuf.append(HtmlChunk.link((String)target, (String)(linkDesc.isEmpty() ? linkValue : linkDesc)));
            }
        } else if (INHERITDOC_TAG.equalsIgnoreCase(tagName)) {
            outBuf.append(tagName);
        }
    }

    private static String markAsError(String text) {
        return "<u color='red'>" + text + "</u>";
    }

    public static String extractDefinition(PhpNamedElement psiElement) {
        ASTNode node;
        boolean hasAttribute;
        StringBuilder buf = new StringBuilder();
        boolean bl = hasAttribute = psiElement instanceof PhpAttributesOwner && !((PhpAttributesOwner)psiElement).getAttributes().isEmpty();
        for (PsiElement child = psiElement.getFirstChild(); child != null && ((node = child.getNode()) == null || !PhpElementTypes.ANY_GROUP_STATEMENT.contains(node.getElementType()) && node.getElementType() != PhpTokenTypes.chLBRACE && node.getElementType() != PhpTokenTypes.opCOLON); child = child.getNextSibling()) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.IDENTIFIER)) {
                if (psiElement instanceof PhpClassMember) {
                    PhpClassMemberDocSource.appendLink(buf, (PhpClassMember)psiElement);
                    continue;
                }
                PhpNamedElementDocSource.appendLink(buf, psiElement.getFQN(), psiElement.getNamespaceName());
                continue;
            }
            if (child instanceof ExtendsList || child instanceof ImplementsList) {
                List elements;
                List list = elements = child instanceof ExtendsList ? ((ExtendsList)child).getReferenceElements() : ((ImplementsList)child).getReferenceElements();
                if (elements.isEmpty()) continue;
                buf.append(child instanceof ExtendsList ? "extends " : "implements ");
                for (ClassReference element : elements) {
                    PhpNamedElementDocSource.appendLink(buf, element.getFQN(), element.getNamespaceName());
                    buf.append(", ");
                }
                buf.setLength(buf.length() - 2);
                continue;
            }
            if (child instanceof ParameterList) {
                for (PsiElement parameterListChild = child.getFirstChild(); parameterListChild != null; parameterListChild = parameterListChild.getNextSibling()) {
                    if (parameterListChild instanceof Parameter) {
                        PhpFunctionDocSource.appendParameterSignature((Parameter)parameterListChild, buf, psiElement instanceof PhpDocMethod);
                        continue;
                    }
                    buf.append(PhpDocUtil.prepareText(parameterListChild.getText()));
                }
                continue;
            }
            if (child instanceof PhpAttributesList) {
                PhpDocUtil.appendAttributeListDoc(psiElement, buf, (PhpAttributesList)child);
                continue;
            }
            if (hasAttribute && child instanceof PhpDocComment) continue;
            buf.append(PhpDocUtil.prepareText(child.getText()));
        }
        return buf.toString().trim();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void appendAttributeListDoc(PhpNamedElement psiElement, StringBuilder buf, PhpAttributesList child) {
        @NotNull Collection attributes = child.getAttributes();
        if (!attributes.isEmpty()) {
            buf.append("#[");
            for (PhpAttribute attribute : attributes) {
                String fqn = attribute.getFQN();
                if (fqn == null) continue;
                PhpNamedElementDocSource.appendLink(buf, fqn, PhpLangUtil.getParentNamespaceFQN(fqn));
                Object[] parameters = attribute.getParameters();
                if (parameters.length > 0) {
                    buf.append("(");
                    buf.append(StringUtil.join((Object[])parameters, PsiElement::getText, (String)", "));
                    buf.append(")");
                }
                buf.append(", ");
            }
            buf.setLength(buf.length() - 2);
            buf.append("] ");
        }
    }

    public static String prepareText(String text) {
        String result = text.replace("<code>", "<pre>").replace("</code>", "</pre>").replace("<script", "&lt;script").replace("</script>", "&lt;/script&gt;").replaceAll("\n\\s*\n", "<br>").replaceAll("<([^a-zA-Z/]|$)", "&lt;$1");
        return result;
    }

    @Nullable
    public static String getParamName(@NotNull PhpDocTag docTag, @NotNull Function function) {
        PsiElement nextElement;
        PsiElement tagName;
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(4);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(5);
        }
        if ((tagName = docTag.getFirstChild()) == null || !PARAM_TAG.equals(tagName.getText())) {
            return null;
        }
        for (nextElement = tagName; nextElement != null; nextElement = nextElement.getNextSibling()) {
            String paramName = PhpDocUtil.getParamName(nextElement);
            if (paramName == null) continue;
            return paramName;
        }
        nextElement = docTag.getNextPsiSibling();
        if (nextElement instanceof PsiWhiteSpace) {
            nextElement = nextElement.getNextSibling();
        }
        if (nextElement != null) {
            String candidateName = nextElement.getText();
            for (Parameter parameter : function.getParameters()) {
                if (!candidateName.equals(parameter.getName())) continue;
                return candidateName;
            }
        }
        return null;
    }

    @Nullable
    private static String getParamName(PsiElement element) {
        String text = element.getText();
        if (StringUtil.startsWithChar((CharSequence)text, (char)'$')) {
            text = text.substring(1);
        } else if (text.startsWith("&$")) {
            text = text.substring(2);
        } else if (text.startsWith("...$")) {
            text = text.substring(4);
        } else {
            return null;
        }
        int unlimitedPos = text.indexOf(",...");
        if (unlimitedPos > 0) {
            text = text.substring(0, unlimitedPos);
        }
        return text;
    }

    public static String @NotNull [] getRawParamTypeStrings(@NotNull PhpDocTag docTag, @NotNull Function function) {
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(6);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(7);
        }
        PsiElement tagName = docTag.getFirstChild();
        ArrayList<String> typeStrings = new ArrayList<String>();
        if (tagName != null && PARAM_TAG.equals(tagName.getText())) {
            String text;
            String paramName = PhpDocUtil.getParamName(docTag, function);
            PsiElement nextElement = tagName.getNextSibling();
            if (nextElement instanceof PsiWhiteSpace) {
                nextElement = nextElement.getNextSibling();
            }
            if (!(nextElement == null || StringUtil.startsWithChar((CharSequence)(text = nextElement.getText()), (char)'$') || text.startsWith("&$") || paramName != null && paramName.equals(text))) {
                typeStrings.add(text);
                boolean typeExpected = false;
                for (nextElement = nextElement.getNextSibling(); nextElement != null; nextElement = nextElement.getNextSibling()) {
                    IElementType currType = nextElement.getNode().getElementType();
                    if (currType == PhpDocTokenTypes.DOC_PIPE) {
                        typeExpected = true;
                        continue;
                    }
                    if (nextElement instanceof PsiWhiteSpace) continue;
                    if (!typeExpected) break;
                    typeStrings.add(nextElement.getText());
                    typeExpected = false;
                }
            }
        }
        if (typeStrings.isEmpty()) {
            typeStrings.add("mixed");
        }
        String[] stringArray = ArrayUtilRt.toStringArray(typeStrings);
        if (stringArray == null) {
            PhpDocUtil.$$$reportNull$$$0(8);
        }
        return stringArray;
    }

    public static PhpType getParamType(@NotNull PhpDocTag docTag, @NotNull Function function) {
        PhpType docType;
        if (docTag == null) {
            PhpDocUtil.$$$reportNull$$$0(9);
        }
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(10);
        }
        if (docTag instanceof PhpDocParamTag && docTag.textContains('$') && !(docType = docTag.getGlobalType()).isEmpty()) {
            return docType;
        }
        String[] typeStrings = PhpDocUtil.getRawParamTypeStrings(docTag, function);
        PhpType paramType = new PhpType();
        for (String typeString : typeStrings) {
            paramType.add(PhpDocUtil.getTypeString(typeString, (PhpPsiElement)function));
        }
        return paramType;
    }

    public static String getTypeString(@NotNull String text, @NotNull PhpPsiElement element) {
        if (text == null) {
            PhpDocUtil.$$$reportNull$$$0(11);
        }
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(12);
        }
        String typeString = text;
        if ("$this".equals(text)) {
            return text;
        }
        if ("self".equals(text)) {
            return text;
        }
        if ("static".equals(text)) {
            return text;
        }
        if (PhpType.isPrimitiveType((String)typeString) || PhpType.isPluralPrimitiveType((String)typeString)) {
            return StringUtil.startsWithChar((CharSequence)typeString, (char)'\\') ? typeString : "\\" + typeString;
        }
        typeString = PhpReferenceImpl.findNamespaceName(typeString, (PsiElement)element);
        return typeString;
    }

    @NotNull
    public static String getParamTagValue(PhpDocTag paramTag, Function function) {
        String prefixedString;
        PsiElement childElement = paramTag.getFirstChild();
        if (childElement == null || !PARAM_TAG.equals(childElement.getText())) {
            return "";
        }
        String afterString = PhpDocUtil.getParamName(paramTag, function);
        String string = prefixedString = afterString != null ? "$" + afterString : null;
        if (afterString == null) {
            String[] typeStrings = PhpDocUtil.getRawParamTypeStrings(paramTag, function);
            afterString = typeStrings[typeStrings.length - 1];
        }
        StringBuilder result = new StringBuilder();
        boolean isCollecting = false;
        while (childElement != null) {
            String elementText = childElement.getText();
            if (isCollecting) {
                result.append(elementText);
            }
            if (elementText.equals(afterString) || elementText.equals(prefixedString)) {
                isCollecting = true;
            }
            childElement = childElement.getNextSibling();
        }
        String string2 = result.toString().trim();
        if (string2 == null) {
            PhpDocUtil.$$$reportNull$$$0(13);
        }
        return string2;
    }

    public static boolean isSimpleTag(PsiElement element) {
        IElementType prevType;
        if (!(element instanceof PhpDocTag)) {
            return false;
        }
        PsiElement prev = element.getPrevSibling();
        if (prev instanceof PsiWhiteSpace) {
            prev = prev.getPrevSibling();
        }
        if ((prevType = PsiUtilCore.getElementType((PsiElement)prev)) == PhpDocTokenTypes.DOC_LEADING_ASTERISK || prevType == PhpDocTokenTypes.DOC_COMMENT_LEADING_ASTERISK) {
            PsiElement child = element.getFirstChild();
            if (child instanceof PsiWhiteSpace) {
                child = child.getNextSibling();
            }
            if (PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TAG_NAME)) {
                if (ALL_TAGS_MAP.contains(child.getText())) {
                    return true;
                }
                if ((child = PhpPsiUtil.getNextSiblingIgnoreWhitespace(child, true)) == null) {
                    return true;
                }
                IElementType childType = child.getNode().getElementType();
                if (childType == PhpDocElementTypes.phpDocType || childType == PhpDocElementTypes.phpDocVariable || childType == PhpDocElementTypes.phpDocRef) {
                    return true;
                }
                if (childType == PhpDocElementTypes.phpDocTagValue && ((child = child.getFirstChild()) == null || PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_IDENTIFIER) || PhpPsiUtil.isOfType(child, PhpDocTokenTypes.DOC_TEXT))) {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isInsidePhpDocAttributeList(@NotNull PsiElement element) {
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(14);
        }
        for (PsiElement parent = element.getParent(); parent != null && !(parent instanceof PsiFile) && !(parent instanceof PhpDocComment); parent = parent.getParent()) {
            if (!PhpPsiUtil.isOfType(parent, (IElementType)PhpDocElementTypes.phpDocAttributeList)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDocVarType(@Nullable String tagName) {
        return VAR_TAG.equals(tagName) || GLOBAL_TAG.equals(tagName) || TYPE_TAG.equals(tagName);
    }

    @NotNull
    public static String getTypePresentation(@NotNull Project project, @NotNull PhpType phpType, @Nullable PhpPsiElement scope) {
        if (project == null) {
            PhpDocUtil.$$$reportNull$$$0(15);
        }
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(16);
        }
        return PhpDocUtil.getTypePresentation(project, phpType, scope, null);
    }

    @NotNull
    public static String getTypePresentation(@NotNull Project project, @NotNull PhpType phpType, @Nullable PhpPsiElement scope, @Nullable PhpTypeDeclaration sortBy) {
        if (project == null) {
            PhpDocUtil.$$$reportNull$$$0(17);
        }
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(18);
        }
        PhpCodeStyleSettings codeStyleSettings = scope == null ? null : (PhpCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)scope.getContainingFile(), PhpCodeStyleSettings.class);
        Comparator<String> comparator = PhpDocUtil.docTypesComparator(sortBy, codeStyleSettings);
        return PhpDocUtil.toQualifiedPresentation(phpType.global(project), scope, codeStyleSettings, comparator);
    }

    public static Comparator<String> docTypesComparator(@Nullable PhpTypeDeclaration sortBy, @Nullable PhpCodeStyleSettings codeStyleSettings) {
        Comparator<String> nullOrder = codeStyleSettings == null ? null : PhpDocUtil.nullOrderSettingsComparator(codeStyleSettings);
        Comparator<String> originalOrder = sortBy == null ? String.CASE_INSENSITIVE_ORDER : PhpDocUtil.typeDeclarationComparator(sortBy);
        return nullOrder == null ? originalOrder : nullOrder.thenComparing(originalOrder);
    }

    private static Comparator<String> nullOrderSettingsComparator(@NotNull PhpCodeStyleSettings settings) {
        if (settings == null) {
            PhpDocUtil.$$$reportNull$$$0(19);
        }
        if (settings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.DONT_FORCE) {
            return (a1, a2) -> 0;
        }
        return (o1, o2) -> {
            if ("\\null".equalsIgnoreCase((String)o1)) {
                return settings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING ? -1 : 1;
            }
            if ("\\null".equalsIgnoreCase((String)o2)) {
                return settings.NULL_TYPE_POSITION == PhpCodeStyleSettings.PhpDocNullPosition.IN_THE_BEGINNING ? 1 : -1;
            }
            return 0;
        };
    }

    private static Comparator<String> typeDeclarationComparator(@NotNull PhpTypeDeclaration element) {
        if (element == null) {
            PhpDocUtil.$$$reportNull$$$0(20);
        }
        List references = ContainerUtil.map((Collection)element.getClassReferences(), c -> (String)c.getDeclaredType().global(c.getProject()).getTypes().iterator().next());
        return (o1, o2) -> {
            int i2;
            int i1 = references.indexOf(o1);
            if (i1 == (i2 = references.indexOf(o2))) {
                return String.CASE_INSENSITIVE_ORDER.compare(o1, o2);
            }
            if (i1 < 0) {
                return 1;
            }
            if (i2 < 0) {
                return -1;
            }
            return Integer.compare(i1, i2);
        };
    }

    @NotNull
    public static PhpType getReturnType(@NotNull Function function) {
        PhpType type;
        PhpType globalInferredType;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(21);
        }
        PhpType phpType = (globalInferredType = (type = PhpDocUtil.getDeclaredOrInferredType((PhpTypedElement)function)).global(function.getProject())).filterUnknown().isEmpty() && !type.isEmpty() ? PhpType.MIXED : globalInferredType;
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(22);
        }
        return phpType;
    }

    public static PhpType getParameterType(@NotNull Parameter parameter) {
        if (parameter == null) {
            PhpDocUtil.$$$reportNull$$$0(23);
        }
        PhpType declaredOrInferredType = PhpDocUtil.getDeclaredOrInferredType((PhpTypedElement)parameter).global(parameter.getProject());
        ConstantReference defaultValue = (ConstantReference)ObjectUtils.tryCast((Object)parameter.getDefaultValue(), ConstantReference.class);
        if (defaultValue == null || PhpType.intersects((PhpType)defaultValue.getType(), (PhpType)declaredOrInferredType)) {
            return declaredOrInferredType;
        }
        return PhpType.or((PhpType)declaredOrInferredType, (PhpType)defaultValue.getType());
    }

    private static PhpType getDeclaredOrInferredType(@NotNull PhpTypedElement e) {
        PhpType declaredType;
        if (e == null) {
            PhpDocUtil.$$$reportNull$$$0(24);
        }
        if (!(declaredType = e.getDeclaredType()).isEmpty()) {
            return declaredType;
        }
        return e.getInferredType();
    }

    @NotNull
    public static List<PhpDocTag> collectTagsConsideringInheritance(@NotNull Function function, @NotNull String tagName) {
        SmartList tags2;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(25);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(26);
        }
        if (PhpDocUtil.processFunction(function, tagName, (List<PhpDocTag>)(tags2 = new SmartList())) && function instanceof Method) {
            PhpClassHierarchyUtils.processSuperMethods((Method)((Method)function), (arg_0, arg_1, arg_2) -> PhpDocUtil.lambda$collectTagsConsideringInheritance$4(tagName, (List)tags2, arg_0, arg_1, arg_2));
        }
        SmartList smartList = tags2;
        if (smartList == null) {
            PhpDocUtil.$$$reportNull$$$0(27);
        }
        return smartList;
    }

    private static boolean processFunction(@NotNull Function function, @NotNull String name, @NotNull List<PhpDocTag> tags2) {
        PhpDocComment comment;
        if (function == null) {
            PhpDocUtil.$$$reportNull$$$0(28);
        }
        if (name == null) {
            PhpDocUtil.$$$reportNull$$$0(29);
        }
        if (tags2 == null) {
            PhpDocUtil.$$$reportNull$$$0(30);
        }
        if (!(function instanceof PhpDocMethod) && (comment = function.getDocComment()) != null) {
            tags2.addAll(Arrays.asList(comment.getTagElementsByName(name)));
            if (!comment.hasInheritDocTag()) {
                return false;
            }
        }
        return true;
    }

    public static boolean hasOnlyNoInspectionTag(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(31);
        }
        return PhpDocUtil.hasOnlyTagWithName(comment, NOINSPECTION);
    }

    public static boolean hasOnlyTagWithName(@NotNull PhpDocComment comment, String tagName) {
        List tags2;
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(32);
        }
        if ((tags2 = PhpPsiUtil.getChildren((PsiElement)comment, (Condition<? super PsiElement>)PhpDocTag.INSTANCEOF)).size() != 1) {
            return false;
        }
        PhpDocTag tag = (PhpDocTag)ContainerUtil.getFirstItem(tags2);
        if (tag == null || !tagName.equalsIgnoreCase(tag.getName())) {
            return false;
        }
        for (PsiElement child = comment.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (child instanceof PsiWhiteSpace || child instanceof PhpDocTag || PhpPsiUtil.isOfType(child, ALLOWED_PHP_DOC_TOKENS)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static String toQualifiedPresentation(@NotNull PhpType phpType, @Nullable PhpPsiElement scope, PhpCodeStyleSettings codeStyleSettings, @Nullable Comparator<String> comparator) {
        if (phpType == null) {
            PhpDocUtil.$$$reportNull$$$0(33);
        }
        TreeSet<String> types = phpType.getTypesSorted();
        if (comparator != null) {
            TreeSet<String> sortedTypes = new TreeSet<String>(comparator);
            sortedTypes.addAll((Collection<String>)types);
            types = sortedTypes;
        }
        StringBuilder typeBuilder = new StringBuilder();
        boolean flag = false;
        for (String type : types) {
            if (type.startsWith("?")) continue;
            if (!flag) {
                flag = true;
            } else {
                typeBuilder.append("|");
            }
            String normalizedType = PhpType.toString((String)type);
            if (scope != null && !codeStyleSettings.PHPDOC_USE_FQCN && PhpLangUtil.isFqn(normalizedType)) {
                typeBuilder.append(PhpCodeInsightUtil.createQualifiedName(scope, normalizedType, true, true));
                continue;
            }
            typeBuilder.append(normalizedType);
        }
        String string = typeBuilder.toString();
        if (string == null) {
            PhpDocUtil.$$$reportNull$$$0(34);
        }
        return string;
    }

    public static boolean hasDocTagWithName(@NotNull PhpDocComment docComment, @NotNull String tagName) {
        if (docComment == null) {
            PhpDocUtil.$$$reportNull$$$0(35);
        }
        if (tagName == null) {
            PhpDocUtil.$$$reportNull$$$0(36);
        }
        return !PhpDocUtil.processTagElementsByName(docComment, tagName, (Processor<? super PhpDocTag>)((Processor)tag -> false));
    }

    public static boolean processTagElementsByNames(@NotNull PhpDocComment comment, @NotNull Processor<? super PhpDocTag> processor, String ... tagNames) {
        PhpDocCommentStub stub;
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(37);
        }
        if (processor == null) {
            PhpDocUtil.$$$reportNull$$$0(38);
        }
        PhpDocCommentStub phpDocCommentStub = stub = comment instanceof PhpDocCommentImpl ? (PhpDocCommentStub)((PhpDocCommentImpl)comment).getGreenStub() : null;
        if (stub != null) {
            for (StubElement child : stub.getChildrenStubs()) {
                PhpDocTagStub tagStub;
                String tagStubName;
                if (!(child instanceof PhpDocTagStub) || !ContainerUtil.exists((Object[])tagNames, arg_0 -> PhpDocUtil.lambda$processTagElementsByNames$6(tagStubName = (tagStub = (PhpDocTagStub)child).getName(), arg_0)) || processor.process((Object)tagStub.getPsi())) continue;
                return false;
            }
        } else {
            for (PsiElement child = comment.getFirstChild(); child != null; child = child.getNextSibling()) {
                String name;
                if (!(child instanceof PhpDocTag) || !ContainerUtil.exists((Object[])tagNames, arg_0 -> PhpDocUtil.lambda$processTagElementsByNames$7(name = ((PhpDocTag)child).getName(), arg_0)) || processor.process((Object)((PhpDocTag)child))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean processTagElementsByName(@NotNull PhpDocComment comment, @Nullable String tagName, @NotNull Processor<? super PhpDocTag> processor) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(39);
        }
        if (processor == null) {
            PhpDocUtil.$$$reportNull$$$0(40);
        }
        return PhpDocUtil.processTagElementsByNames(comment, processor, tagName);
    }

    @NotNull
    public static Collection<TextRange> getRangesToHighlight(@NotNull PhpDocComment comment) {
        if (comment == null) {
            PhpDocUtil.$$$reportNull$$$0(41);
        }
        Set set = ContainerUtil.set((Object[])new TextRange[]{comment.getFirstChild().getTextRangeInParent(), comment.getLastChild().getTextRangeInParent()});
        if (set == null) {
            PhpDocUtil.$$$reportNull$$$0(42);
        }
        return set;
    }

    private static /* synthetic */ boolean lambda$processTagElementsByNames$7(String name, String tagName) {
        return tagName == null || tagName.equals(name);
    }

    private static /* synthetic */ boolean lambda$processTagElementsByNames$6(String tagStubName, String tagName) {
        return tagName == null || tagName.equals(tagStubName);
    }

    private static /* synthetic */ boolean lambda$collectTagsConsideringInheritance$4(String tagName, List tags2, Method classMember, PhpClass subClass, PhpClass baseClass) {
        return PhpDocUtil.processFunction((Function)classMember, tagName, tags2);
    }

    static {
        Collections.addAll(ALL_TAGS_MAP, ALL_TAGS);
        ALLOWED_PHP_DOC_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpDocTokenTypes.DOC_COMMENT_START, PhpDocTokenTypes.DOC_LEADING_ASTERISK, PhpDocTokenTypes.DOC_COMMENT_END});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outBuf";
                break;
            }
            case 2: 
            case 26: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagValue";
                break;
            }
            case 4: 
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docTag";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 21: 
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 12: 
            case 14: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 18: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpType";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tags";
                break;
            }
            case 31: 
            case 32: 
            case 37: 
            case 39: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/phpdoc/PhpDocUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawParamTypeStrings";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getParamTagValue";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTagsConsideringInheritance";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "toQualifiedPresentation";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangesToHighlight";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendInlineTag";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getParamName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRawParamTypeStrings";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getParamType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getTypeString";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePhpDocAttributeList";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getTypePresentation";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "nullOrderSettingsComparator";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "typeDeclarationComparator";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getReturnType";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getParameterType";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredOrInferredType";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "collectTagsConsideringInheritance";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processFunction";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyNoInspectionTag";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "hasOnlyTagWithName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "toQualifiedPresentation";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "hasDocTagWithName";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processTagElementsByNames";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processTagElementsByName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getRangesToHighlight";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

