/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.documentation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.lang.documentation.PhpNamedElementDocSource;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocReturnTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.util.PhpStringUtil;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpFunctionDocSource
extends PhpNamedElementDocSource {
    private final Function myFunction;

    public PhpFunctionDocSource(@NotNull Function func) {
        if (func == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(0);
        }
        super((PhpNamedElement)func);
        this.myFunction = func;
    }

    @Override
    @NotNull
    public String getTitle() {
        String string = PhpDocUtil.extractDefinition((PhpNamedElement)this.myFunction);
        if (string == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static void appendParameterSignature(@NotNull Parameter parameter, @NotNull StringBuilder buf, boolean phpDoc) {
        if (parameter == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(2);
        }
        if (buf == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(3);
        }
        for (PhpAttributesList attributeList : PhpPsiUtil.getChildren((PsiElement)parameter, (Condition<? super PsiElement>)((Condition)PhpAttributesList.class::isInstance))) {
            PhpDocUtil.appendAttributeListDoc((PhpNamedElement)parameter, buf, attributeList);
        }
        String declaredTypeSignature = PhpFunctionDocSource.getDeclaredTypeSignature(parameter.getProject(), parameter, phpDoc);
        if (StringUtil.isNotEmpty((String)declaredTypeSignature)) {
            buf.append(declaredTypeSignature).append(" ");
        }
        if (parameter.isPassByRef()) {
            buf.append("&");
        }
        if (parameter.isVariadic()) {
            buf.append("...");
        }
        buf.append("$").append(parameter.getName());
        PsiElement defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            buf.append(" = ").append(defaultValue.getText());
        }
    }

    @Nullable
    private static String getDeclaredTypeSignature(@NotNull Project project, @NotNull Parameter parameter, boolean phpDoc) {
        if (project == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(4);
        }
        if (parameter == null) {
            PhpFunctionDocSource.$$$reportNull$$$0(5);
        }
        Parameter typeReferencesOwner = !phpDoc ? parameter.getTypeDeclaration() : parameter;
        List<ClassReference> typeReferences = PhpPsiUtil.getChildren((PsiElement)typeReferencesOwner, (Condition<? super PsiElement>)ClassReference.INSTANCEOF);
        if (typeReferencesOwner == null || typeReferences.isEmpty()) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        if (PhpPsiUtil.isOfType(typeReferencesOwner.getFirstChild(), PhpTokenTypes.opQUEST)) {
            buf.append("?");
        }
        String namespaceName = parameter.getNamespaceName();
        for (ClassReference typeReference : typeReferences) {
            PhpFunctionDocSource.appendType(buf, typeReference.getType(), namespaceName, project);
            buf.append("|");
        }
        return StringUtil.trimTrailing((StringBuilder)buf, (char)'|').toString();
    }

    @Override
    public String getParameters() {
        StringBuilder paramBuf = new StringBuilder();
        Set<String> processedParametersNames = PhpStringUtil.createCaseInsensitiveSet();
        this.myElement.processDocs(comment -> {
            if (comment == null) {
                return true;
            }
            List paramTags = comment.getParamTags();
            if (paramTags.size() == 0) {
                return true;
            }
            Set<String> processedParametersNamesInCurrentComment = PhpStringUtil.createCaseInsensitiveSet();
            for (PhpDocParamTag paramTag : paramTags) {
                String paramName = paramTag.getVarName();
                if (processedParametersNames.contains(paramName)) continue;
                processedParametersNamesInCurrentComment.add(paramName);
                paramBuf.append("<tr>");
                paramBuf.append("<td valign=top style=\"padding-right:5px;\">");
                PhpFunctionDocSource.appendType(paramBuf, paramTag.isVariadic() ? paramTag.getType().unpluralize() : paramTag.getType(), this.myFunction.getNamespaceName(), paramTag.getProject());
                paramBuf.append("</td>");
                paramBuf.append("<td valign=top style=\"padding-right:5px;\"><b>");
                if (paramTag.isVariadic()) {
                    paramBuf.append("...");
                }
                paramBuf.append("$").append(paramName);
                paramBuf.append("</b></td>");
                paramBuf.append("<td valign=top style=\"padding-right:5px;\">").append(PhpDocUtil.prepareText(paramTag.getTagValue())).append("</td>");
                paramBuf.append("</tr>");
            }
            processedParametersNames.addAll(processedParametersNamesInCurrentComment);
            return false;
        });
        if (paramBuf.length() == 0) {
            return null;
        }
        return "<table>" + paramBuf + "</table>";
    }

    @Override
    public String getReturnDescription() {
        PhpDocComment docComment = this.myDocComment;
        if (docComment == null) {
            return null;
        }
        PhpDocReturnTag retTag = docComment.getReturnTag();
        if (retTag == null) {
            return null;
        }
        return retTag.getTagValue();
    }

    @Override
    public String getThrows() {
        if (this.myDocComment == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        PhpDocTag[] throwsTags = this.myDocComment.getTagElementsByName("@throws");
        if (throwsTags.length == 0) {
            return null;
        }
        buf.append("<table>");
        for (PhpDocTag throwTag : throwsTags) {
            buf.append("<tr valign=top>");
            PhpDocType phpDocType = (PhpDocType)PsiTreeUtil.getChildOfType((PsiElement)throwTag, PhpDocType.class);
            if (phpDocType != null) {
                PhpType type = phpDocType.getType();
                buf.append("<td style=\"padding-right:5px;\">");
                PhpFunctionDocSource.appendType(buf, type, phpDocType.getNamespaceName(), phpDocType.getProject());
                buf.append("</td>").append("<td style=\"padding-right:5px;\">");
            }
            String tagValue = PhpDocUtil.getTagValue(throwTag);
            buf.append(PhpDocUtil.prepareText(tagValue)).append(' ');
            buf.append("</td></tr>");
        }
        buf.append("</table>");
        return buf.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/documentation/PhpFunctionDocSource";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/documentation/PhpFunctionDocSource";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "appendParameterSignature";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaredTypeSignature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

