/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

class PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction
implements IntentionAction {
    private final SmartPsiElementPointer<MethodReference> element;

    PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction(MethodReference reference) {
        this.element = SmartPointerManager.getInstance((Project)reference.getProject()).createSmartPsiElementPointer((PsiElement)reference);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = PhpBundle.message("replace.with.absolute.reference", new Object[0]);
        if (string == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(2);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        String suggestedTraitName;
        MethodReference methodReference;
        if (project == null) {
            PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction.$$$reportNull$$$0(3);
        }
        if ((methodReference = (MethodReference)this.element.getElement()) == null) {
            return;
        }
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)methodReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (containingClass == null) {
            return;
        }
        String methodName = methodReference.getName();
        PhpPsiElement operator = PhpCodeInsightUtil.findScopeForUseOperator((PsiElement)methodReference);
        if (operator == null) {
            return;
        }
        Set possibleTraitNames = Arrays.stream(containingClass.getTraits()).filter(trait -> trait.findMethodByName((CharSequence)methodName) != null).map(trait -> PhpCodeInsightUtil.createQualifiedName(operator, trait.getFQN())).collect(Collectors.toSet());
        PhpTraitUseRule traitUseRule = (PhpTraitUseRule)PhpPsiUtil.getParentByCondition((PsiElement)methodReference, (Condition<? super PsiElement>)PhpTraitUseRule.INSTANCEOF);
        assert (traitUseRule != null);
        String string = suggestedTraitName = possibleTraitNames.isEmpty() ? (String)ArrayUtil.getFirstElement((Object[])traitUseRule.getTraitNames()) : (String)ContainerUtil.getFirstItem(possibleTraitNames);
        if (suggestedTraitName == null) {
            return;
        }
        String absoluteMethodReference = suggestedTraitName + "::" + methodName;
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)methodReference)) {
            return;
        }
        MethodReference replacedElement = (MethodReference)WriteAction.compute(() -> (MethodReference)methodReference.replace((PsiElement)PhpPsiElementFactory.createMethodReference(project, String.format("class bar{use foo{%s insteadof a;}}", absoluteMethodReference))));
        editor.getCaretModel().moveToOffset(replacedElement.getTextRange().getStartOffset());
        TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)replacedElement);
        PhpPsiElement classReference = replacedElement.getFirstPsiChild();
        assert (classReference != null);
        builder.replaceRange(classReference.getTextRange(), (Expression)new ConstantNode(suggestedTraitName).withLookupStrings(possibleTraitNames));
        WriteAction.run(() -> TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate()));
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

