/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import java.util.Collection;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpMakeReturnTypeNullableFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    public PhpMakeReturnTypeNullableFix(@Nullable PsiElement element) {
        super(element);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Function function;
        if (project == null) {
            PhpMakeReturnTypeNullableFix.$$$reportNull$$$0(0);
        }
        if (file == null) {
            PhpMakeReturnTypeNullableFix.$$$reportNull$$$0(1);
        }
        if (startElement == null) {
            PhpMakeReturnTypeNullableFix.$$$reportNull$$$0(2);
        }
        if (endElement == null) {
            PhpMakeReturnTypeNullableFix.$$$reportNull$$$0(3);
        }
        if ((function = (Function)PhpPsiUtil.getParentByCondition(startElement, true, (Condition<? super PsiElement>)Function.INSTANCEOF)) == null) {
            return;
        }
        PhpTypeDeclarationImpl returnTypeElement = (PhpTypeDeclarationImpl)((Object)ObjectUtils.tryCast((Object)function.getTypeDeclaration(), PhpTypeDeclarationImpl.class));
        if (returnTypeElement == null) {
            return;
        }
        Collection<ClassReference> classReferences = returnTypeElement.getClassReferences();
        if (classReferences.size() == 1) {
            returnTypeElement.addBefore(PhpPsiElementFactory.createQuest(project), (PsiElement)ContainerUtil.getFirstItem(classReferences));
        } else {
            returnTypeElement.addTypeReference("null");
        }
        returnTypeElement.update();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = PhpBundle.message("php.annotator.return.type.make.nullable.fix", new Object[0]);
        if (string == null) {
            PhpMakeReturnTypeNullableFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.annotator.return.type.make.nullable.fix", new Object[0]);
        if (string == null) {
            PhpMakeReturnTypeNullableFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpMakeReturnTypeNullableFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpMakeReturnTypeNullableFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

