/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpMakeClassNonFinalQuickFix
extends LocalQuickFixOnPsiElement
implements IntentionAction {
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("php.make.class.non.final.quick.fix.family.name", new Object[0]);
        if (string == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(1);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(2);
        }
        this.removeFinalModifier();
    }

    private void removeFinalModifier() {
        PhpClass phpClass = (PhpClass)ObjectUtils.tryCast((Object)this.getStartElement(), PhpClass.class);
        if (phpClass == null) {
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)phpClass)) {
            return;
        }
        ASTNode finalNode = phpClass.getNode().findChildByType(PhpTokenTypes.kwFINAL);
        if (finalNode == null) {
            return;
        }
        WriteAction.run(() -> finalNode.getPsi().delete());
    }

    public boolean startInWriteAction() {
        return false;
    }

    public PhpMakeClassNonFinalQuickFix(PhpClass aClass) {
        super((PsiElement)aClass);
    }

    @NotNull
    public String getText() {
        PhpClass phpClass = (PhpClass)ObjectUtils.tryCast((Object)this.getStartElement(), PhpClass.class);
        if (phpClass == null) {
            String string = this.getFamilyName();
            if (string == null) {
                PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(3);
            }
            return string;
        }
        String string = PhpBundle.message("intention.name.make.non.final", PhpLangUtil.toPresentableFQN(phpClass.getFQN()));
        if (string == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(5);
        }
        if (file == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(6);
        }
        if (startElement == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(7);
        }
        if (endElement == null) {
            PhpMakeClassNonFinalQuickFix.$$$reportNull$$$0(8);
        }
        this.removeFinalModifier();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpMakeClassNonFinalQuickFix";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpMakeClassNonFinalQuickFix";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

