/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpDeleteElementQuickFix
extends LocalQuickFixOnPsiElement
implements IntentionAction {
    @Nls
    private final String myText;
    private IElementType myDelivery;

    public PhpDeleteElementQuickFix(@NotNull PsiElement element) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(0);
        }
        this(element, PhpBundle.message("quick.fix.delete", element.getText()));
    }

    public PhpDeleteElementQuickFix(@NotNull PsiElement element, @Nls String text) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(1);
        }
        super(element);
        this.myText = text;
    }

    public PhpDeleteElementQuickFix(@NotNull PsiElement element, @Nls String text, @NotNull IElementType delivery) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(2);
        }
        if (delivery == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(3);
        }
        this(element, text);
        this.myDelivery = delivery;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = this.myText;
        if (string == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(6);
        }
        if (file == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(7);
        }
        if (startElement == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(8);
        }
        if (endElement == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(9);
        }
        this.deleteElement(startElement);
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(10);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        PsiElement element;
        if (project == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(11);
        }
        if ((element = this.getStartElement()) != null) {
            this.deleteElement(element);
        }
    }

    private void deleteElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpDeleteElementQuickFix.$$$reportNull$$$0(12);
        }
        if (this.myDelivery != null) {
            PhpCodeEditUtil.removeStatementWithDelivery(element, this.myDelivery);
            return;
        }
        element.delete();
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delivery";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpDeleteElementQuickFix";
                break;
            }
            case 6: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpDeleteElementQuickFix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "deleteElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

