/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.annotator.PhpAnnotatorVisitor;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeTypeQuickFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @Nullable
    private final String myNewTypePresentation;
    @NotNull
    private final String myOldTypePresentation;

    public PhpChangeTypeQuickFix(@NotNull ClassReference currentType, @Nullable String newTypePresentation) {
        if (currentType == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(0);
        }
        super((PsiElement)currentType);
        this.myNewTypePresentation = newTypePresentation;
        this.myOldTypePresentation = currentType.getText();
    }

    @Nls
    @NotNull
    public String getText() {
        String string = this.myNewTypePresentation == null ? PhpBundle.message("quickfix.remove.type", this.myOldTypePresentation) : PhpBundle.message("quickfix.change.type", this.myNewTypePresentation);
        if (string == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.change.type.declaration.family", new Object[0]);
        if (string == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PhpTypeDeclarationImpl typeDeclaration;
        if (project == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(6);
        }
        if ((typeDeclaration = (PhpTypeDeclarationImpl)PsiTreeUtil.getParentOfType((PsiElement)startElement, PhpTypeDeclarationImpl.class)) == null) {
            return;
        }
        if (this.myNewTypePresentation != null) {
            PhpChangeTypeQuickFix.replaceDocType(typeDeclaration, this.myOldTypePresentation, this.myNewTypePresentation);
            startElement.replace((PsiElement)PhpPsiElementFactory.createClassReference(project, this.myNewTypePresentation));
        } else {
            PhpChangeTypeQuickFix.removeDocType(typeDeclaration, this.myOldTypePresentation);
            PhpAnnotatorVisitor.PhpRemoveUnionTypeReference.removeClassReference(startElement);
        }
    }

    private static void replaceDocType(@NotNull PhpTypeDeclarationImpl typeDeclaration, @NotNull String oldType, @NotNull String newType) {
        Collection<PhpDocType> docTypes;
        boolean alreadyContainsNewType;
        if (typeDeclaration == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(7);
        }
        if (oldType == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(8);
        }
        if (newType == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(9);
        }
        if (alreadyContainsNewType = (docTypes = PhpChangeTypeQuickFix.getDocTypes(typeDeclaration)).stream().anyMatch(type -> newType.equalsIgnoreCase(type.getName()))) {
            PhpChangeTypeQuickFix.removeFromDocTypes(docTypes, oldType);
            return;
        }
        docTypes.stream().filter(type -> oldType.equalsIgnoreCase(type.getName())).findFirst().ifPresent(docType -> docType.replace((PsiElement)PhpPsiElementFactory.createPhpDocType(typeDeclaration.getProject(), newType)));
    }

    private static void removeDocType(@NotNull PhpTypeDeclarationImpl typeDeclaration, @NotNull String type) {
        if (typeDeclaration == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(10);
        }
        if (type == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(11);
        }
        Collection<PhpDocType> docTypes = PhpChangeTypeQuickFix.getDocTypes(typeDeclaration);
        PhpChangeTypeQuickFix.removeFromDocTypes(docTypes, type);
    }

    private static void removeFromDocTypes(Collection<PhpDocType> docTypes, @NotNull String type) {
        if (type == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(12);
        }
        docTypes.stream().filter(it -> type.equalsIgnoreCase(it.getName())).findFirst().ifPresent(docTypeToRemove -> PhpCodeEditUtil.removeStatementWithDelivery((PsiElement)docTypeToRemove, PhpDocTokenTypes.DOC_PIPE));
    }

    @NotNull
    private static Collection<PhpDocType> getDocTypes(@NotNull PhpTypeDeclarationImpl typeDeclaration) {
        if (typeDeclaration == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(13);
        }
        Collection collection = Optional.ofNullable(typeDeclaration.getDocTag()).map(docTag -> PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)docTag, PhpDocType.class)).orElse(Collections.emptyList());
        if (collection == null) {
            PhpChangeTypeQuickFix.$$$reportNull$$$0(14);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentType";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpChangeTypeQuickFix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeDeclaration";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpChangeTypeQuickFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replaceDocType";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeDocType";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeFromDocTypes";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDocTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

