/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeFieldTypeToMatchSuperQuickFix;
import com.jetbrains.php.lang.inspections.quickfix.type.PhpChangeReturnTypeQuickFix;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpChangeReturnTypeAnnotatorFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    @NotNull
    private final PhpType myNewType;
    @NotNull
    private final SmartPsiElementPointer<Function> myFunction;
    private final String myNewTypePresentation;
    private final String myCurrentTypePresentation;

    public PhpChangeReturnTypeAnnotatorFix(@NotNull PsiElement element, @NotNull Function function, @NotNull PhpType newType) {
        if (element == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(0);
        }
        if (function == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(1);
        }
        if (newType == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(2);
        }
        super(element);
        Project project = function.getProject();
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
        @NotNull PhpType currentType = function.getDeclaredType();
        this.myNewType = newType;
        this.myFunction = pointerManager.createSmartPsiElementPointer((PsiElement)function);
        this.myNewTypePresentation = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, this.myNewType, (PsiElement)function);
        this.myCurrentTypePresentation = PhpChangeFieldTypeToMatchSuperQuickFix.getDeclaredTypeString(project, currentType, (PsiElement)function);
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        Function function;
        if (project == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(3);
        }
        if (file == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(4);
        }
        if (startElement == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(5);
        }
        if (endElement == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(6);
        }
        if ((function = (Function)this.myFunction.getElement()) == null) {
            return;
        }
        PhpChangeReturnTypeQuickFix.changeReturnType(function, this.myNewType);
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.return.type.name", this.myCurrentTypePresentation, this.myNewTypePresentation);
        if (string == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("quickfix.strict.type.checking.change.return.type.family", new Object[0]);
        if (string == null) {
            PhpChangeReturnTypeAnnotatorFix.$$$reportNull$$$0(8);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endElement";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpChangeReturnTypeAnnotatorFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpChangeReturnTypeAnnotatorFix";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

