/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.google.common.base.Predicates;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.ConstantNode;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.annotation.AnnotationBuilder;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpWorkaroundUtil;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.PhpTargetElementEvaluator;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowImpl;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpGotoLabelDefinitionInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpYieldInstruction;
import com.jetbrains.php.codeInsight.dataFlow.type.PhpTypeConditionDFAnalyzer;
import com.jetbrains.php.completion.PhpCompletionContributor;
import com.jetbrains.php.completion.PhpKeywordsCompletionContributor;
import com.jetbrains.php.config.PhpLanguageFeature;
import com.jetbrains.php.config.PhpLanguageLevel;
import com.jetbrains.php.config.PhpProjectConfigurationFacade;
import com.jetbrains.php.lang.PhpCodeValidationUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.annotator.PhpAdjustMemberAccessFix;
import com.jetbrains.php.lang.annotator.PhpChangeFieldTypeToMatchDefaultValueFix;
import com.jetbrains.php.lang.annotator.PhpChangeParameterTypeToMatchDefaultValueFix;
import com.jetbrains.php.lang.annotator.PhpChangeReturnTypeAnnotatorFix;
import com.jetbrains.php.lang.annotator.PhpChangeTypeQuickFix;
import com.jetbrains.php.lang.annotator.PhpChangeTypeToMatchDefaultValueFix;
import com.jetbrains.php.lang.annotator.PhpDeleteElementQuickFix;
import com.jetbrains.php.lang.annotator.PhpMakeClassNonFinalQuickFix;
import com.jetbrains.php.lang.annotator.PhpMakeReturnTypeNullableFix;
import com.jetbrains.php.lang.annotator.PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction;
import com.jetbrains.php.lang.annotator.PhpSquashRepetitiveUnderscoresWithSingleOneQuickFix;
import com.jetbrains.php.lang.documentation.phpdoc.parser.PhpDocElementTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethod;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocMethodTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocProperty;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocPsiElement;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocType;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocVariable;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocParamTag;
import com.jetbrains.php.lang.documentation.phpdoc.psi.tags.PhpDocTag;
import com.jetbrains.php.lang.highlighter.PhpHighlightingData;
import com.jetbrains.php.lang.inspections.PhpElementIsNotAvailableInCurrentPhpVersionInspection;
import com.jetbrains.php.lang.inspections.PhpInconsistentReturnPointsInspection;
import com.jetbrains.php.lang.inspections.quickfix.PhpExchangeExtendsImplementsQuickFix;
import com.jetbrains.php.lang.inspections.type.PhpIncompatibleReturnTypeInspection;
import com.jetbrains.php.lang.inspections.type.PhpParamsInspection;
import com.jetbrains.php.lang.inspections.type.PhpStrictTypeCheckingInspection;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.PhpTypeCodeFragment;
import com.jetbrains.php.lang.psi.elements.ArrayAccessExpression;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ArrayHashElement;
import com.jetbrains.php.lang.psi.elements.ArrayIndex;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.Catch;
import com.jetbrains.php.lang.psi.elements.ClassConstantReference;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.Constant;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.ControlStatement;
import com.jetbrains.php.lang.psi.elements.Declare;
import com.jetbrains.php.lang.psi.elements.Else;
import com.jetbrains.php.lang.psi.elements.ElseIf;
import com.jetbrains.php.lang.psi.elements.ExtendsList;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.FieldReference;
import com.jetbrains.php.lang.psi.elements.Finally;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ImplementsList;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.MultiassignmentExpression;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpAttributesList;
import com.jetbrains.php.lang.psi.elements.PhpBreak;
import com.jetbrains.php.lang.psi.elements.PhpCase;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassFieldsList;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpContinue;
import com.jetbrains.php.lang.psi.elements.PhpDefaultMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpDefine;
import com.jetbrains.php.lang.psi.elements.PhpElementWithModifier;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpFieldType;
import com.jetbrains.php.lang.psi.elements.PhpGoto;
import com.jetbrains.php.lang.psi.elements.PhpGotoLabel;
import com.jetbrains.php.lang.psi.elements.PhpIsset;
import com.jetbrains.php.lang.psi.elements.PhpMatchArm;
import com.jetbrains.php.lang.psi.elements.PhpMatchExpression;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpModifierList;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpNamespace;
import com.jetbrains.php.lang.psi.elements.PhpNamespaceReference;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.PhpReturn;
import com.jetbrains.php.lang.psi.elements.PhpReturnType;
import com.jetbrains.php.lang.psi.elements.PhpStaticStatement;
import com.jetbrains.php.lang.psi.elements.PhpThrowExpression;
import com.jetbrains.php.lang.psi.elements.PhpTraitUseRule;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclaration;
import com.jetbrains.php.lang.psi.elements.PhpTypeDeclarationOwner;
import com.jetbrains.php.lang.psi.elements.PhpTypedElement;
import com.jetbrains.php.lang.psi.elements.PhpUnset;
import com.jetbrains.php.lang.psi.elements.PhpUse;
import com.jetbrains.php.lang.psi.elements.PhpUseList;
import com.jetbrains.php.lang.psi.elements.PhpYield;
import com.jetbrains.php.lang.psi.elements.SelfAssignmentExpression;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StatementWithArgument;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.UnaryExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.ArrayCreationExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ClassReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.DeclareImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.FieldReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.ForeachImpl;
import com.jetbrains.php.lang.psi.elements.impl.FunctionImpl;
import com.jetbrains.php.lang.psi.elements.impl.MethodImpl;
import com.jetbrains.php.lang.psi.elements.impl.MultiassignmentExpressionImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.ParameterListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassConstantsListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpClassImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpDefineImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpPromotedFieldParameterImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpReferenceImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpTypeDeclarationImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpUseListImpl;
import com.jetbrains.php.lang.psi.elements.impl.PhpYieldImpl;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.lang.psi.resolve.types.PhpTypeSignatureKey;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpFieldsDefaultValueMatcherIndex;
import com.jetbrains.php.lang.psi.stubs.indexes.PhpParametersDefaultValueMatchersIndex;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import com.jetbrains.php.refactoring.PhpMoveClassMemberBase;
import com.jetbrains.php.refactoring.move.constant.PhpMoveFileConstantProcessor;
import com.jetbrains.php.util.PhpFlexibleHeredocHelper;
import com.jetbrains.php.util.PhpStringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpAnnotatorVisitor
extends PhpElementVisitor {
    private static final TokenSet POSSIBLE_TYPE_HINT = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.kwARRAY, PhpTokenTypes.kwCALLABLE, PhpElementTypes.CLASS_REFERENCE, PhpDocElementTypes.phpDocType});
    private static final TokenSet ASSIGNABLE_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{PhpElementTypes.ASSIGNABLE, TokenSet.create((IElementType[])new IElementType[]{PhpElementTypes.ARRAY_CREATION_EXPRESSION})});
    @NotNull
    private static final PhpType ITERATOR_TRAVERSABLE_TYPE = new PhpType().add("\\Traversable").add("\\Iterator");
    private final AnnotationHolder holder;
    private static final boolean isUnitTestMode = ApplicationManager.getApplication().isUnitTestMode();
    private static final PhpType GENERATOR_TYPE = new PhpType().add("\\Generator");
    private static final PhpType PROBABLY_GENERATOR_TYPE = new PhpType().add("\\Iterator").add("\\Traversable").add("\\iterable");
    private static final TokenSet UNSUPPORTED_OPERATORS_FOR_ARRAYS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opMINUS, PhpTokenTypes.opMUL, PhpTokenTypes.opDIV});

    public PhpAnnotatorVisitor(AnnotationHolder holder) {
        this.holder = holder;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(0);
        }
        if (element instanceof LeafPsiElement) {
            PsiElement grandParent;
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.IDENTIFIER) && "match".equalsIgnoreCase(element.getText()) && PhpLanguageFeature.MATCH_EXPRESSION.isSupported(element.getProject()) && !PhpAnnotatorVisitor.isAllowedMatchIdentifierContext(element)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("cannot.use.match.as.identifier", new Object[0]), new IntentionAction[0]);
            }
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.PHP_CLOSING_TAG) && "__halt_compiler();".equals(element.getText()) && !((grandParent = element.getParent().getParent()) instanceof PhpFile) && !(grandParent instanceof PhpNamespace)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("halt.compiler.can.only.be.used.from.the.outermost.scope", new Object[0]), new IntentionAction[0]);
            }
        }
    }

    private static boolean isAllowedMatchIdentifierContext(@NotNull PsiElement matchIdentifier) {
        PsiElement parent;
        if (matchIdentifier == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(1);
        }
        return (parent = matchIdentifier.getParent()) instanceof PhpClassMember || parent instanceof MemberReference || parent instanceof PhpNamespace || parent instanceof PhpNamespaceReference;
    }

    public void visitPhpGroupStatement(GroupStatement groupStatement) {
        super.visitPhpGroupStatement(groupStatement);
        PsiElement child = groupStatement.getFirstChild();
        if (PhpPsiUtil.isOfType(child, PhpElementTypes.EMPTY_INPUT)) {
            this.holder.newAnnotation(HighlightSeverity.WEAK_WARNING, PhpBundle.message("inspection.message.code.fragment.too.complex.to.parse.this.piece.code.will.be.treated.as.plain.text", new Object[0])).range(child).create();
        }
    }

    public void visitPhpNamespace(PhpNamespace namespace) {
        PsiElement parent;
        super.visitPhpNamespace(namespace);
        this.checkControlFlow((PhpScopeHolder)namespace);
        PsiElement firstChild = namespace.getFirstChild();
        PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(firstChild, true);
        if (PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.kwNAMESPACE)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nextSibling, PhpBundle.message("namespace.cannot.start.with.namespace.due.to.conflict.with.ns.relative.names", new Object[0]), new IntentionAction[0]);
        }
        if ("\\".equals(namespace.getFQN()) && !namespace.isBraced() && firstChild != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild, PhpBundle.message("global.namespace.should.use.braced.syntax", new Object[0]), new IntentionAction[0]);
        }
        if (!((parent = namespace.getParent()) instanceof GroupStatement && parent.getParent() instanceof PhpFile || firstChild == null)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild, PhpBundle.message("namespace.declarations.cannot.be.nested", new Object[0]), new IntentionAction[0]);
        }
        this.highlightInfo(namespace.getNameNode(), PhpHighlightingData.IDENTIFIER);
    }

    public void visitPhpStaticStatement(PhpStaticStatement staticStatement) {
        super.visitPhpStaticStatement(staticStatement);
        for (AssignmentExpression expression : staticStatement.getDeclarations()) {
            PhpPsiElement value = expression.getValue();
            if (value == null || PhpCodeValidationUtil.isAllowedAsStaticValue((PsiElement)value)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)value, PhpBundle.message("expression.is.not.allowed.as.static.initializer", new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitPhpAssignmentExpression(AssignmentExpression expr) {
        super.visitPhpAssignmentExpression(expr);
        this.checkIsVariableAssignable((PsiElement)expr.getVariable());
    }

    private void checkIsVariableAssignable(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.ARRAY_VALUE)) {
            this.checkIsVariableAssignable((PsiElement)((PhpPsiElement)element).getFirstPsiChild());
        } else if (element instanceof AssignmentExpression) {
            this.checkIsVariableAssignable((PsiElement)((AssignmentExpression)element).getVariable());
            this.checkIsVariableAssignable((PsiElement)((AssignmentExpression)element).getValue());
        } else if (element instanceof Variable && PhpLangUtil.equalsVariableNames("this", ((Variable)element).getName())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("this.reassignment.is.not.allowed", new Object[0]), new IntentionAction[0]);
        } else if (PhpAnnotatorVisitor.isTemporaryExpression(element)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("cant.use.temporary.expression.in.write.context", new Object[0]), new IntentionAction[0]);
        } else if (!PhpAnnotatorVisitor.isAssignable(element)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("expression.is.not.assignable", new Object[0]), new IntentionAction[0]);
        } else if (element instanceof MemberReference && ((MemberReference)element).hasNullSafeDereference()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, element, PhpBundle.message("can.t.use.nullsafe.operator.in.write.context", new Object[0]), new IntentionAction[0]);
        }
    }

    private static boolean isAssignable(PsiElement element) {
        if (element instanceof FieldReference && PhpPsiUtil.classConstantReferenceViaVariable((FieldReference)element)) {
            return false;
        }
        return PhpPsiUtil.isOfType(element, ASSIGNABLE_TOKENS);
    }

    private static boolean isTemporaryExpression(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        if (element instanceof Variable) {
            return false;
        }
        if (element instanceof ClassReference) {
            return false;
        }
        if (element instanceof MemberReference) {
            PhpExpression reference = ((MemberReference)element).getClassReference();
            return !(reference instanceof FunctionReference) && PhpAnnotatorVisitor.isTemporaryExpression((PsiElement)reference);
        }
        if (element instanceof ArrayAccessExpression) {
            PhpPsiElement value = ((ArrayAccessExpression)element).getValue();
            return !(value instanceof FunctionReference) && PhpAnnotatorVisitor.isTemporaryExpression((PsiElement)value);
        }
        if (element instanceof ArrayCreationExpression && PhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.ARRAY_VALUE)) {
            return false;
        }
        if (element instanceof PhpPsiElement && PhpPsiUtil.isOfType(element, PhpElementTypes.ARRAY_VALUE)) {
            PhpPsiElement value = ((PhpPsiElement)element).getFirstPsiChild();
            return !(value instanceof ArrayCreationExpression) && PhpAnnotatorVisitor.isTemporaryExpression((PsiElement)value);
        }
        return true;
    }

    public void visitPhpExpression(PhpExpression expression) {
        super.visitPhpExpression(expression);
        if (PhpPsiUtil.isOfType((PsiElement)expression, PhpElementTypes.NUMBER)) {
            String text;
            PsiElement child;
            if (expression.getText().contains("__")) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("multiple.subsequent.underscores.in.a.numeric.literal.are.not.allowed", new Object[0]), new PhpSquashRepetitiveUnderscoresWithSingleOneQuickFix(expression));
            }
            if (PhpPsiUtil.isOfType(child = expression.getFirstChild(), PhpTokenTypes.OCTAL_INTEGER) && ((text = PhpPsiUtil.getLiteralText((PsiElement)expression)).indexOf(56) >= 0 || text.indexOf(57) >= 0)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("invalid.octal.literal.won.t.be.reported.by.php.but.will.work.incorrectly", new Object[0]), new IntentionAction[0]);
            }
        }
    }

    public void visitPhpArrayCreationExpression(ArrayCreationExpression expression) {
        boolean multiAssignmentVariable;
        super.visitPhpArrayCreationExpression(expression);
        MultiassignmentExpression parent = (MultiassignmentExpression)PhpPsiUtil.getParentByCondition((PsiElement)expression, false, (Condition<? super PsiElement>)MultiassignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
        boolean bl = multiAssignmentVariable = parent != null && PsiTreeUtil.isAncestor((PsiElement)parent.getFirstPsiChild(), (PsiElement)expression, (boolean)false);
        if (!multiAssignmentVariable) {
            boolean expectedDelimiter = false;
            for (PsiElement child = expression.getFirstChild(); child != null; child = child.getNextSibling()) {
                if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opCOMMA)) {
                    if (!expectedDelimiter) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("cannot.use.empty.array.elements.in.arrays", new Object[0]), new IntentionAction[0]);
                    }
                    expectedDelimiter = false;
                    continue;
                }
                if (!(child instanceof ArrayHashElement) && !PhpPsiUtil.isOfType(child, PhpElementTypes.ARRAY_VALUE)) continue;
                expectedDelimiter = true;
            }
        }
        if (PhpLanguageFeature.SPREAD_OPERATOR_IN_ARRAY.isSupported(expression.getProject())) {
            for (PsiElement child : ArrayCreationExpressionImpl.children(expression)) {
                this.checkPossibleUnpackedArgument((PhpPsiElement)child, multiAssignmentVariable);
            }
        }
    }

    private void checkPossibleUnpackedArgument(PhpPsiElement child, boolean multiAssignmentVariable) {
        if (child instanceof ArrayHashElement) {
            PhpPsiElement value;
            PhpPsiElement key = ((ArrayHashElement)child).getKey();
            if (key != null && ArrayCreationExpressionImpl.isUnpackedArrayArgument(key.getParent())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, key.getParent(), PhpBundle.message("it.s.not.possible.to.unpack.array.key", new Object[0]), new IntentionAction[0]);
            }
            if ((value = ((ArrayHashElement)child).getValue()) != null && ArrayCreationExpressionImpl.isUnpackedArrayArgument(value.getParent())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, value.getParent(), PhpBundle.message("it.s.not.possible.to.unpack.array.value.with.associated.key", new Object[0]), new IntentionAction[0]);
            }
        } else if (ArrayCreationExpressionImpl.isUnpackedArrayArgument((PsiElement)child)) {
            if (multiAssignmentVariable) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)child, PhpBundle.message("spread.operators.in.arrays.are.not.supported.for.multiassignments.variables", new Object[0]), new IntentionAction[0]);
            } else if (PhpPsiUtil.isOfType(child.getFirstChild().getNextSibling(), PhpTokenTypes.opBIT_AND)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)child, PhpBundle.message("it.s.not.possible.to.unpack.array.argument.by.reference", new Object[0]), new IntentionAction[0]);
            }
        }
    }

    public void visitPhpArrayAccessExpression(ArrayAccessExpression expression) {
        super.visitPhpArrayAccessExpression(expression);
        ArrayIndex index = expression.getIndex();
        if (index != expression.getValue() && (index == null || index.getTextLength() == 0)) {
            PsiElement parent = expression.getParent();
            if (parent instanceof ArrayAccessExpression || parent instanceof MultiassignmentExpression || parent instanceof ParameterList || parent instanceof FieldReference) {
                return;
            }
            AssignmentExpression assignmentExpression = (AssignmentExpression)PhpPsiUtil.getParentByCondition(parent, false, (Condition<? super PsiElement>)AssignmentExpression.INSTANCEOF, (Condition<? super PsiElement>)Statement.INSTANCEOF);
            if (assignmentExpression != null) {
                PsiElement parentOfParent;
                Collection<Object> variables;
                Collection<Object> collection = variables = assignmentExpression instanceof MultiassignmentExpression ? ((MultiassignmentExpression)assignmentExpression).getVariables() : Collections.singleton(assignmentExpression.getVariable());
                if (variables.contains(expression)) {
                    return;
                }
                if (assignmentExpression.getValue() == expression && (parentOfParent = parent.getParent()) instanceof AssignmentExpression && ((AssignmentExpression)parentOfParent).getVariable() == parent) {
                    return;
                }
                if (PhpWorkaroundUtil.isAssignByReference(assignmentExpression)) {
                    return;
                }
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("cannot.use.for.reading", new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitComment(@NotNull PsiComment comment) {
        if (comment == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(2);
        }
        if (PhpPsiUtil.isOfType((PsiElement)comment, PhpTokenTypes.LINE_COMMENT) && comment.getText().startsWith("#[")) {
            this.highlightInfo(comment.getNode(), PhpHighlightingData.COMMENT);
        }
    }

    public void visitPhpUnaryExpression(UnaryExpression expr) {
        super.visitPhpUnaryExpression(expr);
        ASTNode node = expr.getNode();
        PhpPsiElement value = expr.getValue();
        if (node != null) {
            IElementType elementType = node.getElementType();
            if (elementType == PhpElementTypes.CLONE_EXPRESSION) {
                PhpType phpType;
                if (value instanceof PhpTypedElement && !(phpType = ((PhpTypedElement)value).getGlobalType()).isAmbiguous() && !PhpAnnotatorVisitor.methodCloneCanBeCalled(expr, phpType)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)value, PhpBundle.message("call.to.method.clone.from.invalid.context", new Object[0]), new IntentionAction[0]);
                }
            } else if (elementType == PhpElementTypes.CAST_EXPRESSION) {
                PsiElement operation = expr.getOperation();
                if (operation == null) {
                    return;
                }
                TextRange castKeywordRange = PhpAnnotatorVisitor.getCastKeywordRange(operation);
                if (castKeywordRange == null) {
                    return;
                }
                TextRange rangeToHighlight = castKeywordRange.shiftRight(operation.getTextRange().getStartOffset());
                this.highlightInfo(rangeToHighlight, PhpHighlightingData.PRIMITIVE_TYPE_HINT);
            }
        }
        if (value != null && PhpPsiUtil.isOfType(expr.getOperation(), com.jetbrains.php.lang.parser.parsing.expressions.UnaryExpression.INC_DEC_OPERATORS)) {
            this.checkIsVariableAssignable((PsiElement)value);
        }
    }

    @Nullable
    public static TextRange getCastKeywordRange(@NotNull PsiElement operation) {
        int start;
        if (operation == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(3);
        }
        String text = operation.getText();
        int end = text.length() - 1;
        for (start = 1; start < text.length() - 1 && Character.isWhitespace(text.charAt(start)); ++start) {
        }
        while (end > 1 && Character.isWhitespace(text.charAt(end - 1))) {
            --end;
        }
        if (start >= end) {
            return null;
        }
        return TextRange.create((int)start, (int)end);
    }

    private static boolean methodCloneCanBeCalled(UnaryExpression expr, PhpType phpType) {
        for (String type : phpType.getTypes()) {
            if (PhpType.isNull((String)type) || PhpType.isMixedType((String)type) || PhpType.isCallableType((String)type)) {
                return true;
            }
            if ((PhpType.isPrimitiveType((String)type) || PhpType.isPluralType((String)type)) && !PhpType.isObject((String)StringUtil.toLowerCase((String)type))) continue;
            Collection classes = PhpIndex.getInstance((Project)expr.getProject()).getClassesByFQN(type);
            if (classes.isEmpty()) {
                return true;
            }
            for (PhpClass clazz : classes) {
                PhpModifier.Access access;
                Method clone = clazz.findMethodByName((CharSequence)"__clone");
                PhpModifier.Access access2 = access = clone == null ? null : clone.getAccess();
                if (clone == null || access == PhpModifier.Access.PUBLIC) {
                    return true;
                }
                Object callerClass = PhpPsiUtil.getParentByCondition((PsiElement)expr, false, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                String caller = callerClass == null ? null : ((PhpClass)callerClass).getFQN();
                if (caller == null || !PhpLangUtil.equalsClassNames(caller, type) && (access != PhpModifier.Access.PROTECTED || !PhpType.findSuper((String)type, (String)caller, (PhpIndex)PhpIndex.getInstance((Project)expr.getProject())))) continue;
                return true;
            }
        }
        return false;
    }

    public void visitPhpBinaryExpression(BinaryExpression expression) {
        PsiElement rightOperand;
        super.visitPhpBinaryExpression(expression);
        if (expression instanceof ConcatenationExpression && !(expression.getParent() instanceof ConcatenationExpression)) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(PhpHighlightingData.PHP_CONCATENATION).create();
        }
        if (expression.getOperationType() == PhpTokenTypes.kwINSTANCEOF && (rightOperand = expression.getRightOperand()) != null) {
            if (PhpAnnotatorVisitor.isFunction(rightOperand)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, rightOperand, PhpBundle.message("function.call.is.not.allowed.here", new Object[0]), new IntentionAction[0]);
            } else if (PhpPsiUtil.isOfType(rightOperand, PhpElementTypes.CLASS_REFERENCE)) {
                this.highlightInfo(rightOperand.getNode(), PhpHighlightingData.CLASS);
            }
        }
        this.checkOperatorsArraySupport(expression);
    }

    private void checkOperatorsArraySupport(@NotNull BinaryExpression expression) {
        if (expression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(4);
        }
        Project project = expression.getProject();
        PsiElement operation = expression.getOperation();
        boolean level800plus = PhpProjectConfigurationFacade.getInstance(project).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP800);
        if (!level800plus && PhpPsiUtil.isOfType(operation, UNSUPPORTED_OPERATORS_FOR_ARRAYS) && StreamEx.of((Object[])new PsiElement[]{expression.getLeftOperand(), expression.getRightOperand()}).map(PhpAnnotatorVisitor::getType).anyMatch(PhpType::isArray)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("arrays.are.not.supported.as.operands.for.0", operation.getText()), new IntentionAction[0]);
        }
    }

    @Nullable
    private static PhpType getType(@Nullable PsiElement operand) {
        return operand instanceof PhpTypedElement ? ((PhpTypedElement)operand).getGlobalType() : null;
    }

    private static boolean isFunction(@NotNull PsiElement operand) {
        PsiElement[] children;
        if (operand == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(5);
        }
        for (PsiElement child : children = operand.getChildren()) {
            if (!PhpPsiUtil.isOfType(child, PhpElementTypes.PARAMETER_LIST)) continue;
            return true;
        }
        return false;
    }

    public void visitPhpSelfAssignmentExpression(SelfAssignmentExpression expression) {
        this.visitPhpAssignmentExpression((AssignmentExpression)expression);
    }

    public void visitPhpMultiassignmentExpression(MultiassignmentExpression multiassignmentExpression) {
        super.visitPhpMultiassignmentExpression(multiassignmentExpression);
        PhpPsiElement child = multiassignmentExpression.getFirstPsiChild();
        this.checkFullSyntaxArrayDestructing(child);
        List variables = multiassignmentExpression.getVariables();
        if (variables.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)(child instanceof ArrayCreationExpression ? child : multiassignmentExpression.getFirstChild()), PhpBundle.message("cannot.use.empty.list", new Object[0]), new IntentionAction[0]);
        }
        for (PhpPsiElement expression : variables) {
            this.checkIsVariableAssignable((PsiElement)expression);
        }
        Collection<PhpPsiElement> keyedEntries = PhpAnnotatorVisitor.getKeyedEntries(variables);
        if (!keyedEntries.isEmpty()) {
            for (PhpPsiElement variable : variables) {
                if (keyedEntries.contains(variable)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, PhpBundle.message("cannot.mix.keyed.and.unkeyed.array.entries.in.assignments", new Object[0]), new IntentionAction[0]);
            }
            this.checkEmptyEntries(multiassignmentExpression, child);
        }
        this.checkSameArrayStyle((PhpPsiElement)(child instanceof ArrayCreationExpression ? child : multiassignmentExpression));
    }

    private void checkSameArrayStyle(PhpPsiElement expression) {
        for (PhpPsiElement child : MultiassignmentExpressionImpl.getChildren((PsiElement)expression)) {
            PsiElement firstChild = child.getFirstChild();
            if (PhpPsiUtil.isOfType(firstChild, PhpTokenTypes.kwLIST)) {
                if (expression instanceof ArrayCreationExpression) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)child, PhpBundle.message("cannot.mix.and.list", new Object[0]), new IntentionAction[]{new PhpReplaceWithArrayQuickFix((PsiElement)child)});
                    continue;
                }
                if (!(firstChild instanceof ArrayCreationExpression)) continue;
                this.checkSameArrayStyle((PhpPsiElement)firstChild);
                continue;
            }
            if (!(firstChild instanceof ArrayCreationExpression)) continue;
            if (!(expression instanceof ArrayCreationExpression)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, firstChild, PhpBundle.message("cannot.mix.and.list", new Object[0]), new IntentionAction[]{new PhpReplaceWithListQuickFix(firstChild)});
                continue;
            }
            this.checkSameArrayStyle((PhpPsiElement)firstChild);
        }
    }

    private void checkFullSyntaxArrayDestructing(PhpPsiElement array) {
        PhpPsiUtil.findChildrenNonStrict((PsiElement)array, ArrayCreationExpression.class).stream().sorted(Comparator.comparingInt(PsiElement::getTextOffset)).filter(Predicate.not(ArrayCreationExpression::isShortSyntax)).findFirst().ifPresent(c -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)c, PhpBundle.message("array.can.t.be.used.for.array.destructuring.assignment", new Object[0]), new IntentionAction[0]));
    }

    @NotNull
    public static Collection<PhpPsiElement> getKeyedEntries(List<PhpPsiElement> variables) {
        List list = ContainerUtil.filter(variables, v -> v.getParent().getParent() instanceof ArrayHashElement);
        if (list == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(6);
        }
        return list;
    }

    private void checkEmptyEntries(MultiassignmentExpression multiassignmentExpression, PhpPsiElement child) {
        Collection commas = Arrays.stream((child instanceof ArrayCreationExpression ? child : multiassignmentExpression).getNode().getChildren(TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.opCOMMA}))).map(ASTNode::getPsi).filter(Objects::nonNull).collect(Collectors.toList());
        for (PsiElement comma : commas) {
            PsiElement prev = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(comma, true);
            if (prev == null || prev instanceof PhpPsiElement) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, TextRange.create((int)prev.getTextRange().getStartOffset(), (int)comma.getTextRange().getEndOffset()), PhpBundle.message("cannot.use.empty.array.entries.in.keyed.array.assignment", new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitPhpVariable(Variable variable) {
        super.visitPhpVariable(variable);
        if (VariableImpl.isVariableVariable(variable)) {
            this.holder.newAnnotation(HighlightSeverity.INFORMATION, PhpBundle.message("annotation.variable.variable", new Object[0])).textAttributes(PhpHighlightingData.VAR_VAR).create();
        } else {
            Function fun = (Function)PhpPsiUtil.getParentByCondition((PsiElement)variable, (Condition<? super PsiElement>)Function.INSTANCEOF);
            if (fun != null) {
                for (Parameter parameter : fun.getParameters()) {
                    if (!PhpLangUtil.equalsVariableNames(parameter.getNameCS(), variable.getNameCS())) continue;
                    this.highlightInfo(variable.getNameNode(), PhpHighlightingData.PARAMETER);
                    break;
                }
            }
        }
        if (PhpLangUtil.equalsVariableNames("this", variable.getName())) {
            this.highlightInfo(variable.getNode(), PhpHighlightingData.THIS_VAR);
            Function f = (Function)PsiTreeUtil.getParentOfType((PsiElement)variable, Function.class);
            boolean level710plus = PhpProjectConfigurationFacade.getInstance(variable.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP710);
            if (f instanceof Method && ((Method)f).isStatic() || !(f instanceof Method) && f != null && !f.isClosure() && level710plus) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, variable.getNameNode(), PhpBundle.message("using.this.when.not.in.object.context", new Object[0]));
            }
        }
    }

    public void visitPhpFunctionCall(FunctionReference reference) {
        super.visitPhpFunctionCall(reference);
        if (StringUtil.isEmpty((String)reference.getName())) {
            long childrenCount;
            PhpPsiElement name = reference.getFirstPsiChild();
            if (name instanceof Variable) {
                PhpType type = ((Variable)name).getGlobalType();
                Set types = type.filterUnknown().getTypes();
                if (!(types.isEmpty() || types.contains("\\mixed") || types.contains("\\string") || types.contains("\\callable") || types.contains("\\array") || types.stream().anyMatch(PhpType::isPluralType) || reference.multiResolve(false).length != 0)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)name, PhpBundle.message("function.name.must.be.callable.a.string.closure.or.class.implementing.invoke.currently.0", type.toStringResolved()), new IntentionAction[0]);
                }
            } else if (name instanceof ArrayCreationExpression && (childrenCount = ArrayCreationExpressionImpl.children((ArrayCreationExpression)name).stream().count()) != 2L) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)name, PhpBundle.message("array.callback.must.have.exactly.two.elements", new Object[0]), new IntentionAction[0]);
            }
        } else {
            ASTNode nameNode = reference.getNameNode();
            if (nameNode != null) {
                if (PhpCompletionContributor.PHP_PREDEFINED_FUNCTIONS.contains(nameNode.getText())) {
                    this.highlightInfo(nameNode, PhpHighlightingData.PREDEFINED_SYMBOL);
                } else {
                    this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION_CALL);
                }
            }
        }
        this.checkCallParamList(reference);
    }

    public void visitPhpParameterList(ParameterList list) {
        super.visitPhpParameterList(list);
        ParameterListOwner owner = (ParameterListOwner)ObjectUtils.tryCast((Object)list.getParent(), ParameterListOwner.class);
        if (owner == null) {
            return;
        }
        for (ParameterListImpl.PhpNamedArgumentPart range : ((ParameterListImpl)list).getNamedArgumentsParts()) {
            this.highlightInfo(range.getNameIdentifier().getNode(), PhpHighlightingData.NAMED_ARGUMENT);
            PsiElement colon = range.getColon();
            this.highlightInfo(colon.getNode(), PhpHighlightingData.NAMED_ARGUMENT);
            PsiElement nextSibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace(colon, true);
            if (!PhpPsiUtil.isOfType(nextSibling, PhpTokenTypes.opVARIADIC)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nextSibling, PhpBundle.message("spread.operator.on.named.arguments.is.forbidden", new Object[0]), new IntentionAction[0]);
        }
        if (!PhpLanguageFeature.NAMED_ARGUMENTS.isSupported(list.getProject())) {
            return;
        }
        this.checkNamedArguments(list, owner);
    }

    private void checkNamedArguments(ParameterList list, ParameterListOwner owner) {
        List<PsiElement> parameters = Arrays.asList(list.getParameters());
        int firstNamedIdentifier = ContainerUtil.indexOf(parameters, p -> ParameterListImpl.getNameIdentifier(p) != null);
        if (firstNamedIdentifier >= 0) {
            this.checkPositionalArgumentsAfterNamed(parameters, firstNamedIdentifier);
            Collection<Function> resolvedFunctions = PhpAnnotatorVisitor.resolveFunctions(owner);
            this.checkDuplicateNamesNamedArguments(parameters, resolvedFunctions);
            Collection functionParameters = resolvedFunctions.stream().flatMap(f -> Arrays.stream(f.getParameters())).collect(Collectors.toSet());
            Collection overriddenMethodParameters = resolvedFunctions.stream().flatMap(f -> f instanceof Method && !(f instanceof PhpDocMethod) ? PhpAnnotatorVisitor.overridingMethods((Method)f) : Stream.of(f)).flatMap(f -> Arrays.stream(f.getParameters())).filter(p -> !functionParameters.contains(p)).collect(Collectors.toSet());
            if (!(resolvedFunctions.isEmpty() || ContainerUtil.exists((Iterable)functionParameters, Parameter::isVariadic) || ContainerUtil.exists((Iterable)overriddenMethodParameters, Parameter::isVariadic))) {
                this.checkUnresolvedNamedArguments(parameters, functionParameters, overriddenMethodParameters);
            }
        }
    }

    private static Stream<Method> overridingMethods(Method method) {
        final ArrayList methods = new ArrayList();
        PhpClassHierarchyUtils.processOverridingMethods((Method)method, (PhpClassHierarchyUtils.TypedHierarchyMemberProcessor)new PhpClassHierarchyUtils.TypedHierarchyMemberProcessor<Method>(){

            public boolean process(Method member, PhpClass subClass, PhpClass baseClass) {
                if (!subClass.isTrait()) {
                    methods.add(member);
                }
                return true;
            }
        });
        return methods.stream();
    }

    public static Collection<Function> resolveFunctions(@Nullable ParameterListOwner owner) {
        PhpReference referenceToResolve = PhpAnnotatorVisitor.getReferenceToResolve(owner);
        if (referenceToResolve == null) {
            return Collections.emptyList();
        }
        return (Collection)StreamEx.of((Object[])referenceToResolve.multiResolve(false)).map(ResolveResult::getElement).select(Function.class).collect(Collectors.toSet());
    }

    @Nullable
    public static PhpReference getReferenceToResolve(@Nullable ParameterListOwner owner) {
        if (owner instanceof PhpAttribute) {
            return ((PhpAttribute)owner).getClassReference();
        }
        if (owner instanceof NewExpression) {
            return ((NewExpression)owner).getClassReference();
        }
        return (PhpReference)ObjectUtils.tryCast((Object)owner, PhpReference.class);
    }

    private void checkUnresolvedNamedArguments(Collection<PsiElement> arguments, Collection<Parameter> resolvedFunctionParameters, Collection<Parameter> overrridenMethodparameters) {
        Collection<String> parametersNames = PhpAnnotatorVisitor.getParametersNames(resolvedFunctionParameters);
        Collection<String> overriddenParametersNames = PhpAnnotatorVisitor.getParametersNames(overrridenMethodparameters);
        for (PsiElement argument : arguments) {
            String name;
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(argument);
            if (nameIdentifier == null || parametersNames.contains(name = nameIdentifier.getText()) || overriddenParametersNames.contains(name)) continue;
            this.createErrorOnNamedArgument(nameIdentifier, PhpBundle.message("unknown.named.parameter", name));
        }
    }

    @NotNull
    private static Collection<String> getParametersNames(Collection<Parameter> resolvedFunctionParameters) {
        Collection collection = (Collection)resolvedFunctionParameters.stream().map(Parameter::getName).collect(Collectors.toCollection(() -> new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE)));
        if (collection == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(7);
        }
        return collection;
    }

    private void checkDuplicateNamesNamedArguments(List<PsiElement> arguments, Collection<Function> resolvedFunctions) {
        HashSet<String> alreadyMappedParameterNames = new HashSet<String>();
        for (int i = 0; i < arguments.size(); ++i) {
            PsiElement nameIdentifier = ParameterListImpl.getNameIdentifier(arguments.get(i));
            String nameOfMappedParam = PhpAnnotatorVisitor.getNameOfMappedParam(resolvedFunctions, arguments, nameIdentifier, i);
            if (nameOfMappedParam == null || alreadyMappedParameterNames.add(nameOfMappedParam) || nameIdentifier == null) continue;
            String message = PhpBundle.message("named.parameter.overwrites.previous.argument", new Object[0]);
            this.createErrorOnNamedArgument(nameIdentifier, message);
        }
    }

    @Nullable
    private static String getNameOfMappedParam(Collection<Function> resolvedFunctions, List<PsiElement> arguments, PsiElement nameIdentifier, int i) {
        Set mappedParameters = resolvedFunctions.stream().map(f -> PhpParamsInspection.getMappedParam(arguments, Arrays.asList(f.getParameters()), i)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (resolvedFunctions.isEmpty() || ContainerUtil.exists(mappedParameters, Parameter::isVariadic)) {
            return nameIdentifier != null ? nameIdentifier.getText() : null;
        }
        return (String)ContainerUtil.getOnlyItem((Collection)ContainerUtil.map2Set(mappedParameters, Parameter::getName));
    }

    @Nullable
    public static String getNameOfMappedParam(List<PsiElement> arguments, List<Parameter> functionParameters, int i) {
        return PhpAnnotatorVisitor.getNameOfMappedParam(functionParameters, ParameterListImpl.getNameIdentifier(arguments.get(i)), i);
    }

    @Nullable
    private static String getNameOfMappedParam(List<Parameter> functionParameters, PsiElement nameIdentifier, int i) {
        return nameIdentifier != null ? nameIdentifier.getText() : (i < functionParameters.size() ? functionParameters.get(i).getName() : null);
    }

    private void createErrorOnNamedArgument(PsiElement nameIdentifier, @Nls String message) {
        TextRange range = PhpAnnotatorVisitor.getRangeWithColon(nameIdentifier);
        this.holder.newAnnotation(HighlightSeverity.ERROR, message).range(range).enforcedTextAttributes(PhpAnnotatorVisitor.getInvalidNamedArgumentTextAttributes()).create();
    }

    @NotNull
    public static TextRange getRangeWithColon(PsiElement nameIdentifier) {
        PsiElement colon = PhpPsiUtil.getNextSiblingIgnoreWhitespace(nameIdentifier, true);
        if (colon == null) {
            TextRange textRange = nameIdentifier.getTextRange();
            if (textRange == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(8);
            }
            return textRange;
        }
        TextRange textRange = TextRange.create((int)nameIdentifier.getTextRange().getStartOffset(), (int)colon.getTextRange().getEndOffset());
        if (textRange == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(9);
        }
        return textRange;
    }

    private static TextAttributes getInvalidNamedArgumentTextAttributes() {
        EditorColorsScheme theme = EditorColorsManager.getInstance().getSchemeForCurrentUITheme();
        TextAttributes namedArgument = theme.getAttributes(PhpHighlightingData.NAMED_ARGUMENT);
        TextAttributes error = theme.getAttributes(CodeInsightColors.ERRORS_ATTRIBUTES);
        return TextAttributes.merge((TextAttributes)namedArgument, (TextAttributes)error);
    }

    private void checkPositionalArgumentsAfterNamed(List<PsiElement> parameters, int firstNamedIdentifier) {
        for (int i = firstNamedIdentifier + 1; i < parameters.size(); ++i) {
            if (ParameterListImpl.getNameIdentifier(parameters.get(i)) != null) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameters.get(i), PhpBundle.message("cannot.use.positional.argument.after.named.argument", new Object[0]), new IntentionAction[0]);
        }
    }

    private void checkCallParamList(FunctionReference reference) {
        PsiElement[] callParams = reference.getParameters();
        int lastUnpacked = Integer.MAX_VALUE;
        for (int i = 0; i < callParams.length; ++i) {
            if (PhpPsiUtil.isArgumentUnpacking(callParams[i])) {
                lastUnpacked = i;
            }
            if (lastUnpacked >= i) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, callParams[i], PhpBundle.message("cannot.use.positional.argument.after.argument.unpacking", new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitPhpIsset(PhpIsset issetExpression) {
        PsiElement[] children;
        super.visitPhpIsset(issetExpression);
        for (PsiElement param : children = issetExpression.getChildren()) {
            if (PhpAnnotatorVisitor.allowedForIssetCheck(param)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, param, PhpBundle.message("isset.only.works.with.variables.and.arrays", new Object[0]), new IntentionAction[]{new PhpReplaceWithNullCheckQuickFix((PsiElement)issetExpression)});
        }
    }

    private static boolean allowedForIssetCheck(PsiElement param) {
        return param instanceof ArrayAccessExpression || param instanceof Variable || param instanceof FieldReference;
    }

    public void visitPhpClassConstantReference(ClassConstantReference reference) {
        super.visitPhpClassConstantReference(reference);
        ASTNode constantNameNode = reference.getNameNode();
        if (reference.isStatic() && !"class".equalsIgnoreCase(reference.getName())) {
            this.highlightInfo(constantNameNode, PhpHighlightingData.CONSTANT);
        }
        this.checkAccessModifiers((MemberReference)reference);
    }

    public void visitPhpFieldReference(FieldReference reference) {
        PsiElement parent;
        super.visitPhpFieldReference(reference);
        this.checkCorrectNullsafeDereferencing((MemberReference)reference);
        this.checkAccessModifiers((MemberReference)reference);
        this.checkClassNameLiteral(reference);
        PsiElement target = reference.resolve();
        ASTNode nameNode = reference.getNameNode();
        if (nameNode != null) {
            if (target instanceof PhpDocPsiElement) {
                this.highlightInfo(reference.getNameNode(), PhpHighlightingData.MAGIC_MEMBER_ACCESS);
            } else {
                parent = nameNode.getPsi().getParent();
                if (!(parent instanceof Variable && VariableImpl.isVariableVariable((Variable)parent) || FieldReferenceImpl.isClassNameLiteral(reference))) {
                    this.highlightInfo(nameNode, reference.getReferenceType().isStatic() ? PhpHighlightingData.STATIC_FIELD : PhpAnnotatorVisitor.getInstanceFieldHighlightingData((Field)ObjectUtils.tryCast((Object)target, Field.class)));
                }
            }
        }
        if (target instanceof PhpDocProperty) {
            parent = reference.getParent();
            CharSequence nameCS = ((PhpDocTag)target.getParent()).getNameCS();
            if (nameCS.equals("@property-read")) {
                if (parent instanceof ArrayAccessExpression && parent.getParent() instanceof AssignmentExpression && ((AssignmentExpression)parent.getParent()).getVariable() == reference.getParent() || parent instanceof AssignmentExpression && ((AssignmentExpression)parent).getVariable() == reference || parent instanceof UnaryExpression && PhpTokenTypes.tsUNARY_POSTFIX_OPS.contains(PsiUtilCore.getElementType((PsiElement)((UnaryExpression)parent).getOperation()))) {
                    if (PhpAnnotatorVisitor.isFieldAccessLocal(reference)) {
                        return;
                    }
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("property.read", new Object[0]), new IntentionAction[0]);
                }
            } else if (nameCS.equals("@property-write") && (!(parent instanceof AssignmentExpression) || ((AssignmentExpression)parent).getVariable() != reference || parent instanceof SelfAssignmentExpression)) {
                if (PhpAnnotatorVisitor.isFieldAccessLocal(reference)) {
                    return;
                }
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("property.write", new Object[0]), new IntentionAction[0]);
            }
        }
    }

    private void checkClassNameLiteral(@NotNull FieldReference reference) {
        PhpType type;
        PhpExpression classReference;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(10);
        }
        if (FieldReferenceImpl.isClassNameLiteral(reference) && (classReference = reference.getClassReference()) != null && !(type = classReference.getGlobalType()).isEmpty() && !PhpType.MIXED.equals((Object)type) && !PhpType.isSubType((PhpType)PhpType.OBJECT, (PhpType)type) && type.filterPrimitives().isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("cannot.use.class.on.primitive.type", new Object[0]), new IntentionAction[0]);
        }
    }

    private static boolean isFieldAccessLocal(FieldReference reference) {
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return false;
        }
        if (classReference instanceof Variable && "this".contentEquals(((Variable)classReference).getNameCS())) {
            return true;
        }
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)reference, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        return containingClass != null && PhpLangUtil.equalsClassNames(PhpLangUtil.toFQN(classReference.getType().toString()), containingClass.getFQN());
    }

    public void visitPhpMethodReference(MethodReference reference) {
        PhpClass resolvedMethodContainingClass;
        super.visitPhpMethodReference(reference);
        this.checkCorrectNullsafeDereferencing((MemberReference)reference);
        PsiElement resolvedElement = reference.resolve();
        if (resolvedElement instanceof PhpDocPsiElement) {
            this.highlightInfo(reference.getNameNode(), PhpHighlightingData.MAGIC_MEMBER_ACCESS);
        } else {
            this.highlightInfo(reference.getNameNode(), reference.isStatic() ? PhpHighlightingData.STATIC_METHOD_CALL : PhpAnnotatorVisitor.getInstanceMethodHighlightingData((Method)ObjectUtils.tryCast((Object)resolvedElement, Method.class)));
        }
        PhpExpression classReference = reference.getClassReference();
        if (PhpLangUtil.equalsFunctionNames("__clone", reference.getNameCS()) && classReference != null && !(classReference.getParent() instanceof PhpUse) && !PhpLangUtil.equalsClassNames("parent", classReference.getName())) {
            ASTNode nameNode = reference.getNameNode();
            if (nameNode == null) {
                return;
            }
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("an.object.s.clone.method.cannot.be.called.directly", new Object[0]));
            return;
        }
        if (PhpAnnotatorVisitor.isSelfOrParentReference(classReference) && resolvedElement instanceof Method && ((Method)resolvedElement).isAbstract() && (resolvedMethodContainingClass = ((Method)resolvedElement).getContainingClass()) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("cannot.call.abstract.method.0.1", resolvedMethodContainingClass.getName(), ((Method)resolvedElement).getName()), new IntentionAction[0]);
        }
        this.checkAccessModifiers((MemberReference)reference, resolvedElement);
        this.checkCallParamList((FunctionReference)reference);
    }

    private void checkCorrectNullsafeDereferencing(MemberReference reference) {
        PsiElement sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)reference.getClassReference(), true);
        if (PhpPsiUtil.isOfType(sibling, PhpTokenTypes.opCOALESCE)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, sibling, PhpBundle.message("incorrect.null.safe.operator", new Object[0]), PhpReplaceWithQuestionQuickFix.INSTANCE);
        }
    }

    private static boolean isSelfOrParentReference(@Nullable PhpExpression classReference) {
        return classReference instanceof ClassReference && (PhpLangUtil.isSelfReference((ClassReference)classReference) || PhpLangUtil.isParentReference((PsiElement)classReference));
    }

    private static TextAttributesKey getInstanceMethodHighlightingData(@Nullable Method method) {
        PhpModifier.Access access = method != null ? method.getAccess() : PhpModifier.Access.PUBLIC;
        switch (access) {
            case PROTECTED: {
                return PhpHighlightingData.PROTECTED_INSTANCE_METHOD_CALL;
            }
            case PRIVATE: {
                return PhpHighlightingData.PRIVATE_INSTANCE_METHOD_CALL;
            }
        }
        return PhpHighlightingData.INSTANCE_METHOD_CALL;
    }

    private void checkAccessModifiers(MemberReference reference) {
        this.checkAccessModifiers(reference, reference.resolve());
    }

    private void checkAccessModifiers(MemberReference reference, PsiElement resolvedElement) {
        PhpModifier.Access access;
        Collection<PhpClass> current;
        ASTNode nameNode = reference.getNameNode();
        if (nameNode == null || nameNode.getTextLength() == 0) {
            return;
        }
        PhpExpression classReference = reference.getClassReference();
        if (classReference == null) {
            return;
        }
        if (!(resolvedElement instanceof PhpClassMember)) {
            return;
        }
        PhpClass declaringClass = ((PhpClassMember)resolvedElement).getContainingClass();
        PhpModifier.Access accessibleInContextAccess = PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess(reference, declaringClass, current = PhpAnnotatorVisitor.resolveCurrentScope(reference, access = ((PhpElementWithModifier)resolvedElement).getModifier().getAccess()));
        if (accessibleInContextAccess.isWeakerThan(access)) {
            boolean hasMagic;
            String magicName = reference instanceof MethodReference ? (reference.isStatic() ? "__callStatic" : "__call") : (reference instanceof FieldReference ? (((FieldReference)reference).isWriteAccess() ? "__set" : "__get") : null);
            boolean bl = hasMagic = declaringClass != null && PhpCodeInsightUtil.hasMagicMethod(declaringClass.getType(), PhpIndex.getInstance((Project)resolvedElement.getProject()), magicName);
            if (!hasMagic && !current.isEmpty()) {
                hasMagic = ContainerUtil.exists(current, c -> PhpAnnotatorVisitor.hasMagic(reference, resolvedElement, classReference, c, magicName));
            }
            if (hasMagic) {
                this.holder.newAnnotation(HighlightSeverity.WARNING, PhpBundle.message("member.has.0.access.but.class.has.magic.method.1", access, magicName)).range(nameNode).create();
            } else {
                this.holder.newAnnotation(HighlightSeverity.ERROR, PhpBundle.message("member.has.0.access", access)).range(nameNode).withFix((IntentionAction)new PhpAdjustMemberAccessFix(reference, accessibleInContextAccess)).create();
            }
        }
    }

    private static boolean hasMagic(MemberReference reference, PsiElement resolvedElement, PhpExpression classReference, PhpClass current, String magicName) {
        String classReferenceName = classReference.getName();
        if (PhpLangUtil.isThisReference(classReferenceName) || PhpLangUtil.equalsClassNames(classReferenceName, current.getNameCS())) {
            Method currentMethod = (Method)PsiTreeUtil.getParentOfType((PsiElement)reference, Method.class);
            return (currentMethod == null || !PhpLangUtil.equalsMethodNames(magicName, currentMethod.getNameCS())) && PhpCodeInsightUtil.hasMagicMethod(current.getType(), PhpIndex.getInstance((Project)resolvedElement.getProject()), magicName);
        }
        return false;
    }

    @NotNull
    public static Collection<PhpClass> resolveCurrentScope(MemberReference reference, PhpModifier.Access access) {
        List closureBoundClasses;
        Function parentFunction = (Function)PhpPsiUtil.getParentByCondition((PsiElement)reference, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (parentFunction != null && parentFunction.isClosure() && !(closureBoundClasses = (List)PhpReferenceImpl.extendedResolve2((PhpReference)reference, PhpAnnotatorVisitor.resolveClosureBoundClasses(parentFunction))).isEmpty()) {
            List list = closureBoundClasses;
            if (list == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(11);
            }
            return list;
        }
        PhpClass current = PhpClassImpl.getContainingClass((PhpPsiElement)reference);
        if (current == null && access != PhpModifier.Access.PUBLIC) {
            current = PhpAnnotatorVisitor.resolveThis((PsiElement)reference);
        }
        Collection<Object> collection = current != null ? Collections.singleton(current) : Collections.emptyList();
        if (collection == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static Collection<PhpClass> resolveClosureBoundClasses(Function function) {
        PsiElement expression = function.getParent();
        if (PhpPsiUtil.isOfType(expression, PhpElementTypes.CLOSURE)) {
            PsiElement parent = expression.getParent();
            if (parent instanceof ParameterList) {
                return PhpAnnotatorVisitor.resolveClosureBoundClassesFromBindCallArgument((MethodReference)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)((Condition)MethodReference.class::isInstance)));
            }
            if (parent instanceof AssignmentExpression) {
                PhpPsiElement variable = ((AssignmentExpression)parent).getVariable();
                if (((AssignmentExpression)parent).getValue() == expression && variable instanceof Variable) {
                    return PhpAnnotatorVisitor.resolveClosureBoundClassesFromVariableUsage(variable);
                }
            }
        }
        return Collections.emptySet();
    }

    @NotNull
    private static Collection<PhpClass> resolveClosureBoundClassesFromVariableUsage(PhpPsiElement variable) {
        PhpAccessVariableInstruction instruction = PhpControlFlowUtil.getAccessInstruction(variable, PhpAccessVariableInstruction.class);
        if (instruction == null) {
            Set<PhpClass> set = Collections.emptySet();
            if (set == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(13);
            }
            return set;
        }
        final CharSequence variableName = instruction.getVariableName();
        final HashSet<PhpClass> res = new HashSet<PhpClass>();
        PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

            public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                if (!PhpLangUtil.equalsVariableNames(variableName, instruction.getVariableName())) {
                    return true;
                }
                if (instruction.getAccess().isWrite()) {
                    return false;
                }
                PsiElement parent = instruction.getAnchor().getParent();
                if (parent instanceof ParameterList) {
                    res.addAll(PhpAnnotatorVisitor.resolveClosureBoundClassesFromBindCallArgument((MethodReference)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)((Condition)MethodReference.class::isInstance))));
                } else if (parent instanceof MethodReference && ((MethodReference)parent).getClassReference() == instruction.getAnchor()) {
                    res.addAll(PhpAnnotatorVisitor.resolveClosureBoundClassesFromBindCallArgument((MethodReference)parent));
                }
                return super.processAccessVariableInstruction(instruction);
            }
        });
        HashSet<PhpClass> hashSet = res;
        if (hashSet == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(14);
        }
        return hashSet;
    }

    private static Collection<PhpClass> resolveClosureBoundClassesFromBindCallArgument(@Nullable MethodReference methodReference) {
        if (methodReference == null) {
            return Collections.emptyList();
        }
        PhpIndex index = PhpIndex.getInstance((Project)methodReference.getProject());
        return PhpAnnotatorVisitor.getReboundScopeFqn(methodReference).stream().flatMap(s -> index.getAnyByFQN(s).stream()).collect(Collectors.toSet());
    }

    @Nullable
    private static PsiElement getReboundArgument(MethodReference methodReference) {
        if (PhpAnnotatorVisitor.isClosureBindToCall(methodReference, "bind")) {
            return methodReference.getParameter(2);
        }
        if (PhpAnnotatorVisitor.isClosureBindToCall(methodReference, "bindTo")) {
            return methodReference.getParameter(1);
        }
        return null;
    }

    private static boolean isClosureBindToCall(MethodReference methodReference, String methodName) {
        if (methodReference == null || !PhpLangUtil.equalsMethodNames(methodReference.getName(), methodName)) {
            return false;
        }
        Set resolvedMethods = (Set)StreamEx.of((Object[])methodReference.multiResolve(false)).map(ResolveResult::getElement).select(Method.class).collect(Collectors.toSet());
        return !resolvedMethods.isEmpty() && ContainerUtil.all((Collection)resolvedMethods, m -> PhpLangUtil.equalsMethodNames("\\Closure." + methodName, m.getFQN()));
    }

    private static Collection<String> getReboundScopeFqn(@Nullable MethodReference methodReference) {
        PsiElement parameter = PhpAnnotatorVisitor.getReboundArgument(methodReference);
        if (parameter == null) {
            return Collections.emptyList();
        }
        String inferredStaticClassName = PhpTypeConditionDFAnalyzer.inferClassName(parameter);
        if (inferredStaticClassName != null) {
            return Collections.singleton(inferredStaticClassName);
        }
        if (parameter instanceof PhpTypedElement) {
            return ((PhpTypedElement)parameter).getGlobalType().filterPrimitives().getTypes();
        }
        return Collections.emptyList();
    }

    @NotNull
    public static PhpModifier.Access getStrictestAccessibleInContextReferenceAccess(@NotNull MemberReference reference, @Nullable PhpClass declaringClass, @NotNull Collection<PhpClass> currentClasses) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(15);
        }
        if (currentClasses == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(16);
        }
        PhpModifier.Access access = currentClasses.stream().map(c -> PhpAnnotatorVisitor.getStrictestAccessibleInContextReferenceAccess(reference, declaringClass, c)).min(Comparator.comparingInt(PhpModifier.Access::getLevel)).orElse(PhpModifier.Access.PUBLIC);
        if (access == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(17);
        }
        return access;
    }

    @NotNull
    private static PhpModifier.Access getStrictestAccessibleInContextReferenceAccess(@NotNull MemberReference reference, @Nullable PhpClass declaringClass, @Nullable PhpClass current) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(18);
        }
        if (current == null) {
            PhpModifier.Access access = PhpModifier.Access.PUBLIC;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(19);
            }
            return access;
        }
        if (declaringClass == null || current == declaringClass) {
            PhpModifier.Access access = PhpModifier.Access.PRIVATE;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(20);
            }
            return access;
        }
        if (!current.isTrait() && !declaringClass.isTrait()) {
            PhpModifier.Access access = PhpAnnotatorVisitor.protectedAccessAccessibleInContext(reference, declaringClass, current) ? PhpModifier.Access.PROTECTED : PhpModifier.Access.PUBLIC;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(21);
            }
            return access;
        }
        if (!current.isTrait() && !PhpClassHierarchyUtils.isMyTrait((PhpClass)current, (PhpClass)declaringClass, null) || !declaringClass.isTrait() && !PhpClassHierarchyUtils.isMyTrait((PhpClass)declaringClass, (PhpClass)current, null)) {
            PhpModifier.Access access = PhpModifier.Access.PROTECTED;
            if (access == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(22);
            }
            return access;
        }
        PhpModifier.Access access = PhpModifier.Access.PRIVATE;
        if (access == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(23);
        }
        return access;
    }

    private static boolean protectedAccessAccessibleInContext(@NotNull MemberReference reference, @NotNull PhpClass declaringClass, @NotNull PhpClass current) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(24);
        }
        if (declaringClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(25);
        }
        if (current == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(26);
        }
        if (PhpClassHierarchyUtils.isSuperClass((PhpClass)declaringClass, (PhpClass)current, (boolean)true)) {
            return true;
        }
        if (PhpClassHierarchyUtils.isSuperClass((PhpClass)current, (PhpClass)declaringClass, (boolean)true)) {
            return true;
        }
        boolean commonSuper = PhpAnnotatorVisitor.hasCommonSuper(reference, declaringClass, current);
        if (commonSuper) {
            return true;
        }
        if (current.isTrait() && !declaringClass.isTrait()) {
            Collection usages = PhpIndex.getInstance((Project)reference.getProject()).getTraitUsages(current);
            return usages.stream().anyMatch(usage -> PhpClassHierarchyUtils.isSuperClass((PhpClass)declaringClass, (PhpClass)usage, (boolean)true));
        }
        return false;
    }

    private static boolean hasCommonSuper(@NotNull MemberReference reference, @NotNull PhpClass declaringClass, @NotNull PhpClass current) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(27);
        }
        if (declaringClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(28);
        }
        if (current == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(29);
        }
        boolean[] commonSuper = new boolean[]{false};
        PhpClassHierarchyUtils.processSuperClasses((PhpClass)current, (boolean)true, (boolean)true, aClass -> {
            if (PhpLangUtil.equalsClassNames("\\___PHPSTORM_HELPERS\\object", aClass.getFQN())) {
                return true;
            }
            if (PhpClassHierarchyUtils.isSuperClass((PhpClass)aClass, (PhpClass)declaringClass, (boolean)true) && aClass.findOwnMethodByName((CharSequence)reference.getName()) != null) {
                commonSuper[0] = true;
            }
            return !commonSuper[0];
        });
        return commonSuper[0];
    }

    @Nullable
    public static PhpClass resolveThis(@NotNull PsiElement position) {
        PhpDocType typeRef;
        PhpNamedElement aThis;
        if (position == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(30);
        }
        if ((aThis = (PhpNamedElement)ContainerUtil.getFirstItem(VariableImpl.collectDeclarations(position, false, "this"))) instanceof PhpDocVariable && (typeRef = (PhpDocType)PhpPsiUtil.getChildByCondition(aThis.getParent(), (Condition<? super PsiElement>)PhpDocType.INSTANCEOF)) != null) {
            return (PhpClass)typeRef.resolve();
        }
        return null;
    }

    public void visitPhpFile(PhpFile file) {
        super.visitPhpFile(file);
        this.checkControlFlow((PhpScopeHolder)file);
        file.accept((PsiElementVisitor)new PhpDeclarationDuplicateCheckerVisitor());
        GroupStatement groupStatement = (GroupStatement)PhpPsiUtil.getChildByCondition((PsiElement)file, (Condition<? super PsiElement>)GroupStatement.INSTANCEOF);
        this.checkNamespaceSyntax(groupStatement);
    }

    private void checkNamespaceSyntax(GroupStatement groupStatement) {
        if (groupStatement != null) {
            PsiElement[] children = groupStatement.getChildren();
            Boolean isBraced = null;
            for (PsiElement it : children) {
                if (!(it instanceof PhpNamespace)) continue;
                PhpNamespace namespace = (PhpNamespace)it;
                String text = PhpBundle.message("multiple.namespaces.in.a.file.should.use.same.preferably.braced.syntax", new Object[0]);
                if (isBraced == null) {
                    isBraced = namespace.isBraced();
                }
                if (isBraced.booleanValue() == namespace.isBraced()) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, namespace.getFirstChild(), text, new IntentionAction[0]);
            }
        }
    }

    public void visitPhpClassReference(ClassReference classReference) {
        Object element;
        super.visitPhpClassReference(classReference);
        String referenceText = classReference.getText();
        if ("self".equalsIgnoreCase(referenceText) || "parent".equalsIgnoreCase(referenceText) || "static".equalsIgnoreCase(referenceText)) {
            this.highlightInfo(classReference.getNode(), PhpHighlightingData.KEYWORD);
        } else if (PhpTargetElementEvaluator.getElementByReference((PsiReference)classReference) != null) {
            this.highlightInfo(classReference.getNameNode(), PhpHighlightingData.ALIAS_REFERENCE);
        } else {
            PsiElement parent = classReference.getParent();
            IElementType parentType = PsiUtilCore.getElementType((PsiElement)parent);
            if (parentType == PhpElementTypes.METHOD_REFERENCE || parentType == PhpElementTypes.FIELD_REFERENCE || parentType == PhpElementTypes.CLASS_CONSTANT_REFERENCE) {
                this.highlightInfo(classReference.getNameNode(), PhpHighlightingData.CLASS);
            }
        }
        if ("static".equalsIgnoreCase(referenceText) && (element = PhpPsiUtil.getParentByCondition((PsiElement)classReference, (Condition<? super PsiElement>)((Condition)element1 -> PhpPsiUtil.isOfType(element1, PhpElementTypes.PARAMETER_DEFAULT_VALUE) || PhpPsiUtil.isOfType(element1, PhpElementTypes.CLASS_CONSTANTS) || PhpPsiUtil.isOfType(element1, PhpElementTypes.CLASS_FIELDS)))) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, classReference.getNode(), PhpBundle.message("static.is.not.allowed.in.compile.time.constants", new Object[0]));
        }
    }

    public void visitPhpNamespaceReference(PhpNamespaceReference reference) {
        super.visitPhpNamespaceReference(reference);
        PsiReference firstReference = (PsiReference)ArrayUtil.getFirstElement((Object[])reference.getReferences());
        if (firstReference != null && PhpTargetElementEvaluator.getElementByReference(firstReference) != null) {
            this.highlightInfo(reference.getFirstChild().getNode(), PhpHighlightingData.ALIAS_REFERENCE);
        }
    }

    public void visitPhpUseList(PhpUseList useList) {
        PsiElement trailingComma;
        PsiElement grandParent;
        super.visitPhpUseList(useList);
        PsiElement parent = useList.getParent();
        PsiElement psiElement = grandParent = parent != null ? parent.getParent() : null;
        if (!(parent instanceof Function) && !(parent instanceof PhpClass) && !(parent instanceof GroupStatement) || parent instanceof GroupStatement && !(grandParent instanceof PhpFile) && !(grandParent instanceof PhpNamespace)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)useList, PhpBundle.message("the.use.keyword.must.be.declared.in.the.outermost.scope.of.a.file.the.global.scope.or.inside.namespace.declarations", new Object[0]), new IntentionAction[0]);
        } else if (!(parent instanceof Function || parent instanceof PhpClass || PhpProjectConfigurationFacade.getInstance(useList.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP720) || (trailingComma = PhpUseListImpl.getTrailingComma(useList)) == null)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, trailingComma, PhpBundle.message("trailing.comma.is.not.allowed", new Object[0]), new IntentionAction[0]);
        }
        if (parent instanceof Function && ((Function)parent).isClosure()) {
            THashSet usedVariableNames = new THashSet();
            for (Variable variable : PhpPsiUtil.getChildren((PsiElement)useList, (Condition<? super PsiElement>)Variable.INSTANCEOF)) {
                if (!usedVariableNames.add(variable.getName())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, PhpBundle.message("duplicate.variable.0", variable.getText()), new IntentionAction[]{new PhpRemoveVariableIntention((PsiElement)variable)});
                }
                if (PhpAnnotatorVisitor.canBeUsedAsLexicalVariable(variable)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)variable, PhpBundle.message("cannot.use.0.as.lexical.variable", variable.getName()), new IntentionAction[0]);
            }
        }
    }

    public static boolean canBeUsedAsLexicalVariable(@NotNull Variable variable) {
        String variableName;
        if (variable == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(31);
        }
        return !"this".equals(variableName = variable.getName()) && !PhpLangUtil.isSuperGlobal(variableName);
    }

    public void visitPhpUse(PhpUse expression) {
        super.visitPhpUse(expression);
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)expression, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF, (Condition<? super PsiElement>)Function.INSTANCEOF);
        PhpReference reference = expression.getTargetReference();
        if (reference != null) {
            String alias;
            PsiElement resolvedElement;
            if (reference.getImmediateNamespaceName().startsWith("\\") && PhpPsiUtil.getParentByCondition((PsiElement)expression, true, PhpUseImpl.USE_BRACES_CONDITION, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF) != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("absolute.reference.is.not.allowed", new Object[0]), new IntentionAction[0]);
            }
            if ((resolvedElement = reference.resolve()) instanceof PhpClass) {
                PhpClass resolvedClass = (PhpClass)resolvedElement;
                boolean isTrait = resolvedClass.isTrait();
                if (expression.isTraitImport() && containingClass != null) {
                    if (!isTrait) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), PhpBundle.message("trait.expected.class.found", new Object[0]));
                    }
                    if (containingClass.isInterface()) {
                        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNode(), PhpBundle.message("cannot.use.traits.inside.of.interfaces", new Object[0]));
                    }
                }
            }
            if (PhpLangUtil.isPhpReservedClassName(alias = expression.getAliasName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, expression.getNameNode(), PhpBundle.message("annotator.special.class.name", reference.getText(), alias));
            }
        }
    }

    public void visitPhpConstantReference(ConstantReference constant) {
        super.visitPhpConstantReference(constant);
        if (PhpLangUtil.isBuiltInConstant(constant)) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(PhpHighlightingData.KEYWORD).create();
        } else {
            this.highlightInfo(constant.getNameNode(), PhpHighlightingData.CONSTANT);
        }
    }

    public void visitPhpClass(final PhpClass clazz) {
        Collection superClasses;
        super.visitPhpClass(clazz);
        ASTNode nameNode = clazz.getNameNode();
        final boolean anInterface = clazz.isInterface();
        String className = clazz.getName();
        if (PhpLangUtil.isPhpReservedClassName(className)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("annotator.reserved.class.name", className));
        }
        this.highlightInfo(nameNode, anInterface ? PhpHighlightingData.INTERFACE : PhpHighlightingData.CLASS);
        if (PhpPsiUtil.getParentByCondition((PsiElement)clazz, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("class.declarations.may.not.be.nested", new Object[0]));
        }
        if (!(superClasses = clazz.getSuperClasses()).isEmpty() && ContainerUtil.all((Collection)superClasses, PhpClass::isFinal) && nameNode != null && nameNode.getTextLength() != 0) {
            AnnotationBuilder annotation = this.holder.newAnnotation(HighlightSeverity.ERROR, PhpBundle.message("inspection.message.class.may.inherit.from.final.class", new Object[0])).range(nameNode);
            if (superClasses.size() == 1) {
                annotation.withFix((IntentionAction)new PhpMakeClassNonFinalQuickFix((PhpClass)ContainerUtil.getFirstItem((Collection)superClasses))).create();
            } else {
                annotation.create();
            }
        }
        ExtendsList extendsList = clazz.getExtendsList();
        List referenceElements = extendsList.getReferenceElements();
        HashSet<String> extendedClasses = new HashSet<String>();
        for (ClassReference it : referenceElements) {
            String itFQN = it.getFQN();
            if (PhpLangUtil.isPhpReservedClassName(it.getName()) && it.getImmediateNamespaceName().isEmpty()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, PhpBundle.message("annotator.reserved.class.name", it.getName()), new IntentionAction[0]);
            } else if (PhpLangUtil.equalsClassNames(clazz.getFQN(), itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("0.should.not.extend.itself", anInterface ? "Interface" : "Class"), new IntentionAction[0]);
            }
            PsiElement element = it.resolve();
            if (element instanceof PhpClass && ((PhpClass)element).isTrait() && !clazz.isTrait()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("class.cannot.extend.from.trait", new Object[0]), new IntentionAction[0]);
            }
            if (!anInterface) continue;
            if (extendedClasses.contains(itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, PhpBundle.message("interface.cannot.extend.previously.extended.interface", new Object[0]), new IntentionAction[0]);
            }
            PhpAnnotatorVisitor.addAllSuperInterfaces(it, extendedClasses);
        }
        this.checkClassRefsOfAppropriateType(clazz, anInterface, referenceElements);
        if (clazz.isTrait() && !referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("a.trait.cannot.extend.a.class", new Object[0]), new IntentionAction[0]);
        }
        if (extendsList.getFirstChild() != null && referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)extendsList, PhpBundle.message("empty.extends.list", new Object[0]), new IntentionAction[0]);
        }
        ImplementsList implementsList = clazz.getImplementsList();
        referenceElements = implementsList.getReferenceElements();
        HashSet<String> implementedInterfaces = new HashSet<String>();
        for (ClassReference it : referenceElements) {
            String itFQN = it.getFQN();
            if (PhpLangUtil.equalsClassNames(clazz.getFQN(), itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, PhpBundle.message("class.should.not.implement.itself", new Object[0]), new IntentionAction[0]);
            }
            if (implementedInterfaces.contains(itFQN)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)it, PhpBundle.message("class.cannot.implement.previously.implemented.interface", new Object[0]), new IntentionAction[0]);
            }
            PhpAnnotatorVisitor.addAllSuperInterfaces(it, implementedInterfaces);
        }
        this.checkClassRefsOfAppropriateType(clazz, true, referenceElements);
        if (clazz.isTrait() && !referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, PhpBundle.message("a.trait.cannot.implement.an.interface", new Object[0]), new IntentionAction[0]);
        }
        if (implementsList.getFirstChild() != null && referenceElements.isEmpty()) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)implementsList, PhpBundle.message("empty.implements.list", new Object[0]), new IntentionAction[0]);
        }
        this.markDuplicateMethods(clazz, false);
        this.markDuplicateFields(clazz, false);
        PhpClassHierarchyUtils.processFields((PhpClass)clazz, (PhpClass)clazz, (PhpClassHierarchyUtils.HierarchyFieldProcessor)new PhpClassHierarchyUtils.HierarchyFieldProcessor(){
            final Map<String, Pair<Field, PhpModifier.Access>> classConstants = new THashMap();
            final Map<String, Field> myStaticSet = new THashMap();
            final Map<String, Field> myNonStaticSet = new THashMap();
            final Map<String, Pair<Field, PhpModifier.Access>> myFieldMap = new THashMap();

            public boolean process(Field field, PhpClass subClass, PhpClass baseClass) {
                if (field instanceof PhpDocProperty) {
                    return false;
                }
                if (field instanceof PhpClassImpl.MyRenamableFakePsiElement) {
                    return true;
                }
                String fieldName = field.getName();
                PhpModifier modifier = field.getModifier();
                PhpModifier.Access superAccess = modifier.getAccess();
                if (field.isConstant()) {
                    if (PhpElementIsNotAvailableInCurrentPhpVersionInspection.notAvailableByRemovedTag((PsiElement)field) || PhpElementIsNotAvailableInCurrentPhpVersionInspection.notAvailableBySinceTag((PsiElement)field)) {
                        return true;
                    }
                    ASTNode nameNode = clazz.getNameNode();
                    if (this.classConstants.containsKey(fieldName)) {
                        PhpModifier.Access childAccess;
                        Field f = (Field)this.classConstants.get((Object)fieldName).first;
                        PhpClass containingClass = f.getContainingClass();
                        if (containingClass == clazz) {
                            nameNode = f.getNameNode();
                        }
                        if (!this.haveSameFQNs(subClass, containingClass) && (anInterface || subClass.isInterface())) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("cannot.inherit.previously.inherited.or.override.constant.0.from.interface.1", fieldName, subClass.getName()));
                        }
                        if (superAccess.isWeakerThan(childAccess = (PhpModifier.Access)this.classConstants.get((Object)fieldName).second)) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("access.level.to.0.1.must.be.2.as.in.class.3.or.weaker2", clazz.getName(), fieldName, superAccess, subClass.getName()));
                            return false;
                        }
                    } else {
                        this.classConstants.put(fieldName, (Pair<Field, PhpModifier.Access>)Pair.create((Object)field, (Object)superAccess));
                    }
                } else {
                    PhpClass containingClass;
                    ASTNode nameNode = null;
                    if (this.myFieldMap.containsKey(fieldName)) {
                        PhpModifier.Access childAccess;
                        Field f = (Field)this.myFieldMap.get((Object)fieldName).first;
                        if (f != null && f.getContainingClass() == clazz) {
                            nameNode = f.getNameNode();
                        }
                        if (superAccess.isWeakerThan(childAccess = (PhpModifier.Access)this.myFieldMap.get((Object)fieldName).second)) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("access.level.to.0.1.must.be.2.as.in.class.3.or.weaker", clazz.getName(), fieldName, superAccess, subClass.getName()));
                            return false;
                        }
                        if (subClass.isTrait() && !baseClass.isTrait() && !PhpAnnotatorVisitor.fieldsAreCompatible(field, f) && ArrayUtil.contains((String)subClass.getFQN(), (String[])baseClass.getTraitNames())) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("0.and.1.define.the.same.property.2", baseClass.getName(), subClass.getName(), fieldName));
                        }
                    } else {
                        this.myFieldMap.put(fieldName, (Pair<Field, PhpModifier.Access>)Pair.create((Object)field, (Object)superAccess));
                    }
                    if (this.myStaticSet.containsKey(fieldName)) {
                        containingClass = this.myStaticSet.get(fieldName).getContainingClass();
                        if (!(this.haveSameFQNs(subClass, containingClass) || modifier.isStatic() || modifier.isPrivate())) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("cannot.redeclare.non.static.0.1.as.static.2.3", subClass.getName(), fieldName, clazz.getName(), fieldName));
                            return false;
                        }
                    } else if (this.myNonStaticSet.containsKey(fieldName)) {
                        containingClass = this.myNonStaticSet.get(fieldName).getContainingClass();
                        if (!this.haveSameFQNs(subClass, containingClass) && modifier.isStatic() && !modifier.isPrivate()) {
                            PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("cannot.redeclare.static.0.1.as.non.static.2.3", subClass.getName(), fieldName, clazz.getName(), fieldName));
                            return false;
                        }
                    } else if (modifier.isStatic()) {
                        this.myStaticSet.put(fieldName, field);
                    } else {
                        this.myNonStaticSet.put(fieldName, field);
                    }
                }
                return true;
            }

            private boolean haveSameFQNs(PhpClass subClass, PhpClass containingClass) {
                return containingClass != null && PhpLangUtil.equalsClassNames(subClass.getFQN(), containingClass.getFQN());
            }
        }, (boolean)false);
        if (clazz.hasTraitUses()) {
            PhpAnnotatorVisitor.checkTraitMethodsConflictsWithAppliedMethods(clazz, this.holder);
        }
    }

    private static boolean fieldsAreCompatible(@Nullable Field field, @Nullable Field another) {
        if (field == null || another == null) {
            return true;
        }
        if (!field.getModifier().getAccess().equals((Object)another.getModifier().getAccess())) {
            return false;
        }
        PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher matcher = PhpFieldsDefaultValueMatcherIndex.getDefaultValueMatcher(field);
        PhpParametersDefaultValueMatchersIndex.PhpParameterDefaultValueMatcher anotherMatcher = PhpFieldsDefaultValueMatcherIndex.getDefaultValueMatcher(another);
        return anotherMatcher == null || matcher == null || anotherMatcher.equals(matcher);
    }

    private void markDuplicateFields(final PhpClass clazz, final boolean docProperties) {
        PhpClassHierarchyUtils.processFields((PhpClass)clazz, (PhpClass)clazz, (PhpClassHierarchyUtils.HierarchyFieldProcessor)new PhpClassHierarchyUtils.HierarchyFieldProcessor(){
            final Set<String> propNames = new THashSet();
            final Set<String> fieldNames = new THashSet();
            final Set<String> constantNames = new THashSet();

            public boolean process(Field field, PhpClass subClass, PhpClass baseClass) {
                Set<String> names = field.isConstant() ? this.constantNames : (PhpPsiUtil.getParentByCondition((PsiElement)field, true, (Condition<? super PsiElement>)PhpDocComment.INSTANCEOF) != null ? this.propNames : this.fieldNames);
                String name = field.getName();
                if (!StringUtil.isEmpty((String)name) && !names.add(name) && docProperties == field instanceof PhpDocProperty) {
                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, field.getNameIdentifier(), PhpBundle.message("0.with.same.name.already.defined.in.this.class", field.isConstant() ? "Constant" : "Field"), new IntentionAction[0]);
                }
                if (!docProperties && subClass.isInterface() && !(field instanceof PhpDocProperty) && !field.isConstant()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, (PsiElement)field, PhpBundle.message("interfaces.may.not.include.member.variables", new Object[0]), PhpAnnotatorVisitor.getFix(field, clazz));
                }
                return true;
            }
        }, (boolean)true);
    }

    @NotNull
    private static IntentionAction getFix(Field field, PhpClass clazz) {
        return field.getDefaultValue() != null && clazz.findFieldByName((CharSequence)field.getName(), true) == null ? new PhpReplaceWithConstantQuickFix(field) : new PhpDeleteFieldQuickFix(field);
    }

    private static void checkTraitMethodsConflictsWithAppliedMethods(@NotNull PhpClass phpClass, AnnotationHolder holder) {
        if (phpClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(32);
        }
        PhpIndex index = PhpIndex.getInstance((Project)phpClass.getProject());
        Set<String> traitMethodsExcludedFromConflicts = PhpAnnotatorVisitor.getTraitsExcludedFromConflicts(phpClass, index, new HashSet<PhpClass>());
        THashMap usedMethodsFromTraits = new THashMap((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        List<PhpUseList> useListElements = PhpPsiUtil.getChildren((PsiElement)phpClass, (Condition<? super PsiElement>)PhpUseList.INSTANCEOF);
        Collection ownMethodNames = Arrays.stream(phpClass.getOwnMethods()).map(PhpNamedElement::getName).collect(PhpStringUtil.toCaseInsensitiveSet());
        for (PhpUseList useList : useListElements) {
            for (PhpUse declaration : useList.getDeclarations()) {
                String traitFqn = PhpAnnotatorVisitor.getTargetReferenceFqn(declaration);
                if (traitFqn == null) continue;
                index.getTraitsByFQN(traitFqn).stream().flatMap(trait -> PhpAnnotatorVisitor.getMethods(trait, new HashSet<PhpClass>(), new HashSet<String>())).filter(traitMethod -> PhpAnnotatorVisitor.canConflict(traitMethod) && !ownMethodNames.contains(traitMethod.getName())).distinct().forEach(arg_0 -> PhpAnnotatorVisitor.lambda$checkTraitMethodsConflictsWithAppliedMethods$18(holder, (Map)usedMethodsFromTraits, declaration, traitMethodsExcludedFromConflicts, traitFqn, arg_0));
            }
            for (PhpTraitUseRule rule : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)useList, PhpTraitUseRule.class)) {
                PhpClass containingClass;
                Method original2;
                String alias = rule.getAlias();
                if (alias == null || rule.isInsteadOf() || ownMethodNames.contains(alias) || !PhpAnnotatorVisitor.canConflict(original2 = rule.getOriginal()) || (containingClass = original2.getContainingClass()) == null) continue;
                PhpAnnotatorVisitor.checkTraitMethodDoestConflictWithExisting(holder, (Map<String, String>)usedMethodsFromTraits, (PsiElement)rule, Collections.emptySet(), alias, containingClass.getFQN());
            }
        }
    }

    @NotNull
    private static Set<String> getTraitsExcludedFromConflicts(@NotNull PhpClass phpClass, PhpIndex index, Collection<PhpClass> visited) {
        if (phpClass == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(33);
        }
        if (!visited.add(phpClass)) {
            Set<String> set = Collections.emptySet();
            if (set == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(34);
            }
            return set;
        }
        THashSet res = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
        Set<Object> exclusions = PhpClassHierarchyUtils.getTraitUseRulesConflictResolutions((Collection)phpClass.traitUseRules().toList()).keySet();
        if (PhpLanguageLevel.current(phpClass.getProject()).isAtLeast(PhpLanguageLevel.PHP730)) {
            exclusions = exclusions.stream().map(s -> PhpTypeSignatureKey.METHOD.sign((CharSequence)PhpTypeSignatureKey.CLASS.sign((CharSequence)s))).flatMap(s -> index.getBySignature(s).stream()).map(PhpNamedElement::getFQN).collect(Collectors.toSet());
        }
        res.addAll(exclusions);
        for (PhpClass trait : phpClass.getTraits()) {
            res.addAll(PhpAnnotatorVisitor.getTraitsExcludedFromConflicts(trait, index, visited));
        }
        THashSet tHashSet = res;
        if (tHashSet == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(35);
        }
        return tHashSet;
    }

    @NotNull
    private static String getConflictingTraitFqn(@NotNull Method traitMethod, @NotNull String originalTraitFqn) {
        PhpClass containingClass;
        if (traitMethod == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(36);
        }
        if (originalTraitFqn == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(37);
        }
        if (PhpProjectConfigurationFacade.getInstance(traitMethod.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP730) && (containingClass = traitMethod.getContainingClass()) != null) {
            String string = containingClass.getFQN();
            if (string == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(38);
            }
            return string;
        }
        String string = originalTraitFqn;
        if (string == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(39);
        }
        return string;
    }

    private static Stream<Method> getMethods(@NotNull PhpClass trait, Set<PhpClass> visited, Collection<String> alreadyImplementedNames) {
        if (trait == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(40);
        }
        List methods = ContainerUtil.filter((Object[])trait.getOwnMethods(), e -> !alreadyImplementedNames.contains(e.getName().toLowerCase()));
        StreamEx result = StreamEx.of((Collection)methods);
        Collection<String> alreadyImplementedNamesWithCurrent = PhpAnnotatorVisitor.unionMethodsNames(alreadyImplementedNames, methods);
        Set conflictResolutions = PhpClassHierarchyUtils.getTraitUseRulesConflictResolutions((Collection)trait.traitUseRules().toList()).keySet();
        for (PhpClass usedTrait : trait.getTraits()) {
            if (!visited.add(usedTrait)) continue;
            result = (StreamEx)result.append(PhpAnnotatorVisitor.getMethods(usedTrait, visited, alreadyImplementedNamesWithCurrent));
        }
        return result.filter(m -> !conflictResolutions.contains(m.getFQN()));
    }

    @NotNull
    private static Collection<String> unionMethodsNames(Collection<String> names, List<Method> methods) {
        Set set = ContainerUtil.union(names, (Collection)ContainerUtil.map2Set(methods, method -> method.getName().toLowerCase()));
        if (set == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(41);
        }
        return set;
    }

    private static boolean canConflict(@Nullable Method traitMethod) {
        return traitMethod != null && !(traitMethod instanceof PhpDocMethod) && !traitMethod.isAbstract();
    }

    @Nullable
    private static String getTargetReferenceFqn(@NotNull PhpUse declaration) {
        PhpReference reference;
        if (declaration == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(42);
        }
        return (reference = declaration.getTargetReference()) != null ? reference.getFQN() : null;
    }

    private static void checkTraitMethodDoestConflictWithExisting(AnnotationHolder holder, Map<String, String> usedMethodsFromTraits, PsiElement elementToRegisterError, Collection<String> traitMethodsExcludedFromConflicts, String methodName, String traitFqn) {
        String conflictTraitFqn;
        if (usedMethodsFromTraits.containsKey(methodName) && !PhpLangUtil.equalsClassNames(conflictTraitFqn = usedMethodsFromTraits.get(methodName), traitFqn) && !traitMethodsExcludedFromConflicts.contains(conflictTraitFqn + "." + methodName) && !traitMethodsExcludedFromConflicts.contains(traitFqn + "." + methodName)) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, elementToRegisterError, PhpBundle.message("trait.method.0.will.not.be.applied.because.it.collides.with.1", methodName, PhpLangUtil.toShortName(conflictTraitFqn)), new IntentionAction[0]);
        }
        usedMethodsFromTraits.put(methodName, traitFqn);
    }

    private static void addAllSuperInterfaces(@NotNull ClassReference reference, @NotNull Set<String> interfaces) {
        PsiElement phpClass;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(43);
        }
        if (interfaces == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(44);
        }
        if ((phpClass = reference.resolve()) instanceof PhpClass && !interfaces.contains(((PhpClass)phpClass).getFQN())) {
            PhpClassHierarchyUtils.processSuperInterfaces((PhpClass)((PhpClass)phpClass), (boolean)true, (boolean)true, superInterface -> {
                interfaces.add(superInterface.getFQN());
                return true;
            });
        }
    }

    private static void createErrorAnnotation(AnnotationHolder holder, @Nullable ASTNode node, @Nls @NotNull String message) {
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(45);
        }
        if (node != null && node.getTextLength() != 0) {
            holder.newAnnotation(HighlightSeverity.ERROR, message).range(node).create();
        }
    }

    private static void createErrorAnnotation(AnnotationHolder holder, @Nullable TextRange e, @Nls @NotNull String message, IntentionAction ... fixes) {
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(46);
        }
        if (fixes == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(47);
        }
        if (e != null && e.getLength() != 0) {
            AnnotationBuilder builder = holder.newAnnotation(HighlightSeverity.ERROR, message).range(e);
            for (IntentionAction fix : fixes) {
                builder = builder.withFix(fix);
            }
            builder.create();
        }
    }

    private static void createErrorAnnotation(AnnotationHolder holder, @NotNull PsiElement e, @Nls @NotNull String message, IntentionAction ... fixes) {
        if (e == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(48);
        }
        if (message == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(49);
        }
        if (fixes == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(50);
        }
        PhpAnnotatorVisitor.createErrorAnnotation(holder, e.getTextRange(), message, fixes);
    }

    public void checkControlFlow(PhpScopeHolder scope) {
        PhpInstruction[] instructions = scope.getControlFlow().getInstructions();
        if (instructions == PhpControlFlowImpl.EMPTY) {
            PsiElement mark = scope.getFirstChild();
            if (mark instanceof GroupStatement) {
                mark = mark.getFirstChild();
            }
            this.holder.newAnnotation(HighlightSeverity.WARNING, PhpBundle.message("inspection.message.control.flow.too.big.to.analyze", new Object[0])).range(mark).create();
        } else {
            THashSet labels = new THashSet();
            for (PhpInstruction instruction : instructions) {
                if (!(instruction instanceof PhpGotoLabelDefinitionInstruction)) continue;
                PhpGotoLabel label = ((PhpGotoLabelDefinitionInstruction)instruction).getLabel();
                String labelName = label.getName();
                if (labels.contains(labelName)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)label, PhpBundle.message("label.with.same.name.already.defined.in.current.scope", new Object[0]), new IntentionAction[0]);
                    continue;
                }
                labels.add(labelName);
            }
        }
    }

    public void visitPhpReturn(PhpReturn returnStatement) {
        Function method = (Function)PhpPsiUtil.getParentByCondition((PsiElement)returnStatement, (Condition<? super PsiElement>)Function.INSTANCEOF);
        if (method instanceof Method && "getIterator".equals(method.getName())) {
            PhpTypedElement returnArgument;
            PhpClass containingClass = ((Method)method).getContainingClass();
            PhpIndex index = PhpIndex.getInstance((Project)returnStatement.getProject());
            if (containingClass != null && PhpType.findSuper((String)"\\IteratorAggregate", (String)containingClass.getFQN(), (PhpIndex)index) && (returnArgument = (PhpTypedElement)ObjectUtils.tryCast((Object)returnStatement.getArgument(), PhpTypedElement.class)) != null) {
                PhpType returnArgumentType = returnArgument.getType();
                if (!ITERATOR_TRAVERSABLE_TYPE.isConvertibleFromGlobal(returnStatement.getProject(), returnArgumentType) && !returnArgumentType.global(returnArgument.getProject()).equals((Object)PhpType.NULL)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnArgument, PhpBundle.message("returned.by.iterator.aggregate.should.be.traversable", new Object[0]), new IntentionAction[0]);
                }
            }
        }
        if (method != null) {
            this.checkReturnStatementNullability(method, returnStatement, (PhpReturnType)method.getTypeDeclaration());
            this.checkNoReturnArgumentForVoidFunction(method, returnStatement);
        }
    }

    private void checkNoReturnArgumentForVoidFunction(@NotNull Function function, @NotNull PhpReturn returnStatement) {
        PsiElement returnArgument;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(51);
        }
        if (returnStatement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(52);
        }
        if ((returnArgument = returnStatement.getArgument()) == null) {
            return;
        }
        if (!PhpIncompatibleReturnTypeInspection.isVoidDeclaredType(function)) {
            return;
        }
        ArrayList<PhpDeleteElementQuickFix> fixes = new ArrayList<PhpDeleteElementQuickFix>();
        fixes.add(new PhpDeleteElementQuickFix(returnArgument, PhpBundle.message("quickfix.delete.return.argument", new Object[0])));
        ContainerUtil.addIfNotNull(fixes, (Object)PhpAnnotatorVisitor.getChangeReturnTypeFix(function, returnArgument));
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, returnArgument, PhpBundle.message("php.annotator.void.function.must.not.return.value", new Object[0]), fixes.toArray(IntentionAction.EMPTY_ARRAY));
    }

    @Nullable
    private static IntentionAction getChangeReturnTypeFix(@NotNull Function function, @Nullable PsiElement returnArgument) {
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(53);
        }
        if (returnArgument == null) {
            return null;
        }
        PhpType returnArgumentType = ((PhpTypedElement)returnArgument).getType().global(function.getProject()).filterUnknown();
        PhpType typeWithoutNull = returnArgumentType.filterNull();
        if (!PhpType.VOID.equals((Object)returnArgumentType) && (typeWithoutNull.size() == 1 || typeWithoutNull.size() > 1 && PhpLanguageFeature.UNION_TYPES.isSupported(function.getProject()))) {
            return new PhpChangeReturnTypeAnnotatorFix(returnArgument, function, returnArgumentType);
        }
        return null;
    }

    private void checkReturnStatementNullability(@NotNull Function function, @NotNull PhpReturn returnStatement, @Nullable PhpReturnType returnTypeElement) {
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(54);
        }
        if (returnStatement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(55);
        }
        if (returnTypeElement == null) {
            return;
        }
        PhpType returnType = returnTypeElement.getGlobalType();
        if (PhpType.intersects((PhpType)returnType, (PhpType)PhpType.VOID) || returnType.isNullable() || returnType.equals((Object)PhpType.MIXED)) {
            return;
        }
        if (PhpType.intersects((PhpType)returnType, (PhpType)GENERATOR_TYPE)) {
            return;
        }
        if (PhpType.intersects((PhpType)returnType, (PhpType)PROBABLY_GENERATOR_TYPE)) {
            return;
        }
        boolean nullablesSupported = PhpLanguageFeature.NULLABLES.isSupported(function.getProject());
        boolean hasNonNullableSuperMethods = PhpAnnotatorVisitor.hasNonNullableSuperMethods(function);
        for (PsiElement returnArgument : PhpIncompatibleReturnTypeInspection.collectArgumentsContributingToReturnType(returnStatement.getArgument())) {
            boolean isNull = PhpLangUtil.isNull(returnArgument);
            if (isNull && nullablesSupported && !hasNonNullableSuperMethods) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, returnArgument, PhpBundle.message("php.annotator.return.type.non.nullable.null.returned", new Object[0]), new IntentionAction[]{new PhpMakeReturnTypeNullableFix(returnArgument)});
                continue;
            }
            if (!isNull) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, returnArgument, PhpBundle.message("php.annotator.return.type.non.nullable.null.returned", new Object[0]), new IntentionAction[0]);
        }
    }

    private static boolean hasNonNullableSuperMethods(@NotNull Function function) {
        Method method;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(56);
        }
        if ((method = (Method)ObjectUtils.tryCast((Object)function, Method.class)) == null) {
            return false;
        }
        return !PhpClassHierarchyUtils.processSuperMethods((Method)method, (superMethod, subClass, baseClass) -> baseClass.isTrait() || superMethod.getTypeDeclaration() == null || ((PhpReturnType)superMethod.getTypeDeclaration()).isNullable());
    }

    public void visitPhpFunction(Function function) {
        super.visitPhpFunction(function);
        if (PhpAnnotatorVisitor.hasYield(function)) {
            this.checkCorrectReturnGeneratorType(function);
        }
        this.checkControlFlow((PhpScopeHolder)function);
        ASTNode nameNode = function.getNameNode();
        if (!function.isClosure()) {
            PsiElement staticKeyword = PhpPsiUtil.getChildOfType((PsiElement)function, PhpTokenTypes.kwSTATIC);
            if (staticKeyword != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, staticKeyword, PhpBundle.message("anonymous.function.expected", new Object[0]), new IntentionAction[0]);
            }
            this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION);
            PsiElement parent = function.getParent();
            if (parent instanceof PhpExpression && PhpPsiUtil.isOfType(parent, PhpElementTypes.CLOSURE) && nameNode != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("anonymous.function.expected", new Object[0]));
            }
        }
        this.checkParametersRedefinition(function);
        PhpReturnType returnTypeElement = (PhpReturnType)function.getTypeDeclaration();
        if (returnTypeElement != null) {
            if (FunctionImpl.isShortArrowFunction(function)) {
                this.checkArrowFunctionReturnType(function, returnTypeElement);
            }
            for (ClassReference classReference : returnTypeElement.getClassReferences()) {
                this.checkInvalidClassName(classReference);
            }
        }
    }

    private void checkArrowFunctionReturnType(@NotNull Function function, @NotNull PhpReturnType returnTypeElement) {
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(57);
        }
        if (returnTypeElement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(58);
        }
        if (returnTypeElement.getType().global(function.getProject()).equals((Object)PhpType.VOID)) {
            PhpExpression returnArgument = (PhpExpression)ObjectUtils.tryCast((Object)FunctionImpl.getShortArrowFunctionArgument(function), PhpExpression.class);
            ArrayList<PhpDeleteElementQuickFix> fixes = new ArrayList<PhpDeleteElementQuickFix>();
            ContainerUtil.addIfNotNull(fixes, (Object)PhpAnnotatorVisitor.getChangeReturnTypeFix(function, (PsiElement)returnArgument));
            fixes.add(new PhpDeleteElementQuickFix((PsiElement)returnTypeElement, PhpBundle.message("delete.void.return.type", new Object[0]), PhpTokenTypes.opCOLON));
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnTypeElement, PhpBundle.message("short.arrow.function.cannot.return.void", new Object[0]), fixes.toArray(IntentionAction.EMPTY_ARRAY));
        }
    }

    private static boolean hasYield(Function function) {
        final Ref hasYield = Ref.create((Object)Boolean.FALSE);
        PhpControlFlowUtil.processFlow(function.getControlFlow(), new PhpInstructionProcessor(){

            public boolean processYieldInstruction(PhpYieldInstruction instruction) {
                hasYield.set((Object)Boolean.TRUE);
                return false;
            }
        });
        return (Boolean)hasYield.get();
    }

    public void visitPhpMethod(Method method) {
        CharSequence name;
        super.visitPhpMethod(method);
        this.checkControlFlow((PhpScopeHolder)method);
        if (!(method instanceof PhpDocMethod) && PhpAnnotatorVisitor.hasYield((Function)method)) {
            this.checkCorrectReturnGeneratorType((Function)method);
        }
        boolean hasBody = PsiTreeUtil.getChildOfType((PsiElement)method, GroupStatement.class) != null;
        boolean isAbstract = method.isAbstract();
        ASTNode nameNode = method.getNameNode();
        this.highlightInfo(nameNode, PhpHighlightingData.FUNCTION);
        if ((!isAbstract && !hasBody || isAbstract && hasBody) && nameNode != null) {
            PhpClass clazz = method.getContainingClass();
            if (clazz != null && clazz.isInterface() && hasBody) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("interface.method.can.t.have.body", new Object[0]));
            } else {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("method.should.either.have.body.or.be.abstract", new Object[0]));
            }
        }
        PsiElement last = method.getLastChild();
        if (!method.isAbstract() && last instanceof LeafPsiElement && last.getText() == ";") {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, last, PhpBundle.message("method.should.not.be.finished.with", new Object[0]), new IntentionAction[0]);
        }
        PhpReturnType returnType = (PhpReturnType)method.getTypeDeclaration();
        if (nameNode != null && returnType != null && (PhpLangUtil.equalsMethodNames("__construct", name = method.getNameCS()) || PhpLangUtil.equalsMethodNames("__destruct", name) || PhpLangUtil.equalsMethodNames("__clone", name) && !PhpLanguageLevel.current(method.getProject()).isAtLeast(PhpLanguageLevel.PHP800))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("return.type.declaration.is.not.allowed", new Object[0]), new IntentionAction[0]);
        }
        if (method instanceof MethodImpl && PhpLanguageLevel.current(method.getProject()).isAtLeast(PhpLanguageLevel.PHP800) && method.getAccess().isPrivate()) {
            PsiElement finalKeyword;
            ASTNode kwFinalNode = ((MethodImpl)method).getModifierList().getNode().findChildByType(PhpTokenTypes.kwFINAL);
            PsiElement psiElement = finalKeyword = kwFinalNode != null ? kwFinalNode.getPsi() : null;
            if (finalKeyword != null) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, finalKeyword, PhpBundle.message("private.methods.cannot.be.final", new Object[0]), new PhpDeleteElementQuickFix(finalKeyword));
            }
        }
        if (returnType != null) {
            for (ClassReference classReference : returnType.getClassReferences()) {
                this.checkInvalidClassName(classReference);
            }
        }
        if (nameNode != null && PhpLangUtil.equalsMethodNames("__clone", method.getNameCS()) && method.getParameters().length != 0) {
            ParameterList parameters = (ParameterList)PhpPsiUtil.getChildByCondition((PsiElement)method, (Condition<? super PsiElement>)ParameterList.INSTANCEOF);
            assert (parameters != null);
            PhpClass containingClass = method.getContainingClass();
            String className = containingClass != null ? containingClass.getName() : "";
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameters, PhpBundle.message("method.0.clone.cannot.accept.any.arguments", className), new IntentionAction[0]);
        }
        this.checkParametersRedefinition((Function)method);
    }

    private void checkParametersRedefinition(@NotNull Function function) {
        Parameter[] parameters;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(59);
        }
        if (PhpProjectConfigurationFacade.getInstance(function.getProject()).getLanguageLevel().isAtLeast(PhpLanguageLevel.PHP700) && (parameters = function.getParameters()).length > 1) {
            if (parameters.length == 2 && parameters[0].getName().equals(parameters[1].getName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameters[1], PhpBundle.message("redefinition.of.parameters.is.not.allowed", new Object[0]), new IntentionAction[0]);
            } else {
                HashSet duplicates = new HashSet();
                Arrays.stream(parameters).filter(parameter -> !duplicates.add(parameter.getName())).forEach(parameter -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, PhpBundle.message("redefinition.of.parameters.is.not.allowed", new Object[0]), new IntentionAction[0]));
            }
        }
    }

    public void visitPhpField(Field field) {
        PsiElement defaultValue;
        super.visitPhpField(field);
        PhpClass aClass = field.getContainingClass();
        assert (aClass != null);
        ASTNode nameNode = field.getNameNode();
        this.highlightFieldNameNode(field, nameNode);
        if (field.isConstant()) {
            if (aClass.isTrait()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)field, PhpBundle.message("traits.cannot.have.constants", new Object[0]), new IntentionAction[0]);
            }
            if (PhpTokenTypes.kwCLASS.equals(PsiUtilCore.getElementType((ASTNode)nameNode))) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, nameNode, PhpBundle.message("a.class.constant.must.not.be.called.class.it.is.reserved.for.class.name.fetching", new Object[0]));
            }
            if ((defaultValue = field.getDefaultValue()) != null && PhpAnnotatorVisitor.expressionHasReferenceToConstant(field, defaultValue)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("cannot.declare.self.referencing.constant", new Object[0]), new IntentionAction[0]);
            }
        }
        if ((defaultValue = field.getDefaultValue()) != null) {
            if (field.isConstant()) {
                if (!PhpCodeValidationUtil.isAllowedAsConstantValue(defaultValue)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("annotation.expression.is.not.allowed.as.class.constant.value", new Object[0]), new IntentionAction[0]);
                }
            } else if (!PhpCodeValidationUtil.isAllowedAsFieldDefaultValue(defaultValue)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("expression.is.not.allowed.as.field.default.value", new Object[0]), new IntentionAction[0]);
            } else if (PhpLanguageFeature.TYPED_PROPERTIES.isSupported(field.getProject())) {
                this.checkTypedPropertyDefaultValue(field, defaultValue);
            }
        }
    }

    private void highlightFieldNameNode(@NotNull Field field, @Nullable ASTNode nameNode) {
        if (field == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(60);
        }
        if (nameNode == null) {
            return;
        }
        if (field.isConstant()) {
            this.highlightInfo(nameNode, PhpHighlightingData.CONSTANT);
        } else {
            this.highlightInfo(nameNode, field.getModifier().isStatic() ? PhpHighlightingData.STATIC_FIELD : PhpAnnotatorVisitor.getInstanceFieldHighlightingData(field));
        }
    }

    private static boolean expressionHasReferenceToConstant(@NotNull Field constant, @NotNull PsiElement expression) {
        if (constant == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(61);
        }
        if (expression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(62);
        }
        return SyntaxTraverser.psiTraverser((PsiElement)expression).filter(ClassConstantReference.class).filter(e -> PhpLangUtil.equalsClassNames(e.getName(), constant.getName())).filter(e -> e.resolve() == constant).isNotEmpty();
    }

    private void checkTypedPropertyDefaultValue(@NotNull Field field, @NotNull PsiElement defaultValue) {
        if (field == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(63);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(64);
        }
        if (!(defaultValue instanceof PhpTypedElement)) {
            return;
        }
        PhpType declaredType = field.getDeclaredType();
        if (declaredType.isEmpty() || declaredType.equals((Object)PhpType.MIXED)) {
            return;
        }
        PhpType defaultValueType = ((PhpTypedElement)defaultValue).getGlobalType();
        if (PhpAnnotatorVisitor.isPropertyDefaultValueTypeCompatible(declaredType, defaultValueType)) {
            return;
        }
        PhpType type = PhpAnnotatorVisitor.getCompatibleType(declaredType, defaultValueType);
        PhpAnnotatorVisitor.createIncompatibleDefaultValueAnnotation(this.holder, declaredType, defaultValue, PhpAnnotatorVisitor.getChangeFieldTypeFixes(field, defaultValue, declaredType, type));
    }

    private static IntentionAction[] getChangeFieldTypeFixes(@NotNull Field field, @NotNull PsiElement defaultValue, @NotNull PhpType declaredType, @Nullable PhpType type) {
        if (field == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(65);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(66);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(67);
        }
        if (type == null || PhpAnnotatorVisitor.isInsideHierarchy((PhpClassMember)field)) {
            return IntentionAction.EMPTY_ARRAY;
        }
        java.util.function.Function<PhpType, PhpChangeTypeToMatchDefaultValueFix> quickFixFactory = newType -> {
            if (defaultValue == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(110);
            }
            return new PhpChangeFieldTypeToMatchDefaultValueFix(defaultValue, declaredType, (PhpType)newType);
        };
        return PhpAnnotatorVisitor.getChangeTypeFixes(defaultValue, declaredType, type, quickFixFactory);
    }

    private static IntentionAction[] getChangeParameterTypeFixes(@NotNull Parameter parameter, @NotNull PsiElement defaultValue, @NotNull PhpType declaredType, @Nullable PhpType type) {
        if (parameter == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(68);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(69);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(70);
        }
        if (type == null) {
            return IntentionAction.EMPTY_ARRAY;
        }
        Method method = (Method)PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Method.INSTANCEOF);
        if (method != null && PhpAnnotatorVisitor.isInsideHierarchy((PhpClassMember)method)) {
            return IntentionAction.EMPTY_ARRAY;
        }
        java.util.function.Function<PhpType, PhpChangeTypeToMatchDefaultValueFix> quickFixFactory = newType -> {
            if (defaultValue == null) {
                PhpAnnotatorVisitor.$$$reportNull$$$0(109);
            }
            return new PhpChangeParameterTypeToMatchDefaultValueFix(defaultValue, declaredType, (PhpType)newType);
        };
        return PhpAnnotatorVisitor.getChangeTypeFixes(defaultValue, declaredType, type, quickFixFactory);
    }

    private static IntentionAction[] getChangeTypeFixes(@NotNull PsiElement defaultValue, @NotNull PhpType declaredType, @NotNull PhpType type, @NotNull java.util.function.Function<PhpType, PhpChangeTypeToMatchDefaultValueFix> typeFixerFactory) {
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(71);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(72);
        }
        if (type == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(73);
        }
        if (typeFixerFactory == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(74);
        }
        ArrayList<PhpChangeTypeToMatchDefaultValueFix> fixes = new ArrayList<PhpChangeTypeToMatchDefaultValueFix>();
        PhpChangeTypeToMatchDefaultValueFix changeFix = typeFixerFactory.apply(ParameterImpl.replaceFalseWithBoolean(type));
        fixes.add(changeFix);
        if (PhpLanguageFeature.UNION_TYPES.isSupported(defaultValue.getProject())) {
            PhpType appendedType = new PhpType().add(declaredType).add(type);
            fixes.add((PhpChangeTypeToMatchDefaultValueFix)((IntentionAction)typeFixerFactory.apply(appendedType)));
            if (appendedType.getTypes().contains("\\false")) {
                fixes.add((PhpChangeTypeToMatchDefaultValueFix)((IntentionAction)typeFixerFactory.apply(ParameterImpl.replaceFalseWithBoolean(appendedType))));
            }
        }
        return fixes.toArray(IntentionAction.EMPTY_ARRAY);
    }

    private static boolean isInsideHierarchy(@NotNull PhpClassMember classMember) {
        if (classMember == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(75);
        }
        if (classMember.getModifier().isPrivate()) {
            return false;
        }
        return !PhpClassHierarchyUtils.processOverridingMembers((PhpClassMember)classMember, (superMember, subClass, baseClass) -> false) || !PhpClassHierarchyUtils.processSuperMembers((PhpClassMember)classMember, (member, subClass, baseClass) -> false);
    }

    private static void createIncompatibleDefaultValueAnnotation(@NotNull AnnotationHolder holder, @NotNull PhpType declaredType, @NotNull PsiElement defaultValue, IntentionAction @NotNull [] fixes) {
        PhpType globalDeclaredType;
        PhpType typesThatCanHaveDefaultValue;
        if (holder == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(76);
        }
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(77);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(78);
        }
        if (fixes == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(79);
        }
        if (!(typesThatCanHaveDefaultValue = (globalDeclaredType = declaredType.global(defaultValue.getProject())).filterOut((Predicate)Predicates.not(PhpType::isPrimitiveType))).isEmpty()) {
            PhpType mustBeType = PhpType.intersects((PhpType)typesThatCanHaveDefaultValue, (PhpType)PhpType.ITERABLE) ? typesThatCanHaveDefaultValue.filter(PhpType.ITERABLE).add(PhpType.ARRAY) : typesThatCanHaveDefaultValue;
            PhpAnnotatorVisitor.createErrorAnnotation(holder, defaultValue, PhpBundle.message("php.annotator.typed.property.type.mismatch", mustBeType), fixes);
        } else {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, defaultValue, PhpBundle.message("php.annotator.typed.property.illegal.value", globalDeclaredType), fixes);
        }
    }

    @Nullable
    private static PhpType getCompatibleType(@NotNull PhpType declaredType, @NotNull PhpType defaultValueType) {
        if (declaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(80);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(81);
        }
        if (defaultValueType.size() != 1 || defaultValueType.isAmbiguous()) {
            return null;
        }
        if (PhpType.isArray((PhpType)defaultValueType)) {
            return PhpType.ARRAY;
        }
        if (PhpType.NULL.equals((Object)defaultValueType)) {
            return new PhpType().add(declaredType).add(PhpType.NULL);
        }
        return defaultValueType;
    }

    public static boolean isPropertyDefaultValueTypeCompatible(@NotNull PhpType fieldDeclaredType, @NotNull PhpType defaultValueType) {
        if (fieldDeclaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(82);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(83);
        }
        if (PhpType.MIXED.equals((Object)fieldDeclaredType)) {
            return true;
        }
        if (PhpAnnotatorVisitor.falseAndBooleanNonCompatible(fieldDeclaredType, defaultValueType)) {
            return false;
        }
        return defaultValueType.isEmpty() || PhpType.intersects((PhpType)fieldDeclaredType, (PhpType)defaultValueType) || PhpType.intersects((PhpType)fieldDeclaredType, (PhpType)PhpType.ITERABLE) && PhpType.isArray((PhpType)defaultValueType) || PhpType.intersects((PhpType)fieldDeclaredType, (PhpType)PhpType.ARRAY) && PhpType.isArray((PhpType)defaultValueType) || PhpType.intersects((PhpType)fieldDeclaredType, (PhpType)PhpType.FLOAT) && PhpType.intersects((PhpType)defaultValueType, (PhpType)PhpType.FLOAT_INT) || (defaultValueType.size() != 1 || defaultValueType.isAmbiguous()) && fieldDeclaredType.getTypes().stream().allMatch(PhpType::isPrimitiveType);
    }

    private static boolean falseAndBooleanNonCompatible(@NotNull PhpType fieldDeclaredType, @NotNull PhpType defaultValueType) {
        if (fieldDeclaredType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(84);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(85);
        }
        return fieldDeclaredType.getTypes().contains("\\false") && defaultValueType.equals((Object)PhpType.BOOLEAN);
    }

    private static TextAttributesKey getInstanceFieldHighlightingData(@Nullable Field field) {
        PhpModifier.Access access = field != null ? field.getModifier().getAccess() : PhpModifier.Access.PUBLIC;
        switch (access) {
            case PROTECTED: {
                return PhpHighlightingData.PROTECTED_INSTANCE_FIELD;
            }
            case PRIVATE: {
                return PhpHighlightingData.PRIVATE_INSTANCE_FIELD;
            }
        }
        return PhpHighlightingData.INSTANCE_FIELD;
    }

    public void visitPhpConstant(Constant constant) {
        super.visitPhpConstant(constant);
        if (constant instanceof PhpDefineImpl) {
            PsiElement value;
            PsiElement[] parameters = ((PhpDefineImpl)constant).getParameters();
            if (parameters.length > 1 && !PhpAnnotatorVisitor.allowedDefineValue(value = parameters[1])) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, value, PhpBundle.message("constants.may.only.evaluate.to.scalar.values.arrays.or.resources", new Object[0]), new IntentionAction[0]);
            }
        } else {
            String constantName = constant.getName();
            if (PhpLangUtil.isBuiltInConstant(constantName)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)constant, PhpBundle.message("cannot.redeclare.constant.0", constantName), new IntentionAction[0]);
            }
            this.highlightInfo(constant.getNameNode(), PhpHighlightingData.CONSTANT);
            PsiElement value = constant.getValue();
            if (value != null && !PhpCodeValidationUtil.isAllowedAsConstantValue(value)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, value, PhpBundle.message("expression.is.not.allowed.as.constant.value", new Object[0]), PhpAnnotatorVisitor.getFix(constant));
            }
            if (PhpAnnotatorVisitor.notAllowedConstantDeclarationPlace(constant)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)constant, PhpBundle.message("constants.defined.using.the.const.keyword.must.be.declared.at.the.top.level.scope", new Object[0]), PhpAnnotatorVisitor.getFix(constant));
            }
        }
    }

    private static IntentionAction[] getFix(Constant constant) {
        IntentionAction[] intentionActionArray;
        PsiElement value = constant.getValue();
        if (value != null && PhpAnnotatorVisitor.allowedDefineValue(value)) {
            IntentionAction[] intentionActionArray2 = new IntentionAction[1];
            intentionActionArray = intentionActionArray2;
            intentionActionArray2[0] = new PhpReplaceWithDefineQuickFix((PsiElement)constant);
        } else {
            intentionActionArray = IntentionAction.EMPTY_ARRAY;
        }
        return intentionActionArray;
    }

    private static boolean allowedDefineValue(PsiElement value) {
        PhpIndex index = PhpIndex.getInstance((Project)value.getProject());
        PhpType type = new PhpType().add(value).global(value.getProject());
        return type.isEmpty() || ContainerUtil.exists((Iterable)type.getTypes(), t -> PhpAnnotatorVisitor.allowedDefineValueType(index, t));
    }

    private static boolean allowedDefineValueType(PhpIndex index, String t) {
        if (PhpType.isAnonymousClass((String)t)) {
            return false;
        }
        return PhpType.isNotExtendablePrimitiveType((String)t) || PhpType.isArray((String)t) || PhpType.isPluralPrimitiveType((String)t) || !PhpType.nonPrimitiveWithoutToString((String)t, (PhpIndex)index);
    }

    public static boolean notAllowedConstantDeclarationPlace(Constant constant) {
        PhpNamedElement namedElement = (PhpNamedElement)PhpPsiUtil.getParentByCondition((PsiElement)constant, true, (Condition<? super PsiElement>)PhpNamedElement.INSTANCEOF);
        return namedElement != null && !(namedElement instanceof PhpNamespace) || PhpPsiUtil.getParentByCondition((PsiElement)constant, true, (Condition<? super PsiElement>)ControlStatement.INSTANCEOF) != null;
    }

    public void visitPhpBreak(@NotNull PhpBreak breakStatement) {
        if (breakStatement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(86);
        }
        super.visitPhpBreak(breakStatement);
        this.checkBreakOrContinue((StatementWithArgument)breakStatement, this.holder);
    }

    public void visitPhpContinue(PhpContinue continueStatement) {
        super.visitPhpContinue(continueStatement);
        this.checkBreakOrContinue((StatementWithArgument)continueStatement, this.holder);
    }

    public void visitPhpModifierList(PhpModifierList modifierList) {
        super.visitPhpModifierList(modifierList);
        PsiElement parent = modifierList.getParent();
        if (parent instanceof Method) {
            PhpAnnotatorVisitor.checkMemberModifiers((PhpClassMember)((Method)parent), modifierList, this.holder);
        }
    }

    public void visitPhpNewExpression(NewExpression expression) {
        super.visitPhpNewExpression(expression);
        ClassReference classReference = expression.getClassReference();
        PhpClass containingClass = (PhpClass)PsiTreeUtil.getParentOfType((PsiElement)expression, PhpClass.class);
        if (classReference != null && !PhpLangUtil.equalsClassNames("static", classReference.getName())) {
            PsiElement resolvedElement;
            Collection<? extends PhpNamedElement> elements = ClassReferenceImpl.resolveGlobal((PhpReference)classReference, classReference.getName(), classReference.getNamespaceName(), true);
            PsiElement psiElement = resolvedElement = elements.size() == 1 ? (PsiElement)elements.iterator().next() : null;
            if (resolvedElement instanceof PhpClass) {
                PhpClass constructorClass;
                PhpClass clazz = (PhpClass)resolvedElement;
                if (clazz.isInterface()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.interface", clazz.getName()), new IntentionAction[0]);
                } else if (clazz.isTrait() && !PhpLangUtil.equalsClassNames("self", classReference.getName())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.trait", clazz.getName()), new IntentionAction[0]);
                } else if (clazz.isAbstract()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("annotation.new.expression.abstract", clazz.getName()), new IntentionAction[0]);
                }
                Method constructor = clazz.getConstructor();
                if (constructor != null && !PhpAnnotatorVisitor.constructorAccessibleInContext(constructor, containingClass) && (constructorClass = constructor.getContainingClass()) != null) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)expression, PhpBundle.message("call.to.0.1.construct.from.invalid.context", constructor.getAccess(), constructorClass.getName()), new IntentionAction[0]);
                }
            }
        }
    }

    public void visitPhpTraitUseRule(PhpTraitUseRule type) {
        PhpClass aClass;
        ClassReference originalTraitReference;
        MethodReference methodReference;
        super.visitPhpTraitUseRule(type);
        String alias = type.getAlias();
        if (alias != null && (methodReference = type.getOriginalReference()) != null && (originalTraitReference = (ClassReference)ObjectUtils.tryCast((Object)methodReference.getFirstPsiChild(), ClassReference.class)) != null && (aClass = (PhpClass)ObjectUtils.tryCast((Object)originalTraitReference.resolve(), PhpClass.class)) != null && aClass.findMethodByName((CharSequence)alias) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, type.getNameNode(), PhpBundle.message("trait.already.contains.method", aClass.getName(), alias));
        }
        if (type.isInsteadOf()) {
            MethodReference methodReference2;
            Collection overrides = type.getOverrides();
            if (overrides.isEmpty()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)type, PhpBundle.message("target.trait.should.be.specified", new Object[0]), new IntentionAction[0]);
            }
            if ((methodReference2 = type.getOriginalReference()) == null) {
                return;
            }
            this.checkRequiredTraitsArePresent(overrides, methodReference2);
            ClassReference originalTraitReference2 = (ClassReference)ObjectUtils.tryCast((Object)methodReference2.getFirstPsiChild(), ClassReference.class);
            if (originalTraitReference2 == null) {
                if (methodReference2.getTextLength() != 0) {
                    this.holder.newAnnotation(HighlightSeverity.ERROR, PhpBundle.message("inspection.message.absolute.method.reference.should.be.specified.for.insteadof.trait.use.rule", new Object[0])).range((PsiElement)methodReference2).withFix((IntentionAction)new PhpReplaceTraitMethodReferenceWithAbsoluteIntentionAction(methodReference2)).create();
                }
                return;
            }
            PhpClass originalTrait = (PhpClass)ObjectUtils.tryCast((Object)originalTraitReference2.resolve(), PhpClass.class);
            if (originalTrait == null) {
                return;
            }
            for (ClassReference override : overrides) {
                if (!PhpClassHierarchyUtils.classesEqual((PhpClass)((PhpClass)ObjectUtils.tryCast((Object)override.resolve(), PhpClass.class)), (PhpClass)originalTrait)) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)override, PhpBundle.message("method.0.can.t.be.overridden.with.same.trait.1", methodReference2.getName(), originalTrait.getName()), new IntentionAction[0]);
            }
        } else if (type.getAlias() != null) {
            MethodReference reference = type.getOriginalReference();
            if (reference == null || reference.getFirstPsiChild() instanceof ClassReference) {
                return;
            }
            List traitsNamesWithResolvedMethod = (List)StreamEx.of((Object[])reference.multiResolve(false)).map(ResolveResult::getElement).select(Method.class).map(PhpClassMember::getContainingClass).nonNull().map(PhpNamedElement::getName).collect(Collectors.toList());
            String name = reference.getName();
            if (traitsNamesWithResolvedMethod.size() > 1) {
                IntentionAction[] fixes = (IntentionAction[])ContainerUtil.map2Array((Collection)traitsNamesWithResolvedMethod, IntentionAction.class, x$0 -> new PhpMakeReferenceAbsoluteQuickFix((String)x$0));
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("an.alias.was.defined.for.method.0.which.exists.in.1", name, StringUtil.join((Collection)traitsNamesWithResolvedMethod, (String)", ")), fixes);
            }
        }
    }

    public void checkRequiredTraitsArePresent(Collection<ClassReference> overrides, MethodReference methodReference) {
        PhpClass containingClass = (PhpClass)PhpPsiUtil.getParentByCondition((PsiElement)methodReference, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
        if (containingClass != null) {
            THashSet usedTraitNames = new THashSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
            ContainerUtil.addAll((Collection)usedTraitNames, (Object[])containingClass.getTraitNames());
            if (!usedTraitNames.isEmpty()) {
                for (ClassReference override : overrides) {
                    String fqn = override.getFQN();
                    if (fqn == null || usedTraitNames.contains(fqn)) continue;
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)override, PhpBundle.message("required.trait.0.wasn.t.added.to.1", PhpLangUtil.toShortName(fqn), PhpLangUtil.toShortName(containingClass.getFQN())), new PhpAddTraitUseRuleQuickFix(fqn));
                }
            }
        }
    }

    public static boolean constructorAccessibleInContext(@NotNull Method constructor, @Nullable PhpClass contextClass) {
        boolean insideClass;
        PhpClass clazz;
        if (constructor == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(87);
        }
        if ((clazz = constructor.getContainingClass()) == null) {
            return true;
        }
        boolean bl = insideClass = contextClass != null && (PhpClassHierarchyUtils.classesEqual((PhpClass)contextClass, (PhpClass)clazz) || clazz.isTrait() && ArrayUtil.contains((Object)clazz, (Object[])contextClass.getTraits()));
        if (insideClass) {
            return true;
        }
        boolean insideClassHierarchy = contextClass != null && (PhpClassHierarchyUtils.isSuperClass((PhpClass)clazz, (PhpClass)contextClass, (boolean)false) || PhpClassHierarchyUtils.isSuperClass((PhpClass)contextClass, (PhpClass)clazz, (boolean)false));
        PhpModifier.Access access = constructor.getAccess();
        return !access.isPrivate() && (insideClassHierarchy || !access.isProtected());
    }

    public void visitPhpThrowExpression(PhpThrowExpression throwExpression) {
        super.visitPhpThrowExpression(throwExpression);
        PhpExpression argument = throwExpression.getArgument();
        if (argument != null && !PhpAnnotatorVisitor.isCouldBeDerivedFromException(throwExpression.getProject(), (PhpTypedElement)argument)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)argument, PhpBundle.message("inspection.wrong.exception.type.problem.throw", new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitPhpCatch(Catch phpCatch) {
        super.visitPhpCatch(phpCatch);
        Collection exceptionTypes = phpCatch.getExceptionTypes();
        for (ClassReference exceptionType : exceptionTypes) {
            if (exceptionType == null || PhpAnnotatorVisitor.isCouldBeDerivedFromException(phpCatch.getProject(), (PhpTypedElement)exceptionType)) continue;
            this.holder.newAnnotation(HighlightSeverity.WARNING, PhpBundle.message("inspection.wrong.exception.type.problem.catch", new Object[0])).range((PsiElement)exceptionType).create();
        }
    }

    public void visitPhpStringLiteralExpression(StringLiteralExpression expression) {
        Pair<TextRange, String> validationMessage;
        super.visitPhpStringLiteralExpression(expression);
        for (PhpPsiElement psiChild = expression.getFirstPsiChild(); psiChild != null; psiChild = psiChild.getNextPsiSibling()) {
            PhpPsiElement firstPsiChild = psiChild.getFirstPsiChild();
            IElementType type = psiChild.getFirstChild().getNode().getElementType();
            if (psiChild instanceof Variable && firstPsiChild == null || firstPsiChild != null && PhpAnnotatorVisitor.possiblePartOfStringInterpolation(firstPsiChild.getClass(), type)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)psiChild, PhpBundle.message("only.simple.expressions.are.allowed", new Object[0]), new IntentionAction[0]);
        }
        if (expression.isHeredoc() && (validationMessage = PhpFlexibleHeredocHelper.validateHeredocIndentation(expression)) != null) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, (String)validationMessage.second).range(((TextRange)validationMessage.first).shiftRight(expression.getTextRange().getStartOffset())).create();
        }
        super.visitPhpStringLiteralExpression(expression);
    }

    public static boolean possiblePartOfStringInterpolation(Class<? extends PsiElement> element, IElementType firstElementType) {
        return Variable.class.isAssignableFrom(element) || ArrayAccessExpression.class.isAssignableFrom(element) || StringLiteralExpression.class.isAssignableFrom(element) || !PhpTokenTypes.DOLLAR_LBRACE.equals(firstElementType) && !((Object)PhpStubElementTypes.VARIABLE).equals(firstElementType) && (FieldReference.class.isAssignableFrom(element) || MethodReference.class.isAssignableFrom(element) || FunctionReference.class.isAssignableFrom(element));
    }

    public void visitPhpGotoLabel(PhpGotoLabel label) {
        super.visitPhpGotoLabel(label);
        ASTNode nameNode = label.getNameNode();
        if (nameNode != null) {
            this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(nameNode).textAttributes(PhpHighlightingData.GOTO_LABEL).create();
        }
    }

    public static boolean isCouldBeDerivedFromException(@NotNull Project project, @NotNull PhpTypedElement typedElement) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(88);
        }
        if (typedElement == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(89);
        }
        PhpType t = typedElement.getType();
        PhpIndex phpIndex = PhpIndex.getInstance((Project)project);
        if (!PhpType.THROWABLE.isConvertibleFromGlobal(project, t)) {
            for (String type : t.global(project).getTypes()) {
                if (PhpType.isPrimitiveType((String)type)) continue;
                if (phpIndex.getClassesByFQN(type).isEmpty()) {
                    return true;
                }
                if (phpIndex.getInterfacesByFQN(type).isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public void visitPhpParameter(Parameter parameter) {
        super.visitPhpParameter(parameter);
        Object method = PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Method.INSTANCEOF);
        if (method instanceof PhpDocMethod) {
            PsiElement typeNode = PhpAnnotatorVisitor.getDeclaredTypeNode((PsiElement)parameter);
            this.highlightPhpDocType(typeNode);
            this.highlightInfo(parameter.getNameNode(), PhpHighlightingData.DOC_PARAMETER);
            return;
        }
        PsiElement defaultValue = parameter.getDefaultValue();
        if (defaultValue != null) {
            PhpType defaultValueType;
            if (parameter.isVariadic()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("variadic.parameter.cannot.have.a.default.value", new Object[0]), new IntentionAction[0]);
            } else if (defaultValue instanceof PhpTypedElement && !PhpType.intersects((PhpType)PhpType.NULL, (PhpType)(defaultValueType = ((PhpTypedElement)defaultValue).getGlobalType()))) {
                this.checkParameterTypeCompatibility(parameter, defaultValue, defaultValueType);
            }
            if (!(defaultValue instanceof ArrayCreationExpression) && !PhpCodeValidationUtil.isAllowedAsConstantValue(defaultValue)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("expression.is.not.allowed.as.parameter.default.value", new Object[0]), new IntentionAction[0]);
            }
        }
        if (parameter.isVariadic() && parameter.getNextPsiSibling() != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, PhpBundle.message("only.the.last.parameter.can.be.variadic", new Object[0]), new IntentionAction[0]);
        }
        for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof PhpTypeDeclaration)) continue;
            for (ClassReference classReference : ((PhpTypeDeclaration)child).getClassReferences()) {
                this.checkParameterClassReference(classReference);
            }
        }
        if ("this".equals(parameter.getName())) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, PhpBundle.message("cannot.use.this.as.parameter", new Object[0]), new IntentionAction[0]);
        }
        if (parameter.isPromotedField()) {
            Function parentFunction;
            if (defaultValue != null && parameter.getTypeDeclaration() != null) {
                this.checkTypedPropertyDefaultValue((PhpPromotedFieldParameterImpl)parameter, defaultValue);
            }
            if (!((parentFunction = (Function)PhpPsiUtil.getParentByCondition((PsiElement)parameter, (Condition<? super PsiElement>)Function.INSTANCEOF)) instanceof Method) || ((Method)parentFunction).getMethodType(false) != Method.MethodType.CONSTRUCTOR) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, PhpBundle.message("cannot.declare.promoted.property.outside.a.constructor", new Object[0]), new IntentionAction[0]);
            } else if (((Method)parentFunction).isAbstract()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, PhpBundle.message("cannot.declare.promoted.property.in.an.abstract.constructor", new Object[0]), new IntentionAction[0]);
            } else if (parameter.isVariadic()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)parameter, PhpBundle.message("cannot.declare.variadic.promoted.property", new Object[0]), new IntentionAction[0]);
            }
            this.checkNotApplicableModifiers(parameter);
            this.checkCallablePropertyTypeDeclaration(parameter.getTypeDeclaration());
        }
        this.highlightInfo(parameter.getNameNode(), PhpHighlightingData.PARAMETER);
    }

    private void checkNotApplicableModifiers(Parameter parameter) {
        for (PsiElement child = parameter.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!PhpPsiUtil.isOfType(child, PhpTokenTypes.tsVARIABLE_MODIFIERS) || PhpPsiUtil.isOfType(child, PhpTokenTypes.tsVISIBILITY_MODIFIERS)) continue;
            PhpDeleteElementQuickFix deleteElementQuickFix = new PhpDeleteElementQuickFix(child);
            IntentionAction[] fixes = PhpPsiUtil.isOfType(child, PhpTokenTypes.kwVAR) ? new IntentionAction[]{deleteElementQuickFix, new PhpReplaceWithPublicQuickFix(child)} : new IntentionAction[]{deleteElementQuickFix};
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("only.visibility.modifiers.can.be.applied.to.promoted.property", new Object[0]), fixes);
        }
    }

    private void checkParameterTypeCompatibility(Parameter parameter, PsiElement defaultValue, PhpType notNulldefaultValueType) {
        PhpType parameterType = parameter.getDeclaredType().global(parameter.getProject());
        if (parameterType.equals((Object)PhpType.MIXED)) {
            return;
        }
        if (PhpAnnotatorVisitor.falseAndBooleanNonCompatible(parameterType, notNulldefaultValueType) || !parameterType.isEmpty() && parameterType.filterOut(t -> !PhpAnnotatorVisitor.isCompatible(new PhpType().add(t), notNulldefaultValueType, defaultValue)).isEmpty()) {
            PhpType compatibleType = PhpAnnotatorVisitor.getCompatibleType(parameterType, notNulldefaultValueType);
            PhpType neededType = new PhpType();
            parameterType.getTypes().stream().map(type -> !PhpType.isPrimitiveType((String)type) ? "\\null" : type).forEach(arg_0 -> ((PhpType)neededType).add(arg_0));
            if (neededType.equals((Object)PhpType.NULL)) {
                IntentionAction[] fixes = IntentionAction.EMPTY_ARRAY;
                if (compatibleType != null && compatibleType.getTypes().stream().allMatch(PhpType::isPrimitiveType)) {
                    fixes = PhpAnnotatorVisitor.getChangeParameterTypeFixes(parameter, defaultValue, parameterType, compatibleType);
                }
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("default.value.for.parameters.with.a.class.type.can.only.be.null", new Object[0]), fixes);
            } else {
                IntentionAction[] fixes = PhpAnnotatorVisitor.getChangeParameterTypeFixes(parameter, defaultValue, parameterType, compatibleType);
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultValue, PhpBundle.message("argument.passed.must.be.of.the.type.0.1.given", neededType, notNulldefaultValueType), fixes);
            }
        }
    }

    private void checkParameterClassReference(ClassReference classReference) {
        this.checkInvalidClassName(classReference);
        if (PhpAnnotatorVisitor.isStaticKeywordClassReference(classReference)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)classReference, PhpBundle.message("static.is.not.allowed.in.parameter.type.declaration", new Object[0]), new IntentionAction[0]);
        }
    }

    private void highlightPrimitiveTypeHint(@Nullable PsiElement element) {
        PsiElement declaredTypeNode = PhpAnnotatorVisitor.getDeclaredTypeNode(element);
        if (declaredTypeNode != null && PhpType.isPrimitiveType((String)declaredTypeNode.getText())) {
            this.highlightInfo(declaredTypeNode.getNode(), PhpHighlightingData.PRIMITIVE_TYPE_HINT);
        }
    }

    public void visitPhpFieldTypeDeclaration(PhpFieldType fieldTypeDeclaration) {
        super.visitPhpFieldTypeDeclaration(fieldTypeDeclaration);
        this.checkCallablePropertyTypeDeclaration((PhpTypeDeclaration)fieldTypeDeclaration);
    }

    private void checkCallablePropertyTypeDeclaration(@Nullable PhpTypeDeclaration fieldTypeDeclaration) {
        if (fieldTypeDeclaration == null) {
            return;
        }
        fieldTypeDeclaration.getClassReferences().stream().filter(r -> PhpLangUtil.equalsClassNames("callable", r.getText())).forEach(r -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)r, PhpBundle.message("php.annotator.typed.property.callable.is.illegal", new Object[0]), new IntentionAction[0]));
    }

    public void visitPhpTypeDeclaration(PhpTypeDeclaration typeDeclaration) {
        boolean isUnionTypeSupported = PhpLanguageFeature.UNION_TYPES.isSupported(typeDeclaration.getProject());
        Collection classReferences = typeDeclaration.getClassReferences();
        for (ClassReference reference : classReferences) {
            boolean isVoid = PhpAnnotatorVisitor.isVoid(reference);
            if (isUnionTypeSupported && (isVoid && typeDeclaration instanceof PhpReturnType || reference.resolveLocalType().equals((Object)PhpType.MIXED)) && classReferences.size() > 1) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("can.only.be.used.as.standalone.type", StringUtil.capitalize((String)reference.getText())), PhpAnnotatorVisitor.getFixesForIncorrectVoidUsages(typeDeclaration, reference));
            } else if (isVoid && !(typeDeclaration instanceof PhpReturnType) && PhpLanguageFeature.RETURN_VOID.isSupported(typeDeclaration.getProject())) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("void.can.only.be.used.as.return.type", new Object[0]), PhpAnnotatorVisitor.getFixesForIncorrectVoidUsages(typeDeclaration, reference));
            }
            if (PhpAnnotatorVisitor.getPluralDimension(reference) > 0) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, PhpAnnotatorVisitor.getRangeUntilLastBracket(reference), PhpBundle.message("plural.types.are.not.allowed.in.real.types", new Object[0]), PhpRemoveBracketsFix.INSTANCE, PhpUpdateTypeFix.INSTANCE);
            }
            this.highlightPrimitiveTypeHint((PsiElement)reference);
        }
        if (isUnionTypeSupported) {
            ClassReference referenceToCheck;
            String name;
            List notNullReferences;
            if (classReferences.size() > 1) {
                this.checkDuplicateTypes(classReferences);
                boolean nullReferenceExists = ((PhpTypeDeclarationImpl)typeDeclaration).findNullReference() != null;
                SyntaxTraverser.psiApi().children((Object)typeDeclaration).filter(e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opQUEST)).forEach(quest -> this.registerInvalidNullabilityNotationError((PsiElement)quest, nullReferenceExists));
            } else if (typeDeclaration.isNullable() && classReferences.size() == 1 && ((ClassReference)ContainerUtil.getFirstItem((Collection)classReferences)).resolveLocalType().equals((Object)PhpType.MIXED)) {
                PsiElement quest2 = typeDeclaration.getFirstChild();
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, quest2, PhpBundle.message("union.types.mixed.cannot.be.nullable", new Object[0]), new PhpDeleteElementQuickFix(quest2, PhpBundle.message("quick.fix.delete", "?")));
            }
            if (!classReferences.isEmpty() && (notNullReferences = ContainerUtil.filter((Collection)classReferences, c -> !c.textMatches((CharSequence)"null"))).size() <= 1 && (PhpLangUtil.equalsClassNames(name = (referenceToCheck = (ClassReference)ContainerUtil.getFirstItem((Collection)notNullReferences, (Object)((ClassReference)ContainerUtil.getFirstItem((Collection)classReferences)))).getName(), "false") || PhpLangUtil.equalsClassNames(name, "null"))) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)referenceToCheck, PhpBundle.message("type.null.and.false.cannot.be.used.as.as.standalone.type", new Object[0]), new IntentionAction[0]);
            }
        }
    }

    private static int getPluralDimension(ClassReference reference) {
        ClassReference sibling = reference;
        int res = 0;
        while (PhpPsiUtil.isOfType((PsiElement)(sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)sibling, true)), PhpTokenTypes.chLBRACKET) && PhpPsiUtil.isOfType((PsiElement)(sibling = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)sibling, true)), PhpTokenTypes.chRBRACKET)) {
            ++res;
        }
        return res;
    }

    @NotNull
    private static TextRange getRangeUntilLastBracket(@NotNull ClassReference reference) {
        PsiElement next;
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(90);
        }
        ClassReference lastBracket = reference;
        while (PhpPsiUtil.isOfType(next = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)lastBracket, true), PhpTokenTypes.tsBRACKETS)) {
            lastBracket = next;
        }
        TextRange textRange = TextRange.create((int)reference.getTextRange().getStartOffset(), (int)lastBracket.getTextRange().getEndOffset());
        if (textRange == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(91);
        }
        return textRange;
    }

    private static IntentionAction[] getFixesForIncorrectVoidUsages(PhpTypeDeclaration typeDeclaration, ClassReference reference) {
        ArrayList<PhpChangeTypeQuickFix> fixes = new ArrayList<PhpChangeTypeQuickFix>();
        PhpType type = typeDeclaration.getType();
        PhpType nonNullableType = type.filterNull();
        if (nonNullableType.size() > 1 && !PhpLanguageFeature.UNION_TYPES.isSupported(typeDeclaration.getProject())) {
            return IntentionAction.EMPTY_ARRAY;
        }
        if (nonNullableType.equals((Object)PhpType.or((PhpType)PhpType.FALSE, (PhpType)PhpType.VOID))) {
            return IntentionAction.EMPTY_ARRAY;
        }
        if (nonNullableType.size() > 1 || type.equals((Object)PhpType.VOID) && !(typeDeclaration instanceof PhpReturnType)) {
            fixes.add(new PhpChangeTypeQuickFix(reference, null));
        }
        if (!type.isNullable() && !type.equals((Object)PhpType.VOID)) {
            fixes.add(new PhpChangeTypeQuickFix(reference, PhpType.NULL.toString()));
        }
        return fixes.toArray(IntentionAction.EMPTY_ARRAY);
    }

    private void checkDuplicateTypes(Collection<ClassReference> references) {
        HashSet<ClassReference> processedReferences = new HashSet<ClassReference>();
        for (ClassReference reference : references) {
            ClassReference duplicatedReference = (ClassReference)ContainerUtil.find(processedReferences, r -> PhpAnnotatorVisitor.isDuplicatedBy(r, reference));
            if (duplicatedReference != null) {
                processedReferences.remove(duplicatedReference);
                this.registerDuplicatedReference(reference, duplicatedReference);
                this.registerDuplicatedReference(duplicatedReference, reference);
                continue;
            }
            processedReferences.add(reference);
        }
    }

    private static boolean isDuplicatedBy(@NotNull ClassReference reference, @NotNull ClassReference possibleDuplicate) {
        if (reference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(92);
        }
        if (possibleDuplicate == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(93);
        }
        PhpType referenceFQN = reference.resolveLocalType();
        PhpType possibleDuplicateFQN = possibleDuplicate.resolveLocalType();
        return PhpAnnotatorVisitor.coveredBy(reference.getProject(), referenceFQN, possibleDuplicateFQN) || PhpAnnotatorVisitor.coveredBy(reference.getProject(), possibleDuplicateFQN, referenceFQN);
    }

    private static boolean coveredBy(@NotNull Project project, PhpType referenceFQN, PhpType possibleDuplicateFQN) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(94);
        }
        if (ContainerUtil.exists((Iterable)referenceFQN.getTypes(), arg_0 -> ((PhpTypeSignatureKey)PhpTypeSignatureKey.POLYMORPHIC_CLASS).isSigned(arg_0))) {
            return PhpType.OBJECT.equals((Object)possibleDuplicateFQN);
        }
        if (referenceFQN.equals((Object)possibleDuplicateFQN)) {
            return true;
        }
        referenceFQN = referenceFQN.global(project);
        possibleDuplicateFQN = possibleDuplicateFQN.global(project);
        if (PhpType.BOOLEAN.equals((Object)referenceFQN) && PhpType.FALSE.equals((Object)possibleDuplicateFQN)) {
            return true;
        }
        if (!referenceFQN.filterOut(PhpType::isPrimitiveType).isEmpty() && PhpType.OBJECT.equals((Object)possibleDuplicateFQN)) {
            return true;
        }
        return PhpType.ITERABLE.equals((Object)referenceFQN) && (PhpType.TRAVERSABLE.equals((Object)possibleDuplicateFQN) || PhpType.ARRAY.equals((Object)possibleDuplicateFQN));
    }

    private void registerDuplicatedReference(ClassReference reference, ClassReference duplicatedReference) {
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)reference, PhpBundle.message("is.duplicated.by.0", duplicatedReference.getText()), new IntentionAction[]{new PhpRemoveUnionTypeReference(reference, duplicatedReference)});
    }

    private void registerInvalidNullabilityNotationError(PsiElement quest, boolean nullReferenceExists) {
        IntentionAction[] intentionActionArray;
        PhpDeleteElementQuickFixLowPriority deleteQuestionMark = new PhpDeleteElementQuickFixLowPriority(quest, PhpBundle.message("quick.fix.delete", "?"));
        if (nullReferenceExists) {
            IntentionAction[] intentionActionArray2 = new IntentionAction[1];
            intentionActionArray = intentionActionArray2;
            intentionActionArray2[0] = deleteQuestionMark;
        } else {
            IntentionAction[] intentionActionArray3 = new IntentionAction[2];
            intentionActionArray3[0] = deleteQuestionMark;
            intentionActionArray = intentionActionArray3;
            intentionActionArray3[1] = new PhpReplaceNullableNotationWithNullAsPartOfUnionType(quest);
        }
        IntentionAction[] fixes = intentionActionArray;
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, quest, PhpBundle.message("union.types.and.the.nullable.type.notation.cannot.be.mixed", new Object[0]), fixes);
    }

    private static boolean isVoid(@Nullable ClassReference classReference) {
        if (classReference == null) {
            return false;
        }
        return PhpType.VOID.equals((Object)classReference.resolveLocalType());
    }

    private static PsiElement getDeclaredTypeNode(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (PhpPsiUtil.isOfType(element, POSSIBLE_TYPE_HINT)) {
            return element;
        }
        return PhpPsiUtil.getChildOfType(element, POSSIBLE_TYPE_HINT);
    }

    public void visitPhpReturnType(PhpReturnType returnType) {
        super.visitPhpReturnType(returnType);
        for (ClassReference classReference : returnType.getClassReferences()) {
            if (returnType.isNullable() && PhpAnnotatorVisitor.isVoid(classReference)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("void.type.cannot.be.nullable", new Object[0]), new PhpDeleteElementQuickFix(returnType.getFirstChild(), PhpBundle.message("make.non.nullable", new Object[0])));
            }
            if (returnType.getContainingFile() instanceof PhpTypeCodeFragment || !PhpAnnotatorVisitor.isStaticKeywordClassReference(classReference) || PhpPsiUtil.getParentByCondition((PsiElement)returnType, (Condition<? super PsiElement>)PhpClass.INSTANCEOF) != null) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("cannot.use.static.as.function.return.type.declaration", new Object[0]), new IntentionAction[0]);
        }
    }

    public static boolean isStaticKeywordClassReference(ClassReference classReference) {
        return classReference != null && PhpPsiUtil.isOfType(classReference.getFirstChild(), PhpTokenTypes.kwSTATIC);
    }

    private static boolean isCompatible(@NotNull PhpType parameterType, @NotNull PhpType defaultValueType, @NotNull PsiElement defaultValue) {
        if (parameterType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(95);
        }
        if (defaultValueType == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(96);
        }
        if (defaultValue == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(97);
        }
        if (!parameterType.getTypes().stream().allMatch(PhpType::isPrimitiveType)) {
            return false;
        }
        if ((defaultValue instanceof ConstantReference || defaultValue instanceof ClassConstantReference || defaultValue instanceof ArrayAccessExpression || defaultValue instanceof ArrayCreationExpression) && !PhpLangUtil.isTrue(defaultValue) && !PhpLangUtil.isFalse(defaultValue)) {
            if (PhpType.intersects((PhpType)PhpType.FLOAT_INT, (PhpType)parameterType) && PhpType.intersects((PhpType)PhpType.STRING, (PhpType)defaultValueType)) {
                return false;
            }
            return parameterType.isConvertibleFrom(defaultValueType, PhpIndex.getInstance((Project)defaultValue.getProject()));
        }
        boolean isFloat = PhpType.intersects((PhpType)PhpType.FLOAT, (PhpType)parameterType);
        return PhpType.intersects((PhpType)(isFloat ? PhpType.FLOAT_INT : parameterType), (PhpType)defaultValueType);
    }

    private void checkInvalidClassName(@Nullable ClassReference element) {
        String type;
        if (element != null && "\\".equals(element.getImmediateNamespaceName()) && PhpLangUtil.isPhpReservedClassName(PhpLangUtil.toName(type = element.getText()))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("annotator.invalid.class.name", type), new IntentionAction[0]);
        }
    }

    private void checkBreakOrContinue(StatementWithArgument breakOrContinue, AnnotationHolder holder) {
        PsiElement argument = breakOrContinue.getArgument();
        Integer arg = argument == null ? Integer.valueOf(1) : PhpCodeInsightUtil.toInt(argument);
        Statement loopStatement = arg != null ? PhpPsiUtil.getLoopStatement((PhpPsiElement)breakOrContinue, arg) : PhpPsiUtil.getLoopStatement((PhpPsiElement)breakOrContinue, 1);
        if (loopStatement == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(holder, (PsiElement)breakOrContinue, PhpBundle.message("annotator.cannot.break.continue", arg != null ? arg : "any"), new IntentionAction[0]);
        } else {
            Finally finallyStatement = (Finally)PhpPsiUtil.getParentByCondition((PsiElement)breakOrContinue, true, (Condition<? super PsiElement>)Finally.INSTANCEOF);
            this.checkJumpOutOfFinallyStatement(finallyStatement, (PsiElement)breakOrContinue, (PsiElement)loopStatement);
        }
    }

    public void visitPhpGoto(PhpGoto element) {
        super.visitPhpGoto(element);
        Finally finallyStatement = (Finally)PhpPsiUtil.getParentByCondition((PsiElement)element, true, (Condition<? super PsiElement>)Finally.INSTANCEOF);
        for (ResolveResult resolveResult : element.multiResolve(false)) {
            PsiElement targetLabel = resolveResult.getElement();
            Object targetFinally = PhpPsiUtil.getParentByCondition(targetLabel, true, (Condition<? super PsiElement>)Finally.INSTANCEOF);
            if (targetFinally != null && targetFinally != finallyStatement) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("jump.into.a.finally.block.is.disallowed", new Object[0]), new IntentionAction[0]);
                continue;
            }
            if (finallyStatement == null) continue;
            this.checkJumpOutOfFinallyStatement(finallyStatement, (PsiElement)element, targetLabel);
        }
    }

    private void checkJumpOutOfFinallyStatement(@Nullable Finally finallyStatement, @Nullable PsiElement jumpFrom, @Nullable PsiElement jumpTo) {
        if (jumpTo != null && finallyStatement != null && !PsiTreeUtil.isAncestor((PsiElement)finallyStatement, (PsiElement)jumpTo, (boolean)true)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, jumpFrom, PhpBundle.message("annotator.jump.out.of.finally", new Object[0]), new IntentionAction[0]);
        }
    }

    private static void checkMemberModifiers(@Nullable PhpClassMember member, @NotNull PhpModifierList modifierList, AnnotationHolder holder) {
        if (modifierList == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(98);
        }
        ASTNode[] nodes = modifierList.getNode().getChildren(PhpTokenTypes.tsMODIFIERS);
        int staticMod = 0;
        int visibilityMod = 0;
        int abstractnessMod = 0;
        int finalityMod = 0;
        PhpClass containingClass = member != null ? member.getContainingClass() : null;
        PhpModifier modifier = member != null ? member.getModifier() : null;
        boolean isInterface = containingClass != null && containingClass.isInterface();
        for (ASTNode node : nodes) {
            IElementType type = node.getElementType();
            if (type == PhpTokenTypes.kwSTATIC) {
                ++staticMod;
                if (member instanceof Field && ((Field)member).isConstant()) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("static.modifier.is.not.allowed.here", new Object[0]), new PhpDeleteElementQuickFix(node.getPsi()));
                }
            } else if (type == PhpTokenTypes.kwABSTRACT) {
                if (member instanceof Field) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("fields.cannot.be.declared.abstract", new Object[0]), new PhpDeleteElementQuickFix(node.getPsi()));
                } else if (finalityMod > 0 || isInterface || modifier != null && modifier.isPrivate() && (containingClass == null || !containingClass.isTrait())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("abstract.modifier.is.not.allowed.here", new Object[0]), new PhpDeleteElementQuickFix(node.getPsi()));
                }
                ++abstractnessMod;
            } else if (type == PhpTokenTypes.kwFINAL) {
                if (member instanceof Field) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("fields.cannot.be.declared.final", new Object[0]), new PhpDeleteElementQuickFix(node.getPsi()));
                } else if (abstractnessMod > 0 || isInterface) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("final.modifier.is.not.allowed.here", new Object[]{new PhpDeleteElementQuickFix(node.getPsi())}), new IntentionAction[0]);
                }
                ++finalityMod;
            } else if (PhpTokenTypes.tsVISIBILITY_MODIFIERS.contains(type)) {
                if (isInterface && (PhpTokenTypes.kwPRIVATE == type || PhpTokenTypes.kwPROTECTED == type)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("access.type.for.interface.member.must.be.omitted", new Object[0]), new PhpDeleteElementQuickFix(node.getPsi()));
                }
                ++visibilityMod;
            }
            if (staticMod <= 1 && abstractnessMod <= 1 && finalityMod <= 1 && visibilityMod <= 1) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(holder, node.getPsi(), PhpBundle.message("multiple.modifiers.are.not.allowed", new Object[0]), new IntentionAction[0]);
        }
    }

    private void checkClassRefsOfAppropriateType(PhpClass clazz, boolean expectingInterfaces, @NotNull List<ClassReference> referenceElements) {
        if (referenceElements == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(99);
        }
        for (ClassReference classRef : referenceElements) {
            PsiElement element = classRef.resolve();
            if (!(element instanceof PhpClass) || ((PhpClass)element).isInterface() == expectingInterfaces) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)classRef, PhpBundle.message(expectingInterfaces ? "php.annotator.expecting.interface" : "php.annotator.expecting.class", new Object[0]), new PhpExchangeExtendsImplementsQuickFix(clazz, classRef));
        }
    }

    public void visitPhpYield(PhpYield element) {
        Function function;
        super.visitPhpYield(element);
        LeafPsiElement from = PhpYieldImpl.getFrom(element);
        if (from != null) {
            this.highlightInfo(from.getNode(), PhpHighlightingData.KEYWORD);
        }
        if ((function = (Function)PhpPsiUtil.getParentByCondition((PsiElement)element, (Condition<? super PsiElement>)Function.INSTANCEOF)) == null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("the.yield.expression.can.only.be.used.inside.a.function", new Object[0]), new IntentionAction[0]);
        } else if (function.isReturningByReference() && from != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (ASTNode)from, PhpBundle.message("cannot.use.yield.from.inside.a.by.reference.generator", new Object[0]));
        }
    }

    private void checkCorrectReturnGeneratorType(@NotNull Function function) {
        PhpTypeDeclaration returnType;
        if (function == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(100);
        }
        if ((returnType = function.getTypeDeclaration()) == null || returnType.getTextLength() == 0) {
            return;
        }
        PhpType declaredType = function.getDeclaredType().global(function.getProject());
        if (PhpType.intersects((PhpType)PhpInconsistentReturnPointsInspection.GENERATOR_TYPE, (PhpType)declaredType) || PhpInconsistentReturnPointsInspection.isProbablyGenerator(declaredType)) {
            return;
        }
        String type = declaredType.toStringRelativized(function.getNamespaceName());
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)returnType, PhpBundle.message("inspection.message.generators.may.only.declare.return.type.generator.iterator.or.traversable.or.iterable.permitted", type), new IntentionAction[0]);
    }

    public void visitPhpStatement(Statement statement) {
        super.visitPhpStatement(statement);
        if (statement instanceof Declare) {
            if (DeclareImpl.getStrictTypesDirective((Declare)statement) != null) {
                if (!PhpAnnotatorVisitor.allowedPlaceForStrictTypesDeclareStatement((PsiElement)statement)) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)statement, PhpBundle.message("php.annotator.strict.types.first.statement", new Object[0]), new IntentionAction[0]);
                } else if (statement.getLastChild() instanceof GroupStatement) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)statement, PhpBundle.message("php.annotator.strict.types.block.mode", new Object[0]), new IntentionAction[0]);
                }
                PhpExpression value = PhpCodeInsightUtil.getStrictTypeDirectiveValue((Declare)statement);
                if (value != null && !"1".equals(value.getText()) && !"0".equals(value.getText())) {
                    PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)value, PhpBundle.message("strict.types.declaration.must.have.0.or.1.as.its.value", new Object[0]), new IntentionAction[]{new PhpReplaceWithCorrectStrictTypeValueQuickFix((PsiElement)value, 0), new PhpReplaceWithCorrectStrictTypeValueQuickFix((PsiElement)value, 1)});
                }
            }
            this.checkSupportedDirectiveNames(statement);
        }
    }

    private void checkSupportedDirectiveNames(Statement statement) {
        for (PsiElement directive : DeclareImpl.getDirectivesNames((Declare)statement)) {
            String directiveName = directive.getText();
            if (PhpKeywordsCompletionContributor.ALL_DIRECTIVES.contains(StringUtil.toLowerCase((String)directiveName))) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, directive, PhpBundle.message("unsupported.declare.0", directiveName), PhpChangeToSupportDirectiveQuickFix.getFixes(directive));
        }
    }

    public void visitPhpForeach(ForeachStatement foreach) {
        super.visitPhpForeach(foreach);
        Variable key = foreach.getKey();
        this.checkIsVariableAssignable((PsiElement)key);
        this.checkIsVariableAssignable((PsiElement)((ForeachImpl)foreach).getValueExpression());
        PsiElement prevSibling = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)key, true);
        if (PhpPsiUtil.isOfType(prevSibling, PhpTokenTypes.opBIT_AND)) {
            this.holder.newAnnotation(HighlightSeverity.ERROR, PhpBundle.message("inspection.message.key.element.cannot.be.reference", new Object[0])).range(TextRange.create((int)prevSibling.getTextRange().getStartOffset(), (int)key.getTextRange().getEndOffset())).withFix((IntentionAction)new PhpDeleteElementQuickFix(prevSibling, PhpBundle.message("remove.pass.by.ref.sign", new Object[0]))).create();
        }
    }

    public static boolean allowedPlaceForStrictTypesDeclareStatement(PsiElement place) {
        PsiElement phpOpeningTag = place.getParent().getFirstChild();
        if (PhpAnnotatorVisitor.isShebang(phpOpeningTag)) {
            phpOpeningTag = phpOpeningTag.getNextSibling();
        }
        PsiElement declare = PhpPsiUtil.getNextSibling(phpOpeningTag, Conditions.not((Condition)Statement.INSTANCEOF));
        return PhpPsiUtil.isOfType(phpOpeningTag, PhpTokenTypes.PHP_OPENING_TAG) && place == declare;
    }

    public void visitPhpUnset(PhpUnset unsetStatement) {
        super.visitPhpUnset(unsetStatement);
        for (PhpPsiElement argument : unsetStatement.getArguments()) {
            if (argument instanceof FieldReference && ((FieldReference)argument).isStatic()) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)argument, PhpBundle.message("static.property.cannot.be.unset", new Object[0]), new IntentionAction[0]);
                continue;
            }
            this.checkIsVariableAssignable((PsiElement)argument);
        }
    }

    public void visitPhpDocType(PhpDocType type) {
        super.visitPhpDocType(type);
        PsiElement declaredTypeNode = PhpAnnotatorVisitor.getDeclaredTypeNode((PsiElement)type);
        this.highlightPhpDocType(declaredTypeNode);
    }

    private void highlightPhpDocType(@Nullable PsiElement declaredTypeNode) {
        if (declaredTypeNode == null) {
            return;
        }
        this.highlightInfo(declaredTypeNode.getNode(), PhpHighlightingData.DOC_IDENTIFIER);
    }

    public void visitPhpDocTag(PhpDocTag tag) {
        super.visitPhpDocTag(tag);
        if (tag instanceof PhpDocParamTag) {
            String name = tag.getName();
            PhpDocVariable var = (PhpDocVariable)PsiTreeUtil.getChildOfType((PsiElement)tag, PhpDocVariable.class);
            if (var == null) {
                return;
            }
            this.highlightInfo(var.getNode(), "@param".equalsIgnoreCase(name) ? PhpHighlightingData.DOC_PARAMETER : PhpHighlightingData.DOC_VAR);
            return;
        }
        PhpDocRef[] refs = (PhpDocRef[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, PhpDocRef.class);
        if (refs != null) {
            for (PhpDocRef ref : refs) {
                this.highlightInfo(ref.getNode(), PhpHighlightingData.DOC_IDENTIFIER);
            }
        }
        if (tag instanceof PhpDocMethodTag) {
            for (PsiElement docMethodType : PhpPsiUtil.getChildren((PsiElement)tag, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, (IElementType)PhpDocElementTypes.phpDocMethodType)))) {
                this.highlightPhpDocType(docMethodType.getFirstChild());
            }
        }
    }

    public void visitPhpElement(PhpPsiElement element) {
        PsiElement parent;
        if (!(element instanceof PhpNamespace) && !(element instanceof PhpDocComment) && (element.getPrevPsiSibling() instanceof PhpNamespace || !PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.DECLARE, PhpElementTypes.HTML) && element.getNextPsiSibling() instanceof PhpNamespace)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("global.code.should.be.enclosed.in.global.namespace.declaration", new Object[0]), new IntentionAction[0]);
        }
        if (element instanceof PhpDocMethod) {
            this.highlightInfo(((PhpDocMethod)element).getNameNode(), PhpHighlightingData.DOC_METHOD_IDENTIFIER);
        }
        if (element instanceof PhpDocProperty) {
            this.highlightInfo(((PhpDocProperty)element).getNameNode(), PhpHighlightingData.DOC_PROPERTY_IDENTIFIER);
        }
        if (element instanceof PhpDocComment) {
            PhpClass clazz = (PhpClass)ObjectUtils.tryCast((Object)((PhpDocComment)element).getOwner(), PhpClass.class);
            if (clazz == null) {
                return;
            }
            this.markDuplicateMethods(clazz, true);
            this.markDuplicateFields(clazz, true);
        }
        if (PhpPsiUtil.isOfType((PsiElement)element, PhpElementTypes.HTML) && PhpPsiUtil.getPrevSiblingByCondition((PsiElement)element, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpElementTypes.HTML))) == null && (parent = element.getParent()) instanceof GroupStatement && parent.getParent() instanceof PhpFile && !PhpAnnotatorVisitor.isShebang((PsiElement)element) && PhpPsiUtil.getNextSiblingByCondition((PsiElement)element, (Condition<? super PsiElement>)PhpNamespace.INSTANCEOF) != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)element, PhpBundle.message("no.content.allowed.before.namespace.declaration", new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitPhpClassFieldsList(PhpClassFieldsList classFieldsList) {
        Field field = (Field)ContainerUtil.getFirstItem((Collection)classFieldsList.getFields());
        if (field == null) {
            return;
        }
        PhpModifierList modifierList = classFieldsList.getModifierList();
        if (modifierList == null) {
            return;
        }
        PhpAnnotatorVisitor.checkMemberModifiers((PhpClassMember)field, modifierList, this.holder);
    }

    private void markDuplicateMethods(PhpClass clazz, final boolean docMethods) {
        PhpClassHierarchyUtils.processMethods((PhpClass)clazz, (PhpClass)clazz, (PhpClassHierarchyUtils.HierarchyMethodProcessor)new PhpClassHierarchyUtils.HierarchyMethodProcessor(){
            final Set<String> methodNames = new THashSet();

            public boolean process(Method method, PhpClass subClass, PhpClass baseClass) {
                String name = StringUtil.toLowerCase((String)method.getName());
                if (!StringUtil.isEmpty((String)name) && !this.methodNames.add(name) && docMethods == method instanceof PhpDocMethod) {
                    PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, method.getNameIdentifier(), PhpBundle.message("method.with.same.name.already.defined.in.this.class", new Object[0]), new IntentionAction[0]);
                }
                return true;
            }
        }, (boolean)true);
    }

    public static boolean isShebang(@NotNull PsiElement element) {
        PsiFile htmlFile;
        PsiFile phpFile;
        if (element == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(101);
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.HTML) && (phpFile = element.getContainingFile()) != null && (htmlFile = phpFile.getViewProvider().getPsi((Language)HTMLLanguage.INSTANCE)) != null) {
            element = htmlFile.findElementAt(element.getTextOffset());
        }
        if (PhpPsiUtil.isOfType(element, XmlTokenType.XML_DATA_CHARACTERS) && element.getText().startsWith("#!")) {
            PsiElement next = element.getNextSibling();
            while (next instanceof PsiWhiteSpace || PhpPsiUtil.isOfType(next, XmlTokenType.XML_DATA_CHARACTERS)) {
                String text;
                int lineBreak;
                if (next instanceof PsiWhiteSpace && (lineBreak = (text = next.getText()).indexOf(10)) != -1) {
                    if (lineBreak != text.length() - 1) break;
                    next = next.getNextSibling();
                    break;
                }
                next = next.getNextSibling();
            }
            if (next == null) {
                next = element.getParent().getNextSibling();
            }
            if (PhpPsiUtil.isOfType(next, PhpElementTypes.PHP_OUTER_TYPE)) {
                return true;
            }
        }
        return false;
    }

    private void highlightInfo(@Nullable ASTNode node, TextAttributesKey textAttributeKey) {
        if (node == null) {
            return;
        }
        this.highlightInfo(node.getTextRange(), textAttributeKey);
    }

    private void highlightInfo(@NotNull TextRange range, TextAttributesKey textAttributeKey) {
        if (range == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(102);
        }
        @NlsSafe String name = textAttributeKey.getExternalName();
        (isUnitTestMode ? this.holder.newAnnotation(HighlightSeverity.INFORMATION, name) : this.holder.newSilentAnnotation(HighlightSeverity.INFORMATION)).range(range).textAttributes(textAttributeKey).create();
    }

    public void visitPhpMatchExpression(PhpMatchExpression matchExpression) {
        super.visitPhpMatchExpression(matchExpression);
        this.highlightInfo(matchExpression.getFirstChild().getNode(), PhpHighlightingData.KEYWORD);
        this.checkConditionToBodySeparator(matchExpression);
        this.checkDefaultArms(matchExpression);
        this.checkMatchArgumentIsHandled(matchExpression);
    }

    private void checkConditionToBodySeparator(@NotNull PhpMatchExpression matchExpression) {
        if (matchExpression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(103);
        }
        for (PhpMatchArm arm : PhpPsiUtil.getChildren((PsiElement)matchExpression, (Condition<? super PsiElement>)((Condition)PhpMatchArm.class::isInstance))) {
            SyntaxTraverser.psiApi().children((Object)arm).filter(e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.opCOLON)).forEach(opColon -> PhpAnnotatorVisitor.createErrorAnnotation(this.holder, opColon, PhpBundle.message("invalid.condition.to.body.separator.should.be.used", new Object[0]), new IntentionAction[]{new PhpReplaceWithOpHashFix((PsiElement)opColon)}));
        }
    }

    private void checkMatchArgumentIsHandled(@NotNull PhpMatchExpression matchExpression) {
        PhpExpression argument;
        if (matchExpression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(104);
        }
        if ((argument = matchExpression.getArgument()) == null || matchExpression.getDefaultMatchArm() != null) {
            return;
        }
        Project project = matchExpression.getProject();
        PhpType argumentType = argument.getGlobalType();
        if (argumentType.isEmpty() || PhpType.intersects((PhpType)argumentType, (PhpType)PhpType.MIXED) || argumentType.hasUnknown()) {
            return;
        }
        PhpType cumulativeConditionsType = new PhpType();
        for (PhpMatchArm arm : matchExpression.getMatchArms()) {
            for (PhpExpression condition : arm.getConditions()) {
                cumulativeConditionsType.add(condition.getType());
            }
        }
        if (!PhpStrictTypeCheckingInspection.isTypeCompatible(argumentType, cumulativeConditionsType.global(project))) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)argument, PhpBundle.message("annotator.unhandled.match.argument", new Object[0]), new IntentionAction[]{new PhpAddDefaultMatchArmQuickFix((PsiElement)argument)});
        }
    }

    private void checkDefaultArms(@NotNull PhpMatchExpression matchExpression) {
        if (matchExpression == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(105);
        }
        List<PhpDefaultMatchArm> defaultArms = PhpPsiUtil.getChildren((PsiElement)matchExpression, (Condition<? super PsiElement>)((Condition)PhpDefaultMatchArm.class::isInstance));
        if (defaultArms.size() > 1) {
            for (PhpDefaultMatchArm defaultArm : defaultArms) {
                PsiElement defaultKeyword = PhpPsiUtil.getChildOfType((PsiElement)defaultArm, PhpTokenTypes.kwDEFAULT);
                if (defaultKeyword == null) continue;
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, defaultKeyword, PhpBundle.message("annotator.duplicate.default.match.condition", new Object[0]), new PhpDeleteElementQuickFix((PsiElement)defaultArm, PhpBundle.message("quickfix.remove.default.arm", new Object[0]), PhpTokenTypes.opCOMMA));
            }
        }
    }

    public void visitPhpAttributesList(PhpAttributesList attributesList) {
        this.highlightInfo(attributesList.getFirstChild().getNode(), PhpHighlightingData.ATTRIBUTE);
        this.highlightInfo(attributesList.getLastChild().getNode(), PhpHighlightingData.ATTRIBUTE);
        if (PhpPsiUtil.isOfType(attributesList.getParent(), PhpElementTypes.CONSTANTS)) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)attributesList, PhpBundle.message("attributes.are.inapplicable.for.constants", new Object[0]), new PhpDeleteElementQuickFix((PsiElement)attributesList));
        }
        Condition[] conditionArray = new Condition[3];
        conditionArray[0] = PsiWhiteSpace.class::isInstance;
        conditionArray[1] = PsiComment.class::isInstance;
        conditionArray[2] = PhpAttributesList.class::isInstance;
        PsiElement prevInvalidSibling = PhpPsiUtil.getPrevSibling((PsiElement)attributesList, conditionArray);
        if (prevInvalidSibling != null) {
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, (PsiElement)attributesList, PhpBundle.message("attribute.must.be.first.child.of.parent.element", new Object[0]), new IntentionAction[]{new PhpMoveAttributeToStartOfElementQuickFix(attributesList)});
        }
    }

    public void visitPhpAttribute(PhpAttribute attribute) {
        PsiElement child;
        PsiElement lParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chLPAREN);
        PsiElement rParen = PhpPsiUtil.getChildOfType((PsiElement)attribute, PhpTokenTypes.chRPAREN);
        TextRange attributeTextRange = attribute.getTextRange();
        if (lParen != null && rParen != null) {
            this.highlightInfo(TextRange.create((int)attributeTextRange.getStartOffset(), (int)lParen.getTextRange().getStartOffset()), PhpHighlightingData.ATTRIBUTE);
            this.highlightInfo(TextRange.create((int)rParen.getTextRange().getEndOffset(), (int)attributeTextRange.getEndOffset()), PhpHighlightingData.ATTRIBUTE);
        } else {
            this.highlightInfo(attributeTextRange, PhpHighlightingData.ATTRIBUTE);
        }
        ParameterList list = attribute.getParameterList();
        PsiElement psiElement = child = list != null ? list.getFirstChild() : null;
        while (child != null) {
            if (PhpPsiUtil.isOfType(child, PhpTokenTypes.opVARIADIC)) {
                PhpAnnotatorVisitor.createErrorAnnotation(this.holder, child, PhpBundle.message("cannot.use.unpacking.in.attribute.argument.list", new Object[0]), new IntentionAction[0]);
            }
            child = child.getNextSibling();
        }
        for (PsiElement parameter : attribute.getParameters()) {
            if (PhpCodeValidationUtil.isAllowedAsConstantValue(parameter)) continue;
            PhpAnnotatorVisitor.createErrorAnnotation(this.holder, parameter, PhpBundle.message("constant.expression.contains.invalid.operations", new Object[0]), new IntentionAction[0]);
        }
    }

    public void visitPhpCase(PhpCase phpCase) {
        List expressions = PhpPsiUtil.getChildren((PsiElement)phpCase, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
        if (expressions.size() <= 1) {
            return;
        }
        PsiElement prevComma = PhpPsiUtil.getPrevSiblingIgnoreWhitespace((PsiElement)expressions.get(1), true);
        if (prevComma == null) {
            return;
        }
        PhpAnnotatorVisitor.createErrorAnnotation(this.holder, TextRange.create((int)prevComma.getTextRange().getStartOffset(), (int)((PsiElement)ContainerUtil.getLastItem(expressions)).getTextRange().getEndOffset()), PhpBundle.message("invalid.syntax.for.multiple.case.expressions", new Object[0]), PhpSplitIntoSeparateCasesQuickFix.INSTANCE);
    }

    private static void removeBrackets(@NotNull ClassReference classReference) {
        PsiElement sibling;
        if (classReference == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(106);
        }
        while (PhpPsiUtil.isOfType(sibling = classReference.getNextSibling(), PhpTokenTypes.tsBRACKETS)) {
            sibling.delete();
        }
    }

    private static void replaceMultiAssignmentElement(@NotNull Project project, @NotNull PsiElement element, PsiElement lParen, PsiElement rParen, String format) {
        if (project == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(107);
        }
        if (element == null) {
            PhpAnnotatorVisitor.$$$reportNull$$$0(108);
        }
        if (lParen == null || rParen == null) {
            return;
        }
        String elementsText = element.getText().substring(lParen.getTextRangeInParent().getEndOffset(), rParen.getTextRangeInParent().getStartOffset());
        String arrayText = String.format(format, elementsText);
        MultiassignmentExpression multiAssignment = PhpPsiElementFactory.createPhpPsiFromText(project, MultiassignmentExpression.class, String.format("list(%s) = $a;", arrayText));
        element.replace((PsiElement)multiAssignment.getFirstPsiChild());
    }

    private static /* synthetic */ void lambda$checkTraitMethodsConflictsWithAppliedMethods$18(AnnotationHolder holder, Map usedMethodsFromTraits, PhpUse declaration, Set traitMethodsExcludedFromConflicts, String traitFqn, Method traitMethod) {
        PhpAnnotatorVisitor.checkTraitMethodDoestConflictWithExisting(holder, usedMethodsFromTraits, (PsiElement)declaration, traitMethodsExcludedFromConflicts, traitMethod.getName(), PhpAnnotatorVisitor.getConflictingTraitFqn(traitMethod, traitFqn));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 91: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 91: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchIdentifier";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 4: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operand";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor";
                break;
            }
            case 10: 
            case 15: 
            case 18: 
            case 24: 
            case 27: 
            case 43: 
            case 90: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentClasses";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringClass";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "current";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "phpClass";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traitMethod";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalTraitFqn";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trait";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaces";
                break;
            }
            case 45: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 47: 
            case 50: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixes";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 51: 
            case 53: 
            case 54: 
            case 56: 
            case 57: 
            case 59: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnStatement";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "returnTypeElement";
                break;
            }
            case 60: 
            case 63: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constant";
                break;
            }
            case 64: 
            case 66: 
            case 69: 
            case 71: 
            case 78: 
            case 97: 
            case 109: 
            case 110: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 67: 
            case 70: 
            case 72: 
            case 77: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaredType";
                break;
            }
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeFixerFactory";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 81: 
            case 83: 
            case 85: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValueType";
                break;
            }
            case 82: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fieldDeclaredType";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "breakStatement";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 88: 
            case 94: 
            case 107: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedElement";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleDuplicate";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceElements";
                break;
            }
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 103: 
            case 104: 
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchExpression";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyedEntries";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getParametersNames";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeWithColon";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveCurrentScope";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveClosureBoundClassesFromVariableUsage";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictestAccessibleInContextReferenceAccess";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraitsExcludedFromConflicts";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getConflictingTraitFqn";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "unionMethodsNames";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeUntilLastBracket";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visitElement";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAllowedMatchIdentifierContext";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "visitComment";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCastKeywordRange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkOperatorsArraySupport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isFunction";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 91: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "checkClassNameLiteral";
                break;
            }
            case 15: 
            case 16: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getStrictestAccessibleInContextReferenceAccess";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "protectedAccessAccessibleInContext";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasCommonSuper";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "resolveThis";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "canBeUsedAsLexicalVariable";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "checkTraitMethodsConflictsWithAppliedMethods";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTraitsExcludedFromConflicts";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getConflictingTraitFqn";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getMethods";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getTargetReferenceFqn";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addAllSuperInterfaces";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "createErrorAnnotation";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "checkNoReturnArgumentForVoidFunction";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "getChangeReturnTypeFix";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "checkReturnStatementNullability";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "hasNonNullableSuperMethods";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "checkArrowFunctionReturnType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "checkParametersRedefinition";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "highlightFieldNameNode";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "expressionHasReferenceToConstant";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "checkTypedPropertyDefaultValue";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "getChangeFieldTypeFixes";
                break;
            }
            case 68: 
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "getChangeParameterTypeFixes";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getChangeTypeFixes";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "isInsideHierarchy";
                break;
            }
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "createIncompatibleDefaultValueAnnotation";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getCompatibleType";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isPropertyDefaultValueTypeCompatible";
                break;
            }
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "falseAndBooleanNonCompatible";
                break;
            }
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "visitPhpBreak";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "constructorAccessibleInContext";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "isCouldBeDerivedFromException";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getRangeUntilLastBracket";
                break;
            }
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isDuplicatedBy";
                break;
            }
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "coveredBy";
                break;
            }
            case 95: 
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberModifiers";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "checkClassRefsOfAppropriateType";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "checkCorrectReturnGeneratorType";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "isShebang";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "highlightInfo";
                break;
            }
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "checkConditionToBodySeparator";
                break;
            }
            case 104: {
                objectArray = objectArray;
                objectArray[2] = "checkMatchArgumentIsHandled";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "checkDefaultArms";
                break;
            }
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "removeBrackets";
                break;
            }
            case 107: 
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "replaceMultiAssignmentElement";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChangeParameterTypeFixes$31";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getChangeFieldTypeFixes$30";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 41: 
            case 91: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpReplaceWithListQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private PhpReplaceWithListQuickFix(PsiElement array) {
            super(array);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(4);
            }
            PhpAnnotatorVisitor.replaceMultiAssignmentElement(project, startElement.getParent(), startElement.getFirstChild(), startElement.getLastChild(), "list(%s)");
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.list", new Object[0]);
            if (string == null) {
                PhpReplaceWithListQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithListQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithListQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithArrayQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected PhpReplaceWithArrayQuickFix(@Nullable PsiElement listElement) {
            super(listElement);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(3);
            }
            ASTNode node = startElement.getNode();
            ASTNode lParen = node.findChildByType(PhpTokenTypes.chLPAREN);
            ASTNode rParen = PhpPsiUtil.getLastChildByType(node, PhpTokenTypes.chRPAREN);
            if (lParen != null && rParen != null) {
                PhpAnnotatorVisitor.replaceMultiAssignmentElement(project, startElement, lParen.getPsi(), rParen.getPsi(), "[%s]");
            }
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.array", new Object[0]);
            if (string == null) {
                PhpReplaceWithArrayQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithArrayQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithArrayQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithNullCheckQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private PhpReplaceWithNullCheckQuickFix(PsiElement issetCheck) {
            super(issetCheck);
        }

        @NotNull
        public String getText() {
            PsiElement element = this.getStartElement();
            String string = element instanceof PhpIsset && ((PhpIsset)element).getVariables().length == 1 ? PhpBundle.message("intention.family.name.replace.with", ((PhpIsset)element).getVariables()[0].getText() + " !== null") : this.getFamilyName();
            if (string == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(1);
            }
            if (file == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(2);
            }
            if (startElement == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(3);
            }
            if (endElement == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(4);
            }
            PhpExpression[] variables = ((PhpIsset)startElement).getVariables();
            int i = 0;
            ArrayList<String> toCheckInIsset = new ArrayList<String>();
            ArrayList<Object> finalArguments = new ArrayList<Object>();
            while (i < variables.length) {
                while (i < variables.length && PhpAnnotatorVisitor.allowedForIssetCheck((PsiElement)variables[i])) {
                    toCheckInIsset.add(variables[i++].getText());
                }
                if (!toCheckInIsset.isEmpty()) {
                    String issetText = "isset(" + StringUtil.join(toCheckInIsset, (String)",") + ")";
                    finalArguments.add(PhpPsiElementFactory.createPhpPsiFromText(project, PhpIsset.class, issetText));
                    toCheckInIsset.clear();
                }
                while (i < variables.length && !PhpAnnotatorVisitor.allowedForIssetCheck((PsiElement)variables[i])) {
                    finalArguments.add(PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, variables[i++].getText() + " !== null"));
                }
            }
            PsiElement toReplace = finalArguments.size() == 1 ? (PsiElement)finalArguments.get(0) : PhpPsiElementFactory.createPhpPsiFromText(project, BinaryExpression.class, StringUtil.join(finalArguments, PsiElement::getText, (String)"&&"));
            startElement.replace(toReplace);
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.check", new Object[0]);
            if (string == null) {
                PhpReplaceWithNullCheckQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithNullCheckQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithNullCheckQuickFix";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithCorrectStrictTypeValueQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final int myValue;

        private PhpReplaceWithCorrectStrictTypeValueQuickFix(PsiElement directiveValue, int value) {
            super(directiveValue);
            this.myValue = value;
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myValue);
            if (string == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PhpExpression value;
            if (project == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(2);
            }
            if (file == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(3);
            }
            if (startElement == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(4);
            }
            if (endElement == null) {
                PhpReplaceWithCorrectStrictTypeValueQuickFix.$$$reportNull$$$0(5);
            }
            if ((value = PhpCodeInsightUtil.getStrictTypeDirectiveValue(PhpPsiElementFactory.createPhpPsiFromText(project, Declare.class, "declare(strict_types=" + this.myValue + ")"))) == null) {
                return;
            }
            startElement.replace((PsiElement)value);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithCorrectStrictTypeValueQuickFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithCorrectStrictTypeValueQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpChangeToSupportDirectiveQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private final String myDirectiveName;

        private PhpChangeToSupportDirectiveQuickFix(PsiElement element, String name) {
            super(element);
            this.myDirectiveName = name;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Declare declare;
            PsiElement name;
            if (project == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(3);
            }
            if ((name = (PsiElement)ContainerUtil.getFirstItem(DeclareImpl.getDirectivesNames(declare = PhpPsiElementFactory.createPhpPsiFromText(project, Declare.class, String.format("declare(%s=1)", this.myDirectiveName))))) == null) {
                return;
            }
            startElement.replace(name);
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with", this.myDirectiveName);
            if (string == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        public static IntentionAction[] getFixes(@NotNull PsiElement directiveName) {
            if (directiveName == null) {
                PhpChangeToSupportDirectiveQuickFix.$$$reportNull$$$0(6);
            }
            return (IntentionAction[])StreamEx.of(PhpKeywordsCompletionContributor.getSupportedDeclareDirectives(directiveName.getProject())).map(name -> new PhpChangeToSupportDirectiveQuickFix(directiveName, (String)name)).toArray(IntentionAction.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpChangeToSupportDirectiveQuickFix";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "directiveName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpChangeToSupportDirectiveQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getFixes";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpSplitIntoSeparateCasesQuickFix
    implements IntentionAction {
        static final IntentionAction INSTANCE = new PhpSplitIntoSeparateCasesQuickFix();

        private PhpSplitIntoSeparateCasesQuickFix() {
        }

        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.split.into.separate.case.statements", new Object[0]);
            if (string == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            PhpCase phpCase;
            if (project == null) {
                PhpSplitIntoSeparateCasesQuickFix.$$$reportNull$$$0(3);
            }
            if ((phpCase = (PhpCase)PhpPsiUtil.getParentByCondition(file.findElementAt(editor.getCaretModel().getOffset()), (Condition<? super PsiElement>)PhpCase.INSTANCEOF)) == null) {
                return;
            }
            List children = PhpPsiUtil.getChildren((PsiElement)phpCase, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF);
            PhpCase anchor = phpCase;
            for (int i = children.size() - 2; i >= 0; --i) {
                PsiElement child = (PsiElement)children.get(i);
                PhpCodeEditUtil.removeStatementWithDelivery(child, PhpTokenTypes.opCOMMA);
                PhpCase emptyCase = PhpPsiElementFactory.createPhpPsiFromText(project, PhpCase.class, String.format("switch(){case %s: }", child.getText()));
                anchor = anchor.getParent().addBefore((PsiElement)emptyCase, (PsiElement)anchor);
            }
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpSplitIntoSeparateCasesQuickFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpSplitIntoSeparateCasesQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpDeleteElementQuickFixLowPriority
    extends PhpDeleteElementQuickFix
    implements LowPriorityAction {
        private PhpDeleteElementQuickFixLowPriority(@NotNull PsiElement element, @Nls String text) {
            if (element == null) {
                PhpDeleteElementQuickFixLowPriority.$$$reportNull$$$0(0);
            }
            super(element, text);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteElementQuickFixLowPriority", "<init>"));
        }
    }

    private static class PhpDeleteFieldQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private PhpDeleteFieldQuickFix(Field field) {
            super((PsiElement)field);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(3);
            }
            PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)startElement);
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.delete.field", new Object[0]);
            if (string == null) {
                PhpDeleteFieldQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteFieldQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeleteFieldQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithConstantQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private PhpReplaceWithConstantQuickFix(Field field) {
            super((PsiElement)field);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PhpClassFieldsList originalList;
            PhpClassFieldsList list;
            Field field;
            PsiElement defaultValue;
            if (project == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(3);
            }
            if ((defaultValue = (field = (Field)ContainerUtil.getFirstItem((Collection)(list = FieldImpl.copyListWithSingleField((Field)startElement, originalList = (PhpClassFieldsList)startElement.getParent())).getFields())).getDefaultValue()) == null) {
                return;
            }
            String text = list.getText();
            String constantText = String.format("class a{%s const %s = %s;}", text.substring(0, field.getTextRangeInParent().getStartOffset()), field.getName(), defaultValue.getText());
            originalList.getParent().addBefore((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, PhpClassConstantsListImpl.class, constantText), (PsiElement)originalList);
            PhpMoveClassMemberBase.removeFieldWithPhpDoc((Field)startElement);
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.class.constant", new Object[0]);
            if (string == null) {
                PhpReplaceWithConstantQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithConstantQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithConstantQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithDefineQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected PhpReplaceWithDefineQuickFix(@Nullable PsiElement constDeclaration) {
            super(constDeclaration);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            Constant constant;
            PsiElement value;
            if (project == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(3);
            }
            if ((value = (constant = (Constant)startElement).getValue()) == null) {
                return;
            }
            String define = String.format("define(\"%s\", %s);", PhpLangUtil.toPresentableFQN(constant.getFQN()), value.getText());
            PsiElement parent = constant.getParent();
            parent.getParent().addBefore(PhpPsiElementFactory.createPhpPsiFromText(project, PhpDefine.class, define).getParent(), parent);
            PhpMoveFileConstantProcessor.deleteOriginalConstantDeclaration(constant);
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.define.call", new Object[0]);
            if (string == null) {
                PhpReplaceWithDefineQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithDefineQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithDefineQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PhpAddDefaultMatchArmQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected PhpAddDefaultMatchArmQuickFix(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(3);
            }
            PhpMatchExpression matchExpression = (PhpMatchExpression)PhpPsiUtil.getParentByCondition(startElement, (Condition<? super PsiElement>)((Condition)PhpMatchExpression.class::isInstance));
            assert (matchExpression != null && matchExpression.getDefaultMatchArm() == null);
            PhpAddDefaultMatchArmQuickFix.appendDefaultMatchArmWithText(project, matchExpression, "throw new \\Exception('Unexpected match value')");
            if (editor == null) {
                return;
            }
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(editor.getDocument());
            PhpAddDefaultMatchArmQuickFix.runTemplate(project, editor, file);
        }

        public static void appendDefaultMatchArmWithText(@NotNull Project project, @NotNull PhpMatchExpression matchExpression, @NotNull String defaultArmText) {
            if (project == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(4);
            }
            if (matchExpression == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(5);
            }
            if (defaultArmText == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(6);
            }
            PsiElement toAddAfter = (PsiElement)ContainerUtil.getLastItem((List)matchExpression.getMatchArms());
            toAddAfter = matchExpression.addAfter(PhpPsiElementFactory.createComma(project), toAddAfter);
            matchExpression.addAfter((PsiElement)PhpAddDefaultMatchArmQuickFix.createDefaultMatchArm(project, defaultArmText), toAddAfter);
        }

        private static void runTemplate(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(7);
            }
            PsiElement elementAtCaret = file.findElementAt(editor.getCaretModel().getOffset());
            PhpMatchExpression matchExpression = (PhpMatchExpression)PhpPsiUtil.getParentByCondition(elementAtCaret, false, (Condition<? super PsiElement>)((Condition)PhpMatchExpression.class::isInstance));
            assert (matchExpression != null);
            PhpDefaultMatchArm defaultMatchArm = matchExpression.getDefaultMatchArm();
            assert (defaultMatchArm != null);
            PhpExpression body = defaultMatchArm.getBodyExpression();
            assert (body != null);
            editor.getCaretModel().moveToOffset(body.getTextRange().getStartOffset());
            TemplateBuilderImpl builder = new TemplateBuilderImpl((PsiElement)body);
            builder.replaceElement((PsiElement)body, (Expression)new ConstantNode(body.getText()));
            TemplateManager.getInstance((Project)project).startTemplate(editor, builder.buildInlineTemplate());
        }

        @NotNull
        private static PhpDefaultMatchArm createDefaultMatchArm(@NotNull Project project, @NotNull String defaultArmText) {
            if (project == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(8);
            }
            if (defaultArmText == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(9);
            }
            PhpDefaultMatchArm defaultMatchArm = PhpPsiElementFactory.createFromText(project, PhpDefaultMatchArm.class, "match (a) { default => " + defaultArmText + "};");
            assert (defaultMatchArm != null);
            PhpDefaultMatchArm phpDefaultMatchArm = defaultMatchArm;
            if (phpDefaultMatchArm == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(10);
            }
            return phpDefaultMatchArm;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(11);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.default.match.arm", new Object[0]);
            if (string == null) {
                PhpAddDefaultMatchArmQuickFix.$$$reportNull$$$0(12);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matchExpression";
                    break;
                }
                case 6: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "defaultArmText";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddDefaultMatchArmQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddDefaultMatchArmQuickFix";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createDefaultMatchArm";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "appendDefaultMatchArmWithText";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "runTemplate";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "createDefaultMatchArm";
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 10: 
                case 11: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithPublicQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected PhpReplaceWithPublicQuickFix(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(3);
            }
            startElement.replace(PhpPsiUtil.getChildOfType((PsiElement)PhpPsiElementFactory.createModifierList(project, PhpModifier.PUBLIC_IMPLEMENTED_DYNAMIC), PhpTokenTypes.kwPUBLIC));
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.replace.with.public", new Object[0]);
            if (string == null) {
                PhpReplaceWithPublicQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithPublicQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithPublicQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpMoveAttributeToStartOfElementQuickFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        private PhpMoveAttributeToStartOfElementQuickFix(PhpAttributesList attribute) {
            super((PsiElement)attribute);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement parent = startElement.getParent();
            parent.addBefore(startElement.copy(), parent.getFirstChild());
            startElement.delete();
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.move.attribute.to.start.element", new Object[0]);
            if (string == null) {
                PhpMoveAttributeToStartOfElementQuickFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpMoveAttributeToStartOfElementQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpMoveAttributeToStartOfElementQuickFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpAddTraitUseRuleQuickFix
    implements IntentionAction {
        private final String myTraitFQN;

        private PhpAddTraitUseRuleQuickFix(String traitFQN) {
            this.myTraitFQN = traitFQN;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.add.trait.to.use.list", PhpLangUtil.toShortName(this.myTraitFQN));
            if (string == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.add.trait.to.use.list", new Object[0]);
            if (string == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            PsiElement elementAt;
            PhpUseList useList;
            if (project == null) {
                PhpAddTraitUseRuleQuickFix.$$$reportNull$$$0(3);
            }
            if ((useList = (PhpUseList)PhpPsiUtil.getParentByCondition(elementAt = file.findElementAt(editor.getCaretModel().getOffset()), (Condition<? super PsiElement>)PhpUseList.INSTANCEOF)) == null) {
                return;
            }
            PhpUse lastDeclaration = (PhpUse)ArrayUtil.getLastElement((Object[])useList.getDeclarations());
            PsiElement elementToAddAfter = lastDeclaration != null ? useList.addAfter(PhpPsiElementFactory.createComma(project), (PsiElement)lastDeclaration) : useList.getFirstChild();
            PhpPsiElement scope = PhpCodeInsightUtil.findScopeForUseOperator(elementAt);
            if (scope == null) {
                return;
            }
            String traitImportedName = PhpCodeInsightUtil.createQualifiedName(scope, this.myTraitFQN);
            PhpUse traitUseDeclaration = PhpPsiElementFactory.createPhpPsiFromText(project, PhpUse.class, "<?php class a { use " + traitImportedName + ";}");
            useList.addAfter((PsiElement)traitUseDeclaration, elementToAddAfter);
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddTraitUseRuleQuickFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpAddTraitUseRuleQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpMakeReferenceAbsoluteQuickFix
    implements IntentionAction {
        private final String myTraitName;

        private PhpMakeReferenceAbsoluteQuickFix(String traitName) {
            this.myTraitName = traitName;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.family.name.append.absolute.trait", this.myTraitName);
            if (string == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                PhpMakeReferenceAbsoluteQuickFix.$$$reportNull$$$0(3);
            }
            Object reference = PhpPsiUtil.getParentByCondition(file.findElementAt(editor.getCaretModel().getOffset()), false, (Condition<? super PsiElement>)((Condition)MethodReference.class::isInstance));
            if (reference == null) {
                return;
            }
            reference.replace((PsiElement)PhpPsiElementFactory.createPhpPsiFromText(project, MethodReference.class, String.format("class a { use T1 {%s::%s}}", this.myTraitName, reference.getText())));
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpMakeReferenceAbsoluteQuickFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpMakeReferenceAbsoluteQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithQuestionQuickFix
    implements IntentionAction {
        static final IntentionAction[] INSTANCE = new IntentionAction[]{new PhpReplaceWithQuestionQuickFix()};

        private PhpReplaceWithQuestionQuickFix() {
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("replace.with.quest", new Object[0]);
            if (string == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                PhpReplaceWithQuestionQuickFix.$$$reportNull$$$0(3);
            }
            PsiElement at = file.findElementAt(editor.getCaretModel().getOffset());
            MemberReference memberReference = (MemberReference)PhpPsiUtil.getParentByCondition(at, false, (Condition<? super PsiElement>)((Condition)MemberReference.class::isInstance));
            PhpExpression classReference = memberReference != null ? memberReference.getClassReference() : null;
            PsiElement coalesce = PhpPsiUtil.getNextSiblingIgnoreWhitespace((PsiElement)classReference, true);
            if (PhpPsiUtil.isOfType(coalesce, PhpTokenTypes.opCOALESCE)) {
                coalesce.replace(PhpPsiElementFactory.createQuest(project));
            }
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithQuestionQuickFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithQuestionQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpUpdateTypeFix
    implements IntentionAction {
        static final IntentionAction INSTANCE = new PhpUpdateTypeFix();

        private PhpUpdateTypeFix() {
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.replace.brackets.with.types", new Object[0]);
            if (string == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            if (project == null) {
                PhpUpdateTypeFix.$$$reportNull$$$0(3);
            }
            PhpTypeDeclaration typeDeclaration = PhpRemoveBracketsFix.getTypeDeclarationAt(file, editor.getCaretModel().getOffset());
            assert (typeDeclaration != null);
            TObjectIntHashMap unpluralisedTypes = new TObjectIntHashMap();
            for (ClassReference reference : typeDeclaration.getClassReferences()) {
                int pluralDimension = PhpAnnotatorVisitor.getPluralDimension(reference);
                if (pluralDimension <= 0) continue;
                PhpAnnotatorVisitor.removeBrackets(reference);
                unpluralisedTypes.put((Object)reference.resolveLocalType().global(project), pluralDimension);
            }
            PhpType[] newType = new PhpType[]{new PhpType().add(typeDeclaration.getGlobalType())};
            unpluralisedTypes.forEachEntry((type, dimension) -> {
                newType[0] = newType[0].filter(type).add(type.pluralise(dimension));
                return true;
            });
            typeDeclaration.update(newType[0]);
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpUpdateTypeFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpUpdateTypeFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static class PhpRemoveBracketsFix
    implements IntentionAction {
        static final IntentionAction INSTANCE = new PhpRemoveBracketsFix();

        protected PhpRemoveBracketsFix() {
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.remove.brackets", new Object[0]);
            if (string == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        @IntentionFamilyName
        public String getFamilyName() {
            String string = this.getText();
            if (string == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
            if (project == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(2);
            }
            return true;
        }

        public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
            int offset;
            PhpTypeDeclaration typeDeclaration;
            if (project == null) {
                PhpRemoveBracketsFix.$$$reportNull$$$0(3);
            }
            if ((typeDeclaration = PhpRemoveBracketsFix.getTypeDeclarationAt(file, offset = editor.getCaretModel().getOffset())) == null) {
                return;
            }
            ClassReference reference = (ClassReference)ContainerUtil.find((Iterable)typeDeclaration.getClassReferences(), r -> PhpAnnotatorVisitor.getRangeUntilLastBracket(r).containsOffset(offset));
            if (reference == null) {
                return;
            }
            PhpAnnotatorVisitor.removeBrackets(reference);
        }

        @Nullable
        public static PhpTypeDeclaration getTypeDeclarationAt(PsiFile file, int offset) {
            PsiElement elementAt = file.findElementAt(offset);
            PhpTypeDeclarationOwner typeDeclarationOwner = (PhpTypeDeclarationOwner)PhpPsiUtil.getParentByCondition(elementAt, (Condition<? super PsiElement>)((Condition)PhpTypeDeclarationOwner.class::isInstance));
            return typeDeclarationOwner != null ? typeDeclarationOwner.getTypeDeclaration() : null;
        }

        public boolean startInWriteAction() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveBracketsFix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveBracketsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static final class PhpRemoveUnionTypeReference
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        public boolean startInWriteAction() {
            return false;
        }

        private PhpRemoveUnionTypeReference(ClassReference reference, ClassReference duplicatedReference) {
            super((PsiElement)reference, (PsiElement)duplicatedReference);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(3);
            }
            if (editor == null || startElement.textMatches(endElement)) {
                WriteAction.run(() -> PhpRemoveUnionTypeReference.removeClassReference(startElement));
                return;
            }
            final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
            JBPopupFactory.getInstance().createPopupChooserBuilder(Arrays.asList(startElement, endElement)).setMovable(false).setRequestFocus(true).setResizable(false).setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", element -> PhpBundle.message("php.remove.doc.tag.quick.fix.family.name", element.getText()))).setItemChosenCallback(e -> CommandProcessor.getInstance().executeCommand(project, () -> WriteAction.run(() -> PhpRemoveUnionTypeReference.removeClassReference(e)), e.getText(), null)).setItemSelectedCallback(e -> {
                if (e == null) {
                    return;
                }
                highlighter.dropHighlight();
                highlighter.highlight(e, Collections.singletonList(e));
            }).setTitle(PhpBundle.message("popup.title.select.reference.to.remove", new Object[0])).addListener(new JBPopupListener(){

                public void onClosed(@NotNull LightweightWindowEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    highlighter.dropHighlight();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveUnionTypeReference$1", "onClosed"));
                }
            }).createPopup().showInBestPositionFor(editor);
        }

        public static void removeClassReference(PsiElement element) {
            if (ReadonlyStatusHandler.ensureFilesWritable((Project)element.getProject(), (VirtualFile[])new VirtualFile[]{element.getContainingFile().getVirtualFile()})) {
                PhpCodeEditUtil.removeStatementWithDelivery(element, PhpTokenTypes.opBIT_OR);
            }
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.remove.duplicated.type", new Object[0]);
            if (string == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.remove.duplicated.type", new Object[0]);
            if (string == null) {
                PhpRemoveUnionTypeReference.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveUnionTypeReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveUnionTypeReference";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PhpReplaceNullableNotationWithNullAsPartOfUnionType
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected PhpReplaceNullableNotationWithNullAsPartOfUnionType(PsiElement quest) {
            super(quest);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            PhpTypeDeclarationImpl typeDeclaration;
            if (project == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(3);
            }
            if ((typeDeclaration = (PhpTypeDeclarationImpl)((Object)ObjectUtils.tryCast((Object)startElement.getParent(), PhpTypeDeclarationImpl.class))) != null && typeDeclaration.findNullReference() == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.replaceNullableNotationWithNullReference(typeDeclaration, startElement);
            }
        }

        public static void replaceNullableNotationWithNullReference(@NotNull PhpTypeDeclarationImpl typeDeclaration, @NotNull PsiElement nullableNotation) {
            if (typeDeclaration == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(4);
            }
            if (nullableNotation == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(5);
            }
            typeDeclaration.addTypeReference("null");
            nullableNotation.delete();
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = PhpBundle.message("intention.name.replace.nullable.notation.with.null.as.part.union.type", new Object[0]);
            if (string == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(6);
            }
            return string;
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("intention.name.replace.nullable.notation.with.null.as.part.union.type", new Object[0]);
            if (string == null) {
                PhpReplaceNullableNotationWithNullAsPartOfUnionType.$$$reportNull$$$0(7);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeDeclaration";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nullableNotation";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceNullableNotationWithNullAsPartOfUnionType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceNullableNotationWithNullAsPartOfUnionType";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceNullableNotationWithNullReference";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpRemoveVariableIntention
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected PhpRemoveVariableIntention(@Nullable PsiElement element) {
            super(element);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(3);
            }
            PhpCodeEditUtil.removeStatementWithDelivery(startElement, PhpTokenTypes.opCOMMA);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getText() {
            Variable variable = (Variable)ObjectUtils.tryCast((Object)this.getStartElement(), Variable.class);
            String string = variable != null ? PhpBundle.message("annotator.fix.remove", variable.getText()) : this.getFamilyName();
            if (string == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("remove.variable", new Object[0]);
            if (string == null) {
                PhpRemoveVariableIntention.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveVariableIntention";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpRemoveVariableIntention";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpReplaceWithOpHashFix
    extends LocalQuickFixAndIntentionActionOnPsiElement {
        protected PhpReplaceWithOpHashFix(PsiElement quest) {
            super(quest);
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @Nullable Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(0);
            }
            if (file == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(1);
            }
            if (startElement == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(2);
            }
            if (endElement == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(3);
            }
            startElement.replace(PhpPsiElementFactory.createFromText(project, PhpTokenTypes.opHASH_ARRAY, "match(1) { true => 1 };"));
        }

        @IntentionFamilyName
        @NotNull
        public String getFamilyName() {
            String string = PhpBundle.message("replace.with.01", "'=>'");
            if (string == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(4);
            }
            return string;
        }

        @IntentionName
        @NotNull
        public String getText() {
            String string = this.getFamilyName();
            if (string == null) {
                PhpReplaceWithOpHashFix.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "startElement";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "endElement";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithOpHashFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpReplaceWithOpHashFix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class PhpDeclarationDuplicateCheckerVisitor
    extends PsiRecursiveElementWalkingVisitor {
        final Set<String> classes = new TreeSet<String>(String::compareToIgnoreCase);
        final Set<String> functions = new TreeSet<String>(String::compareToIgnoreCase);
        final MultiMap<String, String> constants = new MultiMap<String, String>(new TreeMap(String::compareToIgnoreCase)){

            @NotNull
            protected Collection<String> createCollection() {
                return new SmartHashSet();
            }
        };

        private PhpDeclarationDuplicateCheckerVisitor() {
        }

        public void visitElement(@NotNull PsiElement element) {
            if (element == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(0);
            }
            if (element instanceof PhpClass) {
                this.visitPhpClass((PhpClass)element);
            }
            if (element instanceof Function) {
                this.visitPhpFunction((Function)element);
            }
            if (element instanceof Constant) {
                this.visitPhpConstant((Constant)element);
            }
            if (element instanceof PhpUse) {
                this.visitPhpUse((PhpUse)element);
            }
            if (!(element instanceof PhpClass || element instanceof Function || element instanceof Constant || element instanceof Statement && !(element instanceof GroupStatement) && !PhpPsiUtil.isOfType(element, PhpElementTypes.CONSTANTS))) {
                super.visitElement(element);
            }
        }

        public void visitPhpUse(PhpUse use) {
            if (!use.isTraitImport()) {
                String name = use.getName();
                String namespace = use.getNamespaceName();
                if (PhpUseImpl.isOfFunction(use)) {
                    this.checkUseDupe(use, namespace + name, this.functions);
                } else if (PhpUseImpl.isOfConst(use)) {
                    this.checkUseDupe(use, name, this.constants.getModifiable((Object)namespace));
                } else {
                    this.checkUseDupe(use, namespace + name, this.classes);
                }
            }
        }

        private void checkUseDupe(@NotNull PhpUse use, @NotNull String name, Collection<String> collection) {
            if (use == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(1);
            }
            if (name == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(2);
            }
            if (collection.contains(name)) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, (PsiElement)use, PhpBundle.message("annotator.duplicate.use.statement", use.getName()), new IntentionAction[0]);
            } else {
                collection.add(name);
            }
        }

        public void visitPhpClass(PhpClass clazz) {
            this.checkDupe((PhpNamedElement)clazz, this.classes);
        }

        public void visitPhpFunction(Function function) {
            if (!function.getAttributes("\\JetBrains\\PhpStorm\\Internal\\PhpStormStubsElementAvailable").isEmpty()) {
                return;
            }
            this.checkDupe((PhpNamedElement)function, this.functions);
        }

        public void visitPhpConstant(@NotNull Constant constant) {
            ASTNode nameNode;
            if (constant == null) {
                PhpDeclarationDuplicateCheckerVisitor.$$$reportNull$$$0(3);
            }
            if ((nameNode = constant.getNameNode()) != null && this.constants.getModifiable((Object)constant.getNamespaceName()).contains(constant.getName())) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("another.definition.with.same.name.exists.in.this.file", new Object[0]));
            }
        }

        void checkDupe(PhpNamedElement e, Set<String> set) {
            if (PsiTreeUtil.getParentOfType((PsiElement)e, Else.class) != null) {
                return;
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)e, ElseIf.class) != null) {
                return;
            }
            @NonNls String fqn = e.getFQN();
            ASTNode nameNode = e.getNameNode();
            if (nameNode != null && !set.add(fqn)) {
                PhpAnnotatorVisitor.createErrorAnnotation(PhpAnnotatorVisitor.this.holder, nameNode, PhpBundle.message("another.definition.with.same.name.exists.in.this.file", new Object[0]));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "use";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "constant";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAnnotatorVisitor$PhpDeclarationDuplicateCheckerVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitElement";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "checkUseDupe";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPhpConstant";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

