/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpChangeVisibilityIntentionBase;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePrivateIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakeProtectedIntention;
import com.jetbrains.php.lang.intentions.changeVisibility.PhpMakePublicIntention;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.MemberReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpAdjustMemberAccessFix
implements IntentionAction {
    private final String myName;
    private final SmartPsiElementPointer<MemberReference> myReference;
    private final PhpModifier.Access myAccess;
    private final PhpChangeVisibilityIntentionBase myDelegate;

    public PhpAdjustMemberAccessFix(@NotNull MemberReference reference, @NotNull PhpModifier.Access access) {
        if (reference == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(0);
        }
        if (access == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(1);
        }
        this.myReference = SmartPointerManager.createPointer((PsiElement)reference);
        this.myAccess = access;
        this.myName = PhpLangUtil.toShortName(StringUtil.notNullize((String)reference.getFQN()));
        this.myDelegate = PhpAdjustMemberAccessFix.getDelegate(access);
    }

    private static PhpChangeVisibilityIntentionBase getDelegate(@NotNull PhpModifier.Access access) {
        if (access == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(2);
        }
        switch (access) {
            case PUBLIC: {
                return new PhpMakePublicIntention();
            }
            case PROTECTED: {
                return new PhpMakeProtectedIntention();
            }
        }
        return new PhpMakePrivateIntention();
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getText() {
        String string = PhpBundle.message("make.0.1", this.myName, this.myAccess.toString());
        if (string == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    public String getFamilyName() {
        String string = PhpBundle.message("change.member.access", new Object[0]);
        if (string == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(4);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(5);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        MemberReference element;
        if (project == null) {
            PhpAdjustMemberAccessFix.$$$reportNull$$$0(6);
        }
        if ((element = (MemberReference)this.myReference.getElement()) == null) {
            return;
        }
        PhpClassMember member = (PhpClassMember)ObjectUtils.tryCast((Object)element.resolve(), PhpClassMember.class);
        if (member == null) {
            return;
        }
        if (member instanceof Method) {
            this.myDelegate.changeAccess(project, editor, (Method)member);
        } else {
            this.myDelegate.changeAccess((Field)member);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "access";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/annotator/PhpAdjustMemberAccessFix";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/annotator/PhpAdjustMemberAccessFix";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDelegate";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

