/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang.actions.generation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.actions.PhpNamedElementNode;
import com.jetbrains.php.lang.actions.generation.PhpGenerateFieldAccessorHandlerBase;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.intentions.generators.PhpAccessorMethodData;
import com.jetbrains.php.lang.intentions.generators.PhpConstructorGenerator;
import com.jetbrains.php.lang.intentions.generators.PhpInvalidTemplateException;
import com.jetbrains.php.lang.psi.PhpCodeEditUtil;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.ArrayList;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class PhpGenerateConstructorAction
extends CodeInsightAction {
    private static final LanguageCodeInsightActionHandler HANDLER = new PhpGenerateConstructorHandler();

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            PhpGenerateConstructorAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpGenerateConstructorAction.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpGenerateConstructorAction.$$$reportNull$$$0(2);
        }
        if (!file.getLanguage().is((Language)PhpLanguage.INSTANCE)) {
            return false;
        }
        return HANDLER.isValidFor(editor, file);
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        LanguageCodeInsightActionHandler languageCodeInsightActionHandler = HANDLER;
        if (languageCodeInsightActionHandler == null) {
            PhpGenerateConstructorAction.$$$reportNull$$$0(3);
        }
        return languageCodeInsightActionHandler;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/actions/generation/PhpGenerateConstructorAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/actions/generation/PhpGenerateConstructorAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PhpGenerateConstructorHandler
    extends PhpGenerateFieldAccessorHandlerBase {
        private PhpGenerateConstructorHandler() {
        }

        @Override
        public boolean isValidFor(Editor editor, PsiFile file) {
            PhpClass phpClass = PhpCodeEditUtil.findClassAtCaret(editor, file);
            return phpClass != null && !phpClass.isInterface();
        }

        @Override
        public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
            block12: {
                PhpClass phpClass;
                if (project == null) {
                    PhpGenerateConstructorHandler.$$$reportNull$$$0(0);
                }
                if (editor == null) {
                    PhpGenerateConstructorHandler.$$$reportNull$$$0(1);
                }
                if (file == null) {
                    PhpGenerateConstructorHandler.$$$reportNull$$$0(2);
                }
                if ((phpClass = PhpCodeEditUtil.findClassAtCaret(editor, file)) == null || !(file instanceof PhpFile)) {
                    return;
                }
                if (PhpGenerateConstructorHandler.alreadyHasConstructor(phpClass)) {
                    if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
                        HintManager.getInstance().showErrorHint(editor, this.getErrorMessage());
                    }
                    return;
                }
                PhpNamedElementNode[] fields = this.collectFields(phpClass);
                ArrayList<Field> selectedFields = new ArrayList<Field>();
                if (fields.length > 0) {
                    PhpNamedElementNode[] members = this.chooseMembers(fields, true, file.getProject());
                    if (members == null) {
                        return;
                    }
                    for (PhpNamedElementNode member : members) {
                        PsiElement memberPsi = member.getPsiElement();
                        if (!(memberPsi instanceof Field)) continue;
                        selectedFields.add((Field)memberPsi);
                    }
                }
                try {
                    Pair<PhpDocComment, Method> constructorPair = new PhpConstructorGenerator(phpClass).withFields(selectedFields).createConstructor();
                    if (constructorPair != null && constructorPair.second != null) {
                        ApplicationManager.getApplication().runWriteAction(() -> {
                            PsiElement inserted = PhpCodeEditUtil.insertClassMember(phpClass, (PsiElement)constructorPair.second);
                            editor.getCaretModel().moveToOffset(inserted.getTextOffset());
                            if (constructorPair.first != null) {
                                phpClass.addBefore((PsiElement)constructorPair.first, inserted);
                            }
                        });
                    }
                }
                catch (PhpInvalidTemplateException e) {
                    if (ApplicationManager.getApplication().isHeadlessEnvironment()) break block12;
                    HintManager.getInstance().showErrorHint(editor, e.getMessage());
                }
            }
        }

        @Override
        protected PhpAccessorMethodData[] createAccessors(PhpClass targetClass, PsiElement field) {
            return new PhpAccessorMethodData[0];
        }

        @Override
        protected boolean isSelectable(PhpClass phpClass, Field field) {
            return !field.getModifier().isStatic() && field.getContainingClass() == phpClass;
        }

        @Override
        @Nls
        protected String getErrorMessage() {
            return PhpBundle.message("constructor.already.exists", new Object[0]);
        }

        @Override
        protected boolean containsSetters() {
            return false;
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        private static boolean alreadyHasConstructor(PhpClass phpClass) {
            Method[] methods;
            for (Method method : methods = phpClass.getOwnMethods()) {
                if (!"__construct".equals(method.getName())) continue;
                return true;
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/actions/generation/PhpGenerateConstructorAction$PhpGenerateConstructorHandler";
            objectArray[2] = "invoke";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

