/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.completion.PhpCompletionUtil;
import com.jetbrains.php.completion.smartEnter.PhpSmartKeysConfiguration;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.ForeachStatement;
import com.jetbrains.php.lang.psi.elements.GroupStatement;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpTypedHandler
extends TypedHandlerDelegate {
    private boolean myOpenTagStringInsideXmlTag;

    @NotNull
    public TypedHandlerDelegate.Result beforeCharTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull FileType fileType) {
        PsiElement element;
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(1);
        }
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(2);
        }
        if (fileType == null) {
            PhpTypedHandler.$$$reportNull$$$0(3);
        }
        if (c == ',' && file instanceof PhpFile) {
            AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor, f -> {
                int offset = editor.getCaretModel().getOffset();
                PsiElement lastElement = f.findElementAt(offset - 1);
                return lastElement != null && lastElement.getParent() instanceof ParameterList && PhpPsiUtil.getPrevSiblingByCondition(lastElement, (Condition<? super PsiElement>)((Condition)e -> PhpPsiUtil.isOfType(e, PhpTokenTypes.IDENTIFIER))) != null;
            });
        }
        CaretModel caret = editor.getCaretModel();
        int offset = caret.getOffset();
        boolean bl = this.myOpenTagStringInsideXmlTag = c == '?' && offset > 0 && editor.getDocument().getCharsSequence().charAt(offset - 1) == '<' && PhpTypedHandler.insideXmlTag(file, offset);
        if (PhpTypedHandler.redundantCharAfterOpenTag(editor, c, file)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(4);
            }
            return result;
        }
        if (c == '>' && offset > 0) {
            element = file.findElementAt(offset - 1);
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.ARROW)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    PhpTypedHandler.$$$reportNull$$$0(5);
                }
                return result;
            }
            if (PhpPsiUtil.isOfType(element, PhpTokenTypes.opHASH_ARRAY) && PhpPsiUtil.isOfType(element.getParent(), PhpElementTypes.HASH_ARRAY_ELEMENT)) {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                if (result == null) {
                    PhpTypedHandler.$$$reportNull$$$0(6);
                }
                return result;
            }
        }
        if (c == ')' && (element = file.findElementAt(offset)) != null && PhpTokenTypes.CAST_OPERATORS.contains(element.getNode().getElementType()) && element.getTextRange().getEndOffset() - 1 == offset) {
            caret.moveToOffset(offset + 1);
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(7);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = super.beforeCharTyped(c, project, editor, file, fileType);
        if (result == null) {
            PhpTypedHandler.$$$reportNull$$$0(8);
        }
        return result;
    }

    private static boolean redundantCharAfterOpenTag(@NotNull Editor editor, char c, @Nullable PsiFile file) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(9);
        }
        if (c == 'p' || c == 'h') {
            return PhpTypedHandler.findFullPhpTagAtOffset(file, editor.getCaretModel().getOffset()) != null;
        }
        return false;
    }

    @Nullable
    public static PsiElement findFullPhpTagAtOffset(@Nullable PsiFile file, int offset) {
        if (offset > 0 && file != null) {
            PsiElement openTagAt = file.findElementAt(offset - 1);
            return PhpPsiUtil.isOfType(openTagAt, PhpTokenTypes.PHP_OPENING_TAG) && openTagAt.getTextLength() == 5 ? openTagAt : null;
        }
        return null;
    }

    public boolean isImmediatePaintingEnabled(@NotNull Editor editor, char c, @NotNull DataContext context) {
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PhpTypedHandler.$$$reportNull$$$0(11);
        }
        return !PhpTypedHandler.redundantCharAfterOpenTag(editor, c, (PsiFile)context.getData(CommonDataKeys.PSI_FILE));
    }

    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(12);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(13);
        }
        if (psiFile == null) {
            PhpTypedHandler.$$$reportNull$$$0(14);
        }
        if (!(psiFile instanceof PhpFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(15);
            }
            return result;
        }
        if (c == '$') {
            PhpCompletionUtil.showCompletion(editor);
        } else if (c == '>') {
            int offset = editor.getCaretModel().getOffset();
            CharSequence text = editor.getDocument().getCharsSequence();
            if (offset >= 1 && text.charAt(offset - 1) == '-' || offset >= 2 && text.charAt(offset - 2) == '-') {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == ':') {
            int offset = editor.getCaretModel().getOffset();
            if (offset >= 1 && editor.getDocument().getCharsSequence().charAt(offset - 1) == ':') {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == ' ') {
            int offset = editor.getCaretModel().getOffset();
            if (offset > 3 && "new".equals(editor.getDocument().getCharsSequence().subSequence(offset - 3, offset).toString()) && !Character.isJavaIdentifierStart(editor.getDocument().getCharsSequence().charAt(offset - 4))) {
                PhpCompletionUtil.showCompletion(editor);
            }
        } else if (c == '(') {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(16);
            }
            return result;
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            PhpTypedHandler.$$$reportNull$$$0(17);
        }
        return result;
    }

    @NotNull
    public TypedHandlerDelegate.Result charTyped(char c, @NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(18);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(19);
        }
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(20);
        }
        int offset = editor.getCaretModel().getOffset();
        if (!this.myOpenTagStringInsideXmlTag && editor.getCaretModel().getCaretCount() == 1 && c == '?' && offset > 1 && '<' == editor.getDocument().getCharsSequence().charAt(offset - 2) && PhpSmartKeysConfiguration.getInstance().isAutoInsertFullPhpOpenTag()) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement prevElement = file.findElementAt(offset - 1);
            if (PhpPsiUtil.isOfType(prevElement, PhpTokenTypes.PHP_OPENING_TAG) && prevElement.getText().equals("<?")) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"php");
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            }
        }
        if (!(file instanceof PhpFile)) {
            TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
            if (result == null) {
                PhpTypedHandler.$$$reportNull$$$0(21);
            }
            return result;
        }
        switch (c) {
            case '=': {
                AssignmentExpression assignmentExpression;
                PsiElement possibleArrayValue = PhpPsiUtil.getPrevSiblingIgnoreWhitespace(file.findElementAt(offset - 1), true);
                if (!PhpPsiUtil.isOfType(possibleArrayValue, PhpElementTypes.ARRAY_VALUE)) break;
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement typedEquals = file.findElementAt(offset - 1);
                AssignmentExpression assignmentExpression2 = assignmentExpression = typedEquals != null ? (AssignmentExpression)ObjectUtils.tryCast((Object)typedEquals.getParent(), AssignmentExpression.class) : null;
                if (assignmentExpression == null || !PhpPsiUtil.isOfType(assignmentExpression.getParent(), PhpElementTypes.ARRAY_VALUE)) break;
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">");
                break;
            }
            case '-': {
                if (offset > 6 && "$this-".equals(editor.getDocument().getCharsSequence().subSequence(offset - 6, offset).toString())) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                    PhpCompletionUtil.showCompletion(editor);
                }
            }
            case ' ': {
                String typeTag;
                PhpDocComment docComment;
                PhpPsiElement target;
                String varDoc;
                if (offset <= 4 || !"/** ".equals(editor.getDocument().getCharsSequence().subSequence(offset - 4, offset).toString())) break;
                PhpDocComment comment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PhpDocComment.class, (boolean)false);
                if (comment != null && PhpTypedHandler.isCompleteDocComment(comment)) {
                    TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.STOP;
                    if (result == null) {
                        PhpTypedHandler.$$$reportNull$$$0(22);
                    }
                    return result;
                }
                PsiComment cStyleComment = (PsiComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, PsiComment.class, (boolean)false);
                if (cStyleComment == null || cStyleComment.getTokenType() != PhpTokenTypes.C_STYLE_COMMENT) {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" */");
                    editor.getCaretModel().moveCaretRelatively(-3, 0, false, false, false);
                    PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                }
                if ((varDoc = PhpCodeUtil.getVarDocComment((PsiElement)(target = (docComment = (PhpDocComment)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)(offset = editor.getCaretModel().getOffset()), PhpDocComment.class, (boolean)false)) != null ? docComment.getNextPsiSibling() : null), project, typeTag = "@var")) == null) break;
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)varDoc);
                int additionalOffset = typeTag.length() + 1;
                if (target instanceof ForeachStatement && varDoc.startsWith("\n")) {
                    additionalOffset = 8;
                }
                if (target instanceof Statement) {
                    editor.getCaretModel().moveToOffset(offset + additionalOffset);
                } else {
                    EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)" ");
                }
                if (!(target instanceof ForeachStatement)) break;
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
                psiDocumentManager.commitDocument(editor.getDocument());
                if (offset >= target.getTextOffset()) break;
                CodeStyleManager.getInstance((Project)project).reformatRange((PsiElement)file, offset, target.getTextOffset());
                break;
            }
            case '{': {
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.DEFAULT;
                if (result == null) {
                    PhpTypedHandler.$$$reportNull$$$0(23);
                }
                return result;
            }
            case ':': {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                PsiElement currElement = file.findElementAt(offset);
                if (currElement != null) {
                    currElement = currElement.getParent();
                    IElementType parentType = PsiUtilCore.getElementType((PsiElement)currElement);
                    if (currElement != null && (parentType == PhpElementTypes.CASE || parentType == PhpElementTypes.CASE_DEFAULT)) {
                        CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, currElement.getTextOffset());
                    }
                }
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    PhpTypedHandler.$$$reportNull$$$0(24);
                }
                return result;
            }
            case ';': {
                PhpTypedHandler.autoIndentBreak(project, editor, file, offset);
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    PhpTypedHandler.$$$reportNull$$$0(25);
                }
                return result;
            }
            case '@': {
                if (PhpTypedHandler.isInDocComment(project, editor, file, offset)) {
                    PhpTypedHandler.stripExtraSpaces(editor, offset);
                }
                TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
                if (result == null) {
                    PhpTypedHandler.$$$reportNull$$$0(26);
                }
                return result;
            }
        }
        TypedHandlerDelegate.Result result = TypedHandlerDelegate.Result.CONTINUE;
        if (result == null) {
            PhpTypedHandler.$$$reportNull$$$0(27);
        }
        return result;
    }

    private static boolean insideXmlTag(@NotNull PsiFile file, int offset) {
        PsiElement elementAt;
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(28);
        }
        return (elementAt = file.getViewProvider().findElementAt(offset, (Language)HTMLLanguage.INSTANCE)) != null && PsiTreeUtil.getParentOfType((PsiElement)elementAt, XmlTag.class) != null;
    }

    private static void autoIndentBreak(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        boolean indentBreak;
        if (project == null) {
            PhpTypedHandler.$$$reportNull$$$0(29);
        }
        if (editor == null) {
            PhpTypedHandler.$$$reportNull$$$0(30);
        }
        if (file == null) {
            PhpTypedHandler.$$$reportNull$$$0(31);
        }
        if (!(indentBreak = CodeStyle.getLanguageSettings((PsiFile)file, (Language)PhpLanguage.INSTANCE).INDENT_BREAK_FROM_CASE)) {
            PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
            PsiElement currElement = file.findElementAt(offset - 1);
            if (currElement != null && PhpPsiUtil.isOfType(currElement = currElement.getParent(), PhpElementTypes.BREAK)) {
                PsiElement parent = currElement.getParent();
                if (parent instanceof GroupStatement) {
                    parent = parent.getParent();
                }
                if (PhpPsiUtil.isOfType(parent, PhpElementTypes.CASE)) {
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, currElement.getTextOffset());
                }
            }
        }
    }

    private static boolean isCompleteDocComment(PhpDocComment docComment) {
        for (PsiElement child = docComment.getFirstChild(); child != null; child = child.getNextSibling()) {
            ASTNode childNode = child.getNode();
            if (childNode == null) {
                return false;
            }
            IElementType elementType = childNode.getElementType();
            if (child instanceof PsiErrorElement || elementType == PhpDocTokenTypes.DOC_IGNORED) {
                return false;
            }
            if (elementType != PhpDocTokenTypes.DOC_COMMENT_END) continue;
            return true;
        }
        return true;
    }

    private static void stripExtraSpaces(Editor editor, int atOffset) {
        int lineEnd;
        int line;
        int lineStart;
        Document document = editor.getDocument();
        String original2 = document.getText(new TextRange(lineStart = document.getLineStartOffset(line = document.getLineNumber(atOffset)), lineEnd = document.getLineEndOffset(line)));
        Object replacement = original2.substring(0, original2.length() - 1);
        if ("*".equals(((String)replacement).trim())) {
            int starPos = ((String)replacement).indexOf(42);
            replacement = ((String)replacement).substring(0, starPos + 1) + " @";
            document.replaceString(lineStart, lineEnd, (CharSequence)replacement);
        }
    }

    private static boolean isInDocComment(Project project, Editor editor, PsiFile file, int offset) {
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset);
        if (currElement != null) {
            PsiElement parent = currElement.getParent();
            return parent instanceof PhpDocComment;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 19: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 20: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpTypedHandler";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpTypedHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "beforeCharTyped";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAutoPopup";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "charTyped";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCharTyped";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "redundantCharAfterOpenTag";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isImmediatePaintingEnabled";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "checkAutoPopup";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "charTyped";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "insideXmlTag";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "autoIndentBreak";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

