/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import org.jetbrains.annotations.NotNull;

public class PhpQuoteHandler
extends SimpleTokenSetQuoteHandler {
    private static final TokenSet OPENING_QUOTES_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLDOUBLE_QUOTE, PhpTokenTypes.chLSINGLE_QUOTE, PhpTokenTypes.chLBACKTRICK});
    private static final TokenSet CLOSING_QUOTES_TOKENS = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chRDOUBLE_QUOTE, PhpTokenTypes.chRSINGLE_QUOTE, PhpTokenTypes.chRBACKTRICK});

    public PhpQuoteHandler() {
        super(new IElementType[]{PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        if (this.isInsideLiteral(iterator)) {
            int start = iterator.getStart();
            return offset == start;
        }
        return OPENING_QUOTES_TOKENS.contains(iterator.getTokenType());
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        if (this.isInsideLiteral(iterator)) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start >= 1 && offset == end - 1;
        }
        return CLOSING_QUOTES_TOKENS.contains(iterator.getTokenType());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNonClosedLiteral(@NotNull Editor editor, @NotNull HighlighterIterator iterator, int offset) {
        if (editor == null) {
            PhpQuoteHandler.$$$reportNull$$$0(0);
        }
        if (iterator == null) {
            PhpQuoteHandler.$$$reportNull$$$0(1);
        }
        int start = iterator.getStart();
        boolean hasNonClosedLiteral = true;
        try {
            Document doc = editor.getDocument();
            int lineEnd = doc.getLineEndOffset(doc.getLineNumber(offset));
            this.skipInsertedToken(iterator, lineEnd);
            while (!iterator.atEnd() && iterator.getStart() < lineEnd) {
                IElementType tokenType = iterator.getTokenType();
                if (CLOSING_QUOTES_TOKENS.contains(tokenType)) {
                    hasNonClosedLiteral = false;
                }
                if (OPENING_QUOTES_TOKENS.contains(tokenType) || this.myLiteralTokenSet.contains(tokenType)) {
                    hasNonClosedLiteral = true;
                }
                iterator.advance();
            }
        }
        finally {
            while (iterator.atEnd() || iterator.getStart() != start) {
                iterator.retreat();
            }
        }
        return hasNonClosedLiteral;
    }

    public void skipInsertedToken(@NotNull HighlighterIterator iterator, int lineEnd) {
        if (iterator == null) {
            PhpQuoteHandler.$$$reportNull$$$0(2);
        }
        if (!iterator.atEnd() && iterator.getStart() < lineEnd) {
            iterator.advance();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpQuoteHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonClosedLiteral";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "skipInsertedToken";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

