/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUIContextEx;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharArrayUtil;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.PhpPresentationUtil;
import com.jetbrains.php.lang.documentation.PhpDocSource;
import com.jetbrains.php.lang.documentation.PhpDocumentationProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.Parameter;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.ParameterListOwner;
import com.jetbrains.php.lang.psi.elements.PhpAttribute;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class PhpParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<ParameterListOwner, PsiElementResolveResult, PhpPsiElement>,
DumbAware {
    private String text;
    private static final String DOC_TEXT_PLACEHOLDER = "#doc#";

    public ParameterListOwner findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return PhpParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    public ParameterListOwner findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(1);
        }
        return PhpParameterInfoHandler.findAnchorElement(context.getEditor().getCaretModel().getOffset(), context.getFile());
    }

    public PhpPsiElement @NotNull [] getActualParameters(@NotNull ParameterListOwner o) {
        if (o == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(2);
        }
        PsiElement[] parameters = o.getParameters();
        PhpPsiElement[] phpPsiElementArray = (PhpPsiElement[])Arrays.copyOf(parameters, parameters.length, PhpPsiElement[].class);
        if (phpPsiElementArray == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return phpPsiElementArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = PhpTokenTypes.opCOMMA;
        if (iElementType == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(4);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = PhpTokenTypes.chRPAREN;
        if (iElementType == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(5);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class<?>> getArgumentListAllowedParentClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{PhpPsiElement.class});
        if (hashSet == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(6);
        }
        return hashSet;
    }

    @NotNull
    public Set<? extends Class<?>> getArgListStopSearchClasses() {
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new Class[]{Statement.class});
        if (hashSet == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public Class<ParameterListOwner> getArgumentListClass() {
        return ParameterListOwner.class;
    }

    private static boolean isEmbraced(@Nullable PhpPsiElement element, int offset) {
        if (element == null) {
            return false;
        }
        ASTNode node = element.getNode();
        if (node == null) {
            return false;
        }
        ASTNode lbrace = node.findChildByType(PhpTokenTypes.chLPAREN);
        ASTNode rbrace = node.findChildByType(PhpTokenTypes.chRPAREN);
        if (lbrace != null && rbrace != null) {
            return lbrace.getStartOffset() < offset && rbrace.getStartOffset() >= offset;
        }
        if (lbrace != null) {
            return lbrace.getStartOffset() <= offset;
        }
        return false;
    }

    @Nullable
    private static ParameterListOwner findAnchorElement(int offset, PsiFile file) {
        if (offset <= 0) {
            return null;
        }
        if (file instanceof PhpFile) {
            ParameterListOwner parametersOwner;
            CharSequence chars = file.getViewProvider().getContents();
            if (offset > chars.length()) {
                offset = chars.length();
            }
            if ((offset = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(offset - 1), (String)" \t\n\r") + 1) <= 0) {
                return null;
            }
            if (chars.charAt(offset - 1) == ',') {
                --offset;
            }
            if ((parametersOwner = (ParameterListOwner)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, ParameterListOwner.class, (boolean)false)) == null) {
                return null;
            }
            if (PhpParameterInfoHandler.isEmbraced((PhpPsiElement)parametersOwner, offset)) {
                return parametersOwner;
            }
            ParameterListOwner outerParameterListOwner = (ParameterListOwner)PhpPsiUtil.getParentByCondition((PsiElement)parametersOwner, (Condition<? super PsiElement>)((Condition)o -> o instanceof ParameterListOwner && PhpPsiUtil.getChildOfType(o, PhpTokenTypes.chLPAREN) != null));
            if (PhpParameterInfoHandler.isEmbraced((PhpPsiElement)outerParameterListOwner, offset)) {
                return outerParameterListOwner;
            }
        }
        return null;
    }

    public void showParameterInfo(@NotNull ParameterListOwner place, @NotNull CreateParameterInfoContext context) {
        PhpPsiElement classReference;
        if (place == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(9);
        }
        Object[] variants = ResolveResult.EMPTY_ARRAY;
        if (place instanceof PsiPolyVariantReference) {
            variants = ((PsiPolyVariantReference)place).multiResolve(true);
        } else if ((place instanceof NewExpression || place instanceof PhpAttribute) && (classReference = place.getFirstPsiChild()) instanceof ClassReference) {
            variants = ((ClassReference)classReference).multiResolve(true);
        }
        context.setItemsToShow(variants);
        context.showHint((PsiElement)place, place.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public void updateParameterInfo(@NotNull ParameterListOwner place, @NotNull UpdateParameterInfoContext context) {
        PsiElement contextParameterOwner;
        if (place == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if ((contextParameterOwner = context.getParameterOwner()) == null) {
            context.setParameterOwner((PsiElement)place);
        } else if (!(contextParameterOwner instanceof PhpPsiElement)) {
            context.removeHint();
            return;
        }
        int offset = context.getEditor().getCaretModel().getOffset();
        offset = CharArrayUtil.shiftForward((CharSequence)context.getEditor().getDocument().getText(), (int)offset, (String)" \t\n");
        int currIndex = this.getCurrentParameterIndex((PhpPsiElement)place, offset);
        context.setCurrentParameter(currIndex);
        Object[] objects = context.getObjectsToView();
        block0: for (int i = 0; i < objects.length; ++i) {
            PsiElementResolveResult resolveResult = (PsiElementResolveResult)objects[i];
            PsiNamedElement namedElement = (PsiNamedElement)resolveResult.getElement();
            if (!namedElement.isValid()) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            Object argTypes = null;
            PhpType[] parameterTypes = null;
            if (namedElement instanceof Function) {
                Function function = (Function)namedElement;
                Parameter[] parameters = function.getParameters();
                parameterTypes = new PhpType[parameters.length];
                for (int j = 0; j < parameters.length; ++j) {
                    parameterTypes[j] = parameters[j].getType();
                }
            } else if (namedElement instanceof Variable) {
                // empty if block
            }
            if (argTypes == null) continue;
            if (parameterTypes.length <= currIndex) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            PhpIndex phpIndex = PhpIndex.getInstance((Project)place.getProject());
            for (int j = 0; j < currIndex; ++j) {
                void argType = argTypes[j];
                if (parameterTypes[j].isConvertibleFrom((PhpType)argType, phpIndex)) continue;
                context.setUIComponentEnabled(i, false);
                break block0;
            }
            context.setUIComponentEnabled(i, true);
        }
    }

    private int getCurrentParameterIndex(PhpPsiElement place, int offset) {
        ParameterList list;
        if (place instanceof ClassReference) {
            place = (PhpPsiElement)place.getParent();
        }
        if ((place instanceof FunctionReference || place instanceof NewExpression || place instanceof PhpAttribute) && (list = ((ParameterListOwner)place).getParameterList()) != null) {
            return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)list.getNode(), (int)offset, (IElementType)this.getActualParameterDelimiterType());
        }
        return ParameterInfoUtils.getCurrentParameterIndex((ASTNode)place.getNode(), (int)offset, (IElementType)this.getActualParameterDelimiterType());
    }

    public void updateUI(PsiElementResolveResult resolveResult, @NotNull ParameterInfoUIContext context) {
        Method constructor;
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(12);
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        PsiNamedElement element = (PsiNamedElement)resolveResult.getElement();
        if (!element.isValid()) {
            context.setUIComponentEnabled(false);
            return;
        }
        StringBuilder buffer = new StringBuilder();
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (element instanceof PhpClass && (constructor = ((PhpClass)element).getConstructor()) != null) {
            element = constructor;
        }
        if (element instanceof Function) {
            Parameter[] parameters;
            int numParams;
            int currentParameter;
            Function function = (Function)element;
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(element.getName());
                buffer.append("(");
            }
            if ((currentParameter = context.getCurrentParameterIndex()) < 0) {
                currentParameter = 0;
            }
            if ((numParams = (parameters = function.getParameters()).length) > 0) {
                for (int j = 0; j < numParams; ++j) {
                    boolean highlight;
                    Parameter param = parameters[j];
                    boolean bl = highlight = context.isUIComponentEnabled() && (j == currentParameter || j == numParams - 1 && param.isVariadic() && currentParameter >= numParams);
                    if (highlight) {
                        highlightStartOffset = buffer.length();
                    }
                    buffer.append(PhpPresentationUtil.getParameterPresentation(param, PhpPresentationUtil.getParameterTypesStrings(param)));
                    if (highlight) {
                        highlightEndOffset = buffer.length();
                    }
                    if (j >= numParams - 1) continue;
                    buffer.append(", ");
                }
            } else {
                buffer.append("no parameters");
            }
            if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
                buffer.append(")");
                PhpType returnType = function.getType();
                if (!returnType.isEmpty()) {
                    PhpParameterInfoHandler.formatType(buffer, (PhpNamedElement)function);
                }
            }
            if (currentParameter < parameters.length) {
                PhpParameterInfoHandler.appendPhpDoc(buffer, PhpDocumentationProvider.getDocSourceFor((PsiElement)parameters[currentParameter], (PsiElement)element), context);
            }
        } else if (element instanceof PhpClass) {
            buffer.append("no parameters");
        } else if (element instanceof Variable) {
            // empty if block
        }
        this.text = buffer.toString();
        context.setupUIComponentPresentation(this.text, highlightStartOffset, highlightEndOffset, false, false, false, context.getDefaultParameterColor());
    }

    private static void appendPhpDoc(@NotNull StringBuilder buffer, @Nullable PhpDocSource source, @NotNull ParameterInfoUIContext context) {
        String str;
        if (buffer == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if (context == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(14);
        }
        if (context instanceof ParameterInfoUIContextEx && source != null && StringUtil.isNotEmpty((String)(str = StringUtil.trimLog((String)source.getDescription(), (int)200)))) {
            Object docString = str.startsWith("<p>") ? str : "<p>" + str;
            ((ParameterInfoUIContextEx)context).setEscapeFunction(arg_0 -> PhpParameterInfoHandler.lambda$appendPhpDoc$1((String)docString, arg_0));
            assert (buffer.indexOf(DOC_TEXT_PLACEHOLDER) < 0) : buffer.toString();
            buffer.append(DOC_TEXT_PLACEHOLDER);
        }
    }

    private static void formatType(@NotNull StringBuilder builder, @NotNull PhpNamedElement e) {
        if (builder == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(15);
        }
        if (e == null) {
            PhpParameterInfoHandler.$$$reportNull$$$0(16);
        }
        if (DumbService.getInstance((Project)e.getProject()).isDumb()) {
            return;
        }
        PhpType phpType = e.getGlobalType();
        if (!phpType.isEmpty()) {
            builder.append(": ");
            builder.append(phpType.toStringRelativized("\\"));
        }
    }

    @TestOnly
    public String getText() {
        return this.text;
    }

    private static /* synthetic */ String lambda$appendPhpDoc$1(String docString, String s) {
        return StringUtil.replace((String)s, (String)DOC_TEXT_PLACEHOLDER, (String)docString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/lang/PhpParameterInfoHandler";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/lang/PhpParameterInfoHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "appendPhpDoc";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "formatType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

