/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.lang.Language;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.EditorHighlighterProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.ultimate.PluginVerifier;
import com.jetbrains.php.PhpBundle;
import com.jetbrains.php.debug.PhpDebuggerEditorsProvider;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.highlighter.PhpHighlighter;
import com.jetbrains.php.lang.lexer.PhpCodeFragmentLexer;
import com.jetbrains.php.lang.parser.PhpInjectableParserDefinition;
import icons.PhpIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpFileType
extends LanguageFileType {
    public static final PhpFileType INSTANCE = new PhpFileType();
    public static final Key<Boolean> INJECTED_FRAGMENT = Key.create((String)"php-injected-fragment");

    private PhpFileType() {
        super((Language)PhpLanguage.INSTANCE);
        if (ApplicationManager.getApplication() != null) {
            PluginVerifier.verifyUltimatePlugin();
        }
    }

    @Nullable
    private static Lexer getBaseLexer(@Nullable Project project, @Nullable VirtualFile virtualFile) {
        if (virtualFile != null && PhpDebuggerEditorsProvider.isInteractiveConsole(virtualFile)) {
            return new PhpCodeFragmentLexer(project);
        }
        if (virtualFile instanceof LightVirtualFile) {
            Language language = ((LightVirtualFile)virtualFile).getLanguage();
            Boolean injectedFragment = (Boolean)virtualFile.getUserData(INJECTED_FRAGMENT);
            if (injectedFragment == Boolean.TRUE || language != null && language.isKindOf((Language)PhpLanguage.INJECTABLE_INSTANCE)) {
                return new PhpInjectableParserDefinition.PhpWithOptionalOpenTagLexer();
            }
        }
        return null;
    }

    @NotNull
    public String getName() {
        return "PHP";
    }

    @NotNull
    public String getDescription() {
        String string = PhpBundle.message("php", new Object[0]);
        if (string == null) {
            PhpFileType.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "php";
    }

    public Icon getIcon() {
        return PhpIcons.PhpIcon;
    }

    @NonNls
    public String[] getExtensions() {
        return new String[]{this.getDefaultExtension(), "php5", "php4", "phtml", "inc", "hphp", "module", "ctp"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/lang/PhpFileType", "getDescription"));
    }

    public static class PhpEditorHighlighterProvider
    implements EditorHighlighterProvider {
        public EditorHighlighter getEditorHighlighter(@Nullable Project project, @NotNull FileType fileType, @Nullable VirtualFile virtualFile, @NotNull EditorColorsScheme colors) {
            if (fileType == null) {
                PhpEditorHighlighterProvider.$$$reportNull$$$0(0);
            }
            if (colors == null) {
                PhpEditorHighlighterProvider.$$$reportNull$$$0(1);
            }
            return new PhpHighlighter(project, virtualFile, colors, PhpFileType.getBaseLexer(project, virtualFile));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fileType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "colors";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/php/lang/PhpFileType$PhpEditorHighlighterProvider";
            objectArray[2] = "getEditorHighlighter";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

