/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.documentation.PhpDocLinkResolver;
import com.jetbrains.php.lang.documentation.phpdoc.lexer.PhpDocTokenTypes;
import com.jetbrains.php.lang.documentation.phpdoc.parser.tags.PhpUnitCoversTagParser;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocRef;
import com.jetbrains.php.lang.psi.PhpPsiElementFactory;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpClassMember;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import org.jetbrains.annotations.NotNull;

public class PhpDocRefReferenceContributor
extends PsiReferenceContributor {
    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            PhpDocRefReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(PhpDocRef.class), (PsiReferenceProvider)new PhpDocRefReferenceProvider());
    }

    private static PsiElement getPrevSiblingIgnoringPhpUnitTokens(PsiElement element) {
        while (element != null && (element = element.getPrevSibling()) != null && PhpUnitCoversTagParser.isAllowedPhpUnitRefIdentifierToken(PsiUtilCore.getElementType((PsiElement)element), element.getText())) {
        }
        return element;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/jetbrains/php/lang/PhpDocRefReferenceContributor", "registerReferenceProviders"));
    }

    public static final class PhpDocElementReference
    implements PsiReference {
        private final PsiElement myElement;
        private final PsiElement myResult;

        private PhpDocElementReference(@NotNull PsiElement element, @NotNull PsiElement result) {
            if (element == null) {
                PhpDocElementReference.$$$reportNull$$$0(0);
            }
            if (result == null) {
                PhpDocElementReference.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myResult = result;
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement.getParent();
            if (psiElement == null) {
                PhpDocElementReference.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        @NotNull
        public TextRange getRangeInElement() {
            int startOffset = this.myElement.getStartOffsetInParent();
            return new TextRange(startOffset, startOffset + this.myElement.getTextLength());
        }

        @NotNull
        public PsiElement resolve() {
            PsiElement psiElement = this.myResult;
            if (psiElement == null) {
                PhpDocElementReference.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        @NotNull
        public String getCanonicalText() {
            String string = this.myResult instanceof PhpNamedElement ? ((PhpNamedElement)this.myResult).getFQN() : this.myElement.getParent().getText();
            if (string == null) {
                PhpDocElementReference.$$$reportNull$$$0(4);
            }
            return string;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            IElementType elementType;
            if (newElementName == null) {
                PhpDocElementReference.$$$reportNull$$$0(5);
            }
            Object name = (elementType = this.myElement.getNode().getElementType()) == PhpDocTokenTypes.DOC_VARIABLE ? "$" + newElementName : newElementName;
            PhpDocRef phpDocRef = PhpPsiElementFactory.createPhpDocRef(this.myElement.getProject(), (String)name);
            PsiElement newElement = PhpPsiUtil.getChildOfType((PsiElement)phpDocRef, elementType);
            return newElement != null ? this.myElement.replace(newElement) : this.myElement;
        }

        public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
            if (element == null) {
                PhpDocElementReference.$$$reportNull$$$0(6);
            }
            throw new UnsupportedOperationException();
        }

        public boolean isReferenceTo(@NotNull PsiElement element) {
            if (element == null) {
                PhpDocElementReference.$$$reportNull$$$0(7);
            }
            return this.myResult == element;
        }

        public boolean isSoft() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpDocRefReferenceContributor$PhpDocElementReference";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpDocRefReferenceContributor$PhpDocElementReference";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolve";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCanonicalText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "bindToElement";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isReferenceTo";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpDocRefReferenceProvider
    extends PsiReferenceProvider {
        private PhpDocRefReferenceProvider() {
        }

        @NotNull
        public @NotNull PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement docRef, @NotNull ProcessingContext context) {
            if (docRef == null) {
                PhpDocRefReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context == null) {
                PhpDocRefReferenceProvider.$$$reportNull$$$0(1);
            }
            SmartList references = new SmartList();
            boolean hasStatic = PhpPsiUtil.getChildOfType(docRef, PhpDocTokenTypes.DOC_STATIC) != null;
            for (PsiElement element = docRef.getFirstChild(); element != null; element = element.getNextSibling()) {
                if (!PhpPsiUtil.isOfType(element, PhpDocTokenTypes.DOC_IDENTIFIER, PhpDocTokenTypes.DOC_VARIABLE)) continue;
                boolean isClass = hasStatic && PhpPsiUtil.isOfType(element.getNextSibling(), PhpDocTokenTypes.DOC_STATIC);
                boolean isMember = hasStatic && PhpPsiUtil.isOfType(PhpDocRefReferenceContributor.getPrevSiblingIgnoringPhpUnitTokens(element), PhpDocTokenTypes.DOC_STATIC);
                for (PhpDocLinkResolver.Result result : PhpDocLinkResolver.resolve(docRef.getText(), element)) {
                    if (isClass) {
                        PhpClass phpClass = result.getPhpClass();
                        if (phpClass == null) continue;
                        references.add(new PhpDocElementReference(element, (PsiElement)phpClass));
                        continue;
                    }
                    if (isMember) {
                        PhpClassMember member = result.getMember();
                        if (member == null) continue;
                        references.add(new PhpDocElementReference(element, (PsiElement)member));
                        continue;
                    }
                    references.add(new PhpDocElementReference(element, result.getElement()));
                }
            }
            PsiReference[] psiReferenceArray = references.isEmpty() ? PsiReference.EMPTY_ARRAY : references.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                PhpDocRefReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "docRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpDocRefReferenceContributor$PhpDocRefReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpDocRefReferenceContributor$PhpDocRefReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

