/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.php.PhpIndex;
import com.jetbrains.php.lang.PhpCallbackFunctionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ConstantReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpType;
import com.jetbrains.php.refactoring.PhpNameUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpCallbackReferenceBase
extends PsiPolyVariantReferenceBase<PsiElement> {
    public PhpCallbackReferenceBase(@NotNull PsiElement element) {
        if (element == null) {
            PhpCallbackReferenceBase.$$$reportNull$$$0(0);
        }
        super(element);
    }

    @Nullable
    protected static PhpCallbackReferenceBase createVariableReference(@Nullable PsiElement element) {
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.STRING)) {
            return new PhpVariableCallbackReference(element);
        }
        return null;
    }

    @Nullable
    public static PhpCallbackReferenceBase createClassReference(@NotNull PsiElement element, boolean allowSpecialClassNames) {
        if (element == null) {
            PhpCallbackReferenceBase.$$$reportNull$$$0(1);
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.STRING)) {
            return new PhpClassCallbackReference(element, allowSpecialClassNames);
        }
        return null;
    }

    @Nullable
    public static PhpCallbackReferenceBase createMemberReference(@NotNull PsiElement classRef, @NotNull PsiElement memberRef, boolean isMethod) {
        if (classRef == null) {
            PhpCallbackReferenceBase.$$$reportNull$$$0(2);
        }
        if (memberRef == null) {
            PhpCallbackReferenceBase.$$$reportNull$$$0(3);
        }
        if (PhpPsiUtil.isOfType(memberRef, PhpElementTypes.STRING)) {
            return new PhpClassMemberCallbackReference(classRef, memberRef, isMethod);
        }
        return null;
    }

    @Nullable
    public static PhpCallbackReferenceBase createFunctionReference(@NotNull PsiElement element) {
        if (element == null) {
            PhpCallbackReferenceBase.$$$reportNull$$$0(4);
        }
        if (PhpPsiUtil.isOfType(element, PhpElementTypes.STRING)) {
            return new PhpFunctionCallbackReference(element);
        }
        return null;
    }

    protected PsiElement handleRenameElementWithNamespace(@NotNull String newElementName) {
        if (newElementName == null) {
            PhpCallbackReferenceBase.$$$reportNull$$$0(5);
        }
        if (this.getElement() instanceof StringLiteralExpression) {
            String text = ElementManipulators.getValueText((PsiElement)this.getElement());
            newElementName = text.substring(0, text.lastIndexOf(92) + 1) + (String)newElementName;
        }
        return super.handleElementRename((String)newElementName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberRef";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackReferenceBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createClassReference";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createMemberReference";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "createFunctionReference";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "handleRenameElementWithNamespace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class PhpVariableCallbackReference
    extends PhpCallbackReferenceBase {
        PhpVariableCallbackReference(@NotNull PsiElement element) {
            if (element == null) {
                PhpVariableCallbackReference.$$$reportNull$$$0(0);
            }
            super(element);
        }

        @Nullable
        public PsiElement resolve() {
            return VariableImpl.getLeastByPathAndOffset(this.multiResolve(false));
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            String name = PhpCallbackFunctionUtil.getCallbackString(this.myElement);
            if (StringUtil.isNotEmpty((String)name)) {
                Set<? extends PhpNamedElement> variables = VariableImpl.collectDeclarations(this.myElement, true, name);
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(variables);
                if (resolveResultArray == null) {
                    PhpVariableCallbackReference.$$$reportNull$$$0(1);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                PhpVariableCallbackReference.$$$reportNull$$$0(2);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhpVariableCallbackReference.$$$reportNull$$$0(3);
            }
            return this.handleRenameElementWithNamespace(newElementName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpVariableCallbackReference";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpVariableCallbackReference";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PhpClassCallbackReference
    extends PhpCallbackReferenceBase {
        private final boolean myAllowSpecialNames;

        public PhpClassCallbackReference(@NotNull PsiElement element, boolean allowSpecialClassNames) {
            if (element == null) {
                PhpClassCallbackReference.$$$reportNull$$$0(0);
            }
            super(element);
            this.myAllowSpecialNames = allowSpecialClassNames;
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            String callback = this.getCallbackName();
            Collection<PhpClass> resolvedClasses = PhpClassCallbackReference.resolveClassByName(callback, this.myAllowSpecialNames, this.myElement);
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(resolvedClasses);
            if (resolveResultArray == null) {
                PhpClassCallbackReference.$$$reportNull$$$0(1);
            }
            return resolveResultArray;
        }

        @Nullable
        protected String getCallbackName() {
            return PhpCallbackFunctionUtil.getCallbackString(this.myElement);
        }

        @NotNull
        public static Collection<PhpClass> resolveClassByName(@Nullable String callback, boolean allowSpecialNames, PsiElement element) {
            if (StringUtil.isEmpty((String)callback)) {
                List<PhpClass> list = Collections.emptyList();
                if (list == null) {
                    PhpClassCallbackReference.$$$reportNull$$$0(2);
                }
                return list;
            }
            if (allowSpecialNames) {
                if ("self".equals(callback) || "static".equals(callback)) {
                    PhpClass current = (PhpClass)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (current != null) {
                        List<PhpClass> list = Collections.singletonList(current);
                        if (list == null) {
                            PhpClassCallbackReference.$$$reportNull$$$0(3);
                        }
                        return list;
                    }
                    List<PhpClass> list = Collections.emptyList();
                    if (list == null) {
                        PhpClassCallbackReference.$$$reportNull$$$0(4);
                    }
                    return list;
                }
                if ("parent".equals(callback)) {
                    Collection parents;
                    PhpClass current = (PhpClass)PhpPsiUtil.getParentByCondition(element, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
                    if (current != null && !(parents = current.getSuperClasses()).isEmpty()) {
                        Collection collection = parents;
                        if (collection == null) {
                            PhpClassCallbackReference.$$$reportNull$$$0(5);
                        }
                        return collection;
                    }
                    List<PhpClass> list = Collections.emptyList();
                    if (list == null) {
                        PhpClassCallbackReference.$$$reportNull$$$0(6);
                    }
                    return list;
                }
            }
            if (PhpNameUtil.isValidNamespaceFullName(callback, true)) {
                Collection classes;
                MultiMap map;
                Collection its;
                String fqn = PhpLangUtil.toFQN(callback);
                PsiFile file = element.getContainingFile();
                if (file instanceof PhpFile && !(its = (map = ((PhpFile)file).getTopLevelDefs()).get((Object)fqn)).isEmpty()) {
                    ArrayList<PhpClass> local = new ArrayList<PhpClass>();
                    for (PhpNamedElement it : its) {
                        if (!(it instanceof PhpClass)) continue;
                        local.add((PhpClass)it);
                    }
                    if (!local.isEmpty()) {
                        ArrayList<PhpClass> arrayList = local;
                        if (arrayList == null) {
                            PhpClassCallbackReference.$$$reportNull$$$0(7);
                        }
                        return arrayList;
                    }
                }
                if (!(classes = PhpIndex.getInstance((Project)element.getProject()).getAnyByFQN(fqn)).isEmpty()) {
                    Collection collection = classes;
                    if (collection == null) {
                        PhpClassCallbackReference.$$$reportNull$$$0(8);
                    }
                    return collection;
                }
            }
            List<PhpClass> list = Collections.emptyList();
            if (list == null) {
                PhpClassCallbackReference.$$$reportNull$$$0(9);
            }
            return list;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhpClassCallbackReference.$$$reportNull$$$0(10);
            }
            return this.handleRenameElementWithNamespace(newElementName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpClassCallbackReference";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpClassCallbackReference";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveClassByName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static abstract class PhpClassMemberCallbackReferenceBase
    extends PhpCallbackReferenceBase {
        private final boolean myIsMethod;

        public PhpClassMemberCallbackReferenceBase(@NotNull PsiElement memberRef, boolean isMethod) {
            if (memberRef == null) {
                PhpClassMemberCallbackReferenceBase.$$$reportNull$$$0(0);
            }
            super(memberRef);
            this.myIsMethod = isMethod;
        }

        @Nullable
        public String getClassMemberName() {
            return PhpCallbackFunctionUtil.getCallbackString(this.myElement);
        }

        @NotNull
        public abstract Collection<PhpClass> resolveClassReference();

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            String memberName = this.getClassMemberName();
            if (StringUtil.isEmpty((String)memberName)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    PhpClassMemberCallbackReferenceBase.$$$reportNull$$$0(1);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            Collection<PhpClass> classes = this.resolveClassReference();
            if (classes.isEmpty()) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    PhpClassMemberCallbackReferenceBase.$$$reportNull$$$0(2);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            ArrayList<Method> members = new ArrayList<Method>();
            for (PhpClass clazz : classes) {
                Object member = this.myIsMethod ? clazz.findMethodByName((CharSequence)memberName) : clazz.findFieldByName((CharSequence)memberName, false);
                if (member == null) continue;
                members.add((Method)member);
            }
            ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(members);
            if (resolveResultArray == null) {
                PhpClassMemberCallbackReferenceBase.$$$reportNull$$$0(3);
            }
            return resolveResultArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberRef";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpClassMemberCallbackReferenceBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpClassMemberCallbackReferenceBase";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PhpClassMemberCallbackReference
    extends PhpClassMemberCallbackReferenceBase {
        private static final String CLASS_NAME = "__CLASS__";
        private static final String TRAIT_NAME = "__TRAIT__";
        private final PsiElement myClassRef;

        public PhpClassMemberCallbackReference(@NotNull PsiElement classRef, @NotNull PsiElement memberRef, boolean isMethod) {
            if (classRef == null) {
                PhpClassMemberCallbackReference.$$$reportNull$$$0(0);
            }
            if (memberRef == null) {
                PhpClassMemberCallbackReference.$$$reportNull$$$0(1);
            }
            super(memberRef, isMethod);
            this.myClassRef = classRef;
        }

        public PsiElement getClassRef() {
            return this.myClassRef;
        }

        public boolean isStaticRef() {
            return this.myClassRef instanceof StringLiteralExpression;
        }

        @Override
        @NotNull
        public Collection<PhpClass> resolveClassReference() {
            String callback = PhpCallbackFunctionUtil.getCallbackString(this.myClassRef);
            PhpClass current = (PhpClass)PhpPsiUtil.getParentByCondition(this.myClassRef, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF);
            if (current != null) {
                boolean isSelfReference = PhpClassMemberCallbackReference.isSelfReference(callback, this.myClassRef, current);
                if (isSelfReference) {
                    return new SmartList((Object)current);
                }
                if ("parent".equals(callback)) {
                    Collection collection = current.getSuperClasses();
                    if (collection == null) {
                        PhpClassMemberCallbackReference.$$$reportNull$$$0(2);
                    }
                    return collection;
                }
            }
            if (StringUtil.isEmpty((String)callback)) {
                PhpType type = PhpCallbackFunctionUtil.getClassReferenceType(this.myClassRef);
                if (type == null) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        PhpClassMemberCallbackReference.$$$reportNull$$$0(3);
                    }
                    return list;
                }
                ArrayList<PhpClass> result = new ArrayList<PhpClass>();
                Set types = type.getTypes();
                for (String fqn : types) {
                    if (PhpType.isPrimitiveType((String)fqn)) continue;
                    result.addAll(PhpIndex.getInstance((Project)this.myElement.getProject()).getAnyByFQN(fqn));
                }
                ArrayList<PhpClass> arrayList = result;
                if (arrayList == null) {
                    PhpClassMemberCallbackReference.$$$reportNull$$$0(4);
                }
                return arrayList;
            }
            Collection collection = PhpIndex.getInstance((Project)this.myElement.getProject()).getAnyByFQN(PhpLangUtil.toFQN(callback));
            if (collection == null) {
                PhpClassMemberCallbackReference.$$$reportNull$$$0(5);
            }
            return collection;
        }

        private static boolean isSelfReference(@Nullable String name, @NotNull PsiElement element, @NotNull PhpClass current) {
            if (element == null) {
                PhpClassMemberCallbackReference.$$$reportNull$$$0(6);
            }
            if (current == null) {
                PhpClassMemberCallbackReference.$$$reportNull$$$0(7);
            }
            if ("self".equals(name) || "static".equals(name)) {
                return true;
            }
            if (element instanceof Variable && PhpLangUtil.isThisReference(((Variable)element).getNameCS())) {
                return true;
            }
            if (element instanceof ConstantReference) {
                CharSequence constName = ((ConstantReference)element).getNameCS();
                return PhpLangUtil.equalsConstantNames(CLASS_NAME, constName) || PhpLangUtil.equalsConstantNames(TRAIT_NAME, constName) && current.isTrait();
            }
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classRef";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "memberRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpClassMemberCallbackReference";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "current";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpClassMemberCallbackReference";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "resolveClassReference";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelfReference";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class PhpFunctionCallbackReference
    extends PhpCallbackReferenceBase {
        PhpFunctionCallbackReference(@NotNull PsiElement element) {
            if (element == null) {
                PhpFunctionCallbackReference.$$$reportNull$$$0(0);
            }
            super(element);
        }

        public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
            Method method;
            PhpClass clazz;
            Collection functions;
            MultiMap map;
            Collection its;
            String callback = PhpCallbackFunctionUtil.getCallbackString(this.myElement);
            if (StringUtil.isEmpty((String)callback)) {
                if (ResolveResult.EMPTY_ARRAY == null) {
                    PhpFunctionCallbackReference.$$$reportNull$$$0(1);
                }
                return ResolveResult.EMPTY_ARRAY;
            }
            String fqn = PhpLangUtil.toFQN(callback);
            PsiFile file = this.myElement.getContainingFile();
            if (file instanceof PhpFile && !(its = (map = ((PhpFile)file).getTopLevelDefs()).get((Object)fqn)).isEmpty()) {
                ArrayList<Function> local = new ArrayList<Function>();
                for (PhpNamedElement it : its) {
                    if (!(it instanceof Function)) continue;
                    local.add((Function)it);
                }
                if (!local.isEmpty()) {
                    ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults(local);
                    if (resolveResultArray == null) {
                        PhpFunctionCallbackReference.$$$reportNull$$$0(2);
                    }
                    return resolveResultArray;
                }
            }
            if (!(functions = PhpIndex.getInstance((Project)this.myElement.getProject()).getFunctionsByFQN(fqn)).isEmpty()) {
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((Collection)functions);
                if (resolveResultArray == null) {
                    PhpFunctionCallbackReference.$$$reportNull$$$0(3);
                }
                return resolveResultArray;
            }
            if (PhpNameUtil.isValidMethodName(callback) && (clazz = (PhpClass)PhpPsiUtil.getParentByCondition(this.myElement, true, (Condition<? super PsiElement>)PhpClass.INSTANCEOF)) != null && (method = clazz.findMethodByName((CharSequence)callback)) != null) {
                ResolveResult[] resolveResultArray = PsiElementResolveResult.createResults((PsiElement[])new PsiElement[]{method});
                if (resolveResultArray == null) {
                    PhpFunctionCallbackReference.$$$reportNull$$$0(4);
                }
                return resolveResultArray;
            }
            if (ResolveResult.EMPTY_ARRAY == null) {
                PhpFunctionCallbackReference.$$$reportNull$$$0(5);
            }
            return ResolveResult.EMPTY_ARRAY;
        }

        public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
            if (newElementName == null) {
                PhpFunctionCallbackReference.$$$reportNull$$$0(6);
            }
            return this.handleRenameElementWithNamespace(newElementName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpFunctionCallbackReference";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newElementName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/lang/PhpCallbackReferenceBase$PhpFunctionCallbackReference";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "multiResolve";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "handleElementRename";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

