/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.injection;

import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpAccessVariableInstruction;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpInstruction;
import com.jetbrains.php.codeInsight.regexp.PhpRegexpLanguage;
import com.jetbrains.php.injection.PhpInjectionUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.PhpLanguage;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.AssignmentExpression;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.ParameterList;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.Statement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.Variable;
import com.jetbrains.php.lang.psi.elements.impl.VariableImpl;
import com.jetbrains.php.lang.psi.resolve.types.PhpMetaTypeMappingsTable;
import com.jetbrains.php.lang.psi.resolve.types.PhpParameterBasedTypeProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.intellij.lang.regexp.RegExpLanguage;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PhpInjectorBase
implements MultiHostInjector {
    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        PhpInjectionUtil.InjectionResult result;
        if (registrar == null) {
            PhpInjectorBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(1);
        }
        if ((result = this.registerInjection(registrar, context)).isInjected()) {
            this.processInjectedResult(result, context);
        }
    }

    protected void processInjectedResult(PhpInjectionUtil.InjectionResult result, @NotNull PsiElement context) {
        Pair<PsiElement, Language> language;
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(2);
        }
        if (result.containsUnparsableFragment() && (language = this.getInjectedLanguage(context)) != null) {
            InjectorUtils.putInjectedFileUserData((PsiElement)context, (Language)((Language)language.getSecond()), (Key)InjectedLanguageUtil.FRANKENSTEIN_INJECTION, (Object)Boolean.TRUE);
        }
    }

    @NotNull
    public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
        List<Class<? extends PhpExpression>> list = PhpInjectionUtil.ELEMENTS_TO_INJECT_IN;
        if (list == null) {
            PhpInjectorBase.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    protected abstract Language doGetInjectedLanguage(@NotNull PsiElement var1);

    @Nullable
    public @Nullable Pair<@Nullable PsiElement, @NotNull Language> getInjectedLanguage(@NotNull PsiElement context) {
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(4);
        }
        if (context instanceof PsiLanguageInjectionHost && ((PsiLanguageInjectionHost)context).isValidHost()) {
            Language language = this.getSubstitutedLanguage(context);
            if (language != null) {
                return Pair.create(null, (Object)language);
            }
            Pair<PsiElement, Language> languageFromUsages = this.getInjectedLanguageFromUsages(context);
            if (languageFromUsages != null) {
                return languageFromUsages;
            }
        }
        return null;
    }

    @Nullable
    private Pair<PsiElement, Language> getInjectedLanguageFromUsages(@NotNull PsiElement context) {
        PsiElement largestStringLiteral;
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(5);
        }
        if ((largestStringLiteral = PhpInjectionUtil.getLargestStringLiteral(context)) == null) {
            return null;
        }
        PsiElement parent = largestStringLiteral.getParent();
        if (!(parent instanceof AssignmentExpression)) {
            return null;
        }
        if (((AssignmentExpression)parent).getValue() != largestStringLiteral) {
            return null;
        }
        PhpPsiElement variable = ((AssignmentExpression)parent).getVariable();
        if (variable instanceof Variable) {
            return this.getLanguageFromVariableUsages((Variable)variable);
        }
        return null;
    }

    @Nullable
    private Pair<PsiElement, Language> getLanguageFromVariableUsages(final @NotNull Variable variable) {
        PhpAccessVariableInstruction instruction;
        if (variable == null) {
            PhpInjectorBase.$$$reportNull$$$0(6);
        }
        if ((instruction = PhpControlFlowUtil.getAccessInstruction((PhpPsiElement)variable, PhpAccessVariableInstruction.class)) != null) {
            final HashSet languages = new HashSet();
            PhpControlFlowUtil.processSuccessors((PhpInstruction)instruction, false, new PhpInstructionProcessor(){

                public boolean processAccessVariableInstruction(PhpAccessVariableInstruction instruction) {
                    if (PhpLangUtil.equalsVariableNames(instruction.getVariableName(), variable.getName())) {
                        PhpPsiElement anchor = instruction.getAnchor();
                        Language substitutedLanguage = PhpInjectorBase.this.getSubstitutedLanguage((PsiElement)anchor);
                        if (VariableImpl.isLocalWriteAccess((PsiElement)anchor)) {
                            return false;
                        }
                        if (substitutedLanguage != null) {
                            languages.add(Pair.create((Object)anchor, (Object)substitutedLanguage));
                            return false;
                        }
                    }
                    return super.processAccessVariableInstruction(instruction);
                }
            });
            return (Pair)ContainerUtil.getOnlyItem(languages);
        }
        return null;
    }

    @Nullable
    private Language getSubstitutedLanguage(@NotNull PsiElement context) {
        Language language;
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(7);
        }
        if (RegExpLanguage.INSTANCE.is(language = this.doGetInjectedLanguage(context))) {
            return PhpRegexpLanguage.INSTANCE;
        }
        if (PhpLanguage.INSTANCE.is(language)) {
            return PhpLanguage.INJECTABLE_INSTANCE;
        }
        return language;
    }

    protected PhpInjectionUtil.InjectionResult registerInjection(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        Pair<PsiElement, Language> language;
        if (registrar == null) {
            PhpInjectorBase.$$$reportNull$$$0(8);
        }
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(9);
        }
        if ((language = this.getInjectedLanguage(context)) == null) {
            return PhpInjectionUtil.InjectionResult.EMPTY;
        }
        PsiElement element = PhpInjectionUtil.getLargestStringLiteral(context);
        if (element == null) {
            return PhpInjectionUtil.InjectionResult.EMPTY;
        }
        Pair<String, String> prefixSuffixFromUsages = PhpInjectorBase.computePrefixSuffixFromUsages((PsiElement)language.getFirst());
        PhpInjectionUtil.InjectionResult result = PhpInjectionUtil.collectInjections(element, (Language)language.getSecond(), prefixSuffixFromUsages);
        List<PhpInjectionUtil.PhpInjectionInfo> infos = result.getInjectionInfos();
        if (language.getFirst() != null && !infos.isEmpty()) {
            if (prefixSuffixFromUsages == null) {
                return PhpInjectionUtil.InjectionResult.EMPTY;
            }
            PhpInjectorBase.addPrefixSuffixFromUsages(prefixSuffixFromUsages, infos, (Language)language.getSecond());
        }
        return PhpInjectionUtil.registerStringLiteralInjection(element, context, registrar, (Language)language.getSecond(), PhpInjectorBase.patchResult(context.getProject(), result));
    }

    private static void addPrefixSuffixFromUsages(Pair<String, String> prefixSuffixBasedOnUsage, List<PhpInjectionUtil.PhpInjectionInfo> infos, Language language) {
        String prefixFromUsage = (String)prefixSuffixBasedOnUsage.first;
        String suffixFromUsage = (String)prefixSuffixBasedOnUsage.second;
        if (PhpInjectionUtil.isRegExp(language)) {
            if (!prefixFromUsage.isEmpty()) {
                prefixFromUsage = prefixFromUsage.substring(1);
            }
            if (!suffixFromUsage.isEmpty()) {
                suffixFromUsage = suffixFromUsage.substring(0, suffixFromUsage.length() - 1);
            }
        }
        PhpInjectionUtil.PhpInjectionInfo firstInfo = infos.get(0);
        infos.set(0, new PhpInjectionUtil.PhpInjectionInfo(prefixFromUsage + firstInfo.getPrefix(), firstInfo.getSuffix(), firstInfo.getHost(), firstInfo.getRange()));
        PhpInjectionUtil.PhpInjectionInfo lastInfo = infos.get(infos.size() - 1);
        infos.set(infos.size() - 1, new PhpInjectionUtil.PhpInjectionInfo(lastInfo.getPrefix(), lastInfo.getSuffix() + suffixFromUsage, lastInfo.getHost(), lastInfo.getRange()));
    }

    @Nullable
    private static Pair<String, String> computePrefixSuffixFromUsages(PsiElement element) {
        ConcatenationExpression concatenationExpression;
        PsiElement parent = element;
        while ((concatenationExpression = (ConcatenationExpression)PhpPsiUtil.getParentByCondition(parent, (Condition<? super PsiElement>)((Condition)ConcatenationExpression.class::isInstance))) != null) {
            parent = concatenationExpression;
        }
        List<PsiElement> operands = PhpInjectionUtil.unwrapExpressions(parent);
        int index = operands.indexOf(element);
        if (index < 0) {
            return null;
        }
        String prefix = PhpInjectorBase.joinStringLiteralsToString(operands.subList(0, index));
        String suffix = PhpInjectorBase.joinStringLiteralsToString(operands.subList(index + 1, operands.size()));
        if (prefix == null || suffix == null) {
            return null;
        }
        return Pair.create((Object)prefix, (Object)suffix);
    }

    private static String joinStringLiteralsToString(List<PsiElement> elements) {
        StringBuilder sb = new StringBuilder();
        for (PsiElement element : elements) {
            if (!(element instanceof StringLiteralExpression)) {
                return null;
            }
            sb.append(((StringLiteralExpression)element).getContents());
        }
        return sb.toString();
    }

    @Nullable
    protected PhpInjectionUtil.InjectionResult patchInjectionResult(@NotNull PhpInjectionUtil.InjectionResult result) {
        PhpInjectionUtil.PhpInjectionInfo info1;
        if (result == null) {
            PhpInjectorBase.$$$reportNull$$$0(10);
        }
        if (result.getLanguage() != null && result.getLanguage().getDisplayName().contains("SQL") && (info1 = (PhpInjectionUtil.PhpInjectionInfo)result.getInjectionInfos().stream().findAny().orElse(null)) != null) {
            PhpMetaTypeMappingsTable map;
            Map<String, PhpMetaTypeMappingsTable> mappings = PhpParameterBasedTypeProvider.getStaticMethodTypesMap(info1.getHost().getProject());
            PhpMetaTypeMappingsTable phpMetaTypeMappingsTable = map = mappings != null ? mappings.get("#g#F\\PHPSTORM_META\\sql_injection_subst") : null;
            if (map != null && !map.getKeys().isEmpty()) {
                for (String key : map.getKeys()) {
                    List<PhpInjectionUtil.PhpInjectionInfo> fragmentsSubstitutions = result.getInjectionInfos().stream().flatMap(info -> PhpInjectorBase.substitute(info, key, map.get(key).stream().findFirst().orElse(key))).collect(Collectors.toList());
                    result = new PhpInjectionUtil.InjectionResult(result.isInjected(), fragmentsSubstitutions, result.containsUnparsableFragment(), result.getLanguage());
                }
                return result;
            }
        }
        return null;
    }

    private static Stream<PhpInjectionUtil.PhpInjectionInfo> substitute(PhpInjectionUtil.PhpInjectionInfo info, String lookup, String subst) {
        Collection substitutions = null;
        int originalStartOffset = info.getRange().getStartOffset();
        String text = info.getRange().substring(info.getHost().getText());
        int prefixIndex = text.indexOf(lookup);
        if (prefixIndex != -1) {
            SmartList toReturn = new SmartList();
            int chunkStartOffset = 0;
            String externalPrefix = info.getPrefix();
            while (prefixIndex >= 0) {
                toReturn.add(new PhpInjectionUtil.PhpInjectionInfo(externalPrefix, subst, info.getHost(), new TextRange(chunkStartOffset, prefixIndex).shiftRight(originalStartOffset)));
                externalPrefix = "";
                chunkStartOffset = prefixIndex + lookup.length();
                prefixIndex = text.indexOf(lookup, chunkStartOffset);
            }
            String concatenatedSuffix = info.getSuffix();
            toReturn.add(new PhpInjectionUtil.PhpInjectionInfo("", concatenatedSuffix, info.getHost(), TextRange.create((int)(chunkStartOffset + originalStartOffset), (int)info.getRange().getEndOffset())));
            substitutions = toReturn;
        }
        if (substitutions == null || substitutions.isEmpty()) {
            return Stream.of(info);
        }
        return substitutions.stream();
    }

    @NotNull
    private static PhpInjectionUtil.InjectionResult patchResult(@NotNull Project project, @NotNull PhpInjectionUtil.InjectionResult result) {
        if (project == null) {
            PhpInjectorBase.$$$reportNull$$$0(11);
        }
        if (result == null) {
            PhpInjectorBase.$$$reportNull$$$0(12);
        }
        PhpInjectionUtil.InjectionResult injectionResult = StreamEx.of((Collection)MultiHostInjector.MULTIHOST_INJECTOR_EP_NAME.getExtensions((AreaInstance)project)).select(PhpInjectorBase.class).map(injector -> injector.patchInjectionResult(result)).nonNull().findFirst().orElse(result);
        if (injectionResult == null) {
            PhpInjectorBase.$$$reportNull$$$0(13);
        }
        return injectionResult;
    }

    @Nullable
    public static PhpDocComment getDocComment(@NotNull PsiElement context) {
        if (context == null) {
            PhpInjectorBase.$$$reportNull$$$0(14);
        }
        if (!(context instanceof StringLiteralExpression)) {
            return null;
        }
        PhpPsiElement prev = ((PhpPsiElement)context).getPrevPsiSibling();
        if (prev instanceof PhpDocComment) {
            return (PhpDocComment)prev;
        }
        PsiElement parent = context.getParent();
        if (prev == null && (parent instanceof ParameterList || parent instanceof Statement || PhpPsiUtil.isOfType(parent, PhpElementTypes.PARAMETER_DEFAULT_VALUE, PhpElementTypes.ARRAY_VALUE))) {
            context = parent;
        } else if (PhpPsiUtil.isOfType(parent, PhpElementTypes.ARRAY_KEY)) {
            if (PhpPsiUtil.isOfType(parent = parent.getParent(), PhpElementTypes.ARRAY_CREATION_EXPRESSION)) {
                parent = parent.getParent();
            }
            context = parent;
        }
        while (context.getParent() instanceof BinaryExpression) {
            context = context.getParent();
        }
        prev = ((PhpPsiElement)context).getPrevPsiSibling();
        return prev instanceof PhpDocComment ? (PhpDocComment)prev : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/injection/PhpInjectorBase";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/injection/PhpInjectorBase";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "elementsToInjectIn";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "patchResult";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLanguagesToInject";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "processInjectedResult";
                break;
            }
            case 3: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedLanguageFromUsages";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getLanguageFromVariableUsages";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutedLanguage";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerInjection";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchInjectionResult";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchResult";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getDocComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

