/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.injection;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.php.codeInsight.regexp.PhpRegexpExtendedLanguage;
import com.jetbrains.php.codeInsight.regexp.PhpRegexpLanguage;
import com.jetbrains.php.injection.DefaultSQLInPhpInjectionExternalFragmentSubstProvider;
import com.jetbrains.php.injection.PhpInjectionExternalFragmentSubstProvider;
import com.jetbrains.php.lang.lexer.PhpTokenTypes;
import com.jetbrains.php.lang.parser.PhpStubElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.BinaryExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.ParenthesizedExpression;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhpInjectionUtil {
    private static final String SQL_USER_PARAMETER = "%name";
    static final List<Class<? extends PhpExpression>> ELEMENTS_TO_INJECT_IN = Arrays.asList(StringLiteralExpression.class, BinaryExpression.class);
    private static final TokenSet literals = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.STRING_LITERAL, PhpTokenTypes.STRING_NEW_LINE, PhpTokenTypes.STRING_LITERAL_SINGLE_QUOTE, PhpTokenTypes.HEREDOC_CONTENTS});
    private static final TokenSet quotes = TokenSet.create((IElementType[])new IElementType[]{PhpTokenTypes.chLDOUBLE_QUOTE, PhpTokenTypes.chRDOUBLE_QUOTE, PhpTokenTypes.chLSINGLE_QUOTE, PhpTokenTypes.chRSINGLE_QUOTE});
    private static final Map<Character, Character> bracketDelimiters;

    private PhpInjectionUtil() {
    }

    @Nullable
    public static PsiElement getLargestStringLiteral(@Nullable PsiElement context) {
        PsiElement element = null;
        PsiElement current = context;
        while (PhpInjectionUtil.isStringLiteralPart(current, element)) {
            element = current;
            current = current.getParent();
        }
        return element;
    }

    @NotNull
    static InjectionResult registerStringLiteralInjection(@NotNull PsiElement element, PsiElement context, @NotNull MultiHostRegistrar registrar, Language language, InjectionResult result) {
        if (element == null) {
            PhpInjectionUtil.$$$reportNull$$$0(0);
        }
        if (registrar == null) {
            PhpInjectionUtil.$$$reportNull$$$0(1);
        }
        try {
            return PhpInjectionUtil.processElement(context, registrar, result);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException("@`" + element.getText() + "` " + language, e);
        }
    }

    private static boolean isStringLiteralPart(@Nullable PsiElement element, @Nullable PsiElement context) {
        if (element == null) {
            return false;
        }
        if (element == context) {
            return true;
        }
        if (element instanceof StringLiteralExpression) {
            return true;
        }
        if (element instanceof ParenthesizedExpression) {
            PhpPsiElement contained = ((ParenthesizedExpression)element).getArgument();
            return PhpInjectionUtil.isStringLiteralPart((PsiElement)contained, context);
        }
        if (element instanceof BinaryExpression) {
            BinaryExpression expr = (BinaryExpression)element;
            PsiElement left = expr.getLeftOperand();
            PsiElement right = expr.getRightOperand();
            IElementType operation = expr.getOperationType();
            if (operation == PhpTokenTypes.opCONCAT) {
                return PhpInjectionUtil.isStringLiteralPart(left, context) || PhpInjectionUtil.isStringLiteralPart(right, context);
            }
            return false;
        }
        return false;
    }

    @NotNull
    private static InjectionResult processElement(PsiElement context, @NotNull MultiHostRegistrar registrar, @NotNull InjectionResult result) {
        if (registrar == null) {
            PhpInjectionUtil.$$$reportNull$$$0(2);
        }
        if (result == null) {
            PhpInjectionUtil.$$$reportNull$$$0(3);
        }
        Collection<PhpInjectionInfo> infos = PhpInjectionUtil.mergedAdjustmentInfos(result);
        if (result.isInjected() && infos.stream().anyMatch(e -> e.getHost() == context)) {
            registrar.startInjecting(result.getLanguage());
            for (PhpInjectionInfo info : infos) {
                registrar.addPlace(info.getPrefix(), info.getSuffix(), (PsiLanguageInjectionHost)info.getHost(), info.getRange());
            }
            registrar.doneInjecting();
            InjectionResult injectionResult = result;
            if (injectionResult == null) {
                PhpInjectionUtil.$$$reportNull$$$0(4);
            }
            return injectionResult;
        }
        InjectionResult injectionResult = InjectionResult.EMPTY;
        if (injectionResult == null) {
            PhpInjectionUtil.$$$reportNull$$$0(5);
        }
        return injectionResult;
    }

    @NotNull
    private static Collection<PhpInjectionInfo> mergedAdjustmentInfos(@NotNull InjectionResult injectionResult) {
        if (injectionResult == null) {
            PhpInjectionUtil.$$$reportNull$$$0(6);
        }
        ArrayList<PhpInjectionInfo> mergedInfos = new ArrayList<PhpInjectionInfo>();
        PhpInjectionInfo mergedInfo = null;
        for (PhpInjectionInfo info : injectionResult.getInjectionInfos()) {
            if (mergedInfo == null) {
                mergedInfo = info;
                continue;
            }
            if (mergedInfo.getSuffix() == null && info.getPrefix() == null && PhpInjectionUtil.areAdjustment(mergedInfo, info)) {
                TextRange mergedRange = TextRange.create((int)mergedInfo.getRange().getStartOffset(), (int)info.getRange().getEndOffset());
                mergedInfo = new PhpInjectionInfo(mergedInfo.getPrefix(), mergedInfo.getSuffix(), mergedInfo.getHost(), mergedRange);
                continue;
            }
            mergedInfos.add(mergedInfo);
            mergedInfo = info;
        }
        ContainerUtil.addIfNotNull(mergedInfos, mergedInfo);
        ArrayList<PhpInjectionInfo> arrayList = mergedInfos;
        if (arrayList == null) {
            PhpInjectionUtil.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static boolean areAdjustment(PhpInjectionInfo first, PhpInjectionInfo second) {
        return first.getHost() == second.getHost() && first.getRange().getEndOffset() == second.getRange().getStartOffset();
    }

    public static InjectionResult collectInjections(@NotNull PsiElement element, Language language, Pair<String, String> prefixSuffix) {
        if (element == null) {
            PhpInjectionUtil.$$$reportNull$$$0(8);
        }
        InjectionResult result = InjectionResult.EMPTY;
        List<PsiElement> elements = PhpInjectionUtil.unwrapExpressions(element);
        for (int i = 0; i < elements.size(); ++i) {
            String computedSuffix;
            PsiElement operand = elements.get(i);
            if (!(operand instanceof StringLiteralExpression)) continue;
            PsiElement right = i < elements.size() - 1 ? elements.get(i + 1) : null;
            String rightSubstitution = PhpInjectionUtil.isStringLiteralPart(right, null) || right == null ? "" : PhpInjectionUtil.getExtFragmentSubst(right.getNode(), element, language);
            String string = computedSuffix = rightSubstitution != null ? rightSubstitution : SQL_USER_PARAMETER;
            if (rightSubstitution == null) {
                result = result.append(InjectionResult.UNPARSABLE);
            }
            result = result.append(PhpInjectionUtil.processStringLiteralExpr((StringLiteralExpression)operand, computedSuffix, language));
        }
        if (PhpInjectionUtil.isRegExp(language) && result.isInjected() && (prefixSuffix == null || ((String)prefixSuffix.first).isEmpty() && ((String)prefixSuffix.second).isEmpty())) {
            return PhpInjectionUtil.injectRegExp(result, language);
        }
        return result;
    }

    public static boolean isRegExp(Language language) {
        return language == PhpRegexpLanguage.INSTANCE || language == PhpRegexpExtendedLanguage.INSTANCE;
    }

    @NotNull
    private static InjectionResult injectRegExp(InjectionResult result, Language language) {
        String contents;
        List<PhpInjectionInfo> infos = result.getInjectionInfos();
        PhpInjectionInfo firstInjection = (PhpInjectionInfo)ContainerUtil.getFirstItem(infos);
        if (firstInjection != null && !(contents = firstInjection.getHost().getContents()).isEmpty()) {
            infos = PhpInjectionUtil.removeLeadingDelimiterFromInjection(infos, firstInjection);
            char leadingDelimiter = contents.charAt(0);
            char trailingDelimiter = bracketDelimiters.getOrDefault(Character.valueOf(leadingDelimiter), Character.valueOf(leadingDelimiter)).charValue();
            Pair<List<PhpInjectionInfo>, List<PhpInjectionInfo>> infosBeforeAndAfterDelimiter = PhpInjectionUtil.splitInjectionsByTrailingDelimiter(infos, trailingDelimiter);
            List infosAfterDelimiter = (List)infosBeforeAndAfterDelimiter.getSecond();
            return new InjectionResult(result.isInjected(), (List)infosBeforeAndAfterDelimiter.getFirst(), result.containsUnparsableFragment(), PhpInjectionUtil.getRegexpLanguage(language, infosAfterDelimiter));
        }
        InjectionResult injectionResult = result;
        if (injectionResult == null) {
            PhpInjectionUtil.$$$reportNull$$$0(9);
        }
        return injectionResult;
    }

    private static Language getRegexpLanguage(Language language, Collection<PhpInjectionInfo> infosAfterDelimiter) {
        return language == PhpRegexpLanguage.INSTANCE && PhpInjectionUtil.containsExtendedModifier(infosAfterDelimiter) ? PhpRegexpExtendedLanguage.INSTANCE : language;
    }

    private static boolean containsExtendedModifier(Collection<PhpInjectionInfo> infosAfterDelimiter) {
        return StreamEx.of(infosAfterDelimiter).map(e -> e.getRange().substring(e.getHost().getText())).anyMatch(content -> content.indexOf(120) >= 0);
    }

    @NotNull
    private static Pair<List<PhpInjectionInfo>, List<PhpInjectionInfo>> splitInjectionsByTrailingDelimiter(List<PhpInjectionInfo> infos, char delimiter) {
        int injectionWithTrailingDelimiterIdx = infos.size() - 1;
        infos = new SmartList(infos);
        SmartList infosAfterTrailingDelimiter = new SmartList();
        while (injectionWithTrailingDelimiterIdx >= 0) {
            PhpInjectionInfo info = (PhpInjectionInfo)infos.get(injectionWithTrailingDelimiterIdx);
            String contents = info.getHost().getContents();
            int delimiterLastOffset = contents.lastIndexOf(delimiter);
            int valueStart = info.getHost().getValueRange().getStartOffset();
            if (delimiterLastOffset >= 0 && info.getRange().contains(delimiterLastOffset + valueStart)) {
                TextRange rangeBeforeTrailingDelimiter = TextRange.create((int)info.getRange().getStartOffset(), (int)(delimiterLastOffset + valueStart));
                if (!rangeBeforeTrailingDelimiter.isEmpty()) {
                    infos.set(injectionWithTrailingDelimiterIdx, PhpInjectionUtil.copy(info, rangeBeforeTrailingDelimiter));
                    TextRange rangeAfterTrailingDelimiter = PhpInjectionUtil.trimLeft(info.getRange(), rangeBeforeTrailingDelimiter.getLength());
                    infosAfterTrailingDelimiter.add(PhpInjectionUtil.copy(info, rangeAfterTrailingDelimiter));
                    break;
                }
                --injectionWithTrailingDelimiterIdx;
                break;
            }
            --injectionWithTrailingDelimiterIdx;
        }
        if (injectionWithTrailingDelimiterIdx + 1 <= infos.size() && injectionWithTrailingDelimiterIdx + 1 >= 0) {
            infosAfterTrailingDelimiter.addAll(infos.subList(injectionWithTrailingDelimiterIdx + 1, infos.size()));
            infos = infos.subList(0, injectionWithTrailingDelimiterIdx + 1);
        }
        Pair pair = Pair.create((Object)infos, (Object)infosAfterTrailingDelimiter);
        if (pair == null) {
            PhpInjectionUtil.$$$reportNull$$$0(10);
        }
        return pair;
    }

    private static TextRange trimLeft(TextRange range, int length) {
        return TextRange.create((int)(range.getStartOffset() + length), (int)range.getEndOffset());
    }

    private static List<PhpInjectionInfo> removeLeadingDelimiterFromInjection(List<PhpInjectionInfo> infos, @NotNull PhpInjectionInfo firstInjection) {
        TextRange shiftedRange;
        if (firstInjection == null) {
            PhpInjectionUtil.$$$reportNull$$$0(11);
        }
        if (!(shiftedRange = TextRange.create((int)(firstInjection.getRange().getStartOffset() + 1), (int)firstInjection.getRange().getEndOffset())).isEmpty()) {
            return ContainerUtil.prepend(infos.subList(1, infos.size()), (Object[])new PhpInjectionInfo[]{PhpInjectionUtil.copy(firstInjection, shiftedRange)});
        }
        return infos.subList(1, infos.size());
    }

    @NotNull
    private static PhpInjectionInfo copy(PhpInjectionInfo firstInjection, TextRange shiftedRange) {
        return new PhpInjectionInfo(firstInjection.getPrefix(), firstInjection.getSuffix(), firstInjection.getHost(), shiftedRange);
    }

    public static List<PsiElement> unwrapExpressions(PsiElement element) {
        PriorityQueue<PsiElement> res = new PriorityQueue<PsiElement>(Comparator.comparingInt(e -> e.getTextRange().getStartOffset()));
        PhpInjectionUtil.fillExpressions(element, res);
        return new ArrayList<PsiElement>(res);
    }

    private static void fillExpressions(PsiElement element, Collection<PsiElement> res) {
        if (element instanceof ConcatenationExpression) {
            for (PsiElement child : PhpPsiUtil.getChildren(element, (Condition<? super PsiElement>)PhpExpression.INSTANCEOF)) {
                PhpInjectionUtil.fillExpressions(child, res);
            }
        } else if (element instanceof ParenthesizedExpression) {
            PhpInjectionUtil.fillExpressions((PsiElement)((ParenthesizedExpression)element).getArgument(), res);
        } else if (element != null) {
            res.add(element);
        }
    }

    @NotNull
    private static InjectionResult processStringLiteralExpr(StringLiteralExpression expr, @NotNull String suffix, Language language) {
        if (suffix == null) {
            PhpInjectionUtil.$$$reportNull$$$0(12);
        }
        boolean containsUnparsableFragment = false;
        ASTNode child = expr.getNode().getFirstChildNode();
        IElementType type = child.getElementType();
        if (type == PhpTokenTypes.chLDOUBLE_QUOTE || type == PhpTokenTypes.chLSINGLE_QUOTE) {
            child = child.getTreeNext();
        }
        boolean injected = false;
        SmartList injectionInfos = new SmartList();
        while (child != null) {
            ASTNode next = child.getTreeNext();
            IElementType iElementType = type = next != null ? next.getElementType() : null;
            if (type == PhpTokenTypes.chRDOUBLE_QUOTE || type == PhpTokenTypes.chRSINGLE_QUOTE) {
                next = next.getTreeNext();
            }
            if (literals.contains(type = child.getElementType()) || quotes.contains(type)) {
                String chunkSuffix;
                int start = child.getStartOffset() - expr.getTextOffset();
                int end = start + child.getTextLength();
                if (next != null && next.getElementType() == PhpTokenTypes.HEREDOC_END) {
                    ++end;
                }
                TextRange range = new TextRange(start, end);
                assert (range.getLength() > 0);
                if (next != null) {
                    IElementType nextElementType = next.getElementType();
                    if (nextElementType == PhpStubElementTypes.VARIABLE) {
                        String interpolatedVariableSubstitution = PhpInjectionUtil.getExtFragmentSubst(next, (PsiElement)expr, language);
                        chunkSuffix = interpolatedVariableSubstitution != null ? interpolatedVariableSubstitution : SQL_USER_PARAMETER;
                        containsUnparsableFragment = containsUnparsableFragment || interpolatedVariableSubstitution == null;
                    } else {
                        chunkSuffix = nextElementType == PhpTokenTypes.ESCAPE_SEQUENCE ? next.getText() : "";
                    }
                } else {
                    chunkSuffix = suffix;
                }
                if (expr.isValidHost()) {
                    injectionInfos.add(new PhpInjectionInfo("", chunkSuffix, expr, range));
                    injected = true;
                }
            } else if (type == PhpStubElementTypes.VARIABLE) {
                containsUnparsableFragment = true;
            }
            child = next;
        }
        return new InjectionResult(injected, (List<PhpInjectionInfo>)injectionInfos, containsUnparsableFragment, language);
    }

    @Nullable
    private static String getExtFragmentSubst(ASTNode node, PsiElement context, Language language) {
        PhpInjectionExternalFragmentSubstProvider[] extensions = (PhpInjectionExternalFragmentSubstProvider[])PhpInjectionExternalFragmentSubstProvider.EP_NAME.getExtensions((AreaInstance)context.getProject());
        String fragment = null;
        for (PhpInjectionExternalFragmentSubstProvider extension : extensions) {
            String subst = extension.getExtFragmentSubst(node, context, language);
            if (!StringUtil.isNotEmpty((String)subst)) continue;
            fragment = subst;
            break;
        }
        if (fragment == null) {
            fragment = DefaultSQLInPhpInjectionExternalFragmentSubstProvider.INSTANCE.getExtFragmentSubst(node, context, language);
        }
        return fragment != null ? StringUtil.unescapeStringCharacters(fragment) : null;
    }

    static {
        HashMap<Character, Character> map = new HashMap<Character, Character>();
        map.put(Character.valueOf('('), Character.valueOf(')'));
        map.put(Character.valueOf('{'), Character.valueOf('}'));
        map.put(Character.valueOf('['), Character.valueOf(']'));
        map.put(Character.valueOf('<'), Character.valueOf('>'));
        bracketDelimiters = ContainerUtil.unmodifiableOrEmptyMap(map);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/injection/PhpInjectionUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "injectionResult";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstInjection";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/injection/PhpInjectionUtil";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "processElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "mergedAdjustmentInfos";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "injectRegExp";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "splitInjectionsByTrailingDelimiter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "registerStringLiteralInjection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mergedAdjustmentInfos";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectInjections";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeLeadingDelimiterFromInjection";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processStringLiteralExpr";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpInjectionInfo {
        private String myPrefix;
        private String mySuffix;
        private final StringLiteralExpression myHost;
        private final TextRange myRange;

        public PhpInjectionInfo(String prefix, String suffix, StringLiteralExpression injectionHost, TextRange range) {
            this.myPrefix = prefix;
            this.mySuffix = suffix;
            this.myHost = injectionHost;
            this.myRange = range;
        }

        public String getSuffix() {
            return this.mySuffix;
        }

        public StringLiteralExpression getHost() {
            return this.myHost;
        }

        public TextRange getRange() {
            return this.myRange;
        }

        public String getPrefix() {
            return this.myPrefix;
        }

        public void setPrefix(String prefix) {
            this.myPrefix = prefix;
        }

        public void setSuffix(String suffix) {
            this.mySuffix = suffix;
        }
    }

    public static class InjectionResult {
        public static final InjectionResult EMPTY = new InjectionResult(false, false);
        public static final InjectionResult UNPARSABLE = new InjectionResult(false, true);
        private final boolean myInjected;
        private final List<PhpInjectionInfo> myInjectionInfos;
        private final boolean myContainsUnparsableFragment;
        @Nullable
        private final Language myLanguage;

        private InjectionResult(boolean injected, boolean containsUnparsableFragment) {
            this(injected, Collections.emptyList(), containsUnparsableFragment, null);
        }

        public InjectionResult(boolean injected, List<PhpInjectionInfo> injectionInfos, boolean containsUnparsableFragment, @Nullable Language language) {
            this.myInjected = injected;
            this.myInjectionInfos = injectionInfos;
            this.myContainsUnparsableFragment = containsUnparsableFragment;
            this.myLanguage = language;
        }

        public boolean isInjected() {
            return this.myInjected;
        }

        public boolean containsUnparsableFragment() {
            return this.myContainsUnparsableFragment;
        }

        public InjectionResult append(@NotNull InjectionResult result) {
            if (result == null) {
                InjectionResult.$$$reportNull$$$0(0);
            }
            SmartList injectionInfos = new SmartList(this.myInjectionInfos);
            injectionInfos.addAll(result.getInjectionInfos());
            return new InjectionResult(this.myInjected || result.isInjected(), (List<PhpInjectionInfo>)injectionInfos, this.myContainsUnparsableFragment || result.containsUnparsableFragment(), this.myLanguage != null ? this.myLanguage : result.getLanguage());
        }

        public List<PhpInjectionInfo> getInjectionInfos() {
            return this.myInjectionInfos;
        }

        @Nullable
        public Language getLanguage() {
            return this.myLanguage;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/jetbrains/php/injection/PhpInjectionUtil$InjectionResult", "append"));
        }
    }
}

