/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hierarchy.call;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.SmartList;
import com.jetbrains.php.PhpClassHierarchyUtils;
import com.jetbrains.php.hierarchy.PhpHierarchyUtils;
import com.jetbrains.php.hierarchy.call.PhpCallHierarchyNodeDescriptor;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ClassReference;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.NewExpression;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PhpCallerMethodsTreeStructure
extends HierarchyTreeStructure {
    private final String myScopeType;

    public PhpCallerMethodsTreeStructure(Project project, Function method, String scopeType) {
        super(project, (HierarchyNodeDescriptor)new PhpCallHierarchyNodeDescriptor(project, null, (PsiElement)method, true, false));
        this.myScopeType = scopeType;
    }

    protected Object @NotNull [] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        PhpPsiElement enclosingElement;
        if (descriptor == null) {
            PhpCallerMethodsTreeStructure.$$$reportNull$$$0(0);
        }
        if (!((enclosingElement = ((PhpCallHierarchyNodeDescriptor)descriptor).getEnclosingElement()) instanceof Function)) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                PhpCallerMethodsTreeStructure.$$$reportNull$$$0(1);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Function function = (Function)enclosingElement;
        GlobalSearchScope searchScope = GlobalSearchScope.allScope((Project)this.myProject);
        if ("This Class".equals(this.myScopeType)) {
            Function baseMethod = (Function)((PhpCallHierarchyNodeDescriptor)this.getBaseDescriptor()).getTargetElement();
            if (baseMethod instanceof Method) {
                PhpClass containingClass = ((Method)baseMethod).getContainingClass();
                searchScope = containingClass == null ? GlobalSearchScope.EMPTY_SCOPE : new LocalSearchScope((PsiElement)containingClass);
            }
        } else if ("Production".equals(this.myScopeType)) {
            searchScope = GlobalSearchScopesCore.projectProductionScope((Project)this.myProject);
        } else if ("Test".equals(this.myScopeType)) {
            searchScope = GlobalSearchScopesCore.projectTestScope((Project)this.myProject);
        } else {
            NamedScope namedScope = NamedScopesHolder.getScope((Project)this.myProject, (String)this.myScopeType);
            if (namedScope != null) {
                searchScope = GlobalSearchScopesCore.filterScope((Project)this.myProject, (NamedScope)namedScope);
            }
        }
        HashMap methodToDescriptorMap = new HashMap();
        Collection<Function> methods = PhpCallerMethodsTreeStructure.getOverriddenMethods(function);
        for (Function method : methods) {
            ReferencesSearch.search((PsiElement)method, (SearchScope)searchScope, (boolean)true).forEach(reference -> {
                if (reference.getElement().getParent() instanceof Function) {
                    return true;
                }
                if (function instanceof Method && reference instanceof MethodReference) {
                    PsiElement resolveResult;
                    PhpExpression phpReference = ((MethodReference)reference).getClassReference();
                    if (phpReference == null) {
                        return true;
                    }
                    ClassReference classOwner = null;
                    if (phpReference instanceof ClassReference) {
                        classOwner = (ClassReference)phpReference;
                    } else if (phpReference instanceof PhpReference && (resolveResult = ((PhpReference)phpReference).resolve()) instanceof ClassReference) {
                        classOwner = (ClassReference)resolveResult;
                    }
                    if (classOwner != null && "parent".equals(classOwner.getText()) && (resolveResult = classOwner.resolve()) instanceof PhpClass) {
                        PhpClass superClass = (PhpClass)resolveResult;
                        PhpClass methodClass = ((Method)function).getContainingClass();
                        if (methodClass != null && PhpClassHierarchyUtils.isSuperClass((PhpClass)superClass, (PhpClass)methodClass, (boolean)false)) {
                            return true;
                        }
                    }
                }
                if (!(reference instanceof PsiElement)) {
                    return true;
                }
                PsiElement parent = ((PsiElement)reference).getParent();
                if (parent instanceof NewExpression && PhpPsiUtil.getChildOfType(parent, PhpElementTypes.CLASS_REFERENCE) != reference) {
                    return true;
                }
                PsiElement element = reference.getElement();
                PhpPsiElement key = PhpCallHierarchyNodeDescriptor.getEnclosingElement(element);
                if (key == null) {
                    return true;
                }
                PhpCallHierarchyNodeDescriptor d = (PhpCallHierarchyNodeDescriptor)((Object)((Object)methodToDescriptorMap.get(key)));
                if (d == null) {
                    d = new PhpCallHierarchyNodeDescriptor(this.myProject, descriptor, element, false, true);
                    methodToDescriptorMap.put(key, d);
                } else {
                    d.incrementUsageCount();
                }
                d.addReference((PsiReference)reference);
                return true;
            });
        }
        Object[] objectArray = ArrayUtil.toObjectArray(methodToDescriptorMap.values());
        if (objectArray == null) {
            PhpCallerMethodsTreeStructure.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    private static Collection<Function> getOverriddenMethods(Function function) {
        SmartList result = new SmartList((Object)function);
        if (function instanceof Method) {
            Method method = (Method)function;
            PhpClass phpClass = method.getContainingClass();
            String methodName = method.getName();
            if (phpClass != null) {
                List<PhpClass> superClasses = PhpHierarchyUtils.findSuperClassesForMethod(phpClass, method);
                for (PhpClass superClass : superClasses) {
                    Method[] superMethods;
                    for (Method superMethod : superMethods = superClass.getOwnMethods()) {
                        if (!PhpLangUtil.equalsMethodNames(methodName, superMethod.getName())) continue;
                        result.add(superMethod);
                    }
                }
            }
        }
        return result;
    }

    public boolean isAlwaysShowPlus() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/hierarchy/call/PhpCallerMethodsTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/hierarchy/call/PhpCallerMethodsTreeStructure";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

