/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.hierarchy;

import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SmartList;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpModifier;
import com.jetbrains.php.lang.psi.elements.PhpPsiElement;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpHierarchyUtils {
    private static final Comparator<NodeDescriptor<?>> NODE_DESCRIPTOR_COMPARATOR = Comparator.comparingInt(NodeDescriptor::getIndex);

    public static Comparator<NodeDescriptor<?>> getComparator(Project project) {
        if (HierarchyBrowserManager.getInstance((Project)project).getState().SORT_ALPHABETICALLY) {
            return AlphaComparator.INSTANCE;
        }
        return NODE_DESCRIPTOR_COMPARATOR;
    }

    @Nullable
    public static Method findBaseMethodInClass(Method baseMethod, PhpClass aClass, boolean checkBases) {
        if (baseMethod == null) {
            return null;
        }
        if (!PhpHierarchyUtils.canBeOverriddenOrOverriding(baseMethod)) {
            return null;
        }
        Method method = aClass.findOwnMethodByName(baseMethod.getNameCS());
        if (method != null && method.getContainingClass() != aClass) {
            method = null;
        }
        if (method != null || !checkBases) {
            return method;
        }
        return PhpHierarchyUtils.findMethodInSuperClasses(aClass, baseMethod);
    }

    public static boolean canBeOverriddenOrOverriding(Method method) {
        PhpClass containingClass = method.getContainingClass();
        return containingClass != null && !method.isStatic() && method.getAccess() != PhpModifier.Access.PRIVATE;
    }

    @Nullable
    public static Method findMethodInSuperClasses(PhpClass aClass, Method lookInSupers) {
        Method method;
        PhpClass[] superClasses = aClass.getSupers();
        if (superClasses.length == 0) {
            return null;
        }
        for (PhpClass phpClass : superClasses) {
            if (phpClass == null || (method = phpClass.findMethodByName(lookInSupers.getNameCS())) == null) continue;
            return method;
        }
        for (PhpClass phpClass : superClasses) {
            if (phpClass == null || (method = PhpHierarchyUtils.findMethodInSuperClasses(phpClass, lookInSupers)) == null) continue;
            return method;
        }
        return null;
    }

    @Nullable
    private static Function getPhpFunction(PsiElement element) {
        PsiElement resolveResult;
        PhpPsiElement phpElement = element == null ? null : (PhpPsiElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{FunctionReference.class, Function.class});
        Function method = null;
        if (phpElement instanceof Function) {
            method = (Function)phpElement;
        } else if (phpElement instanceof FunctionReference && (resolveResult = ((PsiReference)phpElement).resolve()) instanceof Function) {
            method = (Function)resolveResult;
        }
        return method;
    }

    @Nullable
    public static Function getFunction(DataContext dataContext) {
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project == null) {
            return null;
        }
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        Function method = PhpHierarchyUtils.getPhpFunction(element);
        if (method != null) {
            return method;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            return null;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        if (file instanceof PhpFile) {
            int offset = editor.getCaretModel().getOffset();
            element = file.findElementAt(offset);
        }
        return PhpHierarchyUtils.getPhpFunction(element);
    }

    public static List<PhpClass> findSuperClassesForMethod(@Nullable PhpClass phpClass, @Nullable Method method) {
        if (phpClass == null || method == null || !phpClass.isValid()) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        PhpClass superClass = phpClass;
        block0: do {
            PhpClass[] supers = superClass.getSupers();
            superClass = null;
            for (PhpClass clazz : supers) {
                if (PhpHierarchyUtils.findBaseMethodInClass(method, clazz, false) == null) continue;
                superClass = clazz;
                continue block0;
            }
        } while (superClass != null && result.add(superClass));
        return result;
    }

    @NotNull
    @NlsSafe
    public static String getFileNameContainingElement(@NotNull PsiElement element) {
        if (element == null) {
            PhpHierarchyUtils.$$$reportNull$$$0(0);
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        PsiFile containingFile = element.getContainingFile();
        if (containingFile == null) {
            return "";
        }
        VirtualFile elementFile = containingFile.getVirtualFile();
        if (elementFile == null) {
            return "";
        }
        VirtualFile sourceRoot = index.getContentRootForFile(elementFile);
        if (sourceRoot != null) {
            String string = StringUtil.notNullize((String)VfsUtilCore.getRelativePath((VirtualFile)elementFile, (VirtualFile)sourceRoot, (char)File.separatorChar));
            if (string == null) {
                PhpHierarchyUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        String string = elementFile.getPresentableUrl();
        if (string == null) {
            PhpHierarchyUtils.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/hierarchy/PhpHierarchyUtils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/hierarchy/PhpHierarchyUtils";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileNameContainingElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFileNameContainingElement";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

